$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([{
      element: '#btnFiltrosRel',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
        position: 'right'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para imprimir um relatório.',
        position: 'right'
      }
    },
    {
      element: '#btnInventario',
      popover: {
        title: 'Botão Inventário',
        description: 'Clique aqui para gerar um inventário.',
        position: 'right'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const filtroDeposito = await buscaDepositoEmpresaUsuario();
  addPesquisas()

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  if (colunas == null || colunas.relPosEstoqueMat == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPosEstoqueMat: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPosEstoqueMat: novasColunas }))

      $('#tabelaPosicaoEstoque').DataTable().columns().visible(true);

      $('#tabelaPosicaoEstoque').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaPosicaoEstoque').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relPosEstoqueMat ?? ['MATERIAL', 'DESC_MATERIAL'])
  })

  $('#btnFiltrosRel').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnLimpaFiltros').on('click', function () {
    limpaFiltros();
  });

  $('#btnConsultar').on('click', async function () {
    await fazConsulta();
    $('#modal-filtros').modal('hide');

  });

  await preencheOrdenacaoTela('RelPosEstoqueMat');

  async function fazConsulta() {
    if ($.fn.DataTable.isDataTable('#tabelaPosicaoEstoque')) {
      $("#tabelaPosicaoEstoque").DataTable().destroy();
      $("#tabelaPosicaoEstoque").empty();
    }
    try {
      dataSetCols = [];
      $.LoadingOverlay('show');
      const url = `/sisplan/impressao/v1/relposestoquemat?`;
      const filtros = await retornaFiltros();
      const response = await requisicao('GET', url, `${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`, '', 360000);

      if (!response) {
        return;
      };

      const jsonStr = await response.json();

      if (response.status != 200) {
        throw new Error(jsonStr.mensagem);
      }

      if (jsonStr.length == 0) {
        if ($.fn.DataTable.isDataTable('#tabelaPosicaoEstoque')) {
          $('#tabelaPosicaoEstoque').DataTable().destroy();
          $('#tabelaPosicaoEstoque').empty();
        }
        throw new Error("Nenhum registro encontrado!");
      }

      montaDataTable(jsonStr)
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function montaDataTable(jsonStr) {
    let keys = Object.keys(jsonStr[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    const camposDireita = ['QTD_ATUAL', 'PRECO_COMPRA', 'PRE_MEDIO', 'QTDE', 'PESO'];
    const camposValor = ['PRECO_COMPRA', 'PRE_MEDIO'];
    const camposData = ['DTPOS', 'DATA_ENTRADA_NF',];
    const indiceDireita = [];
    const indiceValor = [];
    const indiceData = [];
    for (let i = 0; i < keys.length; i++) {
      if (camposValor.includes(keys[i])) {
        indiceValor.push(i);
      } else if (camposDireita.includes(keys[i])) {
        indiceDireita.push(i);
      } else if (camposData.includes(keys[i])) {
        indiceData.push(i);
      }
    }

    $('#tabelaPosicaoEstoque').DataTable({
      bPaginate: true,
      destroy: true,
      colReorder: true,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      columnDefs: [
        {
          "className": 'pr-4 text-right',
          targets: indiceDireita
        },
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: indiceData,
        },
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 7,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: indiceValor,
        },
      ]
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaPosicaoEstoque_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
    $('#tabelaPosicaoEstoque_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcel').prop('title', 'Exportar')

    $('#buttonColVis').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcel').on('click', async function () {
      let dados = $("#tabelaPosicaoEstoque").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Relatório de Posição de Estoque - Material', '#tabelaPosicaoEstoque', '', 999, false, false, dados);
    })

    $('#tabelaPosicaoEstoque').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.relPosEstoqueMat).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  async function retornaFiltros(bInventario = false) {
    let cbConsideraCodigo = 'N';
    let cbConsideraCor = 'N';
    let cbConsideraDeposito = 'N';
    let cbConsideraGrupo = 'N';
    let cbConsideraLinha = 'N';
    let cbConsideraColecao = 'N';
    let cbConsideraQualidade = 'N';
    let cbConsideraSubGrupo = 'N';
    let cbConsideraClassificacao = 'N';
    let cbConsideraNatureza = 'N';
    let cbConsideraCodigoSped = 'N';
    let cbConsideraLocal = 'N';

    if ($('#cbConsideraCodigo').is(':checked')) {
      cbConsideraCodigo = 'S';
    }

    if ($('#cbConsideraCor').is(':checked')) {
      cbConsideraCor = 'S';
    }

    if ($('#cbConsideraDeposito').is(':checked')) {
      cbConsideraDeposito = 'S';
    }

    if ($('#cbConsideraGrupo').is(':checked')) {
      cbConsideraGrupo = 'S';
    }

    if ($('#cbConsideraLinha').is(':checked')) {
      cbConsideraLinha = 'S';
    }

    if ($('#cbConsideraColecao').is(':checked')) {
      cbConsideraColecao = 'S';
    }

    if ($('#cbConsideraStatus').is(':checked')) {
      cbConsideraStatus = 'S';
    }

    if ($('#cbConsideraQualidade').is(':checked')) {
      cbConsideraQualidade = 'S';
    }

    if ($('#cbConsideraSubGrupo').is(':checked')) {
      cbConsideraSubGrupo = 'S';
    }

    if ($('#cbConsideraClassificacao').is(':checked')) {
      cbConsideraClassificacao = 'S';
    }

    if ($('#cbConsideraNatureza').is(':checked')) {
      cbConsideraNatureza = 'S';
    }

    if ($('#cbConsideraCodigoSped').is(':checked')) {
      cbConsideraCodigoSped = 'S';
    }

    if ($('#cbConsideraLocal').is(':checked')) {
      cbConsideraLocal = 'S';
    }

    const materiais = $('input[name="filtroTodos"]:checked').val();
    const data = $('#txtData').val().replace();
    const codigo = await formataListas($('#txtMaterial').val().toString());
    let deposito = await formataListas($('#txtDepositoUsuario').val().toString());
    if (deposito == '') {
      deposito = filtroDeposito;
    }
    if (deposito == 'null') {
      deposito = '';
    }
    const grupo = await formataListas($('#txtGrupoMA').val().toString());
    const colecao = await formataListas($('#txtColecao').val().toString());
    const linha = await formataListas($('#txtLinha').val().toString());
    const lote = $('#txtLote').val();
    const cor = await formataListas($('#txtCor').val().toString());
    const qualidade = await formataListas($('#txtQualidade').val().toString());
    const subGrupo = await formataListas($('#txtSubGrupo').val().toString());
    const classificacao = await formataListas($('#txtClasseMat').val().toString());
    const natureza = await formataListas($('#txtNatureza').val().toString());
    const codigoSped = await formataListas($('#txtCodigoSped').val().toString());
    const selPosses = $('#selectPosse').val();
    const local = await formataListas($('#txtLocal').val().toString());

    const filtros =
      `MATERIAIS=${materiais}&` +
      `CONSIDERACODIGO=${cbConsideraCodigo}&` +
      `CONSIDERACOR=${cbConsideraCor}&` +
      `CONSIDERADEPOSITO=${cbConsideraDeposito}&` +
      `CONSIDERAGRUPO=${cbConsideraGrupo}&` +
      `CONSIDERASUBGRUPO=${cbConsideraSubGrupo}&` +
      `CONSIDERALINHA=${cbConsideraLinha}&` +
      `CONSIDERACOLECAO=${cbConsideraColecao}&` +
      `CONSIDERAQUALIDADE=${cbConsideraQualidade}&` +
      `CONSIDERACLASSIFICACAO=${cbConsideraClassificacao}&` +
      `CONSIDERANATUREZA=${cbConsideraNatureza}&` +
      `CONSIDERACODIGOSPED=${cbConsideraCodigoSped}&` +
      `CONSIDERALOCAL=${cbConsideraLocal}&` +
      `DATA=${data}&` +
      `CODIGO=${codigo}&` +
      `DEPOSITO=${deposito}&` +
      `GRUPO=${grupo}&` +
      `LINHA=${linha}&` +
      `LOTE=${lote}&` +
      `COLECAO=${colecao}&` +
      `COR=${cor}&` +
      `QUALIDADE=${qualidade}&` +
      `SUBGRUPO=${subGrupo}&` +
      `CLASSIFICACAO=${classificacao}&` +
      `NATUREZA=${natureza}&` +
      `CODIGOSPED=${codigoSped}&` +
      `POSSE=${selPosses}&` +
      `LOCAL=${local}`;

    return filtros;
  };

  retornaHintRelatorio('btnImprimir', 'RelPosEstoqueMatPadrao')
  $('#txtOrdem').on('change', function () {
    retornaHintRelatorio('btnImprimir', $("#txtOrdem option")
      .toArray()
      .map(map => {
        return [map.selected, $(map)
          .attr('nome_prt')]
      })
      .filter(filter => filter[0] == true)[0][1])
  })

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const filtros = await retornaFiltros();
        let url = `/sisplan/impressao/v1/relposestoqueMat?${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`;
        const ordem = `&TELA_ORDENACAO=RelPosEstoqueMat&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelPosEstoqueMat');
        const arquivo = await GeraRelatorio(`${url}${ordem}&`, "POST", 300000, false, 'RelPosEstoqueMat');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#btnInventario').on('click', function () {
    $('#txtDataInventario').val($('#txtData').val());
    $('#modalInventario').modal('show');
  });

  $('#modalInventario').on('hidden.bs.modal', function () {
    $('#txtSetor').val('');
  });

  async function retornaArrItens(itens, setor, data) {
    if (!($.fn.DataTable.isDataTable('#tabelaPosicaoEstoque')) || ($('#tabelaPosicaoEstoque').DataTable().data().toArray().length <= 0)) {
      throw new Error('Nenhum registro filrado para gerar inventário. Favor realizar a consulta dos materiais antes de gerar inventário!')
    }
    let naoGerar = false
    if (data == '') {
      throw new Error('Data não informada, favor verificar!')
    }
    let depositoErro = '';
    let codigoErro = '';
    const arrDeposito = []
    const posses = [1, 2, 3];
    const arr = [];

    for (let i = 0; i < itens.length; i++) {
      const item = itens[i];
      if (setor == '' && item.SETOR == '') {
        depositoErro = `${item.DEPOSITO} - ${item.DESCDEP}`;
        break;
      }

      if (!posses.includes(parseInt(item.POSSE))) {
        codigoErro = item.CODIGO;
        break;
      }
      const objItem = {
        CODIGO: item.CODIGO,
        DESCRICAO: item.MATERIAL,
        UNIDADE: item.UNIDADE,
        COR: item.COR,
        DEPOSITO: item.DEPOSITO,
        LOTE: item.MAT_LOTE,
        SETOR: item.DESCSETOR,
        CODSETOR: item.SETOR,
        CNPJ: item.CNPJ,
        POSSE: item.POSSE,
        QUALIDADE: item.QUALIDADE,
        GRUPO: item.GRUPO,
        SUBGRUPO: item.SUB_GRUPO,
        LINHA: item.LINHA,
        QTDE: item.QTDE,
        PRECOMEDIO: item.PRE_MEDIO,
        GERAINVENTARIO: item.INVENTARIO,
      };

      arr.push(objItem);

      if (!arrDeposito.includes(item.DEPOSITO)){
        arrDeposito.push(item.DEPOSITO)
      }
    }

    const depositoFormatado = await formataListas(arrDeposito.toString())

    const pesquisaFaixaDesc = {
      tabela: 'INVENTARIO',
      camposSelect: ['DT_MES'],
      where: [`DT_MES = '${data}' 
              AND SETOR = '${pegaDescricao('#txtSetor')}' 
              AND TP_INV = 'P' 
              AND DEPOSITO IN (${depositoFormatado})`]
    }

    const jsonFaixa = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaFaixaDesc));

    if (jsonFaixa.length > 0) {
      await msgAguardaConfirmacao('Inventário já gerado para o setor, data e depositos filtrados, Deseja gerar novamente?', () => { }, () => {
        naoGerar = true
      })

      if (naoGerar) {
        throw new Error('Operação cancelada')
      }
    };
    
    if (codigoErro != '') {
      throw new Error(`Posse não informada para o material: ${codigoErro}. Favor Verificar o Cadastro do Material ou Depósito!`)
    }

    if (depositoErro != '' && setor == '') {
      throw new Error(`Setor não cadastrado no Depósito: ${depositoErro}. Favor Informar o Setor!`)
    }

    return {itens: arr, depositos: depositoFormatado};
  }

  $('#btnConfirmarInventario').on('click', async function () {
    $.LoadingOverlay("show");
    try {
      const url = `/sisplan/impressao/v1/gerarinventario?`;
      const itens = await retornaArrItens($('#tabelaPosicaoEstoque').DataTable().data().toArray(), pegaChave('#txtSetor'), $('#txtDataInventario').val())
      const objInventario = {
        DATAINVENTARIO: $('#txtDataInventario').val(),
        SETORINVENTARIO: pegaChave('#txtSetor'),
        DEPOSITOS: itens.depositos,
        ITENS: itens.itens
      }
      const response = await requisicao('POST', url, ``, encodeURIComponent(JSON.stringify(objInventario)), 990000);

      if (!response) {
        return;
      };

      if (response.status != 200) {
        const jsonStr = await response.json();
        throw new Error(jsonStr.mensagem);
      }

      criaMensagemSucesso('Inventário gerado com sucesso.', () => {
        {
          $('#modalInventario').modal('hide');
        }
      })
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  function addPesquisas() {
    componenteFiltro('material', true);
    componenteFiltro('cor', true);
    componenteFiltro('depositoUsuario', true);
    componenteFiltro('grupoMA', true);
    componenteFiltro('subGrupo', true);
    componenteFiltro('linha', true);
    componenteFiltro('colecao', true);
    componenteFiltro('qualidade', true);
    componenteFiltro('classeMat', true);
    componenteFiltro('natureza', true);
    componenteFiltro('codigoSped', true);
    componenteFiltro('local', true);
    componenteFiltro('setor', false, false)
  }

  function limpaFiltros() {
    $('#txtMaterial').empty().trigger('change');
    $('#txtCor').empty().trigger('change');
    $('#txtDepositoUsuario').empty().trigger('change');
    $('#txtGrupoMA').empty().trigger('change');
    $('#txtSubGrupo').empty().trigger('change');
    $('#txtLinha').empty().trigger('change');
    $('#txtColecao').empty().trigger('change');
    $('#txtQualidade').empty().trigger('change');
    $('#txtClasseMat').empty().trigger('change');
    $('#txtNatureza').empty().trigger('change');
    $('#txtCodigoSped').empty().trigger('change');
    $('#txtLocal').empty().trigger('change');
    $('#selectPosse').val('');
    $('#txtLote').val('');

    $('#txtData').val('1200-01-01');
    $('#rdFiltroTodos').prop('checked', true);
  }

})
