$(document).ready(async function () {
    $('#tutorial').on('click', function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: 'Sair',
                closeBtnText: 'Fechar',
                nextBtnText: 'Próximo',
                prevBtnText: 'Anterior',
                allowClose: false
            });
            driver.defineSteps([{
                element: '#btn-filtros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique nesse botão para filtrar sua consulta.',
                    position: 'bottom'
                }
            },
            {
                element: '#btnConfig',
                popover: {
                    title: 'Botão Config.',
                    description: 'Clique nesse botão para fazer a configuração da MDF-e.',
                    position: 'bottom'
                }
            },
            {
                element: '#btnIncDFe',
                popover: {
                    title: 'Botão Inc. de DFe',
                    description: 'Clique nesse botão para Adiconar Documento Frete Posterior.',
                    position: 'bottom'
                }
            },
            {
                element: '#txtVencimentoCertificadoDigital',
                popover: {
                    title: 'Certificado',
                    description: 'Informação da validade do certificado digital.',
                    position: 'bottom'
                }
            },
            {
                element: '#txtAmbienteDesc',
                popover: {
                    title: 'Ambiente',
                    description: 'Informação do ambiente configurado para emissão de MDF-e.',
                    position: 'bottom'
                }
            },
            {
                element: '#tabelaMDFe_wrapper',
                popover: {
                    title: 'MDF-e',
                    description: `Aqui ficam as MDF-e's filtradas.`,
                    position: 'top'
                }
            },
            {
                element: '#dadosnota',
                popover: {
                    title: 'Dados da MDF-e',
                    description: 'Aqui ficam os dados da MDF-e que está selecionada.',
                    position: 'top'
                }
            },
            {
                element: '#btnGerar',
                popover: {
                    title: 'Botão Gerar',
                    description: 'Clique aqui para gerar a MDF-e selecionada.',
                    position: 'top'
                }
            },
            {
                element: '#btnEncerramento',
                popover: {
                    title: 'Botão Fazer Encerramento',
                    description: 'Clique aqui para encerrar a MDF-e selecionada.',
                    position: 'top'
                }
            },
            {
                element: '#btnImprimir',
                popover: {
                    title: 'Botão Imprimir',
                    description: 'Clique aqui para imprimir a MDF-e selecionada.',
                    position: 'top'
                }
            },
            {
                element: '#btnCancelar',
                popover: {
                    title: 'Botão Cancelar',
                    description: 'Clique aqui para cancelar a MDF-e selecionada.',
                    position: 'top'
                }
            },
            {
                element: '#btnExcluir',
                popover: {
                    title: 'Botão Excluir',
                    description: 'Clique aqui para excluir a MDF-e selecionada.',
                    position: 'top'
                }
            },
            {
                element: '#btnConsultar',
                popover: {
                    title: 'Botão Consultar',
                    description: 'Clique aqui para consultar a MDF-e selecionada.',
                    position: 'top'
                }
            },

            ]);
            //inicio tour 

            driver.start();

            const activeElement = driver.getHighlightedElement();
            // inicior tuor
            //final
        });
    });

    $("#msDFe").validate({
        debug: false,
        ignore: "",
        rules: {
            txtMunicipioCar: {
                required: true,
            },
            txtMunicipioDesc: {
                required: true,
            },
            txtChaveNFe: {
                required: true,
            }
        },
        messages: {
            txtMunicipioCar: {
                required: "Informe o município de carregamento."
            },
            txtMunicipioDesc: {
                required: "Informe o município de descarregamento."
            },
            txtChaveNFe: {
                required: "Informe a chave."
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    if (getCookie('usuario') == "") {
        window.location.href = "<?php echo BASE_URI; ?>/login"
        return;
    }

    const temAcesso = await temAcessoTela('IMPRESSAO_MDFE');
    if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, "<?php echo BASE_URI; ?>");
        return;
    }

    await retornaAmbiente();
    await vencimentoCertificado();
    await retornaMDFe();
    await componenteFiltros();

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtDataEmissaoDe').val('1899-01-01');
        $('#txtDataEmissaoAte').val('2500-01-01');
        $('#txtVeiculoFiltro').val('');
        $('#txtMDFe').val('');
        $('#radioManifestos').prop('checked', true);
        $('#radioProtocolo1').prop('checked', true);
    });

    $('#btnConfig').on('click', async function () {
        try {
            await retornaDadosIni();
        } finally {
            $('#modal-config').modal('show');
        }
    });

    $('#btnConfirmarConfigMDFe').on('click', async function () {
        try {
            await gravaDadosIni();
        } finally {
            $('#modal-config').modal('hide');
        }
    });

    $('#btn-consultar').on('click', async function () {
        await retornaMDFe();
        $('#modal-filtros').modal('hide');
    });

    $('#btnImprimir').on('click', async function () {
        await imprimirMDFe();
    });

    $('#btnCancelar').on('click', async function () {
        const data = $('#tabelaMDFe').DataTable().row($('tr.selected')).data();
        if (data == undefined) {
            msgAlerta('Selecione uma MDF-e para cancelar.');
            return;
        }

        $('#modal-cancelamento').modal('show');
    });

    $('#btnConsultar').on('click', async function () {
        await consultaMDFe();
    });

    $('#btn-confirmar-cancelamento').on('click', async function () {
        await cancelarMDFe();
    });

    $('#btnGerar').on('click', async function () {
        await gerarMDFe();
    });

    $('#btnExcluir').on('click', async function () {
        msgAlerta(
            'Deseja Excluir este Registro?',
            () => { return },
            () => { return },
            async () => { await excluiMDFe() }
        );
    });

    $('#btnEncerramento').on('click', async function () {
        msgAlerta(
            'Deseja realizar o encerramento do Manifesto?',
            () => { return },
            () => { return },
            async () => { await encerrarMDFe() }
        );
    });

    $('#btnGerarDFe').on('click', async function () {
        await gerarDFe();
    });

    $('#confirmar_dados').on('click', async function () {
        await alteraDados();
    });

    $('#txtNumeroAverbacoes').focusout(function () {
        if ($(this).val() != '') {
            adicionaAverbacao($(this).val());
            $(this).val('');
            $(this).focus();
        }
    });

    $('#txtVeiculo').focusout(async function () {
        if ($(this).val() != '') {
            const capacidade = await buscaValor('VEICULO', 'CAPAC_KG', 'PLACA', pegaChave(this));
            insereValor('#txtCapacKG', capacidade.CAPAC_KG);
        }
    });

    $('#btnIncDFe').on('click', async function () {
        const tr = $('#tabelaMDFe tr.selected')[0];
        if (tr == undefined) {
            msgAlerta('Selecione uma MDF-e para prosseguir.');
            return;
        }

        const data = $('#tabelaMDFe').DataTable().row($(tr)).data();

        if (['C', 'E'].includes(data.IMPRESSO)) {
            msgAlerta('Manifesto já encerrado ou cancelado! Impossível continuar.');
            return;
        }

        if (data.CARGA_POSTERIOR == 'N') {
            msgAlerta('Mdfe não é de carga posterior, impossível adicionar DFe.');
            return;
        }

        insereValor('#txtIncDFeChaveMDFe', data.CHAVE_MDFE);
        $('#modal-IncDFe').modal('show');
    });

    $('#modal-itens').on('shown.bs.modal', async function () {
        if ($.fn.DataTable.isDataTable('#tabelaMunicipioCarregamento')) {
            await sleep(200);
            $("#tabelaMunicipioCarregamento").DataTable().columns.adjust().draw(false);
        }

        if ($.fn.DataTable.isDataTable('#tabelaPercurso')) {
            await sleep(200);
            $("#tabelaPercurso").DataTable().columns.adjust().draw(false);
        }

        if ($.fn.DataTable.isDataTable('#tabelaOutrosMotoristas')) {
            await sleep(200);
            $("#tabelaOutrosMotoristas").DataTable().columns.adjust().draw(false);
        }

        if ($.fn.DataTable.isDataTable('#tabelaReboques')) {
            await sleep(200);
            $("#tabelaReboques").DataTable().columns.adjust().draw(false);
        }

        const tr = $('#tabelaMDFe tr.selected')[0];
        const data = $('#tabelaMDFe').DataTable().row($(tr)).data();
        const bAltera = (data?.PROTOCOLO != '') || (data?.RECIBO_MDFE != '');
        $('#rgTipoRespSeguro').prop('disabled', bAltera);
        $('#txtCNPJRespSeguro').prop('disabled', bAltera);
        $('#txtCPFRespSeguro').prop('disabled', bAltera);
        $('#txtNomeInfSeguradora').prop('disabled', bAltera);
        $('#txtCNPJInfSeguradora').prop('disabled', bAltera);
        $('#txtApoliceInfSeguradora').prop('disabled', bAltera);
        $('#rgTipoCargaProdPredo').prop('disabled', bAltera);
        $('#txtDescProdPredomiProdPredo').prop('disabled', bAltera);
        $('#txtCEPCarregamentoProdPredo').prop('disabled', bAltera);
        $('#txtCEPDescarregamentoProdPredo').prop('disabled', bAltera);
        $('#txtLatitudeCarregamentoProdPredo').prop('disabled', bAltera);
        $('#txtLatitudeDescarregamentoProdPredo').prop('disabled', bAltera);
        $('#txtLongitudeCarregamentoProdPredo').prop('disabled', bAltera);
        $('#txtLongitudeDescarregamentoProdPredo').prop('disabled', bAltera);
        $('#btn-CEPCarregamentoProdPredo').prop('disabled', bAltera);
        $('#btn-limpar-CEPCarregamentoProdPredo').prop('disabled', bAltera);
        $('#btn-CEPDescarregamentoProdPredo').prop('disabled', bAltera);
        $('#btn-limpar-CEPDescarregamentoProdPredo').prop('disabled', bAltera);
        $('#txtNumeroAverbacoes').prop('disabled', bAltera);
        $('#tabDadosMDFe').prop('hidden', bAltera);
        $('#divDadosMDFe').prop('hidden', bAltera);
    });

    // $('#tabPercurso').on('click', async function () {
    //     if ($.fn.DataTable.isDataTable('#tabelaPercurso')) {
    //         await sleep(200);
    //         $("#tabelaPercurso").DataTable().columns.adjust().draw(false);
    //     }
    // });

    // $('#tabOutrosMotoristas').on('click', async function () {
    //     if ($.fn.DataTable.isDataTable('#tabelaOutrosMotoristas')) {
    //         await sleep(200);
    //         $("#tabelaOutrosMotoristas").DataTable().columns.adjust().draw(false);
    //     }
    // });

    // $('#tabReboques').on('click', async function () {
    //     if ($.fn.DataTable.isDataTable('#tabelaReboques')) {
    //         await sleep(200);
    //         $("#tabelaReboques").DataTable().columns.adjust().draw(false);
    //     }
    // });

    $('#tabDocFiscais').on('click', async function () {
        if ($.fn.DataTable.isDataTable('#tabelaNFe')) {
            await sleep(200);
            $("#tabelaNFe").DataTable().columns.adjust().draw(false);
        }

        if ($.fn.DataTable.isDataTable('#tabelaCTe')) {
            await sleep(200);
            $("#tabelaCTe").DataTable().columns.adjust().draw(false);
        }

        if ($.fn.DataTable.isDataTable('#tabelaNF')) {
            await sleep(200);
            $("#tabelaNF").DataTable().columns.adjust().draw(false);
        }

        if ($.fn.DataTable.isDataTable('#tabelaCT')) {
            await sleep(200);
            $("#tabelaCT").DataTable().columns.adjust().draw(false);
        }

        if ($.fn.DataTable.isDataTable('#tabelaEventoDFe')) {
            await sleep(200);
            $("#tabelaEventoDFe").DataTable().columns.adjust().draw(false);
        }
    });

    // $('#tabNFe').on('click', async function () {
    //     if ($.fn.DataTable.isDataTable('#tabelaNFe')) {
    //         await sleep(200);
    //         $("#tabelaNFe").DataTable().columns.adjust().draw(false);
    //     }
    // });

    // $('#tabCTe').on('click', async function () {
    //     if ($.fn.DataTable.isDataTable('#tabelaCTe')) {
    //         await sleep(200);
    //         $("#tabelaCTe").DataTable().columns.adjust().draw(false);
    //     }
    // });

    // $('#tabNF').on('click', async function () {
    //     if ($.fn.DataTable.isDataTable('#tabelaNF')) {
    //         await sleep(200);
    //         $("#tabelaNF").DataTable().columns.adjust().draw(false);
    //     }
    // });

    // $('#tabCT').on('click', async function () {
    //     if ($.fn.DataTable.isDataTable('#tabelaCT')) {
    //         await sleep(200);
    //         $("#tabelaCT").DataTable().columns.adjust().draw(false);
    //     }
    // });

    $('#tabAverbacoes').on('click', async function () {
        if ($.fn.DataTable.isDataTable('#tabelaAverbacoes')) {
            await sleep(200);
            $("#tabelaAverbacoes").DataTable().columns.adjust().draw(false);
        }
    });

    $('#tabelaAverbacoes').on('click', '.btn-excluir', async function () {
        $('#tabelaAverbacoes').DataTable().row($(this).parents('tr')).remove().draw(false);
    });

    // $('#tabEventoDFe').on('click', async function () {
    //     if ($.fn.DataTable.isDataTable('#tabelaEventoDFe')) {
    //         await sleep(200);
    //         $("#tabelaEventoDFe").DataTable().columns.adjust().draw(false);
    //     }
    // });

    async function retornaAmbiente() {
        try {
            let response = await requisicao('GET', '/sisplan/funcoes/v1/retornaambientemdfe?', '');
            if (!response) {
                return;
            }
            let jsonStr = await response.json();

            if (jsonStr.mensagem == '1') {
                $("#txtAmbienteDesc").css("color", "green");
                $("#txtAmbienteDesc")[0].textContent = "AMBIENTE: PRODUÇÃO";
            } else {
                $("#txtAmbienteDesc").css("color", "red");
                $("#txtAmbienteDesc")[0].textContent = "AMBIENTE: HOMOLOGAÇÃO";
            }
        } catch (error) {
            console.error(error);
        }
    }

    function retornaBotaoOpcoes(data) {
        return '<div style="text-align:left;"> ' +
            '   <div> ' +
            '    <button class="btn btn-info btn-sm" id="btn-mostrar-itens" type="button"> ' +
            '   ' + data + ' ' +
            '    </button> ' +
            '  </div>' +
            '</div>';
    }

    async function retornaMDFe() {
        $.LoadingOverlay("show");
        try {
            if ($.fn.DataTable.isDataTable('#tabelaMDFe')) {
                $('#tabelaMDFe').DataTable().destroy();
                $('#tabelaMDFe').empty();
            }

            const url = '/sisplan/mdfe/v1/mdfe?';
            const filtros = retornaFiltros();
            const response = await requisicao('GET', url, filtros, null, 50000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            if (response.status != 200) {
                msgErro(jsonStr.mensagem)
                return;
            }

            if (jsonStr.length == 0) {
                msgAlerta('Nenhum registro encontrado!');
                return;
            }

            const colunasItens = [
                { title: 'Impresso', data: 'IMPRESSO' },
                { title: 'Número', data: 'NUMERO' },
                { title: 'Série', data: 'SERIE' },
                { title: 'Data Emissão', data: 'DT_EMISSAO' },
                { title: 'Veículo', data: 'VEICULO' },
                { title: 'Desc. Veículo', data: 'DESC_VEICULO' },
                { title: 'Motorista', data: 'MOTORISTA' },
                { title: 'Nome Motorista', data: 'NOME' },
                { title: 'Valor Carga', data: 'VALOR_CARGA' },
                { title: 'Peso Bruto', data: 'PESO_BRUTO' },
                { title: 'Carga Posterior', data: 'CARGA_POSTERIOR' }
            ]

            $('#tabelaMDFe').DataTable({
                search: false,
                filter: false,
                order: [],
                sort: true,
                destroy: true,
                paging: true,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },

                "autoWidth": true,
                "data": jsonStr,
                "columns": colunasItens,
                autoWidth: true,
                "colReorder": true,
                "columnDefs": [{
                    "type": 'date-br',
                    "targets": 3,
                    "render": function (data) {
                        if (data != undefined) {
                            x = data.slice(0, 10).split('-');
                            return `${x[2]}/${x[1]}/${x[0]}`;
                        } else {
                            return ''
                        }
                    }
                },
                {
                    targets: [1],
                    render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    },
                },
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-BR", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2
                        });
                    },
                    targets: [8, 9],
                    "className": 'pr-4 text-right'
                }]
            });

            $('#tabelaMDFe tbody').unbind('click');
            $('#tabelaMDFe tbody').on('click', 'tr', async function () {
                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                } else {
                    $('#tabelaMDFe').DataTable().$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                    if ($('#tabelaMDFe').DataTable().rows().count() == 0) {
                        $('#txtChave').val('');
                        $('#txtProtocolo').val('');
                        $('#txtEmissao').val('');
                        $('#txtRecibo').val('');
                        $('#txtLote').val('');
                        $('#txtQrCode').val('');
                    } else {
                        const data = $('#tabelaMDFe').DataTable().row($(this)).data();
                        $('#txtChave').val(data.CHAVE_MDFE);
                        $('#txtProtocolo').val(data.PROTOCOLO);
                        $('#txtEmissao').val(data.EMISSAO_MDFE);
                        $('#txtRecibo').val(data.RECIBO_MDFE);
                        $('#txtLote').val(data.LOTE_MDFE);
                        $('#txtQrCode').val(data.QR_CODE);
                    }
                }
            });

            $('#tabelaMDFe').on('click', '#btn-mostrar-itens', async function () {
                const tr = this.closest('tr');
                $(tr).addClass('selected');
                const data = $('#tabelaMDFe').DataTable().row($(tr)).data();
                await buscaDadosMDFe(data);
            });
            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    function retornaFiltros() {
        const dtEmissaoDe = $('#txtDataEmissaoDe').val();
        const dtEmissaoAte = $('#txtDataEmissaoAte').val();
        const veiculo = pegaChave('#txtVeiculoFiltro');
        const numero = pegaChave('#txtMDFe');
        const empID = getCookie('emp_id');
        let protocolo;
        let status;

        switch ($('input[name=rg_status]:checked').val()) {
            case '1': {
                status = 'S';
                break;
            }
            case '2': {
                status = 'N';
                break;
            }
            case '3': {
                status = 'C';
                break;
            }
            case '4': {
                status = 'E';
                break;
            }
            default:
                status = '';
                break;
        }

        switch ($('input[name=rg_protocolo]:checked').val()) {
            case '1': {
                protocolo = "C";
                break;
            }
            case '2': {
                protocolo = "S";
                break;
            }
            default:
                protocolo = '';
                break;
        }

        const retorno = `DATA_EMI_DE=${dtEmissaoDe}` +
            `&DATA_EMI_ATE=${dtEmissaoAte}` +
            `&VEICULO=${veiculo}` +
            `&NUMERO=${numero}` +
            `&PROTOCOLO=${protocolo}` +
            `&STATUS=${status}` +
            `&EMP_ID=${empID}`;

        return retorno;
    }

    async function componenteFiltros() {
        await componenteFiltro('reboque', true);

        $('#txtMDFe').autocompleta(1, `JSON={ "tabela":"NOTA_MDFE", "camposSelect":[ "NUMERO CHAVE", "VEICULO DESCRICAO"], "where": null}`);
        $('#btnMDFe').pesquisa('#txtMDFe', 'CHAVE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NOTA_MDFE", "camposSelect":[ "NUMERO CHAVE", "VEICULO DESCRICAO"]}`, 'Pesquisa MDF-e', 'NOTA_MDFE');
        $('#btnLimpaMDFe').on('click', function () {
            $('#txtMDFe').val('');
        });

        $('#txtVeiculoFiltro').autocompleta(1, `JSON={ "tabela":"VEICULO", "camposSelect":[ "PLACA CHAVE", "MODELO DESCRICAO"], "where": null}`);
        $('#btnVeiculoFiltro').pesquisa('#txtVeiculoFiltro', 'CHAVE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VEICULO", "camposSelect":[ "PLACA CHAVE", "MODELO DESCRICAO"]}`, 'Pesquisa veículo', 'VEICULO');
        $('#btnLimpaVeiculoFiltro').on('click', function () {
            $('#txtVeiculoFiltro').val('');
        });

        $('#txtMunicipioCar').autocompleta(1, `JSON={ "tabela":"CIDADE", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
        $('#btnMunicipioCar').pesquisa('#txtMunicipioCar', 'CHAVE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CIDADE", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"]}`, 'Pesquisa cidade', 'CIDADE');
        $('#btnLimpaMunicipioCar').on('click', function () {
            $('#txtMunicipioCar').val('');
        });

        $('#txtMunicipioDesc').autocompleta(1, `JSON={ "tabela":"CIDADE", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
        $('#btnMunicipioDesc').pesquisa('#txtMunicipioDesc', 'CHAVE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CIDADE", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"]}`, 'Pesquisa cidade', 'CIDADE');
        $('#btnLimpaMunicipioDesc').on('click', function () {
            $('#txtMunicipioDesc').val('');
        });

        $('#txtChaveNFe').autocompleta(1, `JSON={ "tabela":"NOTA", "camposSelect":[ "CHAVE_NFE CHAVE", "FATURA DESCRICAO"], "where": null}`);
        $('#btnChaveNFe').pesquisa('#txtChaveNFe', 'CHAVE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NOTA", "camposSelect":[ "CHAVE_NFE CHAVE", "FATURA DESCRICAO"]}`, 'Pesquisa nota', 'NOTA');
        $('#btnLimpaChaveNFe').on('click', function () {
            $('#txtChaveNFe').val('');
        });

        $('#txtCEPCarregamentoProdPredo').autocompleta(1, `JSON={ "tabela":"CADCEP", "camposSelect":[ "CEP CHAVE", "CEP DESCRICAO"], "where": null}`);
        $(`#btn-CEPCarregamentoProdPredo`).pesquisa_serverside(
            [`#txtCEPCarregamentoProdPredo`],
            ["CEP"],
            ["CEP"],
            '{ "tabela":"CADCEP", "camposSelect":[ "CEP", "CEP"], "where": null}',
            "Pesquisa CEP"
        );
        $('#btn-limpar-CEPCarregamentoProdPredo').on('click', function () {
            $('#txtCEPCarregamentoProdPredo').val('');
        });

        $('#txtCEPDescarregamentoProdPredo').autocompleta(1, `JSON={ "tabela":"CADCEP", "camposSelect":[ "CEP CHAVE", "CEP DESCRICAO"], "where": null}`);
        $(`#btn-CEPDescarregamentoProdPredo`).pesquisa_serverside(
            [`#txtCEPDescarregamentoProdPredo`],
            ["CEP"],
            ["CEP"],
            '{ "tabela":"CADCEP", "camposSelect":[ "CEP", "CEP"], "where": null}',
            "Pesquisa CEP"
        );
        $('#btn-limpar-CEPDescarregamentoProdPredo').on('click', function () {
            $('#txtCEPDescarregamentoProdPredo').val('');
        });

        $('#txtVeiculo').autocompleta(1, `JSON={ "tabela":"VEICULO", "camposSelect":[ "placa chave", "modelo descricao"], "where": ["ATIVO = 'S'"]}`);
        $('#btnVeiculo').pesquisa('#txtVeiculo', 'PLACA', 'MODELO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VEICULO", "camposSelect":[ "PLACA", "MODELO"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa veículo', 'VEICULO');
        $('#btnLimpaVeiculo').on('click', function () {
            $('#txtVeiculo').val('');
        });

        $('#txtMotorista').autocompleta(1, `JSON={ "tabela":"MOTORISTA", "camposSelect":[ "codigo chave", "nome descricao"], "where": null}`);
        $('#btnMotorista').pesquisa('#txtMotorista', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOTORISTA", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa motorista', 'MOTORISTA');
        $('#btnLimpaMotorista').on('click', function () {
            $('#txtMotorista').val('');
        });
    }

    async function retornaDadosIni() {
        $.LoadingOverlay('show');
        try {
            const url = '/sisplan/mdfe/v1/buscarinimdfe?';
            const response = await requisicao('GET', url, '', null);

            const jsonIni = await response.json();
            if (response.status != 200) {
                console.log(jsonIni.RESULT[0][0].mensagem);
                return;
            }

            $('#txtDiretorioLog').val(jsonIni.diretorioLog);

            if (jsonIni.ambiente == '2') {
                $('#txtAmbiente').val('2');
            } else {
                $('#txtAmbiente').val('1');
            }
        } catch (error) {
            msgErro(`Erro na rotina retornaDadosIni: ${error.message}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function gravaDadosIni() {
        $.LoadingOverlay('show');
        try {
            const url = '/sisplan/mdfe/v1/buscarinimdfe?';
            const MDFe = {
                ambiente: $('#txtAmbiente').val(),
                diretorioLog: $('#txtDiretorioLog').val()
            };
            const response = await requisicao('POST', url, '', JSON.stringify(MDFe), 15000);

            if (response.status != 200) {
                const jsonIni = await response.json();
                console.log(jsonIni.RESULT[0][0].mensagem);
                return;
            } else {
                criaMensagemSucesso('Configuração gravada com sucesso!');
                await retornaAmbiente();
            }
        } catch (error) {
            msgErro(`Erro na rotina gravaDadosIni: ${error.message}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function gerarMDFe() {
        $.LoadingOverlay('show');
        try {
            const data = $('#tabelaMDFe').DataTable().row($('tr.selected')).data();
            if (data == undefined) {
                msgAlerta('Selecione uma MDF-e para gerar.');
                return;
            }
            const _url = '/sisplan/mdfe/v1/gerarmdfe?';
            const _params = `NUMERO=${data.NUMERO}&SERIE=${data.SERIE}`;
            const response = await requisicao('POST', _url, _params, null, 60000);

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }

            await criaMensagemSucesso('MDF-e gerada com sucesso!', async () => {
                $('#btnImprimir').trigger('click');
                $('#btn-consultar').trigger('click');
            });
        } catch (error) {
            console.log(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function buscaDadosMDFe(data) {
        $.LoadingOverlay('show');
        try {
            const url = '/sisplan/mdfe/v1/buscamdfe?';
            const filtros = `NUMERO=${data.NUMERO}&SERIE=${data.SERIE}&EMP_ID=${getCookie('emp_id')}`;
            const response = await requisicao('GET', url, filtros, null, 50000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            if (response.status != 200) {
                msgErro(jsonStr.mensagem)
                return;
            }

            if (jsonStr.length == 0) {
                msgAlerta('Nenhum registro encontrado!');
                return;
            }

            municipioCarregamento(jsonStr.nota_Mun);
            outrosMotoristas(jsonStr.nota_Mot);
            percurso(jsonStr.nota_UF);
            reboques(jsonStr.reboques);
            NFe(jsonStr.notaIten);
            CTe(jsonStr.notaIten);
            NF(jsonStr.notaIten);
            CT(jsonStr.notaIten);
            seguradora(jsonStr);
            prodPredominante(jsonStr);
            eventoDFe(jsonStr.evento_MDFe);
            DadosMDFe(jsonStr);
            $('#tabInfTransporte').trigger('click');
            $('#modal-itens').modal('show');
        } catch (error) {
            console.log(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    function municipioCarregamento(data) {
        if ($.fn.DataTable.isDataTable('#tabelaMunicipioCarregamento')) {
            $('#tabelaMunicipioCarregamento').DataTable().destroy();
            $('#tabelaMunicipioCarregamento').empty();
        }

        const colunasMunCarregamento = [
            { title: 'Cidade', data: 'cidade' },
            { title: 'Nome', data: 'nome' }
        ]

        $('#tabelaMunicipioCarregamento').DataTable({
            destroy: true,
            filter: false,
            paging: false,
            scrollX: true,
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },

            "autoWidth": true,
            "data": data,
            "columns": colunasMunCarregamento,
            autoWidth: true,
            "colReorder": true,
        });
    }

    function outrosMotoristas(data) {
        if ($.fn.DataTable.isDataTable('#tabelaOutrosMotoristas')) {
            $('#tabelaOutrosMotoristas').DataTable().destroy();
            $('#tabelaOutrosMotoristas').empty();
        }

        const colunasOutrosMotoristas = [
            { title: 'Motorista', data: 'motorista' },
            { title: 'Nome', data: 'nome' },
            { title: 'CPF', data: 'cPF' }
        ]

        $('#tabelaOutrosMotoristas').DataTable({
            destroy: true,
            filter: false,
            paging: false,
            scrollX: true,
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },

            "autoWidth": true,
            "data": data,
            "columns": colunasOutrosMotoristas,
            autoWidth: true,
            "colReorder": true,
        });
    }

    function percurso(data) {
        if ($.fn.DataTable.isDataTable('#tabelaPercurso')) {
            $('#tabelaPercurso').DataTable().destroy();
            $('#tabelaPercurso').empty();
        }

        const colunasPercurso = [
            { title: 'UF', data: 'uF' }
        ]

        $('#tabelaPercurso').DataTable({
            destroy: true,
            filter: false,
            paging: false,
            scrollX: true,
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },

            "autoWidth": true,
            "data": data,
            "columns": colunasPercurso,
            autoWidth: true,
            "colReorder": true,
        });
    }

    function reboques(data) {
        if ($.fn.DataTable.isDataTable('#tabelaReboques')) {
            $('#tabelaReboques').DataTable().destroy();
            $('#tabelaReboques').empty();
        }

        const colunasPercurso = [
            { title: 'Reboque', data: 'reboque' },
            { title: 'Reboque Tara', data: 'reboq_Tara' },
            { title: 'Reboque Capac. KG', data: 'reboq_Capac_KG' },
            { title: 'Reboque Capac. M3', data: 'reboq_Capac_M3' },
            { title: 'Reboque Tipo Rodado', data: 'reboq_Tipo_Rodado' },
            { title: 'Reboque Tipo Carroceria', data: 'reboq_Tipo_Carroc' },
            { title: 'Reboque UF Licenc.', data: 'reboq_UF_Licenc' },
        ]

        $('#tabelaReboques').DataTable({
            destroy: true,
            filter: false,
            paging: false,
            scrollX: true,
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
            columnDefs: [
                {
                    "targets": [1, 2, 3, 4, 5],
                    "className": 'pr-4 text-right'
                }
            ],
            "autoWidth": true,
            "data": data,
            "columns": colunasPercurso,
            autoWidth: true,
            "colReorder": true,
        });
    }

    function NFe(data) {
        if ($.fn.DataTable.isDataTable('#tabelaNFe')) {
            $('#tabelaNFe').DataTable().destroy();
            $('#tabelaNFe').empty();
        }

        const colunasNFe = [
            { title: 'Cidade', data: 'cidade' },
            { title: 'Nome', data: 'nomeCidade' },
            { title: 'Chave NF-e', data: 'chave_NFe' },
            { title: 'Peso Bruto', data: 'peso_Bruto' },
            { title: 'Valor', data: 'valor' },
        ]

        data = data?.filter((obj) => {
            return obj.tipo === 'N';
        })

        $('#tabelaNFe').DataTable({
            destroy: true,
            filter: false,
            paging: false,
            scrollX: true,
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
            columnDefs: [
                {
                    "render": function (data) {
                        return parseFloat(data).toLocaleString('pt-BR', {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2
                        });
                    },
                    "className": 'pr-4 text-right',
                    "targets": [3, 4],
                }
            ],
            "autoWidth": true,
            "data": data,
            "columns": colunasNFe,
            autoWidth: true,
            "colReorder": true,
        });
    }

    function CTe(data) {
        if ($.fn.DataTable.isDataTable('#tabelaCTe')) {
            $('#tabelaCTe').DataTable().destroy();
            $('#tabelaCTe').empty();
        }

        const colunasCTe = [
            { title: 'Cidade', data: 'cidade' },
            { title: 'Nome', data: 'nomeCidade' },
            { title: 'Chave CT-e', data: 'chave_CTe' },
            { title: 'Peso Bruto', data: 'peso_Bruto' },
            { title: 'Valor', data: 'valor' },
        ]

        data = data?.filter((obj) => {
            return obj.tipo === 'C';
        })

        $('#tabelaCTe').DataTable({
            destroy: true,
            filter: false,
            paging: false,
            scrollX: true,
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
            columnDefs: [
                {
                    "render": function (data) {
                        return parseFloat(data).toLocaleString('pt-BR', {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2
                        });
                    },
                    "className": 'pr-4 text-right',
                    "targets": [3, 4],
                }
            ],
            "autoWidth": true,
            "data": data,
            "columns": colunasCTe,
            autoWidth: true,
            "colReorder": true,
        });
    }

    function NF(data) {
        if ($.fn.DataTable.isDataTable('#tabelaNF')) {
            $('#tabelaNF').DataTable().destroy();
            $('#tabelaNF').empty();
        }

        const colunasNF = [
            { title: 'Cidade', data: 'cidade' },
            { title: 'Nome', data: 'nomeCidade' },
            { title: 'Num. NF', data: 'num_NF' },
            { title: 'Série NF', data: 'serie_NF' },
            { title: 'CNPJ', data: 'cNPJ' },
            { title: 'UF Destino', data: 'uF_Destino' },
            { title: 'Dt. Emissão', data: 'dt_Emissao' },
            { title: 'Valor', data: 'valor' },
            { title: 'Peso Bruto', data: 'peso_Bruto' },
        ]

        data = data?.filter((obj) => {
            return obj.tipo === 'F';
        })

        $('#tabelaNF').DataTable({
            destroy: true,
            filter: false,
            paging: false,
            scrollX: true,
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
            columnDefs: [
                {
                    "type": 'date-br',
                    "targets": 6,
                    "render": function (data) {
                        if (data != undefined) {
                            x = data.slice(0, 10).split('-');
                            return `${x[2]}/${x[1]}/${x[0]}`;
                        } else {
                            return ''
                        }
                    }
                },
                {
                    "render": function (data) {
                        return parseFloat(data).toLocaleString('pt-BR', {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2
                        });
                    },
                    "className": 'pr-4 text-right',
                    "targets": [7, 8],
                }
            ],
            "autoWidth": true,
            "data": data,
            "columns": colunasNF,
            autoWidth: true,
            "colReorder": true,
        });
    }

    function CT(data) {
        if ($.fn.DataTable.isDataTable('#tabelaCT')) {
            $('#tabelaCT').DataTable().destroy();
            $('#tabelaCT').empty();
        }

        const colunasCT = [
            { title: 'Cidade', data: 'cidade' },
            { title: 'Nome', data: 'nomeCidade' },
            { title: 'Num. CT', data: 'num_NF' },
            { title: 'Série CT', data: 'serie_NF' },
            { title: 'Sub. Série', data: 'sub_Serie' },
            { title: 'Dt. Emissão', data: 'dt_Emissao' },
            { title: 'Valor', data: 'valor' },
            { title: 'Peso Bruto', data: 'peso_Bruto' },
        ]

        data = data?.filter((obj) => {
            return obj.tipo === 'T';
        })

        $('#tabelaCT').DataTable({
            destroy: true,
            filter: false,
            paging: false,
            scrollX: true,
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
            columnDefs: [
                {
                    "type": 'date-br',
                    "targets": 5,
                    "render": function (data) {
                        if (data != undefined) {
                            x = data.slice(0, 10).split('-');
                            return `${x[2]}/${x[1]}/${x[0]}`;
                        } else {
                            return ''
                        }
                    }
                },
                {
                    "render": function (data) {
                        return parseFloat(data).toLocaleString('pt-BR', {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2
                        });
                    },
                    "className": 'pr-4 text-right',
                    "targets": [6, 7],
                }
            ],
            "autoWidth": true,
            "data": data,
            "columns": colunasCT,
            autoWidth: true,
            "colReorder": true,
        });
    }

    function seguradora(data) {
        const tr = $('#tabelaMDFe tr.selected')[0];
        const tabela = $('#tabelaMDFe').DataTable().row($(tr)).data();
        const bAltera = (tabela?.PROTOCOLO != '') || (tabela?.RECIBO_MDFE != '');
        $('#rgTipoRespSeguro').val(data.tipo_Resp_Seg);
        insereValor('#txtCNPJRespSeguro', data.cnpj_Resp_Seg);
        insereValor('#txtCPFRespSeguro', data.cpf_Resp_Seg);
        insereValor('#txtNomeInfSeguradora', data.nome_Seg);
        insereValor('#txtCNPJInfSeguradora', data.cnpj_Seg);
        insereValor('#txtApoliceInfSeguradora', data.apolice_Seg);

        if ($.fn.DataTable.isDataTable('#tabelaAverbacoes')) {
            $('#tabelaAverbacoes').DataTable().destroy();
            $('#tabelaAverbacoes').empty();
        }

        const colunasAverbacoes = [
            { title: 'Averbação', data: 'averbacao' },
            { title: "Ação", data: "ACAO" }
        ]

        data.nota_Averb = data.nota_Averb?.map(function (objeto) {
            return { ...objeto, ACAO: adicionaBotoes(bAltera) };
        });

        $('#tabelaAverbacoes').DataTable({
            bPaginate: false,
            destroy: true,
            search: false,
            filter: false,
            lengthChange: false,
            scrollX: true,
            serverside: false,
            order: false,
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
            "autoWidth": true,
            "data": data.nota_Averb,
            "columns": colunasAverbacoes,
            autoWidth: true,
            "colReorder": true,
        });
    }

    function prodPredominante(data) {
        $('#rgTipoCargaProdPredo').val(data.tp_Carga);
        insereValor('#txtDescProdPredomiProdPredo', data.desc_Prodpred);
        insereValor('#txtCEPCarregamentoProdPredo', data.cep_Carrega);
        insereValor('#txtCEPDescarregamentoProdPredo', data.cep_Descarrega);
        insereValor('#txtLatitudeCarregamentoProdPredo', data.latitude_Carrega);
        insereValor('#txtLatitudeDescarregamentoProdPredo', data.latitude_Descarrega);
        insereValor('#txtLongitudeCarregamentoProdPredo', data.longitude_Carrega);
        insereValor('#txtLongitudeDescarregamentoProdPredo', data.longitude_Descarrega);
    }

    function eventoDFe(data) {
        if ($.fn.DataTable.isDataTable('#tabelaEventoDFe')) {
            $('#tabelaEventoDFe').DataTable().destroy();
            $('#tabelaEventoDFe').empty();
        }

        const colunasEventoDFe = [
            { title: 'Seq', data: 'sequencia' },
            { title: 'CodMun. Carregamento', data: 'mun_Carrega' },
            { title: 'Cidade Carregamento', data: 'cidadeCarrega' },
            { title: 'CodMun Descarregamento', data: 'mun_Descarrega' },
            { title: 'Cidade Descarregamento', data: 'cidadeDescarrega' },
            { title: 'Chave NF-e', data: 'chave_NFe' },
            { title: 'Tipo Evento', data: 'tipo_Evento' },
            { title: 'Protocolo', data: 'protocolo_DFe' },
            { title: 'Data Reg Evento', data: 'dh_Reg_Evento' },
        ]

        $('#tabelaEventoDFe').DataTable({
            destroy: true,
            filter: false,
            paging: false,
            scrollX: true,
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
            "autoWidth": true,
            "data": data,
            "columns": colunasEventoDFe,
            autoWidth: true,
            "colReorder": true,
        });
    }

    function adicionaBotoes(bDisabled = false) {
        return '<div class="divBtnOpcoes"> ' +
            `       <button class="botaoOpcoes btn-excluir" type="button" title="Excluir" ${bDisabled ? 'disabled' : ''}><span class="fas fa-trash-alt" style="color:red"></span></button>  ` +
            '     </div>';
    };

    async function alteraDados() {
        $.LoadingOverlay('show')
        try {
            if ($('#rgTipoRespSeguro').prop('disabled')) {
                return;
            }

            const tr = $('#tabelaMDFe tr.selected')[0];
            const tabela = $('#tabelaMDFe').DataTable().row($(tr)).data();

            const reboques = $('#txtReboque').val().toString().split(',');
            const Nota_MDFe = {
                NUMERO: tabela.NUMERO,
                SERIE: tabela.SERIE,
                EMP_ID: getCookie('emp_id'),
                DT_EMISSAO: pegaValor('#txtDtEmissao'),
                REBOQUE: ((reboques.length == 1) && reboques[0] != '') ? reboques[0] : '',
                VEICULO: pegaChave('#txtVeiculo'),
                TIPO_RESP_SEG: pegaValor('#rgTipoRespSeguro'),
                CNPJ_RESP_SEG: pegaValor('#txtCNPJRespSeguro'),
                CPF_RESP_SEG: pegaValor('#txtCPFRespSeguro'),
                NOME_SEG: pegaValor('#txtNomeInfSeguradora'),
                CNPJ_SEG: pegaValor('#txtCNPJInfSeguradora'),
                APOLICE_SEG: pegaValor('#txtApoliceInfSeguradora'),
                TP_CARGA: pegaValor('#rgTipoCargaProdPredo'),
                DESC_PRODPRED: pegaValor('#txtDescProdPredomiProdPredo'),
                CEP_CARREGA: pegaChave('#txtCEPCarregamentoProdPredo'),
                LATITUDE_CARREGA: pegaValor('#txtLatitudeCarregamentoProdPredo'),
                LONGITUDE_CARREGA: pegaValor('#txtLongitudeCarregamentoProdPredo'),
                CEP_DESCARREGA: pegaChave('#txtCEPDescarregamentoProdPredo'),
                LATITUDE_DESCARREGA: pegaValor('#txtLatitudeDescarregamentoProdPredo'),
                LONGITUDE_DESCARREGA: pegaValor('#txtLongitudeDescarregamentoProdPredo'),
                MOTORISTA: pegaChave('#txtMotorista'),
                NOTA_AVERB: retornaNotaAverb(),
                REBOQUES: retornaReboques()
            };

            const response = await requisicao('PUT', '/sisplan/mdfe/v1/mdfe?', '', `JSON=${encodeURIComponent(JSON.stringify(Nota_MDFe))}`, 90000);

            if (!response) {
                $.LoadingOverlay('hide');
                return;
            }

            const jsonStr = await response.json();

            if (response.status != 200) {
                msgAlerta(jsonStr.mensagem);
                return;
            }

            criaMensagemSucesso('Alteração efetuada com sucesso!');
        } catch (error) {
            console.log(error);
        } finally {
            $('#modal-itens').modal('hide');
            $.LoadingOverlay('hide');
        }
    }

    function retornaNotaAverb() {
        const arrayObj = [];
        if ($.fn.DataTable.isDataTable('#tabelaAverbacoes')) {
            const registros = $('#tabelaAverbacoes').DataTable().data().toArray();
            registros.forEach((item) => {
                arrayObj.push({
                    AVERBACAO: item.averbacao,
                    EMP_ID: getCookie('emp_id')
                });
            });
        }

        return arrayObj;
    }

    function retornaReboques() {
        const reboques = $('#txtReboque').val().toString().split(',');
        const arrayObj = [];
        for (const reboque of reboques) {
            arrayObj.push({
                EMP_ID: getCookie('emp_id'),
                REBOQUE: reboque
            })
        }

        return arrayObj;
    }

    function DadosMDFe(data) {
        insereValor('#txtDtEmissao', data.dt_Emissao.slice(0, 10));
        insereValor('#txtCapacKG', data.capac_KG);
        insereValor('#txtVeiculo', data.veiculo, data.veiculo);
        insereValor('#txtMotorista', data.motorista, data.motorista);
        $('#btnLimpaReboque').trigger('click');
        insereValorPesquisaVarios('txtReboque', 'reboque', 'modelo', data.reboques);
        mascaraValor();
    }

    function mascaraValor() {
        $('.maskDecimais').maskMoney({
            decimal: ",",
            thousands: ".",
            precision: 2,
        });
    }

    function adicionaAverbacao(numero) {
        const titulos = [
            { title: "Averbação", data: "averbacao" },
            { title: "Ação", data: "ACAO" }
        ];
        const jsonObject = [];

        if ($.fn.DataTable.isDataTable('#tabelaAverbacoes')) {

            $('#tabelaAverbacoes').DataTable().row.add({
                averbacao: numero,
                ACAO: adicionaBotoes()
            }).draw(false);

            return;
        }

        jsonObject.push({
            averbacao: numero,
            ACAO: adicionaBotoes()
        });


        $("#tabelaAverbacoes").DataTable({
            bPaginate: false,
            destroy: true,
            search: false,
            filter: false,
            lengthChange: false,
            scrollX: true,
            serverside: false,
            order: false,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            columns: titulos,
            data: jsonObject
        });
    }

    async function gerarDFe() {
        $.LoadingOverlay('show');
        try {
            validaDFe();
            const data = $('#tabelaMDFe').DataTable().row($('tr.selected')).data();
            if (data == undefined) {
                msgAlerta('Selecione uma MDF-e para gerar.');
                return;
            }
            const url = '/sisplan/mdfe/v1/geraeventomdfe?';
            const params = `NUMERO=${data.NUMERO}&SERIE=${data.SERIE}&MUNCARREGA=${pegaChave('#txtMunicipioCar')}&MUNDESCARREGA=${pegaChave('#txtMunicipioDesc')}&CHAVE=${pegaChave('#txtChaveNFe')}`;
            const response = await requisicao('POST', url, params, null, 60000);

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }

            await criaMensagemSucesso('Evento DF-e enviado com sucesso');
            $('#modal-IncDFe').modal('hide');
        } catch (error) {
            msgAlerta(error.message);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    function validaDFe() {
        let validator = $("#msDFe").validate();
        validator.element("#txtMunicipioCar");
        validator.element("#txtMunicipioDesc");
        validator.element("#txtChaveNFe");

        if (!(validator.element("#txtMunicipioCar") && validator.element("#txtMunicipioDesc") && validator.element("#txtChaveNFe"))) {
            throw new Error('Necessário informar os campos obrigatórios');
        }
    }

    async function encerrarMDFe() {
        $.LoadingOverlay('show');
        try {
            const data = $('#tabelaMDFe').DataTable().row($('tr.selected')).data();
            if (data == undefined) {
                msgAlerta('Selecione uma MDF-e para fazer o encerramento.');
                return;
            }
            const url = '/sisplan/mdfe/v1/encerrarmdfe?';
            const params = `NUMERO=${data.NUMERO}&SERIE=${data.SERIE}`;
            const response = await requisicao('POST', url, params, null, 15000);

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }

            await criaMensagemSucesso('MDF-e encerrada com sucesso');
            await retornaMDFe();
        } catch (error) {
            msgAlerta(error.message);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function cancelarMDFe() {
        $.LoadingOverlay('show');
        try {
            const data = $('#tabelaMDFe').DataTable().row($('tr.selected')).data();
            if (data == undefined) {
                msgAlerta('Selecione uma MDF-e para cancelar.');
                return;
            }

            const url = '/sisplan/mdfe/v1/cancelarmdfe?';
            const justificativa = pegaValor('#txtCancJustificativa') == '' ? 'a' : pegaValor('#txtCancJustificativa');
            const params = `NUMERO=${data.NUMERO}&SERIE=${data.SERIE}&JUSTIFICATIVA=${justificativa}`;
            const response = await requisicao('POST', url, params, null, 15000);

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }

            $('#modal-cancelamento').modal('hide');
            await criaMensagemSucesso('MDF-e cancelada com sucesso');
            await retornaMDFe();
        } catch (error) {
            msgAlerta(error.message);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function excluiMDFe() {
        $.LoadingOverlay('show');
        try {
            const data = $('#tabelaMDFe').DataTable().row($('tr.selected')).data();
            if (data == undefined) {
                msgAlerta('Selecione uma MDF-e para excluir.');
                return;
            }

            const url = '/sisplan/mdfe/v1/mdfe?';
            const params = `NUMERO=${data.NUMERO}&SERIE=${data.SERIE}`;
            const response = await requisicao('DELETE', url, params, null, 15000);

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }

            await criaMensagemSucesso('MDF-e excluída com sucesso');
            await retornaMDFe();
        } catch (error) {
            msgAlerta(error.message);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function consultaMDFe() {
        $.LoadingOverlay('show');
        try {
            const data = $('#tabelaMDFe').DataTable().row($('tr.selected')).data();
            if (data == undefined) {
                msgAlerta('Selecione uma MDF-e para consultar.');
                return;
            }

            const url = '/sisplan/mdfe/v1/consultamdfe?';
            const params = `CHAVE_MDFE=${data.CHAVE_MDFE}`;
            const response = await requisicao('GET', url, params, null, 15000);

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }
            const jsonStr = await response.json();
            msgAlerta(jsonStr.mensagem);
        } catch (error) {
            msgAlerta(error.message);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function imprimirMDFe() {
        $.LoadingOverlay('show');
        try {
            const data = $('#tabelaMDFe').DataTable().row($('tr.selected')).data();
            if (data == undefined) {
                msgAlerta('Selecione uma MDF-e para imprimir.');
                return;
            }

            const url = `/sisplan/mdfe/v1/imprimirmdfe?NUMERO=${data.NUMERO}&SERIE=${data.SERIE}`;
            const bImprimeAutomatico = await verificaImprimirAutomatico('MDFE');
            const arquivo = await GeraRelatorio(url + '&', 'PUT', 15000, false, 'MDFE');
            if (arquivo != undefined) {
              if (!bImprimeAutomatico) {
                window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
              }
              await limparRelatorios();
            }            
        } catch (error) {
            console.log(error);    
        } finally {
            $.LoadingOverlay('hide');
        }
    }
})