$(document).ready(async function () {

  await setarDataAtual('txtDataDe');
  await setarDataAtual('txtDataAte');
  await setarDataAtual('dtFabricacao');
  await buscaValoresPadroes();

  let codigoEntradasManual = '';

  async function carregaTipoEntrada() {
    const pesquisaParam = {
      tabela: 'TABBAI',
      camposSelect: ['CODIGO', 'DESCRICAO', 'TIPO', 'ATIVO'],
      where: [`ATIVO = 'S'`],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));



    let entradaManual = '';

    jsonStr.forEach(tipoBaixa => {
      if (tipoBaixa.TIPO && tipoBaixa.TIPO.charAt(0) === 'S') {
        entradaManual += entradaManual ? `,'${tipoBaixa.CODIGO}'` : `'${tipoBaixa.CODIGO}'`;
      }
    });

    codigoEntradasManual = entradaManual;
  }

  await carregaTipoEntrada();

  $('#tabela-movimentados').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    autoWidth: true,
    destroy: true,
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
    columnDefs: [
      {
        "targets": [4],
        "className": 'pr-4 text-right'
      }
    ]
  });

  let data = new Date();
  $('#txtDataMovimentoEntrada').val(`${data.getUTCFullYear()}-${String(data.getUTCMonth() + 1).padStart(2, 0)}-${String(data.getUTCDate()).padStart(2, 0)}`);

  $('#txtFuncionarioEntradaMat').autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnFuncionarioEntradaMat').pesquisa_array(['#txtFuncionarioEntradaMat'], ['CODIGO'], ['NOME'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME" ], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Funcionário', 'PESSOAL');
  $('#btnLimpaFuncionarioEntradaMat').on('click', function () {
    $('#txtFuncionarioEntradaMat').val('');
  });


  $('#txtTipoEntradaMat').autocompleta(1, `JSON={ "tabela":"TABBAI", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["CODIGO IN (${codigoEntradasManual})"] }`, [], [], []);

  $('#btnTipoEntradaMat').on('click', function () {
    if (!codigoEntradasManual) {
      msgErro('Não existe Tipo Entrada cadastrada como Entrada Manual na tela "Tipo Baixa" para essa consulta.');
      return;
    }

    $('#btnTipoEntradaMat').pesquisa_array(['#txtTipoEntradaMat'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${codigoEntradasManual})"]}`, 'Pesquisa Tipo Entrada', 'TABBAI');
  });

  $('#btnLimpaTipoEntradaMat').on('click', function () {
    $('#txtTipoEntradaMat').val('');
  });

  $('#txtQualidade').autocompleta(1, `JSON={ "tabela":"TABQUL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnQualidade').pesquisa_array(['#txtQualidade'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Qualidade', 'TABQUL');
  $('#btnLimpaQualidade').on('click', function () {
    $('#txtQualidade').val('');
  });

  $('#txtMaterialEntrada').autocompleta(3, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnMaterialEntrada').pesquisa_array(['#txtMaterialEntrada'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Material', 'MATERIAL');
  $('#btnLimpaMaterialEntrada').on('click', function () {
    $('#txtMaterialEntrada').val('');
  });

  $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ],"where": null}', 'Pesquisa Cor', 'CADCOR');
  $('#btnLimpaCor').on('click', function () {
    $('#txtCor').val('');
  });

  const depositosEmpresaLogada = await verificaDepositosEmpresaLogada(getCookie('empresa'));
  const json = await retornaJsonPesquisaPadrao(`{"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["EMPRESA <> ''"] }`);
  const depositoUsuario = await retornaDepositoUsuario(getCookie('cod_usuario'));

  if (depositoUsuario != 'null') {
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ${depositoUsuario}}`, [], [], []);
    $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ${depositoUsuario}}`, 'Pesquisa Depósito', 'DEPOSITO');
  } else if (depositosEmpresaLogada != '') {
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"] }`, [], [], []);
    $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${depositosEmpresaLogada})"]}`, 'Pesquisa Depósito', 'DEPOSITO');
  } else if (json.length == 0) {
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
    $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": []}`, 'Pesquisa Depósito', 'DEPOSITO');
  } else {
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"] }`, [], [], []);
    $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"]}`, 'Pesquisa Depósito', 'DEPOSITO');
  }
  $('#btnLimpaDeposito').on('click', function () {
    $('#txtDeposito').val('');
  });

  $('#txtTonalidade').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "TONALIDADE CHAVE", "ATIVO DESCRICAO"], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "ATIVO"]}`);
  $('#btnTonalidade').pesquisa_array(['#txtTonalidade'], ['TONALIDADE'], ['ATIVO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "TONALIDADE", "ATIVO" ], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "ATIVO"]}`, 'Pesquisa Tonalidade', 'MAT_ITEN');
  $('#btnLimpaTonalidade').on('click', function () {
    $('#txtTonalidade').val('');
  });

  // $('#btnLimpaLote').on('click', function () {
  //   $('#txtLote').val('');
  // });

  $('#txtTipoEntradaMat').on('blur', async function () {
    let tipoBaixa = (await buscaValor('TABBAI', 'TIPO', 'CODIGO', pegaChave('#txtTipoEntradaMat'))).TIPO
    tipoBaixa = tipoBaixa.charAt(0) === 'S'

    if (tipoBaixa) {
      $('.divUnidade').removeClass('d-none')
      $('#txtUnidade').val('')
      $('#txtUnidadeAux').val('')
      $('#txtRendimento').val('')
    } else {
      $('.divUnidade').addClass('d-none')
      $('#txtUnidade').val('')
      $('#txtUnidadeAux').val('')
      $('#txtRendimento').val('')
    }
  })

  $('#txtQuantidadeAux').on('blur', function () {
    const qtdeAtual = $('#txtQuantidadeAux').val()
    const rendimento = $('#txtRendimento').val()
    if (qtdeAtual != '') {
      const qtdeNova = qtdeAtual * rendimento
      $('#txtQuantidade').val(qtdeNova)
    }
  })

  $('#txtMaterialEntrada').on('blur', async function () {
    // $('#txtCor').off();
    $('#txtCor').unbind('autocompleta');
    $('#txtCor').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["MAT_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${$(this).attr('data-chave')}'"] }`, [], [], []);
    $('#btnCor').off();
    $('#btnCor').unbind('pesquisa_array');
    $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Cor', 'CADCOR');
    $('#txtCor').on('blur', function () {
      const codigoMaterial = pegaChave('#txtMaterialEntrada');
      const codigoCor = pegaChave('#txtCor');

      // $('#txtLote').off();
      // $('#txtLote').unbind('autocompleta');
      // $('#txtLote').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["LOTE CHAVE", "LOTE DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${codigoMaterial}' AND MAT_ITEN.COR = '${codigoCor}'"] }`, [], [], []);
      // $('#btnLote').off();
      // $('#btnLote').unbind('pesquisa_array');
      // $('#btnLote').pesquisa_array(['#txtLote'], ['LOTE'], ['LOTE'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.LOTE" ], "where": ["MAT_ITEN.CODIGO = '${codigoMaterial}' AND MAT_ITEN.COR = '${codigoCor}'"]}`, 'Pesquisa Lote', 'MAT_ITEN');
    });
  });

  $('.controleBlur').on('blur', async function () {
    try {
      const codigo = pegaChave('#txtMaterialEntrada')
      const cor = pegaChave('#txtCor')
      const lote = $('#txtLote').val()
      const qualidade = pegaChave('#txtQualidade')

      if (codigo != '' && cor != '' && lote != '' && qualidade != '') {
        const pesquisa = {
          tabela: 'MAT_ITEN',
          camposSelect: ['MAX(TONALIDADE) TONALIDADE', 'MAX(LOTE_INTERNO) LOTE_INTERNO', 'MAX(BARRA) BARRA'],
          where: [`CODIGO = '${codigo}' AND COR = '${cor}' AND LOTE = '${lote}' AND QUALIDADE = '${qualidade}'`],
        }
        const matIten = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        insereValor('#txtTonalidade', matIten[0].TONALIDADE, 'S')
        $('#txtLoteInterno').val(matIten[0].LOTE_INTERNO)
        $('#txtBarra').val(matIten[0].BARRA)
        // $('#dtFabricacao').val(matIten[0].DT_FAB)
      }
    } catch (e) {

    } finally {

    }
  })

  function montaObjetoMovimentacao() {
    const objetoMaterial = {
      NUM_DOCTO: $('#txtDocumento').val(),
      DT_MOVTO: $('#txtDataMovimentoEntrada').val(),
      CODCRE: pegaChave('#txtFuncionarioEntradaMat'),
      TP_MOV: pegaChave('#txtTipoEntradaMat'),
      CODIGO: pegaChave('#txtMaterialEntrada'),
      QUALIDADE: pegaChave('#txtQualidade'),
      COR: pegaChave('#txtCor'),
      LOTE: $('#txtLote').val() == '' ? '000000' : $('#txtLote').val(),
      DEPOSITO: pegaChave('#txtDeposito'),
      QTDE: parseFloat($('#txtQuantidade').val()),
      PRECO: parseFloat($('#txtPreco').val()),
      TIPO: 'MN',
      TONALIDADE: pegaChave('#txtTonalidade'),
      LOTE_INTERNO: $('#txtLoteInterno').val(),
      BARRA: $('#txtBarra').val(),
      DT_FAB: $('#dtFabricacao').val(),
      CODBAIXA: pegaChave('#txtTipoEntradaMat')
    };
    return objetoMaterial;
  }

  async function gravarMovimentacao(EstProd) {
    try {
      const url = '/sisplan/estoque/v1/movimentaestoquematerial?';
      const sLancto = $('#txtLancamento').val();
      const params = `JSON=${encodeURIComponent(JSON.stringify(EstProd))}&LANCTO=${sLancto}&TIPO=ENTRADA`;
      const response = await requisicao('POST', url, '', params, 30000);
      const codigo = pegaChave('#txtMaterialEntrada');
      const codigoDesc = pegaDescricao('#txtMaterialEntrada');
      const cor = pegaChave('#txtCor');
      const corDesc = pegaDescricao('#txtCor');
      const lote = $('#txtLote').val() == '' ? '000000' : $('#txtLote').val();
      const qtde = $('#txtQuantidade').val();
      const unidade = $('#UnidadeMedidaMat').val();

      const tonalidade = pegaChave('#txtTonalidade')
      const loteInterno = $('#txtLoteInterno').val()
      const barra = $('#txtBarra').val()
      const dtFabricacao = $('#dtFabricacao').val()

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      $('#tabela-movimentados').DataTable().row.add([codigo, codigoDesc, cor, corDesc, qtde, unidade, lote, tonalidade, loteInterno, barra, dtFabricacao]).draw(false);

      toastr.success(
        'Movimentação efetuada com sucesso!',
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          LimpaCampos();
          setTimeout(() => { $('#txtMaterialEntrada').focus(); }, 200);
        }
      }
      ).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.error(error);
    }
  }

  retornaHintRelatorio('Imprimir', 'movimentacao_material')

  $('#Imprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        if ($('#tabela-movimentados').DataTable().rows().count() != 0) {
          let url = `/sisplan/impressao/v1/movmaterial?`;
          const tipoItem = 'M';
          const docto = $('#txtDocumento').val();
          const tipoMov = 'E';
          const bImprimeAutomatico = await verificaImprimirAutomatico('MovimentacaoMaterial');
          let arquivo = await GeraRelatorio(`${url}NUM_DOCTO=${docto}&TIPOITEM=${tipoItem}&TIPOMOV=${tipoMov}&`, 'GET', 100000, false, 'MovimentacaoMaterial');
          if (arquivo != undefined) {
            if (!bImprimeAutomatico) {
              window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            }
            await limparRelatorios();
          }
        } else {
          msgAlerta('Não há itens para serem imprimidos!');
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#txtMaterialEntrada').on('blur', async function () {
    try {
      const codigo = pegaChave('#txtMaterialEntrada');
      const url = `/sisplan/funcoes/v1/pesquisa?`;
      const params = `JSON={"tabela":"MAT_ITEN", "camposSelect":[ "MATERIAL.CODIGO", "MATERIAL.DESCRICAO","MATERIAL.UNIDADE", "CADCOR.COR", "CADCOR.DESCRICAO AS DESCCOR", "MATERIAL.PRECO", "MAT_ITEN.QTDE", "MAT_ITEN.QUALIDADE", "TABQUL.DESCRICAO DESCQUALIDADE"], "leftjoin": [{ "tabela" : "MATERIAL", "condicao" : "MAT_ITEN.CODIGO = MATERIAL.CODIGO " },{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR " },{ "tabela" : "TABQUL", "condicao" : "MAT_ITEN.QUALIDADE = TABQUL.CODIGO " }],"where": ["MATERIAL.CODIGO = '${codigo}'"]}`;
      const response = await requisicao('GET', url, params, null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      if (pegaChave('#txtQualidade') == '') {
        insereValor('#txtQualidade', jsonStr.RESULT[0][0].QUALIDADE, jsonStr.RESULT[0][0].DESCQUALIDADE);
      }
      $('#UnidadeMedidaMat').val(jsonStr.RESULT[0][0].UNIDADE);
      $('#txtPreco').val(jsonStr.RESULT[0][0].PRECO);

      if ($('#txtMaterialEntrada').val() !== '') {
        const codigo = pegaChave('#txtMaterialEntrada')
        const pesquisa = {
          tabela: 'MATERIAL',
          camposSelect: ['UNIDADE', 'UNI_AUX', 'RENDIMENTO'],
          where: [`CODIGO = '${codigo}'`]
        }
        const matIten = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        $('#txtUnidade').val(matIten[0].UNIDADE)
        $('#txtUnidadeAux').val(matIten[0].UNI_AUX)
        $('#txtRendimento').val(matIten[0].RENDIMENTO)
      }

    } catch (error) {
      console.error(error);
    }
  });

  $('#txtDocumento').on('blur', async function () {
    try {
      let lancto;
      if ($(this).val() == '') {
        $.LoadingOverlay("show");
        let docto = await RetornaDoctoELancto('DOCTO', 'MAT_MOV', 'NUM_DOCTO', '6');
        lancto = await RetornaDoctoELancto('LANCTO', 'MAT_MOV', 'NUM_DOCTO', '6');
        insereValor('#txtDocumento', docto);
        insereValor('#txtLancamento', lancto);
        $(this).attr('disabled', $(this).val() != '');
      } else {
        lancto = await RetornaDoctoELancto('LANCTO', 'MAT_MOV', 'NUM_DOCTO', '6');
        insereValor('#txtLancamento', lancto);
        $(this).attr('disabled', $(this).val() != '');
        let dataSet = await RetornaMovimentados($(this).val());
        $('#tabela-movimentados').DataTable().rows().remove().draw(false);
        for (let i = 0; i < dataSet.length; i++) {
          const item = dataSet[i];
          $('#tabela-movimentados').DataTable().row.add([item.CODIGO, item.DESCRICAO, item.COR, item.DESC_COR, item.QUANTIDADE, item.UNIDADE, item.LOTE, item.TONALIDADE, item.LOTE_INTERNO, item.BARRA, item.DT_FAB]).draw(false);
        }
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#limpar_mov').on('click', function () {
    LimpaCampos();
    limpaValor('#txtDocumento');
    $('#txtDocumento').attr('disabled', false);
    $('#tabela-movimentados').DataTable().rows().remove().draw(false);
    $('#txtDocumento').focus();
  });

  $('#msform').validate({
    ignore: "",
    rules: {
      txtDocumento: {
        required: true,
      },
      txtFuncionarioSaidaMat: {
        required: true,
      },
      txtTipoBaixa: {
        required: true,
      },
      txtQualidade: {
        required: true,
      },
      txtMaterialSaida: {
        required: true,
      },
      txtCor: {
        required: true,
      },
      txtDeposito: {
        required: true,
      },
      txtQuantidade: {
        required: true,
      },
      txtPreco: {
        required: true,
      }
    },
    messages: {
      txtDocumento: {
        required: "Gere um documento para continuar."
      },
      txtFuncionarioSaidaMat: {
        required: "Informe um funcionário para continuar."
      },
      txtTipoBaixa: {
        required: "Informe um tipo de baixa para continuar."
      },
      txtQualidade: {
        required: "Informe uma qualidade para continuar."
      },
      txtMaterialSaida: {
        required: "Informe um material para continuar."
      },
      txtCor: {
        required: "Informe uma cor para continuar."
      },
      txtDeposito: {
        required: "Informe um deposito para continuar."
      },
      txtQuantidade: {
        required: "Informe uma quantidade válida para continuar."
      },
      txtPreco: {
        required: "Informe um preço válido para continuar."
      }
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid');
    }

  });

  $('#confirmar_mov').on('click', async function () {
    try {
      $('#confirmar_mov').prop('disabled', true);
      $.LoadingOverlay('show');
      try {
        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
          if (parseFloat($('#txtQuantidade').val()) <= 0) {
            msgErro('Não há quantidade para o material informado, verifique.');
            return;
          }

          if (parseFloat($('#txtQuantidade').val()) > (parseFloat($('#txtEstoque').val()))) {
            msgErro('Quantidade maior que o estoque, verifique.');
            return;
          }

          if ($('#dtFabricacao').val() == '') {
            throw msgAlerta('Necessário inserir uma data de fabricação, verifique.');
            ;
          }

          const objetoMovimentacao = montaObjetoMovimentacao();
          await gravarMovimentacao(objetoMovimentacao);
        }
      } catch (error) {
        console.error(error);
      }

    } finally {
      $('#confirmar_mov').prop('disabled', false);
      $.LoadingOverlay('hide');
    }
  });

  async function RetornaMovimentados(sDocto) {
    try {
      const url = `/sisplan/funcoes/v1/pesquisa?`;
      const params = `JSON={"tabela": "MAT_MOV", "camposSelect": ["MAT_MOV.CODIGO", "MATERIAL.DESCRICAO", "MAT_MOV.COR", "CADCOR.DESCRICAO DESC_COR", "SUM(MAT_MOV.QTDE) QUANTIDADE", "MATERIAL.UNIDADE", "MAT_MOV.LOTE", "TONALIDADE", "LOTE_INTERNO", "BARRA", "DT_FAB"],"leftjoin": [{ "tabela" : "MATERIAL", "condicao" : "MAT_MOV.CODIGO = MATERIAL.CODIGO" }, { "tabela" : "CADCOR", "condicao" : "CADCOR.COR = MAT_MOV.COR" }],"groupby": ["MAT_MOV.CODIGO", "MATERIAL.DESCRICAO", "MAT_MOV.COR", "CADCOR.DESCRICAO", "MATERIAL.UNIDADE", "MAT_MOV.LOTE"],"where": ["MAT_MOV.NUM_DOCTO = '${sDocto}' AND MAT_MOV.OPERACAO = 'E' "], "orderby": ["MAT_MOV.CODIGO", "MAT_MOV.COR"]}`;
      const response = await requisicao('GET', url, params, null);

      if (!response) {
        return '';
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      return jsonStr.RESULT[0];

    } catch (error) {
      console.error(error);
    }
  }

  async function buscaValoresPadroes() {
    $.LoadingOverlay('show');
    try {

      const classValores = { POSICAO: '1' };
      const response = await requisicao('POST', '/sisplan/valorespadroes/v1/buscar?', '', JSON.stringify(classValores), null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      insereValor('#txtTipoEntradaMat', jsonStr.tipoSaida);
      insereValor('#txtDeposito', jsonStr.deposito);

      const pesquisa = {
        camposSelect: ['CAMPO', 'VALOR'],
        tabela: 'TABPADRAO',
        where: [`TABELA = 'ESTOQUE'`]
      }
      const jsonTipo = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      jsonTipo.map(item => {
        switch (item.CAMPO) {
          case 'ENTRADA_MAT': {
            if (item.VALOR != '') {
              insereValor('#txtTipoEntradaMat', item.VALOR, { tabela: 'TABBAI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
            }
            break;
          }
          case 'QUALIDADE_MATERIAL': {
            if (item.VALOR != '') {
              insereValor('#txtQualidade', item.VALOR, { tabela: 'TABQUL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
            }
            break;
          }
        }
      });

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function LimpaCampos() {
    // limpaValor('#txtTipoEntradaMat');
    // limpaValor('#txtDeposito');
    limpaValor('#txtQualidade');
    limpaValor('#txtLote');
    limpaValor('#UnidadeMedidaMat');
    limpaValor('#txtMaterialEntrada');
    limpaValor('#txtCor');
    limpaValor('#txtPreco');
    limpaValor('#txtQuantidade');
    limpaValor('#txtQuantidadeAux');
    limpaValor('#txtUnidadeAux');
    limpaValor('#txtRendimento');
    limpaValor('#txtPreco');
    await setarDataAtual('dtFabricacao');
    limpaValor('#txtTonalidade');
    limpaValor('#txtLoteInterno');
    limpaValor('#txtBarra');
  }

  const driver = new Driver({
    doneBtnText: 'Sair',
    closeBtnText: 'Fechar',
    nextBtnText: 'Próximo',
    prevBtnText: 'Anterior',
    allowClose: false,
    animate: true,
  });
  driver.defineSteps([{
    element: '#campostour',
    popover: {
      title: 'Dados Gerais',
      description: 'Aqui estão os campos disponíveis para realizar a movimentação.',
      position: 'top'
    }
  },
  {
    element: '#txtDocumento',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtDataMovimentoEntrada',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtFuncionarioEntradaMat',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtTipoEntradaMat',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtQualidade',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtMaterialEntrada',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtCor',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtLote',
    popover: {
      title: 'Número do lote',
      description: 'Se não informado irá levar o lote padrão 000000',
      position: 'top'
    }
  },
  {
    element: '#txtDeposito',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtQuantidade',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtPreco',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#limpar_mov',
    popover: {
      title: 'Botão Limpar',
      description: 'Clique aqui para limpar os campos.',
      position: 'left'
    }
  },
  {
    element: '#confirmar_mov',
    popover: {
      title: 'Botão Gravar',
      description: 'Clique aqui para gravar a movimentação.',
      position: 'left'
    }
  }
  ]);

  $('#tutorial').on('click', function () {
    driver.start();
  });

  $('#txtTipoEntradaMat').trigger('blur')

});



