$(document).ready(async function () {

  $('#btnFiltrosEnvioReceber').on('click', function () {
    $('#modalFiltrosReceberEnvio').modal('show');
  });

  $('#btnFiltrosConsultaReceber').on('click', function () {
    $('#modalFiltrosReceberConsulta').modal('show');
  });

  $('#btnFiltrosObservacaoTitulos').on('click', function () {
    $('#modalFiltrosReceberObservacaoTitulos').modal('show');
  });

  $('#btnFiltrosEnvioNotaFiscalSaida').on('click', function () {
    $('#modalFiltrosNFESaida').modal('show');
  });

  $('#btnFiltrosEnvioNFCE').on('click', function () {
    $('#modalFiltrosNFCE').modal('show');
  });

  $('#btnFiltrosEnvioNotaEntrada').on('click', function () {
    $('#modalFiltrosNotaEntrada').modal('show');
  });

  $('#btnFiltrosPagarEnvio').on('click', function () {
    $('#modalFiltrosPagarEnvio').modal('show');
  });

  $('#btnFiltrosEnvioEntidade').on('click', function () {
    $('#modalFiltrosEnvioEntidade').modal('show');
  });

  $('#btnFiltrosObservacaoEntidade').on('click', function () {
    $('#modalFiltrosObservacaoEntidade').modal('show');
  });

  $('#btnConsultarNFE').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaNfeEnvio();
    } catch (error) {
      console.error(error);
      return
    } finally {
      $('#modalFiltrosNFESaida').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarNFCE').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaNfceEnvio();
    } catch (error) {
      console.error(error);
      return
    } finally {
      $('#modalFiltrosNFCE').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarReceberEnvio').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaReceberEnvio();
    } catch (error) {
      console.error(error);
      return
    } finally {
      $('#modalFiltrosReceberEnvio').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarReceberConsulta').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaReceberConsulta();
    } catch (error) {
      console.error(error);
      return
    } finally {
      $('#modalFiltrosReceberConsulta').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarReceberObservacaoTitulos').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaReceberObsTitulos();
    } catch (error) {
      console.error(error);
      return
    } finally {
      $('#modalFiltrosReceberObservacaoTitulos').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarNotaEntradaEnvio').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaNotaEntradaEnvio();
    } catch (error) {
      console.error(error);
      return
    } finally {
      $('#modalFiltrosNotaEntrada').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarPagarEnvio').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaPagarEnvio();
    } catch (error) {
      console.error(error);
      return
    } finally {
      $('#modalFiltrosPagarEnvio').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarEnvioEntidade').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaEntidadeEnvio();
    } catch (error) {
      console.error(error);
      return
    } finally {
      $('#modalFiltrosEnvioEntidade').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarObservacaoEntidade').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaEntidadeObs();
    } catch (error) {
      console.error(error);
      return
    } finally {
      $('#modalFiltrosObservacaoEntidade').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $("#divTabs").on("click", ".abaLink", function () {
    const tabClicada = $(this).attr("id");
    ativaDesativaTabs(tabClicada);
  });

  function ativaDesativaTabs(tabAtivada) {
    const listaTabs = $("#divTabs .abaLink").toArray();

    listaTabs.forEach(elemento => {
      const idDiv = $(elemento).attr("aria-controls");
      if (elemento.id != tabAtivada) {
        $(`#${idDiv}`).addClass("d-none");
      } else {
        $(`#${idDiv}`).removeClass("d-none");
      }
    })
  };

  $("#divTabsSubMenuEntidade, #divTabsSubMenuPagar, #divTabsSubMenuNotaEntrada, #divTabsSubMenuNFCE, #divTabsSubMenuNFE, #divTabsSubMenuReceber").on("click", ".abaLink", function () {
    const tabClicada = $(this).attr("id");
    ativaDesativaSubTabs(tabClicada);
  });

  function ativaDesativaSubTabs(tabAtivada) {
    const listaTabs = $("#divTabsSubMenu .abaLink").toArray();

    listaTabs.forEach(elemento => {
      const idDiv = $(elemento).attr("aria-controls");
      if (elemento.id != tabAtivada) {
        $(`#${idDiv}`).addClass("d-none");
      } else {
        $(`#${idDiv}`).removeClass("d-none");
      }
    })
  };

  function criaPesquisasFiltroNFEEnvio() {
    componenteFiltro('nota', true, true, 'FaturaNFE');
    componenteFiltro('venda', true, true, 'CodvenNFE');
  };

  function criaPesquisasFiltroNFCEEnvio() {
    componenteFiltro('notaNfce', true, true, 'FaturaNFCE');
    componenteFiltro('venda', true, true, 'CodvenNFCE');
  };

  function criaPesquisasFiltroReceberEnvio() {
    componenteFiltro('recSenior', true, true, 'NumeroReceberEnvio');
    componenteFiltro('faturaNfeSenior', true, true, 'FaturaNFEReceberEnvio');
    componenteFiltro('faturaNfceSenior', true, true, 'FaturaNFCEReceberEnvio');
    componenteFiltro('moeda', true, true, 'MoedaReceberEnvio');
    componenteFiltro('historico', true, true, 'HistoricoReceberEnvio');
    componenteFiltro('venda', true, true, 'CodvenReceberEnvio');
  };

  function criaPesquisasFiltroReceberConsulta() {
    componenteFiltro('recSenior', true, true, 'NumeroReceberConsulta');
  };

  function criaPesquisasFiltroReceberObservacaoTitulos() {
    componenteFiltro('recSenior', true, true, 'NumeroReceberObservacaoTitulos');
    componenteFiltro('clienteSenior', true, true, 'ClienteReceberObservacaoTitulos');
  };

  function criaPesquisasFiltroNotaEntraEnvio() {
    componenteFiltro('notaEntra', true, true, 'FaturaNotaEntradaEnvio');
  };

  function criaPesquisasFiltroPagarEnvio() {
    componenteFiltro('pagtoSenior', true, true, 'NumeroPagarEnvio');
  };

  function criaPesquisasFiltroEntidadeEnvio() {
    componenteFiltro('clienteSenior', true, true, 'EnvioEntidade');
  };

  function criaPesquisasFiltroEntidadeObservacaoEntidades() {
    componenteFiltro('clienteSenior', true, true, 'ObservacaoEntidade');
  };

  async function consultaNfeEnvio() {
    $.LoadingOverlay('show');
    try {
      const camposDataTable = [
        { "title": "EMP_ID" },
        { "title": "EMP_FANTASIA" },
        { "title": "MAPEAMENTO" },
        { "title": "TABELA" },
        { "title": "FATURA" },
        { "title": "IMPRESSO" },
        { "title": "PROTOCOLO" },
        { "title": "CODVEN" },
        { "title": "OPERACAO_FISCAL" },
        { "title": "DESC_OPER_FISCAL" },
        { "title": "CODCLI" },
        { "title": "CNPJ" },
        { "title": "NOME" },
        { "title": "COD_IMPORTADO" },
        { "title": "CODREP" },
        { "title": "CNPJ_REP" },
        { "title": "NOME_REP" },
        { "title": "COD_REP_IMPORTADO" },
        { "title": "CODTRAN" },
        { "title": "CNPJ_TRAN" },
        { "title": "NOME_TRAN" },
        { "title": "CODTRAN_IMPORTADO" },
        { "title": "DT_CADASTRO" },
        { "title": "DT_EMISSAO" },
        { "title": "VALOR" },
        { "title": "STATUS" },
        { "title": "DTH_ULT_TENTATIVA" },
        { "title": "OPERACAO" },
        { "title": "OBSERVACAO" },
        { "title": "OBS_1" }
      ];

      preencheTabela('', 'tabelaNotaFiscalSaida', 'consultanfeenvio', camposDataTable, 'NFEEnvio');
      $('#tabelaNotaFiscalSaida_length').prepend('<button class="buttonExcel" id="buttonExcelNFEEnvio"><i class="fas fa-file-excel"></i></button>');
      $('#buttonExcelNFEEnvio').prop('title', 'Exportar');
      $('#buttonExcelNFEEnvio').on('click', async function () {
        const dados = $("#tabelaNotaFiscalSaida").DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório de espelho de pedido', '#tabelaPedidos', '', 999, false, false, dados);
      })
    } catch (error) {
      console.error(error);
      msgErro('Erro ao consultar a aba de envio das notas fiscais de saída! Erro: ' + error);
    } finally {
      $.LoadingOverlay('hide');
    }

  };

  async function consultaNfceEnvio() {
    const params = await retornaFiltros('NFCEEnvio');
    const response = await requisicao("GET", "/sisplan/senior/v1/consultanfceenvio?", params, "", 900000);

    if (!response) {
      throw new Error("Não foi possível consultar os registros.");
    }

    const json = await response.json();
    if (response.status != 200) {
      throw new Error(json.mensagem);
    }

    preencheTabela(json, 'tabelaNFCE');

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    if (colunas == null || colunas.integracaoseniorenvionfce == undefined) {
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniorenvionfce: [] }))
      colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#btnConfirmarColunas').on('click', async function () {
      try {
        $.LoadingOverlay('show');

        const novasColunas = retornaNovasColunasInvisiveis();
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniorenvionfce: novasColunas }))

        $('#tabelaNFCE').DataTable().columns().visible(true);

        $('#tabelaNFCE').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } finally {
        $.LoadingOverlay('hide');
        $('#modal-ColunasVisiveis').modal('hide');
      }
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaNFCE_length').prepend('<button class="buttonColVis" id="buttonColVisNFCEEnvio"><i class="fas fa-cogs"></i></button>');
    $('#tabelaNFCE_length').prepend('<button class="buttonExcel" id="buttonExcelNFCEEnvio"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisNFCEEnvio').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelNFCEEnvio').prop('title', 'Exportar')

    $('#buttonColVisNFCEEnvio').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelNFCEEnvio').on('click', async function () {
      const url = '/sisplan/senior/v1/consultareceberconsulta?';
      const params = await retornaFiltros();
      await exportaCSV(url, params, false, 3600000, 'Relatório de Envio de NFCE', '#tabelaNFCE');
    })

    $('#tabelaNFCE').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.integracaoseniorenvionfce).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
      const cols = [];

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

      $('#tabelaNFCE').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.integracaoseniorenvionfce ?? [])
    });
  };

  async function consultaReceberEnvio() {
    $.LoadingOverlay('show');
    try {
      const camposDataTable = [
        { "title": "EMP_ID" },
        { "title": "EMP_FANTASIA" },
        { "title": "MAPEAMENTO" },
        { "title": "TABELA" },
        { "title": "FATURA" },
        { "title": "CODVEN" },
        { "title": "CODCLI" },
        { "title": "CNPJ" },
        { "title": "NOME" },
        { "title": "NUMERO" },
        { "title": "COD_IMPORTADO" },
        { "title": "CODREP" },
        { "title": "CNPJ_REP" },
        { "title": "NOME_REP" },
        { "title": "COD_REP_IMPORTADO" },
        { "title": "DT_EMISSAO" },
        { "title": "MOEDA" },
        { "title": "DESC_MOEDA" },
        { "title": "HISTORICO" },
        { "title": "DESC_HISTORICO" },
        { "title": "VALOR" },
        { "title": "STATUS" },
        { "title": "DTH_ULT_TENTATIVA" },
        { "title": "OPERACAO" },
        { "title": "OBSERVACAO" },
        { "title": "OBS_1" }
      ];
      await preencheTabela('', 'tabelaEnvioReceber', 'consultareceberenvio', camposDataTable, 'ReceberEnvio');
      $('#tabelaEnvioReceber_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');
      $('#buttonExcel').prop('title', 'Exportar');
      $('#buttonExcel').on('click', async function () {
        const url = '/sisplan/impressao/v1/totalporano?';
        const params = await retornaFiltros();
        await exportaCSV(url, params, false, null, 'Relatório de Total por Ano', '#tabelaTotalPorAno');
      })
    } catch (error) {
      console.error(error);
      msgErro('Ocorreu um erro com a pesquisa de envio do Receber! Erro:' + error);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function consultaReceberConsulta() {
    const params = await retornaFiltros('ReceberConsulta');
    const response = await requisicao("GET", "/sisplan/senior/v1/consultareceberconsulta?", params, "", 900000);

    if (!response) {
      throw new Error("Não foi possível consultar os registros.");
    }

    const json = await response.json();
    if (response.status != 200) {
      throw new Error(json.mensagem);
    }

    preencheTabela(json, 'tabelaConsultaReceber');

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    if (colunas == null || colunas.integracaoseniorconsultareceber == undefined) {
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniorconsultareceber: [] }))
      colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#btnConfirmarColunas').on('click', async function () {
      try {
        $.LoadingOverlay('show');

        const novasColunas = retornaNovasColunasInvisiveis();
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniorconsultareceber: novasColunas }))

        $('#tabelaConsultaReceber').DataTable().columns().visible(true);

        $('#tabelaConsultaReceber').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } finally {
        $.LoadingOverlay('hide');
        $('#modal-ColunasVisiveis').modal('hide');
      }
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaConsultaReceber_length').prepend('<button class="buttonColVis" id="buttonColVisReceberConsulta"><i class="fas fa-cogs"></i></button>');
    $('#tabelaConsultaReceber_length').prepend('<button class="buttonExcel" id="buttonExcelReceberConsulta"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisReceberConsulta').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelReceberConsulta').prop('title', 'Exportar')

    $('#buttonColVisReceberConsulta').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelReceberConsulta').on('click', async function () {
      const url = '/sisplan/senior/v1/consultareceberconsulta?';
      const params = await retornaFiltros();
      await exportaCSV(url, params, false, 3600000, 'Relatório de Consulta de Título', '#tabelaConsultaReceber');
    })

    $('#tabelaConsultaReceber').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.integracaoseniorconsultareceber).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
      const cols = [];

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

      $('#tabelaConsultaReceber').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.integracaoseniorconsultareceber ?? [])
    });
  };

  async function consultaReceberObsTitulos() {
    const params = await retornaFiltros('ReceberObsTitulos');
    const response = await requisicao("GET", "/sisplan/senior/v1/consultareceberobstitulos?", params, "", 900000);

    if (!response) {
      throw new Error("Não foi possível consultar os registros.");
    }

    const json = await response.json();
    if (response.status != 200) {
      throw new Error(json.mensagem);
    }

    preencheTabela(json, 'tabelaObservacaoTitulosReceber');

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    if (colunas == null || colunas.integracaoseniorobsrecebertitulo == undefined) {
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniorobsrecebertitulo: [] }))
      colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#btnConfirmarColunas').on('click', async function () {
      try {
        $.LoadingOverlay('show');

        const novasColunas = retornaNovasColunasInvisiveis();
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniorobsrecebertitulo: novasColunas }))

        $('#tabelaObservacaoTitulosReceber').DataTable().columns().visible(true);

        $('#tabelaObservacaoTitulosReceber').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } finally {
        $.LoadingOverlay('hide');
        $('#modal-ColunasVisiveis').modal('hide');
      }
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaObservacaoTitulosReceber_length').prepend('<button class="buttonColVis" id="buttonColVisReceberObsTitulos"><i class="fas fa-cogs"></i></button>');
    $('#tabelaObservacaoTitulosReceber_length').prepend('<button class="buttonExcel" id="buttonExcelReceberObsTitulos"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisReceberObsTitulos').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelReceberObsTitulos').prop('title', 'Exportar')

    $('#buttonColVisReceberObsTitulos').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelReceberObsTitulos').on('click', async function () {
      const url = '/sisplan/senior/v1/consultareceberobstitulos?';
      const params = await retornaFiltros();
      await exportaCSV(url, params, false, 3600000, 'Relatório de Observação de Título', '#tabelaObservacaoTitulosReceber');
    })

    $('#tabelaObservacaoTitulosReceber').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.integracaoseniorobsrecebertitulo).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
      const cols = [];

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

      $('#tabelaObservacaoTitulosReceber').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.integracaoseniorobsrecebertitulo ?? [])
    });
  };

  async function consultaNotaEntradaEnvio() {
    const params = await retornaFiltros('NotaEntradaEnvio');
    const response = await requisicao("GET", "/sisplan/senior/v1/consultanotaentradaenvio?", params, "", 900000);

    if (!response) {
      throw new Error("Não foi possível consultar os registros.");
    }

    const json = await response.json();
    if (response.status != 200) {
      throw new Error(json.mensagem);
    }

    preencheTabela(json, 'tabelaNotaEntradaEnvio');

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    if (colunas == null || colunas.integracaoseniornotaentradaenvio == undefined) {
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniornotaentradaenvio: [] }))
      colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#btnConfirmarColunas').on('click', async function () {
      try {
        $.LoadingOverlay('show');

        const novasColunas = retornaNovasColunasInvisiveis();
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniornotaentradaenvio: novasColunas }))

        $('#tabelaNotaEntradaEnvio').DataTable().columns().visible(true);

        $('#tabelaNotaEntradaEnvio').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } finally {
        $.LoadingOverlay('hide');
        $('#modal-ColunasVisiveis').modal('hide');
      }
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaNotaEntradaEnvio_length').prepend('<button class="buttonColVis" id="buttonColVisNotaEntradaEnvio"><i class="fas fa-cogs"></i></button>');
    $('#tabelaNotaEntradaEnvio_length').prepend('<button class="buttonExcel" id="buttonExcelNotaEntradaEnvio"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisNotaEntradaEnvio').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelNotaEntradaEnvio').prop('title', 'Exportar')

    $('#buttonColVisNotaEntradaEnvio').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelNotaEntradaEnvio').on('click', async function () {
      const url = '/sisplan/senior/v1/consultanotaentradaenvio?';
      const params = await retornaFiltros();
      await exportaCSV(url, params, false, 3600000, 'Relatório de Envio de Nota de Entrada', '#tabelaNotaEntradaEnvio');
    })

    $('#tabelaNotaEntradaEnvio').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.integracaoseniornotaentradaenvio).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
      const cols = [];

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

      $('#tabelaNotaEntradaEnvio').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.integracaoseniornotaentradaenvio ?? [])
    });
  };

  async function consultaPagarEnvio() {
    const params = await retornaFiltros('PagarEnvio');
    const response = await requisicao("GET", "/sisplan/senior/v1/consultapagarenvio?", params, "", 900000);

    if (!response) {
      throw new Error("Não foi possível consultar os registros.");
    }

    const json = await response.json();
    if (response.status != 200) {
      throw new Error(json.mensagem);
    }

    preencheTabela(json, 'tabelaPagarEnvio');


    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    if (colunas == null || colunas.integracaoseniorenviopagar == undefined) {
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniorenviopagar: [] }))
      colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#btnConfirmarColunas').on('click', async function () {
      try {
        $.LoadingOverlay('show');

        const novasColunas = retornaNovasColunasInvisiveis();
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniorenviopagar: novasColunas }))

        $('#tabelaPagarEnvio').DataTable().columns().visible(true);

        $('#tabelaPagarEnvio').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } finally {
        $.LoadingOverlay('hide');
        $('#modal-ColunasVisiveis').modal('hide');
      }
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaPagarEnvio_length').prepend('<button class="buttonColVis" id="buttonColVisPagarEnvio"><i class="fas fa-cogs"></i></button>');
    $('#tabelaPagarEnvio_length').prepend('<button class="buttonExcel" id="buttonExcelPagarEnvio"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisPagarEnvio').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelPagarEnvio').prop('title', 'Exportar')

    $('#buttonColVisPagarEnvio').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelPagarEnvio').on('click', async function () {
      const url = '/sisplan/senior/v1/consultapagarenvio?';
      const params = await retornaFiltros();
      await exportaCSV(url, params, false, 3600000, 'Relatório de Envio do Pagar', '#tabelaPagarEnvio');
    })

    $('#tabelaPagarEnvio').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.integracaoseniorenviopagar).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
      const cols = [];

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

      $('#tabelaPagarEnvio').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.integracaoseniorenviopagar ?? [])
    });
  };

  async function consultaEntidadeEnvio() {
    const params = await retornaFiltros('EntidadeEnvio');
    const response = await requisicao("GET", "/sisplan/senior/v1/consultaentidadeenvio?", params, "", 900000);

    if (!response) {
      throw new Error("Não foi possível consultar os registros.");
    }

    const json = await response.json();
    if (response.status != 200) {
      throw new Error(json.mensagem);
    }

    preencheTabela(json, 'tabelaEnvioEntidade');

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    if (colunas == null || colunas.integracaoseniorenvioentidade == undefined) {
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniorenvioentidade: [] }))
      colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#btnConfirmarColunas').on('click', async function () {
      try {
        $.LoadingOverlay('show');

        const novasColunas = retornaNovasColunasInvisiveis();
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniorenvioentidade: novasColunas }))

        $('#tabelaEnvioEntidade').DataTable().columns().visible(true);

        $('#tabelaEnvioEntidade').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } finally {
        $.LoadingOverlay('hide');
        $('#modal-ColunasVisiveis').modal('hide');
      }
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaEnvioEntidade_length').prepend('<button class="buttonColVis" id="buttonColVisEntidadeEnvio"><i class="fas fa-cogs"></i></button>');
    $('#tabelaEnvioEntidade_length').prepend('<button class="buttonExcel" id="buttonExcelEntidadeEnvio"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisEntidadeEnvio').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelEntidadeEnvio').prop('title', 'Exportar')

    $('#buttonColVisEntidadeEnvio').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelEntidadeEnvio').on('click', async function () {
      const url = '/sisplan/senior/v1/consultaentidadeenvio?';
      const params = await retornaFiltros();
      await exportaCSV(url, params, false, 3600000, 'Relatório de Envio de Entidade', '#tabelaEnvioEntidade');
    })

    $('#tabelaEnvioEntidade').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.integracaoseniorenvioentidade).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
      const cols = [];

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

      $('#tabelaEnvioEntidade').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.integracaoseniorenvioentidade ?? [])
    });
  };

  async function consultaEntidadeObs() {
    const params = await retornaFiltros('EntidadeObs');
    const response = await requisicao("GET", "/sisplan/senior/v1/consultaentidadeobs?", params, "", 900000);

    if (!response) {
      throw new Error("Não foi possível consultar os registros.");
    }

    const json = await response.json();
    if (response.status != 200) {
      throw new Error(json.mensagem);
    }

    preencheTabela(json, 'tabelaObservacaoEntidade');

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    if (colunas == null || colunas.integracaoseniorobsentidade == undefined) {
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniorobsentidade: [] }))
      colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#btnConfirmarColunas').on('click', async function () {
      try {
        $.LoadingOverlay('show');

        const novasColunas = retornaNovasColunasInvisiveis();
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, integracaoseniorobsentidade: novasColunas }))

        $('#tabelaObservacaoEntidade').DataTable().columns().visible(true);

        $('#tabelaObservacaoEntidade').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } finally {
        $.LoadingOverlay('hide');
        $('#modal-ColunasVisiveis').modal('hide');
      }
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaObservacaoEntidade_length').prepend('<button class="buttonColVis" id="buttonColVisEntidadeObs"><i class="fas fa-cogs"></i></button>');
    $('#tabelaObservacaoEntidade_length').prepend('<button class="buttonExcel" id="buttonExcelEntidadeObs"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisEntidadeObs').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelEntidadeObs').prop('title', 'Exportar')

    $('#buttonColVisEntidadeObs').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelEntidadeObs').on('click', async function () {
      const url = '/sisplan/senior/v1/consultaentidadeobs?';
      const params = await retornaFiltros();
      await exportaCSV(url, params, false, 3600000, 'Relatório de Observação de Entidade', '#tabelaObservacaoEntidade');
    })

    $('#tabelaObservacaoEntidade').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.integracaoseniorobsentidade).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
      const cols = [];

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

      $('#tabelaObservacaoEntidade').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.integracaoseniorobsentidade ?? [])
    });

  };

  async function retornaFiltros(aba) {
    if (aba === 'EntidadeObs') {
      const cliente = await formataListas($('#txtObservacaoEntidade').val().toString());
      const tabela = $('input[name="tabelaObservacaoEntidade"]:checked').val();
      const status = $('input[name="statusObservacaoEntidade"]:checked').val();

      return `CODCLI=${cliente}&TABELA=${tabela}&STATUS=${status}`;
    }

    if (aba === 'EntidadeEnvio') {
      const cliente = await formataListas($('#txtEnvioEntidade').val().toString());
      const status = $('input[name="statusEnvioEntidade"]:checked').val();

      return `CODCLI=${cliente}&STATUS=${status}`;
    }

    if (aba === 'PagarEnvio') {
      const numAp = await formataListas($('#txtNumeroPagarEnvio').val().toString());
      const dtEmiIni = $('#dtEmissaoPagarDeEnvio').val();
      const dtEmiFim = $('#dtEmissaoPagarAteEnvio').val();
      const mapeado = $('input[name="mapeadoPagarEnvio"]:checked').val();
      const tabela = $('input[name="tabelaPagarEnvio"]:checked').val();
      const status = $('input[name="statusPagarEnvio"]:checked').val();

      return `NUM_PAGTO=${numAp}&DT_EMI_INI=${dtEmiIni}&DT_EMI_FIM=${dtEmiFim}&MAPEADO=${mapeado}&TABELA=${tabela}&STATUS=${status}`;
    }

    if (aba === 'NotaEntradaEnvio') {
      const fatura = await formataListas($('#txtFaturaNotaEntradaEnvio').val().toString());
      const mapeado = $('input[name="mapeadoNotaEntradaEnvio"]:checked').val();
      const status = $('input[name="statusNotaEntradaEnvio"]:checked').val();
      const dtEmiIni = $('#dtEmissaoNotaEntradaDeEnvio').val();
      const dtEmiFim = $('#dtEmissaoNotaEntradaAteEnvio').val();

      return `FATURA=${fatura}&MAPEADO=${mapeado}&STATUS=${status}&DT_EMI_INI=${dtEmiIni}&DT_EMI_FIM=${dtEmiFim}`;
    }

    if (aba === 'NFEEnvio') {
      const fatura = await formataListas($('#txtFaturaNFE').val().toString());
      const codven = await formataListas($('#txtCodvenNFE').val().toString());
      const dtEmiIni = $('#dtEmissaoDeNFE').val();
      const dtEmiFim = $('#dtEmissaoAteNFE').val();
      const protocolo = $('input[name="protocoloNFE"]:checked').val();
      const status = $('input[name="status"]:checked').val();
      const mapeado = $('input[name="mapeado"]:checked').val();
      const impresso = $('#selectImpressoNFE').val();

      return `FATURA=${fatura}&CODVEN=${codven}&DT_EMI_INI=${dtEmiIni}&DT_EMI_FIM=${dtEmiFim}&PROTOCOLO=${protocolo}&STATUS=${status}&MAPEADO=${mapeado}&IMPRESSO=${impresso}`;
    }

    if (aba === 'NFCEEnvio') {
      const fatura = await formataListas($('#txtFaturaNFCE').val().toString());
      const codven = await formataListas($('#txtCodvenNFCE').val().toString());
      const dtEmiIni = $('#dtEmissaoDeNFCE').val();
      const dtEmiFim = $('#dtEmissaoAteNFCE').val();
      const protocolo = $('input[name="protocoloNFCE"]:checked').val();
      const status = $('input[name="statusNFCE"]:checked').val();
      const mapeado = $('input[name="mapeadoNFCE"]:checked').val();
      const impresso = $('#selectImpressoNFCE').val();

      return `FATURA=${fatura}&CODVEN=${codven}&DT_EMI_INI=${dtEmiIni}&DT_EMI_FIM=${dtEmiFim}&PROTOCOLO=${protocolo}&STATUS=${status}&MAPEADO=${mapeado}&IMPRESSO=${impresso}`;
    }

    if (aba === 'ReceberObsTitulos') {
      const status = $('input[name="statusReceberObservacaoTitulos"]:checked').val();
      const cliente = await formataListas($('#txtClienteReceberObservacaoTitulos').val().toString());
      const numero = await formataListas($('#txtNumeroReceberObservacaoTitulos').val().toString());

      return `STATUS=${status}&CLIENTE=${cliente}&NUMERO=${numero}`;
    }

    if (aba === 'ReceberConsulta') {
      const numero = await formataListas($('#txtNumeroReceberConsulta').val().toString());
      const dtEmissaoIni = $('#dtEmissaoReceberDeConsulta').val();
      const dtEmissaoFim = $('#dtEmissaoReceberAteConsulta').val();
      const tabela = $('input[name="tabelaReceberConsulta"]:checked').val();
      const status = $('input[name="statusReceberConsulta"]:checked').val();

      return `NUMERO=${numero}&DT_EMI_INI=${dtEmissaoIni}&DT_EMI_FIM=${dtEmissaoFim}&TABELA=${tabela}&STATUS=${status}`;
    }

    if (aba === 'ReceberEnvio') {
      const mapeado = $('input[name="mapeadoReceberEnvio"]:checked').val();
      const status = $('input[name="statusReceberEnvio"]:checked').val();
      const dtEmiIni = $('#dtEmissaoReceberDeEnvio').val();
      const dtEmiFim = $('#dtEmissaoReceberAteEnvio').val();
      const numero = await formataListas($('#txtNumeroReceberEnvio').val().toString());
      const faturaNfe = await formataListas($('#txtFaturaNFEReceberEnvio').val().toString());
      const faturaNfce = await formataListas($('#txtFaturaNFCEReceberEnvio').val().toString());
      const moeda = await formataListas($('#txtMoedaReceberEnvio').val().toString());
      const historico = await formataListas($('#txtHistoricoReceberEnvio').val().toString());
      const venda = await formataListas($('#txtCodvenReceberEnvio').val().toString());

      return `MAPEADO=${mapeado}&STATUS=${status}&DT_EMI_INI=${dtEmiIni}&DT_EMI_FIM=${dtEmiFim}&NUMERO=${numero}&FATURA_NFE=${faturaNfe}&FATURA_NFCE=${faturaNfce}&MOEDA=${moeda}&HISTORICO=${historico}&CODVEN=${venda}`;
    }
  }

  async function preencheTabela(data, idTabela, urlPesquisa = '', camposDataTable = [], filtros = '') {

    if ($.fn.DataTable.isDataTable(`#${idTabela}`)) {
      $(`#${idTabela}`).DataTable().destroy();
      $(`#${idTabela}`).empty();
    };

    const dataSetCols = [];

    if (camposDataTable.length <= 0) {
      if (data.length === 0) {
        msgAlerta('Nenhum registro encontrado.');
        return;
      }

      const keys = Object.keys(data[0]);

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }
    }

    if (idTabela === 'tabelaEnvioReceber' || idTabela === 'tabelaNotaFiscalSaida') {
      return new Promise((resolve, reject) => {
        setTimeout(async () => {
          var table = $(`#${idTabela}`).DataTable({
            destroy: true,
            lengthChange: true,
            autoWidth: true,
            serverSide: true,
            processing: true,
            timeout: 100000000,
            searching: false,
            ajax: async function (data, callback, settings) {
              $.ajax({
                url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/senior/v1/${urlPesquisa}?${await retornaFiltros(filtros)}`,
                type: "GET",
                headers: { 'Authorization': 'Bearer ' + getCookie('accessToken') },
                data: {
                  "EMPRESA": getCookie('empresa'),
                  "USUARIO": getCookie('usuario').toUpperCase(),
                  "JSON": '',
                  "CLIENTE": 'N',
                  "TIPO_PESQUISA": '',
                  "AUTOCOMPLETA": 'N',
                  ...data
                },
                success: function (response) {
                  callback({
                    draw: response.draw,
                    recordsTotal: response.recordsTotal,
                    recordsFiltered: response.recordsFiltered,
                    data: response.data
                  });
                },
                error: function () {
                  console.error('Erro ao carregar os dados.');
                  callback({
                    draw: data.draw,
                    recordsTotal: 0,
                    recordsFiltered: 0,
                    data: []
                  });
                }
              });
            },
            language: {
              "sEmptyTable": "Nenhum registro encontrado",
              "sInfo": "_TOTAL_ registros",
              "sInfoEmpty": " 0 registros",
              "sInfoFiltered": "(Filtrados de MAX registros)",
              "sInfoPostFix": "",
              "sInfoThousands": ".",
              "sLengthMenu": "_MENU_ resultados",
              "sLoadingRecords": "Carregando...",
              "sProcessing": "Processando...",
              "sZeroRecords": "Nenhum registro encontrado",
              "sSearch": "Pesquisar (geral): ",
              "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
              },
              "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
              }
            },
            columns: camposDataTable
          });
          resolve(table);
        }, 500);
      });
    } else {
      $(`#${idTabela}`).DataTable({
        paging: true,
        filter: true,
        info: true,
        order: false,
        destroy: true,
        colReorder: true,
        serverside: true,
        searching: false,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de MAX registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar (geral): ",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "data": data,
        "columns": dataSetCols
      });
    }

  };

  criaPesquisasFiltroReceberEnvio();
  criaPesquisasFiltroNFCEEnvio();
  criaPesquisasFiltroNFEEnvio();
  criaPesquisasFiltroReceberConsulta();
  criaPesquisasFiltroReceberObservacaoTitulos();
  criaPesquisasFiltroNotaEntraEnvio();
  criaPesquisasFiltroPagarEnvio();
  criaPesquisasFiltroEntidadeEnvio();
  criaPesquisasFiltroEntidadeObservacaoEntidades();

}); 