$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#abaGeral',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar a ordem de compra a ser liberada.',
          position: 'bottom'
        }
      },
      {
        element: '#btnConsultar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta de ordens de compra.',
          position: 'left'
        }
      },
      {
        element: '#btnLiberar',
        popover: {
          title: 'Botão Confirmar',
          description: 'Clique aqui para liberar/bloquear as ordens de compra selecionadas.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $("#tabelaOc tbody").on("click", "tr", function () {
    $("#tabelaOc")
      .dataTable()
      .$("tr.selected")
      .removeClass("selected");
    $(this).addClass("selected");
  });

  addPesquisaAutocompleta();

  $('#btnConsultar').on('click', async () => {
    await buscaOc()
  });

  $('#tabelaOc').on('dblclick', 'tr', async function () {
    $.LoadingOverlay('show');
    try {
      $('.selected').removeClass('selected');
      $(this).closest('tr').addClass('selected');
      await buscaItensOc($(this).closest('tr')[0].children[1].innerHTML, $(this).closest('tr')[0].children[2].innerHTML, $(this).closest('tr')[0].children[3].innerHTML);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-itens').modal('show');
      $('#tabelaItens').DataTable().columns.adjust().draw(false);
    }
  });

  $('#tabelaItens').on('dblclick', 'tr', async function () {
    $.LoadingOverlay('show');
    try {
      $('.selected').removeClass('selected');
      $(this).closest('tr').addClass('selected');
      await carregaUltCompras($(this).closest('tr')[0].children[0].innerHTML);
    } finally {
      $.LoadingOverlay('hide');
      $('#tabUltCompras').trigger('click');
      setTimeout(() => { $('#tabelaUltCompras').DataTable().columns.adjust().draw(false); }, 300);
    }
  });

  $('#tabUltCompras').on('click', function () {
    setTimeout(() => { $('#tabelaUltCompras').DataTable().columns.adjust().draw(false); }, 300);
  });

  $('#tabItens').on('click', function () {
    setTimeout(() => { $('#tabelaItens').DataTable().columns.adjust().draw(false); }, 300);
  });

  $('#btnLiberar').on('click', async function () {
    await gravaDados();
  });

  async function gravaDados() {
    let arrOcs = [];

    $('.selecionado').closest('tr').map((index, item) => {
      arrOcs.push({
        NUMERO: item.children[1].innerHTML,
      })
    });

    if (arrOcs.length == 0) {
      msgAlerta('Nenhuma ordem de compra selecionada para liberar.');
      return;
    }

    const response = await requisicao('POST', '/sisplan/liberacaooc/v1/liberacao?', '', JSON.stringify({ OCS: arrOcs }));

    if (!response) {
      $.LoadingOverlay('hide');
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      $.LoadingOverlay('hide');
      msgErro(jsonStr.mensagem);
      return;
    }
    criaMensagemSucesso('Liberação efetuada com sucesso.', () => { window.location.reload() })
  }

  async function buscaItensOc(sNumero, sCodfor, sNomeFor) {
    $.LoadingOverlay('show');
    try {
      const itens = await retornaItens(sNumero);

      insereValor('#txtNumeroOc', sNumero);
      insereValor('#txtClienteOc', sCodfor, sNomeFor);
      insereItens(itens);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function buscaOc() {
    $.LoadingOverlay('show');
    try {
      const dados = await retornaDados();

      if (dados.length == 0) {
        msgAlerta('Nenhum dado encontrado, favor verificar os filtros.')
        return;
      }

      insereDadosTabela(dados);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function retornaDados() {
    try {
      const classFiltros = await retornaFiltros();
      const response = await requisicao('GET', '/sisplan/liberacaooc/v1/liberacao?', `JSON=${JSON.stringify(classFiltros)}`);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }

      const jsonStr = await response.json();

      return jsonStr;
    } catch (error) {
      console.error(error);
    }
  }

  async function carregaUltCompras(sCodigo) {
    try {
      const response = await requisicao('GET', '/sisplan/liberacaooc/v1/ultcompras?', `CODIGO=${sCodigo}&EMP_ID=${getCookie('emp_id')}`);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }

      const jsonStr = await response.json();

      const keys = Object.keys(jsonStr[0]);

      let dataSetCols = [];
      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      criaDataTablePadrao('#tabelaUltCompras', false, false, false, false, true, false, '330px', jsonStr, dataSetCols, [6, 7, 8, 9, 10], [5], []);
    } catch (error) {
      console.error(error);
    }
  }

  async function retornaItens(sNumero) {
    const dadosSelect = {
      tabela: 'CO_ITEN',
      camposSelect: ['CODIGO', 'DESCRICAO', 'COR', 'TAM', 'QTDE', 'PRECO'],
      where: [`NUMERO = '${sNumero}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;
  }

  async function retornaFiltros() {
    return {
      STATUS: await formataListas($('#txtStatus').val().toString()),
      DTENTREGAINI: pegaValor('#txtDtEntregaDe'),
      DTENTREGAFIM: pegaValor('#txtDtEntregaAte'),
      DTEMISSAOINI: pegaValor('#txtDtEmissaoDe'),
      DTEMISSAOFIM: pegaValor('#txtDtEmissaoAte'),
      DTLIBERACAOINI: pegaValor('#txtDtLiberadosDe'),
      DTLIBERACAOFIM: pegaValor('#txtDtLiberadosAte'),
      FORNECEDOR: await formataListas($('#txtFornecedor').val().toString()),
      ORDENSCOMPRA: await formataListas($('#txtOc').val().toString()),
      MATERIAL: await formataListas($('#txtMaterial').val().toString()),
      USERLIBERACAO: await formataListas($('#txtUserLib').val().toString()),
      USERCADASTRO: await formataListas($('#txtUserCadOC').val().toString()),
      SITUACAO: isChecked('#radioAberta') ? 1 : (isChecked('#radioBaixada') ? 2 : 0),
      TIPO: isChecked('#radioMaterial') ? 1 : (isChecked('#radioProduto') ? 2 : (isChecked('#radioServico') ? 3 : 0)),
      HIERARQUIA: isChecked('#radioTodosHierarquia') ? 0 : (isChecked('#radioAguardandoLib') ? 1 : (isChecked('#radioDispLib') ? 2 : 3)),
      FILTRO: isChecked('#radioAnalise') ? 1 : (isChecked('#radioLiberados') ? 2 : (isChecked('#radioRejeitados') ? 3 : (isChecked('#radioBloqueados') ? 4 : (isChecked('#radioBloqDir') ? 5 : 0))))
    }
  }

  function insereItens(sDados) {
    const keys = Object.keys(sDados[0]);

    let dataSetCols = [];
    for (var k in keys) {
      dataSetCols.push({
        'data': keys[k]
      });
    };

    criaDataTablePadrao('#tabelaItens', false, false, false, false, true, false, '330px', sDados, dataSetCols, [], [], [5]);
  }

  function insereDadosTabela(sDados) {
    let dataSetCols = [];

    const keys = Object.keys(sDados[0]);
    dataSetCols.push({
      'data': 'SEL',
      'width': '15px'
    });

    dataSetCols[0].render = function (data, type, row, meta) {
      return `<div class="icheck-primary d-inline">
								<input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
								<label for="check_col_${meta.row}_row_${meta.col}"></label>
						  </div>`
    };

    for (var k in keys) {
      dataSetCols.push({
        'data': keys[k]
      });
    };

    criaDataTablePadrao('#tabelaOc', false, false, false, false, true, false, '300px', sDados, dataSetCols, [], [], [4]);

    $('.campoSel').on('click', function () {
      if (this.checked) {
        $(this).addClass('selecionado');
      } else {
        $(this).removeClass('selecionado');
      }
    });
  }

  function addPesquisaAutocompleta() {
    $('#txtOc').pesquisa_variosServerside(1, `{"tabela":"COMPRA", "camposSelect":[ "COMPRA.NUMERO", "ENTIDADE.NOME" ], "leftjoin": [{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI= COMPRA.CODFOR"}]}`, "NUMERO", "NOME")
    $('#btnOc').pesquisa_serversideSel('#txtOc', `{"tabela":"COMPRA", "camposSelect":[ "COMPRA.NUMERO", "ENTIDADE.NOME" ], "leftjoin": [{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI= COMPRA.CODFOR"}]}`, 'Pesquisa Ordem de Compra');
    $('#btnLimpaOc').on('click', function () { $('#txtOc').empty().trigger('change') })

    $('#txtFornecedor').pesquisa_variosServerside(1, `{"tabela":"entidade", "camposSelect":["CODCLI, NOME"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, "CODCLI", "NOME")
    $('#btnFornecedor').pesquisa_serversideSel('#txtFornecedor', `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, 'Pesquisa de Fornecedor');
    $('#btnLimpaFornecedor').on('click', function () { $('#txtCentroCusto').empty().trigger('change') })

    $('#txtStatus').pesquisa_variosServerside(1, `{ "tabela":"sitprod", "camposSelect":[ "codigo", "descricao"], "where": null}`, "CODIGO", "DESCRICAO")
    $('#btnStatus').pesquisa_serversideSel('#txtStatus', `{ "tabela":"sitprod", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa de Status');
    $('#btnLimpaStatus').on('click', function () { $('#txtStatus').empty().trigger('change') })

    $('#txtUserLib').pesquisa_variosServerside(1, `{ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo", "nome"], "where": null}`, "CODIGO", "NOME")
    $('#btnUserLib').pesquisa_serversideSel('#txtUserLib', `{ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo", "nome"]}`, 'Pesquisa de Usuário');
    $('#btnLimpaUserLib').on('click', function () { $('#txtUserLib').empty().trigger('change') })

    $('#txtUserCadOC').pesquisa_variosServerside(1, `{ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo", "nome"], "where": null}`, "CODIGO", "NOME")
    $('#btnUserCadOC').pesquisa_serversideSel('#txtUserCadOC', `{ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo", "nome"]}`, 'Pesquisa de Usuário');
    $('#btnLimpaUserCadOC').on('click', function () { $('#txtUserCadOC').empty().trigger('change') })

    $('#txtMaterial').pesquisa_variosServerside(1, `{ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, "CODIGO", "DESCRICAO")
    $('#btnMaterial').pesquisa_serversideSel('#txtMaterial', `{ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Materiais');
    $('#btnLimpaMaterial').on('click', function () { $('#txtMaterial').empty().trigger('change') })
  }
});