function validarCaracteres(value) {
    const result = value.match(/[&\/\\#,+()$~%.'":*?<>{}´`]/g);
    return result?.length ?? 0;
}

$(document).ready(async function () {

    componenteFiltro('conta');

    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let lancto = parametros[parametros.length - 1];

    if (lancto != 'create') {
        await buscaDados();
    } else {
        $('#txtConciliado').val('N');
    }

    $('#txtValor').on('input', function () {
        if (($(this).val()).split('.')[1]?.length > 2) {
            $(this).val(($(this).val()).slice(0, -1));
        }
    });

    async function buscaDados() {
        $.LoadingOverlay('show');
        try {
            try {
                const pesquisa = {
                    tabela: 'EXTRATO',
                    camposSelect: ['EXTRATO.*', 'CADCONTA.DESCRICAO DESC_CONTA'],
                    leftjoin: [{ tabela: 'CADCONTA', condicao: 'EXTRATO.CONTA = CADCONTA.CONTA' }],
                    where: [`EXTRATO.LANCTO = '${lancto}'`]
                };

                const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));

                if (!jsonStr) {
                    return;
                }

                let data;

                if (jsonStr.length > 0) {
                    data = jsonStr[0];
                } else {
                    return;
                }

                $('#txtLancamento').val(data.LANCTO);
                $('#txtData').val(data.DT_CONT);
                $('#txtDocto').val(data.DOCTO);
                insereValor('#txtConta', data.CONTA, data.DESC_CONTA);
                $('#txtConciliado').val(data.CONCILIADO != 'S' ? 'N' : data.CONCILIADO);
                $('#txtValor').val(data.VALOR);
                $('#txtOperacao').val(data.OPERACAO);
                $('#txtObs').val(data.OBSERVACAO);

                await calculaSaldoConta();
            } catch (e) {
                console.log(e);
                msgErro(`Não foi possível buscar os dados: ${e}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#txtConta').on('focusout', async function () {
        $.LoadingOverlay('hide');
        try {
            await calculaSaldoConta();
        } catch (e) {
            $.LoadingOverlay('hide');
        }
    });

    async function calculaSaldoConta() {
        try {
            const conta = pegaChave('#txtConta');

            const valorC = (await buscaValor('EXTRATO', 'COALESCE(SUM(VALOR), 0) VALOR', `OPERACAO = 'C' AND CONTA`, conta)).VALOR;
            const valorD = (await buscaValor('EXTRATO', 'COALESCE(SUM(VALOR), 0) VALOR', `OPERACAO = 'D' AND CONTA`, conta)).VALOR;

            const valor = valorC - valorD;

            $('#txtSaldoConta').val(parseFloat(valor).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
            }));
        } catch (e) {
            console.log(e);
        }
    };

    $('#btnGravar').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            if ($('#txtConta').val() == '') {
                msgErro('O campo conta deve ser preenchido, favor verificar.');
                return;
            }

            if (parseFloat($('#txtValor').val() == '' ? 0 : $('#txtValor').val()) <= 0) {
                msgErro('O valor deve ser maior que zero, favor verificar.');
                return;
            }

            if ($('#txtDocto').val() == '') {
                msgErro('O campo documento deve ser preenchido, favor verificar.');
                return;
            }

            if ($('#txtData').val() == '') {
                msgErro('O campo data deve ser preenchido, favor verificar.');
                return;
            }

            if ($('#txtOperacao').val() == '') {
                msgErro('O campo operação deve ser preenchido, favor verificar.');
                return;
            }

            let contaAtiva = await buscaValor('CADCONTA', 'ATIVO', 'CONTA', pegaChave('#txtConta'));
            contaAtiva = contaAtiva != undefined ? contaAtiva.ATIVO : '';

            if (contaAtiva == '') {
                msgErro('Conta inválida, favor verificar.');
            }

            if (contaAtiva == 'N') {
                msgErro('Conta inativa, favor verificar.');
                return;
            }

            await gravaDados();

        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function gravaDados() {
        try {
            let obj = {};

            obj.LANCTO = $('#txtLancamento').val();
            obj.CONTA = pegaChave('#txtConta');
            obj.DT_CONT = $('#txtData').val() != '' ? $('#txtData').val() : '1899-12-30';
            obj.DOCTO = $('#txtDocto').val();
            obj.VALOR = parseFloat($('#txtValor').val());
            obj.OPERACAO = $('#txtOperacao').val();
            obj.BANCO = '';
            obj.OBSERVACAO = $('#txtObs').val();
            obj.CONCILIADO = $('#txtConciliado').val();

            let response = await requisicao("POST", `/Sisplan/extrato/V1/gravadados?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `JSON=${encodeURIComponent(JSON.stringify(obj))}`);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta(jsonStr.mensagem);
                return;
            }

            toastr
                .success("Cadastro efetuado com sucesso!", "Confirmação", {
                    toastClass: "alert",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/extrato`;
                    },
                })
                .css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível gravar os dados: ${e}`);
        }
    }

    $('#btnVoltar').on('click', function () {
        msgAlerta('Tem certeza que deseja voltar?', () => { }, () => { }, () => { window.location.href = `${BASE_URI}/extrato` })
    });

});