$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta das posições.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de uma posição.",
          position: "right",
        },
      },
      {
        element: "#btnImprimir",
        popover: {
          title: "Botão Imprimir",
          description: "Clique aqui para imprimir os dados.",
          position: "top",
        },
      },
      {
        element: "#tabelaDados",
        popover: {
          title: "Tabela",
          description: "Aqui estão os dados das posições.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});


$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("ESCENVIO");
  setaDatasMes();
  let contaAnterior = '';

  function setaDatasMes() {
    const { primeiroDia, ultimoDia } = pegaPrimeiroEUltimoDia();
    $('#dtEmissaoDe').val(primeiroDia);
    $('#dtEmissaoAte').val(ultimoDia);
  }

  function pegaPrimeiroEUltimoDia() {
    const hoje = new Date();
    const primeiroDia = new Date(hoje.getFullYear(), hoje.getMonth(), 1);
    const ultimoDia = new Date(hoje.getFullYear(), hoje.getMonth() + 1, 0);

    const formatDate = (date) => {
      const ano = date.getFullYear();
      const mes = String(date.getMonth() + 1).padStart(2, '0');
      const dia = String(date.getDate()).padStart(2, '0');
      return `${ano}-${mes}-${dia}`;
    };

    return {
      primeiroDia: formatDate(primeiroDia),
      ultimoDia: formatDate(ultimoDia)
    };
  }
  componenteFiltro('conta', true);
  componenteFiltro('fatura', true);
  componenteFiltro('cliente', true);
  componenteFiltro('endosso', true);
  componenteFiltro('cidade', true);
  componenteFiltro('moeda', true, false);
  componenteFiltro('grupoCli', true);

  $('#txtBordero').autocompleta(1, `JSON={ "tabela":"BORDERO", "camposSelect":[ "CARTEIRA CHAVE", "CONTA DESCRICAO"], "where": null}`);
  $('#btnBordero').pesquisa_serverside(['#txtBordero'], ['NUMERO'], ['CONTA'], '{"tabela":"BORDERO", "camposSelect":[ "NUMERO", "CARTEIRA", "CONTA"], "where": null}', 'Pesquisa de Bordero');
  $('#btnLimpaBordero').on('click', function () {
    $('#txtBordero').val('');
  });
  $('#txtBanco').autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`);
  $('#btnBanco').pesquisa_serverside(['#txtBanco'], ['BANCO'], ['NOME_BANCO'], '{"tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"], "where": null}', 'Pesquisa de Banco');
  $('#btnLimpaBanco').on('click', function () {
    $('#txtBanco').val('');
  });
  $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#btnRepresentante').pesquisa('#txtRepresentante', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"]}`, 'Pesquisa Representante', 'REPRESEN');
  $('#btnLimpaRepresentante').on('click', function () {
    $('#txtRepresentante').val('');
  });
  $('#txtClasseGerencial').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnClasseGerencial').pesquisa('#txtClasseGerencial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
  $('#btnLimpaClasseGerencial').on('click', function () {
    $('#txtClasseGerencial').val('');
  });
  $('#txtUF').autocompleta(1, `JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnUF').pesquisa('#txtUF', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa UF', 'UF');
  $('#btnLimpaUF').on('click', function () {
    $('#txtUF').val('');
  });
  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  //MODAL RECOMPRA
  $('#txtClasseGerencialRecompra').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnClasseGerencialRecompra').pesquisa('#txtClasseGerencialRecompra', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
  $('#btnLimpaClasseGerencialRecompra').on('click', function () {
    $('#txtClasseGerencialRecompra').val('');
  });
  $('#txtContaDebito').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "AGENCIA CHAVE", "CONTA DESCRICAO"], "where": null}`);
  $('#btnContaDebito').pesquisa_serverside(['#txtContaDebito'], ['CONTA'], ['AGENCIA'], '{"tabela":"CADCONTA", "camposSelect":[ "AGENCIA", "CONTA", "BANCO"], "where": null}', 'Pesquisa de Conta');
  $('#btnLimpaContaDebito').on('click', function () {
    $('#txtContaDebito').val('');
  });
  $('#txtFornecedor').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#btnFornecedor').pesquisa_serverside(['#txtFornecedor'], ['CODCLI'], ['NOME'], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": ["TIPO_ENTIDADE LIKE '[PERCENTUAL]F[PERCENTUAL]'"]}`, 'Pesquisa de Fornecedor');
  $('#btnLimpaFornecedor').on('click', function () {
    $('#txtFornecedor').val('');
  });

  limparFiltros(true);

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      // '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" title="Recompra Título" id="btnRecompra">Recompra Título</button>     ' +
      '</div>';
    return retorno;
  };

  await buscaDados();

  $("#btnConsultar").on("click", async function () {
    registrosSelecionados = []
    await buscaDados();
    $("#modal-filtros").modal("hide");
  });

  $('#modalRecompraTitulo').on('show.bs.modal', function () {
    $('#txtValorJuros').attr('disabled', true);
    $('#dtCont').val(formataData(new Date()));

    $('#txtValorDiferencial').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2
    });
    $('#txtValorAntecipacao').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2
    });
    $('#txtValorJuros').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2
    });
    $('#txtValorSaldo').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2
    });
  })

  $('#txtValorDe').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtValorAte').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#btnLimparFiltros').on('click', function () {
    setaDatasMes();
    $('#txtValorDe').val('0.0');
    $('#txtValorAte').val('0.0');
  });

  function calculaValorDiferencial() {
    const valorSaldo = TruncaDecimaisNova(2, $('#txtValorSaldo').val());
    const valorAntecipacao = $('#txtValorAntecipacao').val();
    const total = (valorSaldo - valorAntecipacao);

    $('#txtValorDiferencial').val(TruncaDecimaisNova(2, total));
  }

  $('#txtValorAntecipacao').on('blur', function () {
    calculaValorDiferencial();
  });

  async function buscaDadosCampos() {
    let rgTipo = $('#cbLoja').is(':checked') ? 0 : $('#cbAllDupl').is(':checked') ? 1 : $('#cbAllDuplLoja').is(':checked') ? 2 : 0;
    let rgBordero = $('#cbTodos').is(':checked') ? 0 : $('#cbSemBordero').is(':checked') ? 1 : $('#cbComNrBanco').is(':checked') ? 2 : 0;
    let rgStatusDupl = $('#cbDuplicata').is(':checked') ? 0 : $('#cbDuplicata').is(':checked') ? 1 : 0
    let todasEmpresas = $('#cbTodasEmpresas').is(':checked') ? 'S' : 'N';
    let empresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];

    objeto = {
      emissaoDe: $('#dtEmissaoDe').val(),
      emissaoAte: $('#dtEmissaoAte').val(),
      vencimentoDe: $('#dtVencimentoDe').val(),
      vencimentoAte: $('#dtVencimentoAte').val(),
      emissaoBorderoDe: $('#dtEmissaoBorderoDe').val(),
      emissaoBorderoAte: $('#dtEmissaoBorderoAte').val(),
      cadInstrucaoDe: $('#dtCadInstrucaoDe').val(),
      cadInstrucaoAte: $('#dtCadInstrucaoAte').val(),
      codCli: await formataListas($('#txtCliente').val().toString()),
      grupoCli: await formataListas($('#txtGrupoCli').val().toString()),
      fatura: await formataListas($('#txtFatura').val().toString()),
      conta: await formataListas($('#txtConta').val().toString()),
      endosso: await formataListas($('#txtEndosso').val().toString()),
      cidade: await formataListas($('#txtCidade').val().toString()),
      moeda: await formataListas($('#txtMoeda').val().toString()),
      valorDe: $('#txtValorDe').val(),
      valorAte: $('#txtValorAte').val(),
      banco: $('#txtBanco').val(),
      codigoUF: $('#txtUF').val(),
      bordero: $('#txtBordero').val(),
      codRep: $('#txtRepresentante').val(),
      classe: $('#txtClasseGerencial').val(),
      todasEmpresas: todasEmpresas,
      rgTipo: rgTipo,
      rgBordero: rgBordero,
      rgStatusDupl: rgStatusDupl,
      empresasFiltro: empresas.toString()
    }
    return objeto;
  }

  async function buscaDados() {
    if ($.fn.DataTable.isDataTable('#tabelaDados')) {
      $('#tabelaDados').DataTable().destroy();
      $('#tabelaDados').empty();
    };
    $.LoadingOverlay('show');
    try {
      const params = await buscaDadosCampos();

      const response = await requisicao('GET', `/sisplan/escenvio/V1/buscadadosacesso?`, `JSON=${JSON.stringify(params)}`, '', 90000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      const dataSetCols = [
        {
          data: 'SEL',
          title: 'SEL'
        },
        {
          data: 'NUMERO',
          title: 'Número'
        },
        {
          data: 'PEDIDO',
          title: 'Pedido'
        },
        {
          data: 'CLIENTE',
          title: 'Cliente'
        },
        {
          data: 'SITUACAO',
          title: 'Situação'
        },
        {
          data: 'DATAEMISSAO',
          title: 'Data de Emissão'
        },
        {
          data: 'DATAVENCIMENTO',
          title: 'Data de Vencimento'
        },
        {
          data: 'BORDERO',
          title: 'Bordero'
        },
        {
          data: 'BANCO',
          title: 'Banco'
        },
        {
          data: 'DATAENVIO',
          title: 'Data de Envio'
        },
        {
          data: 'VALORTITULO',
          title: 'Valor do Título'
        },
        {
          data: 'EMPRESA',
          title: 'Empresa'
        },
        {
          data: 'NUMEROBANCO',
          title: 'Nr. Banco'
        },
        {
          data: 'NOTADENEGADA',
          title: 'Nota Denegada'
        },
        {
          data: 'VALORNOTA',
          title: 'Valor da Nota'
        },
        {
          data: 'FATURA',
          title: 'Fatura'
        },
        {
          data: 'EMISSAOBORDERO',
          title: 'Emissão do Bordero'
        },
        {
          data: 'GRUPOCLIENTE',
          title: 'Grupo de Cliente'
        },
        {
          data: 'CONTACHEQUE',
          title: 'Conta Cheque'
        },
        {
          data: 'HISTORICO',
          title: 'Histórico'
        },
        {
          data: 'JUROS',
          title: 'Juros'
        },
        {
          data: 'DESCONTOS',
          title: 'Descontos'
        },
        {
          data: 'NEGOCIADO',
          title: 'Negociado'
        },
        {
          data: 'EMPID',
          title: 'Emp_id'
        },
      ];

      $('#tabelaDados').DataTable({
        paging: true,
        filter: false,
        info: false,
        length: false,
        // order: true,
        sort: true,
        destroy: true,
        autoWidth: true,
        language: {
          sEmptyTable: 'Nenhum registro encontrado',
          sInfo: '_TOTAL_ registros',
          sInfoEmpty: ' 0 registros',
          sInfoFiltered: '(Filtrados de _MAX_ registros)',
          sInfoPostFix: '',
          sInfoThousands: '.',
          sLengthMenu: '_MENU_ resultados',
          sLoadingRecords: 'Carregando...',
          sProcessing: 'Processando...',
          sZeroRecords: 'Nenhum registro encontrado',
          sSearch: 'Pesquisar',
          oPaginate: {
            sNext: 'Próximo',
            sPrevious: 'Anterior',
            sFirst: 'Primeiro',
            sLast: 'Último',
          },
          oAria: {
            sSortAscending: ': Ordenar colunas de forma ascendente',
            sSortDescending: ': Ordenar colunas de forma descendente',
          },
        },
        data: jsonStr,
        columns: dataSetCols,
        columnDefs: [
          {
            targets: [0],
            render: function (_data, _type, _row, meta) {
              return `<div class="icheck-danger d-inline">
                        <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
            }
          },
          {
            targets: [5, 6, 9, 16], render: function (data, type, row) {
              if (type === 'display' || type === 'filter') {
                var date = new Date(data);
                var dia = date.getDate();
                var mes = date.getMonth() + 1;
                var ano = date.getFullYear();
                if (dia < 10) {
                  dia = '0' + dia;
                }
                if (mes < 10) {
                  mes = '0' + mes;
                }
                return dia + '/' + mes + '/' + ano;
              } else {
                return data;
              }
            }
          },
          {
            targets: [1], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            },
          },
          {
            "targets": [22],
            "className": 'pr-4 text-right'
          },
          {
            "render": function (data) {
              if (data !== null && data !== undefined && !isNaN(data)) {
                return parseFloat(data).toLocaleString('pt-BR', {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                });
              } else {
                return '0,00';
              }
            },
            "targets": [10, 14, 20, 21],
            "className": 'pr-4 text-right'
          }
        ],
      });

      criaCheckBoxSelecionarTodos()

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnEnvioRemessa').on('click', async function () {
    window.location.href = 'escenvio/create'
  })

  let registrosSelecionados = []

  $('#tabelaDados').DataTable().on('click', ".campoSel", async function () {
    const dados = $('#tabelaDados').DataTable().row($(this).closest('tr')).data();
    if (!$(this).prop('checked')) {
      registrosSelecionados = registrosSelecionados.filter(cod => (cod.NUMERO != dados.NUMERO));
      $($(this).closest('tr')).removeClass('selected');
      if (registrosSelecionados.length <= 0) {
        contaAnterior = '';
      }
    } else {
      const indexJaExistente = registrosSelecionados.findIndex(index => dados.NUMERO == index.NUMERO);
      if (indexJaExistente == -1) {
        if (dados.BORDERO == '' || dados.BORDERO == '0') {
          if (dados.CONTACHEQUE != '') {
            if (dados.CONTACHEQUE != contaAnterior && contaAnterior != '') {
              msgErro('Duplicata com conta corrente diferente da duplicata selecionada anteriormente, não é possível gerar um borderô com duplicatas em contas diferentes! Verifique e tente novamente.');
              $(this).prop('checked', false);
              return;
            };
            registrosSelecionados.push(dados);
          } else {
            msgErro('Duplicata sem conta corrente informada, impossível gerar borderô! Verifique e tente novamente.');
            $(this).prop('checked', false);
            return;
          };
        } else {
          msgErro('Duplicata já vinculada a um borderô, impossível fazer um novo vínculo! Exclua a mesma do devido borderô e tente novamente.');
          $(this).prop('checked', false);
          return;
        }
      };
      $($(this).closest('tr')).addClass('selected');
      contaAnterior = dados.CONTACHEQUE;
    };
  });

  $('#tabelaDados').on('click', '.campoSel', async function () {
    lineIsChecked = $('#tabelaDados').DataTable().rows((this).closest('tr')).data().toArray()[0].sel == 'N' ? true : false
    newValue = lineIsChecked ? 'S' : 'N'
    $('#tabelaDados').DataTable().rows((this).closest('tr')).data().toArray()[0].sel = newValue;
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  $("#tabelaDados").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaDados").DataTable().row($(this).parents("tr")).data();
      let chave = `${data[0]}-${data[2]}-${data[5]}-${data[7]}`;
      window.location.href = `escposicao/${chave}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaDados").on("click", "#btnRecompra", async function () {
    let data = $("#tabelaDados").DataTable().row($(this).parents("tr")).data();
    $('#txtNumeroRecompra').html(data.NUMERO);
    let valorNovo = data.valorTitulo
    $('#txtValorSaldo').val(valorNovo);
    $('#modalRecompraTitulo').modal('show');
  });

  async function retornaFiltros() {
    const filtros = {
      emissaoDe: $('#dtEmissaoDe').val(),
      emissaoAte: $('#dtEmissaoAte').val(),
      vencimentoDe: $('#dtVencimentoDe').val(),
      vencimentoAte: $('#dtVencimentoAte').val(),
      emissaoBorderoDe: $('#dtEmissaoBorderoDe').val(),
      emissaoBorderoAte: $('#dtEmissaoBorderoAte').val(),
      cadInstrucaoDe: $('#dtCadInstrucaoDe').val(),
      cadInstrucaoAte: $('#dtCadInstrucaoAte').val(),
      cliente: await formataListas($('#txtCliente').val().toString()),
      representante: pegaChave('#txtRepresentante'),
      grupoCli: await formataListas($('#txtGrupoCli').val().toString()),
      fatura: await formataListas($('#txtFatura').val().toString()),
      conta: await formataListas($('#txtConta').val().toString()),
      endosso: await formataListas($('#txtEndosso').val().toString()),
      cidade: await formataListas($('#txtCidade').val().toString()),
      moeda: await formataListas($('#txtMoeda').val().toString()),
      classe: $('#txtClasseGerencial').val(),
      valorDe: $('#txtValorDe').val(),
      valorAte: $('#txtValorAte').val(),
      banco: pegaChave('#txtBanco'),
      uf: pegaChave('#txtUF'),
      bordero: pegaChave('#txtBordero'),
      rgTipo: $('#cbLoja').is(':checked') ? '0' : $('#cbAllDupl').is(':checked') ? '1' : $('#cbAllDuplLoja').is(':checked') ? '2' : '2',
      status: $('#cbDuplicata').is(':checked') ? '0' : $('#cbCheque').is(':checked') ? '1' : '0',
      rgBordero: $('#cbTodos').is(':checked') ? 0 : $('#cbSemBordero').is(':checked') ? 1 : $('#cbComNrBanco').is(':checked') ? 2 : 0,
      todas_empresas: $('#cbTodasEmpresas').is(':checked') ? 'S' : 'N',
      empresas_filtro: $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')]
    }
    return filtros;
  }

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/impressao/v1/imprimirescenvio?';
        const filtros = await retornaFiltros();

        const params = `&EMISSAO_DE=${filtros.emissaoDe}` +
          `&EMISSAO_ATE=${filtros.emissaoAte}` +
          `&VENCIMENTO_DE=${filtros.vencimentoDe}` +
          `&VENCIMENTO_ATE=${filtros.vencimentoAte}` +
          `&EMISSAO_BORDERO_DE=${filtros.emissaoBorderoDe}` +
          `&EMISSAO_BORDERO_ATE=${filtros.emissaoBorderoAte}` +
          `&CAD_INSTRUCAO_DE=${filtros.cadInstrucaoDe}` +
          `&CAD_INSTRUCAO_ATE=${filtros.cadInstrucaoAte}` +
          `&CODCLI=${filtros.cliente}` +
          `&CODREP=${filtros.representante}` +
          `&GRUPO_CLI=${filtros.grupoCli}` +
          `&FATURA=${filtros.fatura}` +
          `&CONTA=${filtros.conta}` +
          `&ENDOSSO=${filtros.endosso}` +
          `&CIDADE=${filtros.cidade}` +
          `&MOEDA=${filtros.moeda}` +
          `&VALOR_DE=${filtros.valorDe}` +
          `&VALOR_ATE=${filtros.valorAte}` +
          `&BANCO=${filtros.banco}` +
          `&CODIGO_UF=${filtros.uf}` +
          `&BORDERO=${filtros.bordero}` +
          `&STATUS=${filtros.status}` +
          `&RG_TIPO=${filtros.rgTipo}` +
          `&RG_BORDERO=${filtros.rgBordero}` +
          `&RG_CLASSE=${filtros.classe}` +
          `&TODAS_EMPRESAS=${filtros.todas_empresas}` +
          `&EMPRESAS_FILTRO=${filtros.empresas_filtro}`

        let arquivo = await GeraRelatorio(`${url + params}&`, 'GET', 100000, false);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#modalRecompraTitulo').on('hide.bs.modal', function () {
    $('#dtCont').val(formataData(new Date()));
    $('#txtValorJuros').val('0.00');
    $('#txtValorSaldo').val('');
    $('#txtClasseGerencialRecompra').val('');
    $('#txtContaDebito').val('');
    $('#txtFornecedor').val('');
    $('#txtValorAntecipacao').val('');
    $('#txtValorDiferencial').val('');
  });

  $('#btnConfirmar').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      const conta = buscaValor('CADCONTA', 'CONTA', 'CONTA', pegaChave('#txtContaDebito'));

      if (!pegaChave('#txtContaDebito') || !conta) {
        throw msgAlerta('Conta não pode ser vazio');
      }

      let dadosRecompra = {
        numero: $('#txtNumeroRecompra').html(),
        dataCont: $('#dtCont').val(),
        juros: $('txtValorJuros').val(),
        saldo: $('#txtValorSaldo').val(),
        classeGerencial: pegaChave('#txtClasseGerencialRecompra'),
        contaDebito: pegaChave('#txtContaDebito'),
        forncedor: pegaChave('#txtFornecedor'),
        valorAntecipacao: $('#txtValorAntecipacao').val(),
        valorDiferencial: $('#txtValorDiferencial').val(),
      }

      let response = await requisicao('POST', '/Sisplan/escenvio/v1/recompratitulo?', `JSON=${encodeURIComponent(JSON.stringify(dadosRecompra))}`, null);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      };

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return;
      }

      toastr.success(
        `Cadastro efetuado com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#modalRecompraTitulo').modal('hide');
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (error) {
      console.log(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function buscaDadosInputs(registroEnvio) {
    const infoCarteira = await buscaValor('CARTEIRA', ['*'], ['CONTA'], [`${registroEnvio.contaCheque}`]);
    const objeto = {
      bordero: '',
      conta: registroEnvio.contaCheque,
      carteira: infoCarteira.CARTEIRA,
      varcart1: '',
      diasProtesto: infoCarteira.DIASPROTESTO,
      ocorrencia: '',
      txAcresc: infoCarteira.TAXA1,
      txMulta: infoCarteira.TAXA2,
    }
    return objeto;
  }

  $('#btnGravar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      let Envio = await buscaDadosTabela();

      // if (!$('#txtBordero').val()) {
      //   throw msgAlerta('Bordero não pode estar vazio, verifique!');
      // }
      if (Envio.length == 0) {
        throw msgAlerta('Nenhum título selecionado, verifique!');
      }

      let params = await buscaDadosInputs(Envio[0]);

      body = {
        Envio: Envio
      }

      const response = await requisicao('POST', `/sisplan/escenvio/V1/gravaracesso?`, `PARAMS=${JSON.stringify(params)}`, JSON.stringify(body), 90000);

      if (!response) {
        return;
      };

      if (response.status != 200) {
        throw msgAlerta('Não foi possível gravar os títulos selecionados, verifique!')
      };

      const jsonStr = await response.json();

      toastr.success(
        `Borderô número ${jsonStr.mensagem} gravado com sucesso! `,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/escenvio`
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function buscaDadosTabela() {
    const objeto = registrosSelecionados.map((dados) => ({
      sel: dados.SEL,
      numero: dados.NUMERO,
      pedido: dados.PEDIDO,
      cliente: dados.CLIENTE,
      dataEmissao: dados.DATAEMISSAO != '' ? dados.DATAEMISSAO.split('/').reverse().join('-') : '1899-01-01',
      dataVencimento: dados.DATAVENCIMENTO != '' ? dados.DATAVENCIMENTO.split('/').reverse().join('-') : '1899-01-01',
      bordero: dados.BORDERO,
      banco: dados.BANCO,
      dataEnvio: dados.DATAENVIO != '' ? dados.DATAENVIO.split('/').reverse().join('-') : '1899-01-01',
      valorTitulo: dados.VALORTITULO,
      empresa: dados.EMPRESA,
      notaDenegada: dados.NOTADENEGADA,
      fatura: dados.FATURA,
      emissaoBordero: dados.EMISSAOBORDERO != '' ? dados.EMISSAOBORDERO.split('/').reverse().join('-') : '1899-01-01',
      grupoCliente: dados.GRUPOCLIENTE,
      contaCheque: dados.CONTACHEQUE,
      historico: dados.HISTORICO,
      juros: dados.JUROS,
      descontos: dados.DESCONTOS,
      negociado: dados.NEGOCIADO,
      empId: dados.EMPID,
      valorNota: dados.VALORNOTA,
      situacao: dados.SITUACAO,
      numeroBanco: dados.NUMEROBANCO,
    }))
    return objeto;
  };

  function criaCheckBoxSelecionarTodos() {
    $($('#tabelaDados_wrapper div')[1]).append(`
      <div class="icheck-danger d-inline">
          <input type="checkbox" id="cbSelecionarTodos">
          <label for="cbSelecionarTodos">Selecionar Todos</label>
      </div>`
    )

    $('#cbSelecionarTodos').on('change', function () {
      $(this).prop('disabled', true)
      $.LoadingOverlay('show')
      try {
        const dados = $('#tabelaDados').DataTable().rows().data().toArray()
        if ($(this).prop('checked')) {
          if (registrosSelecionados.length < 1) {
            msgErro('Não é possível utilizar essa opção quando não houver um registro selecionado.')
            $(this).prop('checked', false)
            return
          }

          if (registrosSelecionados.length > 1) {
            msgErro('Não é possível utilizar essa opção quando houver mais de um registro selecionado.')
            $(this).prop('checked', false)
            return
          }

          if (registrosSelecionados.length > 0) {
            const { CONTACHEQUE: contaSelecionada } = registrosSelecionados[0]

            for (let i = 0; i < dados.length; i++) {
              if ((dados[i].CONTACHEQUE !== '') && (contaSelecionada === dados[i].CONTACHEQUE && contaSelecionada !== '') && (['', '0'].includes(dados[i].BORDERO))) {
                const row = $($('#tabelaDados').DataTable().row(i).node())
                row.find('.campoSel').prop('checked', true)
                $(row.find('.campoSel').closest('tr')).addClass('selected')
                if (!registrosSelecionados.some(e => e.NUMERO === dados[i].NUMERO)) {
                  registrosSelecionados.push(dados[i])
                }
              }
            }
          }
        } else {
          for (let i = 0; i < dados.length; i++) {
            const row = $($('#tabelaDados').DataTable().row(i).node())
            row.find('.campoSel').prop('checked', false)
            $(row.find('.campoSel').closest('tr')).removeClass('selected')
          }
          registrosSelecionados = []
        }

      } catch (e) {
        msgErro('Não foi possível selecionar todos os registros.')
        console.log(e)
      } finally {
        $.LoadingOverlay('hide')
        $(this).prop('disabled', false)
      }
    })
  }
});
