$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os campos disponíveis de filtro.',
                position: 'right'
            }
        },
        {
            element: '#btnVoltar',
            popover: {
                title: 'Botão Voltar',
                description: 'Clique aqui para voltar à tela de consulta.',
                position: 'right'
            }
        },
        {
            element: '#btnImprimir',
            popover: {
                title: 'Botão Imprimir',
                description: 'Clique aqui para imprimir o relatório.',
                position: 'right'
            }
        },
        {
            element: '#btnLancarMovimento',
            popover: {
                title: 'Botão Lançar Movimento',
                description: 'Clique aqui para abrir o modal de lançamento de movimento.',
                position: 'right'
            }
        },
        {
            element: '#btnLancarExtrato',
            popover: {
                title: 'Botão Lançar Extrato',
                description: 'Clique aqui para abrir a tela de lançamento de extrato.',
                position: 'right'
            }
        },
        {
            element: '#btnConciliar',
            popover: {
                title: 'Botão Conciliar',
                description: 'Clique aqui para ir para conciliar os registros selecionados.',
                position: 'right'
            }
        },
        {
            element: '#btnVoltarConciliacao',
            popover: {
                title: 'Botão Voltar Conciliação',
                description: 'Clique aqui para ir para voltar a conciliação dos registros selecionados.',
                position: 'left'
            }
        },
        {
            element: '#tabelaMovimento_wrapper',
            popover: {
                title: 'Tabela Movimentos',
                description: 'Aqui ficam os registros de movimentos.',
                position: 'top'
            }
        },
        {
            element: '#tabelaConcilia_wrapper',
            popover: {
                title: 'Tabela Extratos',
                description: 'Aqui ficam os registros de extratos.',
                position: 'top'
            }
        }
        ]);
        //inicio tour

        driver.start();

        // inicior tuor
        //final
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CONCILIA");
    const param380 = await buscaParametroERP('FIN', '380', '3', '1') == 'S';
    //autocomplete
    $('#txtConta').autocompleta(1, 'JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');
    $('#txtClasseGer').pesquisa_variosServerside(1, '{ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');

    //btnconsultar
    $('#btn-ContaConsulta').pesquisa_serverside(['#txtConta'], ['CONTA'], ['DESCRICAO'], `{ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": null}`, 'Pesquisa de Conta');
    $('#btn-ClasseGerConsulta').pesquisa_serversideSel('#txtClasseGer', `{ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Classe Gerencial');

    //btnLimpar
    $('#btn-limpa-Conta').on('click', function () {
        $('#txtConta').val('')
        $('#txtBanco').val('')
    })
    $('#btn-limpa-ClasseGer').on('click', function () { $('#txtClasseGer').empty().trigger('change') })

    $('#btnLimparFiltros').click(async function () {
        $('#txtConta').val('')
        $('#txtBanco').val('')
        $('#txtConciliacao').val('')
        $('#txtDocumento').val('')
        $('#txtClasseGer').empty().trigger('change')
        $('#rdConciliarConciliar').prop('checked', true)
        $('#rdTipoTodos').prop('checked', true)
        $('#dtPeriodoDe').val('1200-01-01')
        $('#dtPeriodoAte').val('2500-12-31')
    });

    $('#txtConta').on('blur', async function () {
        $.LoadingOverlay('show')
        try {
            try {
                const pesquisaParam = {
                    tabela: "CADCONTA",
                    camposSelect: [
                        "CADBAN.BANCO",
                        "CADBAN.NOME_BANCO"
                    ],
                    leftJoin: [
                        { tabela: 'CADBAN', condicao: 'CADCONTA.BANCO = CADBAN.BANCO' },
                    ],
                    where: [`CADCONTA.CONTA = '${pegaChave('#txtConta')}'`],
                };

                const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

                if (jsonStr.length > 0) {
                    $('#txtBanco').val(`${jsonStr[0].BANCO} - ${jsonStr[0].NOME_BANCO}`)
                }
            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    });



    async function retornaFiltros() {
        const conciliado = $('#rdConciliarConciliado').is(':checked') ? 0 : $('#rdConciliarConciliar').is(':checked') ? 1 : 2
        const tipo = $('#rdTipoPagamento').is(':checked') ? 0 : $('#rdTipoPagamento').is(':checked') ? 1 : 2
        const filtros =
            `PERIODODE=${$('#dtPeriodoDe').val()}` +
            `&PERIODOATE=${$('#dtPeriodoAte').val()}` +
            `&CONTA=${pegaChave('#txtConta')}` +
            `&BANCO=${pegaChave('#txtBanco')}` +
            `&DOCUMENTO=${$('#txtDocumento').val()}` +
            `&CONCILIACAO=${$('#txtConciliacao').val()}` +
            `&CLASSE=${await formataListas($('#txtClasseGer').val().toString())}` +
            `&CONCILIADO=${conciliado}` +
            `&TIPO=${tipo}`;
        return filtros;
    }

    // retornaHintRelatorio('btnImprimir', 'RelAcessoConcilia')

    // $('#btnImprimir').on('click', async function () {
    //     try {
    //         $.LoadingOverlay('show');
    //         try {
    //             const url = `/sisplan/concilia/v1/imprimiracesso?`;
    //             const filtros = await retornaFiltros();
    //             const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoConcilia');
    //             const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 100000, false, 'RelAcessoConcilia');
    //             if (arquivo != undefined) {
    //                 if (!bImprimeAutomatico) {
    //                     window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
    //                 }
    //                 await limparRelatorios();
    //             }

    //         } catch (error) {
    //             console.error(error);
    //         }
    //     } finally {
    //         $.LoadingOverlay('hide');
    //     }
    // });

    async function saldoIniMov(tipo) {
        const url = '/sisplan/concilia/v1/consultasaldoini?';
        const filtros = await retornaFiltros();
        try {
            $.LoadingOverlay("Show");
            try {
                let jsonStr;
                let valor = 0;
                if (tipo != 'ext') {
                    const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}&TIPO=${tipo == 'ini' ? '' : tipo == 'mov' ? 'M' : 'R'}`, "", 360000);

                    if (!response) {
                        return;
                    }

                    jsonStr = await response.json()
                    if (response.status != 200) {
                        msgErro(jsonStr['RESULT'][0].mensagem);
                        return;
                    }
                    valor = jsonStr;
                } else {
                    const pesquisaParam = {
                        tabela: "EXTRATO",
                        camposSelect: [
                            "SUM(EXTRATO.VALOR) AS VALOR",
                            "EXTRATO.OPERACAO"
                        ],
                        where: [`EXTRATO.DT_CONT <= '${$('#dtPeriodoAte').val()}' ` +
                            `AND EXTRATO.CONCILIADO = 'S' ` +
                            `AND EXTRATO.CONTA = '${pegaChave('#txtConta')}'`],
                        groupby: ["EXTRATO.OPERACAO"],
                    };

                    jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

                    for (let i = 0; i < jsonStr.length; i++) {
                        if (jsonStr[i].OPERACAO == 'D') {
                            valor = parseFloat(valor) - parseFloat(jsonStr[i].VALOR)
                        } else[
                            valor = parseFloat(valor) + parseFloat(jsonStr[i].VALOR)
                        ]
                    }
                }

                return valor;
            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os dados.');
            }
        } finally {
            $.LoadingOverlay("Hide");
        }
    }

    async function calculaTotais() {
        try {
            $('#txtTotal').val(0)
            $('#txtTotalSelecionado').val(0)
            $('#txtSaldoIni').val(0)
            $('#txtTotalCred').val(0)
            $('#txtTotalDeb').val(0)
            $('#txtSaldoMovimento').val(0)
            $('#txtTotalMovimentos').val(0)
            $('#txtSaldoExtrato').val(0)
            $('#txtTotalExtrato').val(0)
            $('#txtSaldoSelecionado').val(0)
            $('#txtSaldoReal').val(0)

            let totalExtrato = 0;
            let totalMov = 0;
            let totalSelConc = 0;
            let totalConc = 0;
            let totalDeb = 0;
            let totalCred = 0;
            let saldoSel = 0;
            let saldoReal = 0;
            let saldoMov = await saldoIniMov('mov');
            let saldoIni = await saldoIniMov('ini');
            let saldoExt = await saldoIniMov('ext');
        

            $('#tabelaConcilia').DataTable().rows().every(function () {
                let item = this.data();

                if (item.CONCILIAR == 'S') {
                    if (item.OPERACAO == 'D') {
                        totalExtrato = parseFloat(totalExtrato) - parseFloat(item.VALOR)
                    } else {
                        totalExtrato = parseFloat(totalExtrato) + parseFloat(item.VALOR)
                    }
                }
            })

            $('#tabelaMovimento').DataTable().rows().every(function () {
                let item = this.data();

                if (item.CONCILIAR == 'S') {
                    if (item.OPERACAO == 'D') {
                        totalMov = parseFloat(totalMov) - parseFloat(item.VALOR)
                        totalSelConc = parseFloat(totalSelConc) - parseFloat(item.VALOR)
                        saldoIni = parseFloat(saldoIni) - parseFloat(item.VALOR)
                    } else {
                        totalMov = parseFloat(totalMov) + parseFloat(item.VALOR)
                        totalSelConc = parseFloat(totalSelConc) + parseFloat(item.VALOR)
                        saldoIni = parseFloat(saldoIni) + parseFloat(item.VALOR)
                    }
                }

                if ((item.OPERACAO == 'D') && (param380)) {
                    totalConc = parseFloat(totalConc) - parseFloat(item.VALOR)
                } else {
                    totalConc = parseFloat(totalConc) + parseFloat(item.VALOR)
                }

                if (item.OPERACAO == 'D') {
                    totalDeb = parseFloat(totalDeb) + parseFloat(item.VALOR)
                } else {
                    totalCred = parseFloat(totalCred) + parseFloat(item.VALOR)
                }

            })

            if (totalExtrato > 0) {
                if (totalSelConc >= 0) {
                    saldoSel = parseFloat(totalSelConc) - parseFloat(totalExtrato)
                } else {
                    saldoSel = parseFloat(totalSelConc) + parseFloat(totalExtrato)
                }
            } else {
                if (totalSelConc >= 0) {
                    saldoSel = parseFloat(totalSelConc) + parseFloat(totalExtrato)
                } else {

                    saldoSel = parseFloat(totalSelConc) + (parseFloat(totalExtrato) * -1)
                }
            }

            if (param380) {
                saldoReal = parseFloat(saldoMov) + parseFloat(totalConc)
            } else {
                saldoReal = parseFloat(saldoMov) - parseFloat(totalConc)
            }

            if (await buscaParametroERP('FIN', '380', '6', '1') == 'S') {
                saldoReal = await saldoIniMov('real')
                saldoReal = parseFloat(saldoReal)
            }

            $('#txtTotalExtrato').val(formatarNumero(totalExtrato))
            $('#txtSaldoIni').val(formatarNumero(saldoIni))
            $('#txtTotalMovimentos').val(formatarNumero(totalMov))
            $('#txtTotalSelecionado').val(formatarNumero(totalSelConc))
            $('#txtTotal').val(formatarNumero(totalConc))
            $('#txtTotalCred').val(formatarNumero(totalCred))
            $('#txtTotalDeb').val(formatarNumero(totalDeb))
            $('#txtSaldoSelecionado').val(formatarNumero(saldoSel))
            $('#txtSaldoReal').val(formatarNumero(saldoReal))
            $('#txtSaldoMovimento').val(formatarNumero(saldoMov))
            $('#txtSaldoExtrato').val(formatarNumero(saldoExt))
        } catch (error) {
            console.error(error)
        }
    }

    function formatarNumero(numero) {
        return numero.toFixed(2).replace('.', ',').replace(/\d(?=(\d{3})+,)/g, '$&.');
    }

    async function buscaRegistrosMovimento() {
        const url = "/sisplan/concilia/v1/consultamovto?";
        const filtros = await retornaFiltros();
        try {
            $.LoadingOverlay("Show");
            try {
                const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}`, "", 360000);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json()
                if (response.status != 200) {
                    msgErro(jsonStr['RESULT'][0].mensagem);
                    return;
                }

                return jsonStr;
            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os dados.');
            }
        } finally {
            $.LoadingOverlay("Hide");
        }
    }

    async function criaDataTableMovto() {
        if ($.fn.DataTable.isDataTable('#tabelaMovimento')) {
            $('#tabelaMovimento').DataTable().destroy();
            $('#tabelaMovimento').empty();
        }
        try {
            $.LoadingOverlay('show')
            const jsonStr = await buscaRegistrosMovimento();

            if (jsonStr.length <= 0) {
                msgAlerta('Nenhum registro encontrado!')
                $('#divTotais').addClass('d-none')
                $('#divSaldos').addClass('d-none')
                return;
            }

            const dataCols = []


            const keys = Object.keys(jsonStr[0]);

            keys.forEach((k) => {
                dataCols.push({
                    title: k,
                    data: k,
                });
            });

            dataCols[0].render = function (data, type, row, meta) {
                return '<div class="form-check">' +
                    '<div class="icheck-primary">' +
                    `<input style="height:20px" type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="align-self-center campoCheck"><label for="check_col_${meta.row}_row_${meta.col}"></label>` +
                    '</div>' +
                    '</div>';
            }

            $("#tabelaMovimento").DataTable({
                destroy: true,
                sort: true,
                colReorder: true,
                order: [],
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    language: {
                        decimal: ",",
                        thousands: ".",
                    },
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                autoWidth: true,
                data: jsonStr,
                columns: dataCols,
                columnDefs: [
                    {
                        type: "date-br",
                        render(data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        },
                        targets: [4, 5, 6]
                    },
                    {
                        render(data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                minimumFractionDigits: 2,
                            });
                        },
                        targets: [9, 14, 15, 16],
                        "className": 'pr-4 text-right'
                    },
                ]
            });

            $('#tabelaMovimento').on('click', '.campoCheck', async function () {
                const row = parseInt(this.id.split('col_')[1].split('_row')[0])
                if (this.checked) {
                    $('#tabelaMovimento').DataTable().rows(row).data()[0].CONCILIAR = 'S'
                    $(this).parents('tr').addClass('selected')
                } else {
                    $('#tabelaMovimento').DataTable().rows(row).data()[0].CONCILIAR = 'N'
                    $('#tabelaMovimento').DataTable().$('tr.selected').removeClass('selected');
                }
                await calculaTotais();
            });

            $('#tabelaMovimento tbody').on('click', 'tr', function () {
                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                } else {
                    $('#tabelaMovimento').DataTable().$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function buscaRegistrosConcilia() {
        const url = "/sisplan/concilia/v1/consultaconcilia?";
        const filtros = await retornaFiltros();
        try {
            const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}`, "", 360000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem);
                return;
            }

            return jsonStr;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados.');
        }
    }

    async function criaDataTableConcilia() {
        if ($.fn.DataTable.isDataTable('#tabelaConcilia')) {
            $('#tabelaConcilia').DataTable().destroy();
            $('#tabelaConcilia').empty();
        }
        $.LoadingOverlay("Show");
        try {
            const jsonStr = await buscaRegistrosConcilia();

            if (jsonStr.length <= 0) {
                msgAlerta('Nenhum registro de extrato encontrado!')
                $('#divTotais').addClass('d-none')
                $('#divSaldos').addClass('d-none')
                return;
            }

            $('#divTotais').removeClass('d-none')
            $('#divSaldos').removeClass('d-none')

            const dataCols = []

            const keys = Object.keys(jsonStr[0]);

            keys.forEach((k) => {
                dataCols.push({
                    title: k,
                    data: k,
                });
            });

            dataCols[0].render = function (data, type, row, meta) {
                return '<div class="form-check">' +
                    '<div class="icheck-primary">' +
                    `<input style="height:20px" type="checkbox" id="check_col_${meta.row}_row_${meta.col}_table_concilia" class="align-self-center campoCheck"><label for="check_col_${meta.row}_row_${meta.col}_table_concilia"></label>` +
                    '</div>' +
                    '</div>';
            }

            $("#tabelaConcilia").DataTable({
                destroy: true,
                sort: true,
                paging: true,
                filter: false,
                info: true,
                pageLength: 5,
                lengthMenu: [ [5, 10, 25, 50, 100], [5, 10, 25, 50, 100] ],
                order: false,
                destroy: true,
                colReorder: {
                    fixedColumnsLeft: 2
                },
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    language: {
                        decimal: ",",
                        thousands: ".",
                    },
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                autoWidth: true,
                data: jsonStr,
                columns: dataCols,
                columnDefs: [
                    {
                        type: "date-br",
                        render(data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        },
                        targets: [5]
                    },
                    {
                        render(data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                minimumFractionDigits: 2,
                            });
                        },
                        targets: [4],
                        "className": 'pr-4 text-right'
                    },
                ]
            });

            $('#tabelaConcilia').on('click', '.campoCheck', async function () {
                const row = parseInt(this.id.split('col_')[1].split('_row')[0])
                if (this.checked) {
                    $('#tabelaConcilia').DataTable().rows(row).data()[0].CONCILIAR = 'S'
                    $(this).parents('tr').addClass('selected')
                } else {
                    $('#tabelaConcilia').DataTable().rows(row).data()[0].CONCILIAR = 'N'
                    $('#tabelaConcilia').DataTable().$('tr.selected').removeClass('selected');
                }

                await calculaTotais();
            });

            $("#tabelaConcilia_length").parent().append(`<div class="col-sm-12 icheck-primary d-inline">` +
                `<input class="form-check-input" type="checkbox" id="checkSelecionarTodos">` +
                `<label class="form-check-label" for="checkSelecionarTodos">Selecionar Todos</label>` +
                `</div>`);


            $('#checkSelecionarTodos').on('change', async function () {
                async function callBack() {
                    $.LoadingOverlay("show");
                    try {
                        $("#tabelaConcilia").DataTable().page.len(200).draw(false);
                        $($(".page-link")[1]).trigger("click");
                        await sleep(700);
                        const totalPaginas = $("#tabelaConcilia").DataTable().page.info().pages;

                        for (let i = 1; i <= totalPaginas; i++) {
                            $('input[class=campoCheck]:checked').trigger('click');
                            if ($("#checkSelecionarTodos").prop("checked")) {
                                $(".campoCheck").trigger("click");
                            }
                            $("#tabelaConcilia_next").trigger("click");
                            await sleep(700);
                            if (totalPaginas == i) {
                                $($(".page-link")[1]).trigger("click");
                                $("#tabelaConcilia").DataTable().page.len(5).draw(false);
                            }
                        };
                    } finally {
                        $.LoadingOverlay("hide");
                    }
                }

                msgAlerta(`Tem certeza que deseja ${!$("#checkSelecionarTodos").prop("checked") ? "desconsiderar" : "selecionar"} todos os registros? \nEssa ação percorrerá todas as páginas da tabela e resultará na seleção completa dos registros.`,
                    callBack,
                    () => { $("#checkSelecionarTodos").prop("checked", !$("#checkSelecionarTodos").prop("checked")); },
                    undefined,
                    () => { $("#checkSelecionarTodos").prop("checked", !$("#checkSelecionarTodos").prop("checked")); },
                    true);
            });


            $('#tabelaConcilia tbody').on('click', 'tr', function () {
                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                } else {
                    $('#tabelaConcilia').DataTable().$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

            await calculaTotais()
        } finally {
            $.LoadingOverlay("Hide");
        }
    }

    $('#btnVoltar').on('click', function () {
        window.location.href = `${BASE_URI}/concilia`;
    })

    $('#btnConsultar').on('click', async function () {
        if ($('#txtConta').val() == '') {
            msgAlerta('Selecione uma conta');
            return;
        }
        $.LoadingOverlay("Show");
        try {
            try {
                $('#divTotais').removeClass('d-none')
                $('#divSaldos').removeClass('d-none')
                await criaDataTableMovto();
                await criaDataTableConcilia();

                if ($('#rdConciliarConciliado').is(':checked')) {
                    $('#btnVoltarConciliacao').prop('disabled', false)
                    $('#btnConciliar').prop('disabled', true)
                } else if ($('#rdConciliarConciliar').is(':checked')) {
                    $('#btnVoltarConciliacao').prop('disabled', true)
                    $('#btnConciliar').prop('disabled', false)
                } else {
                    $('#btnVoltarConciliacao').prop('disabled', true)
                    $('#btnConciliar').prop('disabled', true)
                }
            } catch (error) {
                console.error(error);
                msgErro("Erro ao buscar os dados");
            }
        } finally {
            $("#modal-filtros").modal("hide");
            $.LoadingOverlay("hide");
        }
    });

    $('#btnLancarExtrato').on('click', async function () {
        localStorage.setItem('lancarExtrato', true);

        parent.document.querySelector('#menu_extrato .nav-link').click();
    })

    $('#btnVoltarConciliacao').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            const data = $('#tabelaMovimento tr.selected')
            if (data.length > 0) {
                const selectedRow = $("#tabelaMovimento ").DataTable().row(data).data();
                msgAlerta('Tem certeza que deseja voltar conciliação?', async () => {
                    await rotinaVoltaDup(selectedRow.LANC_CON, selectedRow.LANCAMENTO)
                })
            } else {
                msgAlerta('Nenhum registro selcionado!')
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    async function rotinaVoltaDup(lancCon, lancamento) {
        $.LoadingOverlay('show')
        try {
            try {
                if (!(await validaFechamentoPeriodo())) {
                    msgAlerta('Não é possível estornar conta corrente para esta data. Período de apuração já está fechado.');
                    return;
                }

                const response = await requisicao("POST", "/sisplan/concilia/v1/voltaconciliacao?", `LANC_CON=${encodeURIComponent(lancCon)}&LANCAMENTO=${encodeURIComponent(lancamento)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success(`Conciliação estornada com sucesso!`, "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/concilia/create`;
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    function pegaDataAtual() {
        const dataAtual = new Date();
        const ano = dataAtual.getFullYear();
        const mes = (dataAtual.getMonth() + 1).toString().padStart(2, '0');
        const dia = dataAtual.getDate().toString().padStart(2, '0');
        return `${ano}-${mes}-${dia}`;
    }

    async function validaFechamentoPeriodo() {
        try {
            const dataFormatada = pegaDataAtual()

            const pesquisaParam = {
                tabela: "FECHA_APUR",
                camposSelect: [
                    "ID"
                ],
                where: [`DT_CONTACOR >= '${dataFormatada}' AND EMP_ID = '${getCookie('emp_id')}'`],
            };

            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

            if (jsonStr.length <= 0) {
                return true
            }
            return false
        } catch (error) {
            console.error(error)
        }
    }

    $('#btnLancarMovimento').on('click', function () {
        $.LoadingOverlay('show')
        try {
            $('#modal-movimento').modal('show')
            $('#txtContaMovimento').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO DESCRICAO" ], "where": ["ATIVO = 'S'"]}`);
            $('#txtMoedaMovimento').autocompleta(1, 'JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');

            //btnconsultar
            $('#btn-ContaMovimentoConsulta').pesquisa_serverside(['#txtContaMovimento'], ['CONTA'], ['DESCRICAO'], `{ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": ["ATIVO = 'S'"]}`, 'Pesquisa de Conta');
            $('#btn-MoedaMovimentoConsulta').pesquisa_serverside(['#txtMoedaMovimento'], ['CODMOE'], ['DESCRICAO'], `{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}`, 'Pesquisa de Moeda');

            //btnLimpar
            $('#btn-limpa-ContaMovimento').on('click', function () { $('#txtContaMovimento').val('') })
            $('#btn-limpa-MovimentoConsulta').on('click', function () { $('#txtMoedaMovimento').val('') })

            $('#dtLancamentoMovimento').val(pegaDataAtual())
            $('#dtContMovimento').val(pegaDataAtual())

            $('#txtDoctoMovimento').focus()
            criaDataTableCadMovimento()
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#txtDoctoMovimento').on('blur', async function () {
        $.LoadingOverlay('show')
        try {
            if ($('#txtDoctoMovimento').val() == '') {
                const docto = await RetornaProximo('DOCTO', 'CONTACOR', 'DOCTO', 6)
                $('#txtDoctoMovimento').val(docto)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $("#btnIncluirCadMovimento").click(function () {
        $.LoadingOverlay('show')
        try {
            $("#containerCadMovimento").removeClass("d-none", function () {
                $("#containerCadMovimento").slideDown(250);
                $("#btnIncluirCadMovimento").addClass('d-none')
                $("#btnConfirmarCadMovimento").removeClass('d-none')
                $("#btnDesistirCadMovimento").removeClass('d-none')
            });
            $('#txtValorCadMovimento').maskMoney({
                decimal: '.',
                thousands: '',
                precision: 2
            });

            $('#txtClasseCadMovimento').autocompleta(1, 'JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');
            $('#txtHistoricoCadMovimento').autocompleta(1, 'JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');

            //btnconsultar
            $('#btn-ClasseCadMovimento').pesquisa_serverside(['#txtClasseCadMovimento'], ['CODIGO'], ['DESCRICAO'], `{ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Classe Gerencial');
            $('#btn-HistoricoCadMovimento').pesquisa_serverside(['#txtHistoricoCadMovimento'], ['HISTORICO'], ['DESCRICAO'], `{ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Histórico');

            //btnLimpar
            $('#btn-limpa-ClasseCadMovimento').on('click', function () { $('#txtClasseCadMovimento').val('') })
            $('#btn-limpa-HistoricoCadMovimento').on('click', function () { $('#txtHistoricoCadMovimento').val('') })
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    function limpaCamposCadMovimento() {
        $('#txtOperacaoCadMovimento').val('')
        $('#txtClasseCadMovimento').val('')
        $('#txtHistoricoCadMovimento').val('')
        $('#txtValorCadMovimento').val('')
        $('#txtObsCadMovimento').val('')
    }

    $("#btnDesistirCadMovimento").click(function () {
        $.LoadingOverlay('show')
        try {
            $("#containerCadMovimento").addClass("d-none");
            $("#btnIncluirCadMovimento").removeClass('d-none')
            $("#btnConfirmarCadMovimento").addClass('d-none')
            $("#btnDesistirCadMovimento").addClass('d-none')

            limpaCamposCadMovimento()
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    $("#btnConfirmarCadMovimento").click(function () {
        $.LoadingOverlay('show')
        try {
            if ($('#txtOperacaoCadMovimento').val() == null) {
                msgAlerta('Operação não informada!');
                return;
            }
            if ($('#txtClasseCadMovimento').val() == '') {
                msgAlerta('Classe não informada!');
                return;
            }
            if ($('#txtHistoricoCadMovimento').val() == '') {
                msgAlerta('Histórico não informado!');
                return;
            }
            if (($('#txtValorCadMovimento').val() == '') || ($('#txtValorCadMovimento').val() <= 0)) {
                msgAlerta('Valor não informado!');
                return;
            }

            insereValorCadMovimento()
            $("#containerCadMovimento").addClass("d-none");
            $("#btnIncluirCadMovimento").removeClass('d-none')
            $("#btnConfirmarCadMovimento").addClass('d-none')
            $("#btnDesistirCadMovimento").addClass('d-none')

            limpaCamposCadMovimento()
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    function criaDataTableCadMovimento() {
        if ($.fn.DataTable.isDataTable('#tabelaCadMovimento')) {
            $("#tabelaCadMovimento").DataTable().destroy();
            $("#tabelaCadMovimento").empty();
        };

        const dataSetCols = [];

        dataSetCols.push({
            'title': 'Operação',
        })
        dataSetCols.push({
            'title': 'Classe',
        })
        dataSetCols.push({
            'title': 'Desc. Classe',
        })
        dataSetCols.push({
            'title': 'Valor',
        })
        dataSetCols.push({
            'title': 'Histórico',
        })
        dataSetCols.push({
            'title': 'Desc. Histórico',
        })
        dataSetCols.push({
            'title': 'Observação',
        })

        $('#tabelaCadMovimento').DataTable({
            bPaginate: false,
            order: false,
            sort: false,
            searching: false,
            destroy: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            columns: dataSetCols,
        });

        $('#tabelaCadMovimento tbody').on('click', 'tr', async function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                $('#tabelaCadMovimento').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }
        });
    }

    async function insereValorCadMovimento() {
        $.LoadingOverlay('show')
        try {
            try {
                const novoRegistro = []

                const operacao = $('#txtOperacaoCadMovimento').val()
                const classe = pegaChave('#txtClasseCadMovimento')
                const descClasse = pegaDescricao('#txtClasseCadMovimento')
                const valor = $('#txtValorCadMovimento').val()
                const historico = pegaChave('#txtHistoricoCadMovimento')
                const descHistorico = pegaDescricao('#txtHistoricoCadMovimento')
                const observacao = $('#txtObsCadMovimento').val()

                novoRegistro.push(operacao)
                novoRegistro.push(classe)
                novoRegistro.push(descClasse)
                novoRegistro.push(valor)
                novoRegistro.push(historico)
                novoRegistro.push(descHistorico)
                novoRegistro.push(observacao)

                $('#tabelaCadMovimento').DataTable().row.add(novoRegistro).draw(false);
            } catch {
                console.log(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnExcluirMovimento').on('click', function () {
        const tabela = $("#tabelaCadMovimento").DataTable()
        const linha = tabela.$("tr.selected");
        if (linha.length > 0) {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                $.LoadingOverlay('show')
                try {
                    tabela.row(linha).remove().draw();
                } finally {
                    $.LoadingOverlay('hide')
                }
            });
        } else {
            msgAlerta('Nenhum registro selecionado para excluir!')
        }
    })

    $('#btnConfirmarMovimento').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            if ($('#txtDoctoMovimento').val() == '') {
                msgAlerta('Documento inválido');
                return;
            }

            if ($('#txtContaMovimento').val() == '') {
                msgAlerta('Conta não informada');
                return;
            }

            if ($('#txtMoedaMovimento').val() == '') {
                msgAlerta('Moeda não informada');
                return;
            }

            const movimentoClasse = montaClasseMovimento();

            await gravaMovimento(movimentoClasse)

        } finally {
            $.LoadingOverlay('hide')
        }
    })

    function montaClasseMovimento() {
        const classe = {}

        classe.DOCTO = $('#txtDoctoMovimento').val()
        classe.CONTA = pegaChave('#txtContaMovimento')
        classe.MOEDA = pegaChave('#txtMoedaMovimento')
        classe.DTLANCAMENTO = $('#dtLancamentoMovimento').val()
        classe.DTCONTABILIZACAO = $('#dtContMovimento').val()
        classe.ARQUIVO = montaArrayArq()

        return classe
    }

    function montaArrayArq() {
        const arrayArq = []
        let novaRow = {}
        const tabela = $('#tabelaCadMovimento').DataTable().data().toArray()
        for (let i = 0; i < tabela.length; i++) {
            novaRow = {}
            novaRow.OPERACAO = tabela[i][0];
            novaRow.CLASSE = tabela[i][1]
            novaRow.VALOR = tabela[i][3];
            novaRow.HISTORICO = tabela[i][4];
            novaRow.OBS = tabela[i][6];

            arrayArq.push(novaRow)
        }

        return arrayArq
    }

    async function gravaMovimento(classe) {
        $.LoadingOverlay("show");
        try {
            try {
                let response = await requisicao(
                    "POST",
                    "/sisplan/concilia/v1/gravamovimento?",
                    `JSON=${encodeURIComponent(JSON.stringify(classe))}`,
                    null
                );

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr
                    .success(
                        `Cadastro de movimento efetuado com sucesso!`,
                        "Confirmação",
                        {
                            toastClass: "alert",
                            iconClasses: {
                                error: "alert-error",
                                info: "alert-info",
                                success: "alert-success",
                                warning: "alert-warning",
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 5000,
                            fadeOut: 3000,
                            onHidden() {
                                $('#modal-movimento').modal('hide')
                                limpaCamposCadMovimento()
                                $('#txtConta').val() != '' ? $('#btnConsultar').trigger('click') : '';
                            },
                        }
                    )
                    .css({
                        "margin-top": "20%",
                        width: "500px",
                        "max-width": "500px",
                    });

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível gravar os dados da prospecção: ${error}`);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    async function fazerConsultaNovamente() {
        let fazerConsulta = false
        const listaDocto = []
        const listaLanto = []
        $('#tabelaConcilia').DataTable().rows().every(function () {
            let item = this.data();
            if (item.CONCILIAR == 'S') {
                listaDocto.push(item.DOCTO)
                listaLanto.push(item.LANCTO)
            }
        })

        const pesquisaParam = {
            tabela: "EXTRATO",
            camposSelect: [
                "LANC_CON"
            ],
            where: [`LANCTO IN (${await formataListas(listaLanto.toString())}) AND ` +
                `DOCTO IN (${await formataListas(listaDocto.toString())}) AND ` +
                `CONTA = '${pegaChave('#txtConta')}'`],
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        for (let i = 0; i < jsonStr.length; i++) {
            if (parseInt(jsonStr[i].LANC_CON) > 0) {
                fazerConsulta = true
            }
        }

        return fazerConsulta
    }

    $('#btnConciliar').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            try {
                let hasChecked = false;
                if ((($('#txtTotalExtrato').val() != $('#txtTotalMovimentos').val())) ||
                    ((Math.abs(parseFloat($('#txtTotalExtrato').val().replaceAll('.', '').replace(',', '.'))) != Math.abs(parseFloat($('#txtTotalMovimentos').val().replaceAll('.', '').replace(',', '.')))))) {
                    msgAlerta('Valores diferentes no Extrato. Impossível conciliar!');
                    return;
                }

                $('#tabelaMovimento').DataTable().rows().every(function () {
                    let item = this.data();

                    if (item.CONCILIAR == 'S') {
                        hasChecked = true
                    }
                })

                if (!hasChecked) {
                    msgAlerta('Nenhnum registro do movimento foi selecionado. Impossível conciliar!');
                    return;
                }

                if (!(await validaFechamentoPeriodo())) {
                    msgAlerta('Não é possível incluir conta corrente para esta data. Período de apuração já está fechado.');
                    return;
                }

                const consultarNovamente = await fazerConsultaNovamente()

                if (consultarNovamente) {
                    msgAlerta('O Registro Selecionado ja está conciliado. Favor Consultar novamente para Atualizar as Informações!');
                    return;
                }

                const conciliaClasse = montaClasseConcilia()

                await fazConciliacao(conciliaClasse)

            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    function montaClasseConcilia() {
        const classe = {}

        classe.CONTA = pegaChave('#txtConta')
        classe.MOVTO = montaArrayMovto()
        classe.EXTRATO = montaArrayExtrato()

        return classe
    }

    function montaArrayMovto() {
        const arrayMovto = []
        let novaRow = {}
        const tabela = $('#tabelaMovimento').DataTable().data().toArray()
        for (let i = 0; i < tabela.length; i++) {
            if (tabela[i].CONCILIAR == 'S') {
                novaRow = {}
                novaRow.OPERACAO = tabela[i].OPERACAO;
                novaRow.LANCAMENTO = tabela[i].LANCAMENTO;
                novaRow.DOCTO = tabela[i].DOCTO;
                novaRow.DTLAN = tabela[i].DT_LAN;
                novaRow.DTCONT = tabela[i].DT_CONT;
                novaRow.DTVENCTO = tabela[i].DT_VENCTO;
                novaRow.GRUPO = tabela[i].GRUPO;
                novaRow.VALOR = tabela[i].VALOR;
                novaRow.HISTORICO = tabela[i].HISTORICO;
                novaRow.OBSERVACAO = tabela[i].OBSERVACAO;
                novaRow.LANCCON = tabela[i].LANC_CON;
                novaRow.VALORBRUTO = tabela[i].VALORBRUTO;
                novaRow.VALORBRUTOCC = tabela[i].VALORBRUTO_CC;
                novaRow.VALORORIG = tabela[i].VALOR_ORIG;
                novaRow.CODCLI = tabela[i].CODCLI;
                novaRow.ORDEM = tabela[i].ORDEM;

                arrayMovto.push(novaRow)
            }
        }

        return arrayMovto
    }

    function montaArrayExtrato() {
        const arrayExtrato = []
        let novaRow = {}
        const tabela = $('#tabelaConcilia').DataTable().data().toArray()
        for (let i = 0; i < tabela.length; i++) {
            if (tabela[i].CONCILIAR == 'S') {
                novaRow = {}
                novaRow.OPERACAO = tabela[i].OPERACAO;
                novaRow.LANCTO = tabela[i].LANCTO;
                novaRow.DOCTO = tabela[i].DOCTO;
                novaRow.VALOR = tabela[i].VALOR;
                novaRow.DTCONT = tabela[i].DT_CONT;
                novaRow.OBSERVACAO = tabela[i].OBSERVACAO;
                novaRow.LANCCON = tabela[i].LANC_CON;

                arrayExtrato.push(novaRow)
            }
        }

        return arrayExtrato
    }

    async function fazConciliacao(classe) {
        $.LoadingOverlay('show')
        try {
            try {
                let response = await requisicao(
                    "POST",
                    "/sisplan/concilia/v1/concilia?",
                    `JSON=${encodeURIComponent(JSON.stringify(classe))}`,
                    null
                );

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr
                    .success(
                        `Conciliação efetuada com sucesso!`,
                        "Confirmação",
                        {
                            toastClass: "alert",
                            iconClasses: {
                                error: "alert-error",
                                info: "alert-info",
                                success: "alert-success",
                                warning: "alert-warning",
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 5000,
                            fadeOut: 3000,
                            onHidden() {
                                window.location.href = `${BASE_URI}/concilia/create`;
                            },
                        }
                    )
                    .css({
                        "margin-top": "20%",
                        width: "500px",
                        "max-width": "500px",
                    });
            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    };
}); 