$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false,
        animate: true,
        onNext: (Element) => {
            if ((Element.node.id == 'avancar1')) {
                $('#avancar1').trigger('click');
            };
        },
        onPrevious: (Element) => {
            if (Element.node.id == 'checkTour') {
                $('#voltar4').trigger('click');
            };
        }
    });
    driver.defineSteps([
      {
        element: "#formcard1",
        popover: {
          title: "Dados Gerais",
          description:
            "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Código do Banco",
          description:
            "Adicionamos aqui o código do banco.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Nome do Banco",
          description:
            "Aqui adicionamos o nome do banco",
          position: "top",
        },
      },
      {
        element: "#avancar1",
        popover: {
          title: "Borão Avançar",
          description: "Clique aqui para ir para a próxima aba.",
          position: "left",
        },
      },
      {
        element: "#contas",
        popover: {
          title: "Configurações do Bordero",
          description: "Aqui temos algumas informações do bordero para preencher.",
          position: "left",
        },
      },
      {
        element: "#gravar",
        popover: {
          title: "Botão Gravar",
          description: "Clicamos aqui para gravar o registro.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#txtValDespesa').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtDesconto').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtValContrato').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtCliente').autocompleta(1, `JSON={ "tabela": "entidade", "camposSelect":[ "CODCLI chave", "NOME descricao"], "where": null}`);

  $("#btn-cliente").pesquisa_serverside(
    ["#txtCliente"],
    ["CODCLI", "CNPJ"],
    ["NOME", "CNPJ"],
    '{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": null}',
    "Pesquisa Cliente"
  );

  $("#btn-limpa-cliente").on("click", function () {
    $("#txtCliente").val("");
  });

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("CADBANCO", getCookie("usuario"), banco);
    window.location.href = `${BASE_URI}/cadbanco`;
  });

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let banco = parametros[parametros.length - 1];

  $('#msform').validate({
    debug: false,
    ignore: "",
    messages: {
      rgExtrato: {
        max: "Deve ser menor que 10"
      },
      rgExtrato: {
        min: "Deve ser maior que 0"
      },
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element, errorClass, validClass) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element, errorClass, validClass) {
      $(element).removeClass('is-invalid');
    }
  });

  $('#txtCodigo').on('blur', async function () {
    if (banco === 'create') {
      const banco = $('#txtCodigo').val();
      let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"cadban",
                "camposSelect":["banco"], 
                "where": ["banco = '${banco}'"]}`, null);

      let json = await response.json();
      if (json.RESULT[0].length > 0) {
        msgAlerta('Código já existe. Favor verifique!');
        return;
      }
    }
  });

  if (banco != "" && banco != "create") {
    if ((await liberarRegistro("CADBANCO", banco)) == false) {
      window.location.href = "../cadbanco";
    } else {
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"cadban", 
            "camposSelect":["banco", "nome_banco", "entrada", "layout", "layout_pag", "local", "nome_arq",  "ult_linha_ext", "dir_env_pagto",
            "dir_ret_pagto", "padrao", "seguimento_q", "seguimento_r", "entrada_lido", "val_contrato", "linha_ext", "soma_tarifa", 
                    "cod_compl_pagfor", "pag_for_31", "pag_for_03", "pag_for_08", "linha_retpag", "seg_retpag", "codcli", "val_despesa", 
                    "perc_desc", "cod_importado", "integra_envio"], "where": ["banco = '${banco}'"]}`,
            null
          );

          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgAlerta(jsonStr.RESULT[0].mensagem);
            return;
          }

          async function buscaCliente(codcli) {
            const url = '/Sisplan/Funcoes/v1/pesquisa?';
            try {


              const response = await requisicao('GET', url, `JSON={ "tabela":"ENTIDADE",
              "camposSelect":["CODCLI", "NOME"],
              "where": ["CODCLI = '${codcli}' "]}`);

              if (!response) {
                return;
              }

              let jsonStr = await response.json();
              if (response.status != 200) {
                msgAlerta(jsonStr.mensagem);
                return;
              }
              // $('#txtCliente').val(`[${jsonStr.RESULT[0][0].CODCOND}] - ${jsonStr.RESULT[0][0].DESCRICAO}`);
              const concatenado = { codigo: jsonStr.RESULT[0][0].CODCLI, nome: jsonStr.RESULT[0][0].NOME };
              return concatenado;

            } catch (error) {
              console.error(error);
              msgAlerta('Erro ao buscar dados do banco');
            }
          }

          let concatenado = jsonStr.RESULT[0][0].CODCLI
          if (concatenado != '') {
            concatenado = await buscaCliente(jsonStr.RESULT[0][0].CODCLI);
          }


          insereValor('#txtCliente', concatenado.codigo, concatenado.nome)
          $("#txtCodigo").val(jsonStr.RESULT[0][0].BANCO);
          $("#txtDescricao").val(jsonStr.RESULT[0][0].NOME_BANCO);
          $("#txtArqEnvio").val(jsonStr.RESULT[0][0].LOCAL);
          $("#txtArquivoLayout").val(jsonStr.RESULT[0][0].LAYOUT);
          $("#txtArqRetorno").val(jsonStr.RESULT[0][0].ENTRADA);
          $("#txtNomeArquivo").val(jsonStr.RESULT[0][0].NOME_ARQ);
          $("#txtArqRetornoLido").val(jsonStr.RESULT[0][0].ENTRADA_LIDO);
          $("#txtLayoutPagto").val(jsonStr.RESULT[0][0].LAYOUT_PAG);
          $("#txtArqEnvioPagto").val(jsonStr.RESULT[0][0].DIR_ENV_PAGTO);
          $("#txtArqRetornoPagto").val(jsonStr.RESULT[0][0].DIR_RET_PAGTO);
          $("#txtValContrato").val(jsonStr.RESULT[0][0].VAL_CONTRATO);
          $("#txtValDespesa").val(jsonStr.RESULT[0][0].VAL_DESPESA);
          $("#txtCodComunicacao").val(jsonStr.RESULT[0][0].COD_COMPL_PAGFOR);
          $("#txtDesconto").val(jsonStr.RESULT[0][0].PERC_DESC);
          $('#rgExtrato').val(jsonStr.RESULT[0][0].LINHA_EXT);
          if (jsonStr.RESULT[0][0].PADRAO == "S") {
            $('#cbBancoPadrao').prop('checked', true);
          }
          if (jsonStr.RESULT[0][0].SEGUIMENTO_Q == "S") {
            $('#cbSeguimentoQ').prop('checked', true);
          }
          if (jsonStr.RESULT[0][0].SEGUIMENTO_R == "S") {
            $('#cbSeguimentoR').prop('checked', true);
          }
          if (jsonStr.RESULT[0][0].SOMA_TARIFA == "S") {
            $('#cbTarifaValPago').prop('checked', true);
          }
          if (jsonStr.RESULT[0][0].INTEGRA_ENVIO == "S") {
            $('#cbPossuiIntegracao').prop('checked', true);
          }
          if (jsonStr.RESULT[0][0].ULT_LINHA_EXT == "S") {
            $('#cbUltimaLinhaExtrato').prop('checked', true);
          }
          if (jsonStr.RESULT[0][0].PAG_FOR_31 == "31") {
            $('#cbTituloTerceiros').prop('checked', true);
          }
          if (jsonStr.RESULT[0][0].PAG_FOR_08 == "08") {
            $('#cbTed').prop('checked', true);
          }
          if (jsonStr.RESULT[0][0].PAG_FOR_03 == "03") {
            $('#cbDoc').prop('checked', true);
          }

        } catch (error) {
          console.error(error);
          msgAlerta(`Não foi possível buscar os dados:`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  }

  let contaFs = 1;

  $('#account').on('click', function () {
    if (banco != 'create') {
      if (contaFs == 2) {
        $('#voltar').trigger('click');
      }
      if (contaFs == 3) {
        $('#voltar').trigger('click');
      }
      if (contaFs == 4) {
        $('#voltar4').trigger('click');
        $('#voltar').trigger('click');
      }
    }
  });

  $('#payment').on('click', function () {
    if (banco != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
      }
      if (contaFs == 4) {
        $('#voltar4').trigger('click');
      }
    }
  });

  $(".previous").click(function () {

    contaFs -= 1;

    currentFs = $(this).parent();
    previousFs = $(this).parent().prev();
    $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
    previousFs.show();
    currentFs.animate({
      opacity: 0
    }, {
      step(now) {
        opacity = 1 - now;
        currentFs.css({
          'display': 'none',
          'position': 'relative'
        });
        previousFs.css({
          'opacity': opacity
        });
      },
      duration: 600
    });
  });

  $(".next").click(function () {

    if (($(this).attr('id') == 'avancar3') && ($('#tipoInteg').val() == '')) {
      msgAlerta('Necessário informar tipo de integração, favor verificar.', undefined, undefined, setaFocoInput);
      return;
    };

    contaFs += 1;

    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {

      currentFs = $(this).parent();
      nextFs = $(this).parent().next();

      $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

      nextFs.show();
      currentFs.animate({
        opacity: 0
      }, {
        step(now) {
          opacity = 1 - now;

          currentFs.css({
            'display': 'none',
            'position': 'relative'
          });
          nextFs.css({
            'opacity': opacity
          });
        },
        duration: 600
      });
    }
  });

  $("#txtDescricao").change(function () {
    $(this).val($(this).val().toUpperCase());
  });


  $("#gravar").click(async function () {

    if ($('#txtCodigo').val() == '') {
      msgAlerta('Preencha o campo Banco');
      return;
    }else if ($('#txtDescricao').val() == '') {
      msgAlerta('Preencha o campo Nome do Banco');
      return;
    }

    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();


    if (erros == 0) {
      try {
        $.LoadingOverlay("show");

        if ($('#txtDescricao').val() === '') {
          msgAlerta(`Necessário informar uma descrição.`);

        } if ($('#txtCodiigo').val() === '') {
          msgAlerta(`Necessário informar um código.`);
        }


        let BancoClasse = {};



        BancoClasse.CODCLI = pegaChave("#txtCliente");
        BancoClasse.BANCO = $("#txtCodigo").val().toUpperCase();
        BancoClasse.NOME_BANCO = $("#txtDescricao").val().toUpperCase();
        BancoClasse.LOCAL = $("#txtArqEnvio").val();
        BancoClasse.LAYOUT = $("#txtArquivoLayout").val();
        BancoClasse.ENTRADA = $("#txtArqRetorno").val();
        BancoClasse.NOME_ARQ = $("#txtNomeArquivo").val();
        BancoClasse.ENTRADA_LIDO = $("#txtArqRetornoLido").val();
        BancoClasse.LAYOUT_PAG = $("#txtLayoutPagto").val();
        BancoClasse.DIR_ENV_PAGTO = $("#txtArqEnvioPagto").val();
        BancoClasse.DIR_RET_PAGTO = $("#txtArqRetornoPagto").val();
        BancoClasse.VAL_CONTRATO = $("#txtValContrato").val();
        BancoClasse.VAL_DESPESA = $("#txtValDespesa").val();
        BancoClasse.COD_COMPL_PAGFOR = $("#txtCodComunicacao").val();
        BancoClasse.PERC_DESC = $("#txtDesconto").val();
        BancoClasse.LINHA_EXT = $('#rgExtrato').val();
        if ($("#cbTituloTerceiros").is(":checked")) {
          BancoClasse.PAG_FOR_31 = '31';
        }
        if ($("#cbDoc").is(":checked")) {
          BancoClasse.PAG_FOR_03 = '3';
        }
        if ($("#cbTed").is(":checked")) {
          BancoClasse.PAG_FOR_08 = '8';
        }
        if ($("#cbUltimaLinhaExtrato").is(":checked")) {
          BancoClasse.ULT_LINHA_EXT = 'S';
        }
        if ($("#cbBancoPadrao").is(":checked")) {
          BancoClasse.PADRAO = 'S';
        }
        if ($("#cbSeguimentoQ").is(":checked")) {
          BancoClasse.SEGUIMENTO_Q = 'S';
        }
        if ($("#cbSeguimentoR").is(":checked")) {
          BancoClasse.SEGUIMENTO_R = 'S';
        }
        if ($("#cbTarifaValPago").is(":checked")) {
          BancoClasse.SOMA_TARIFA = 'S';
        }
        if ($("#cbPossuiIntegracao").is(":checked")) {
          BancoClasse.INTEGRA_ENVIO = 'S';
        }

        let response = await requisicao(
          'POST', '/sisplan/cadastros/v1/cadbanco?', '', JSON.stringify(BancoClasse), 15500
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        if (response.status != 200) {
          let jsonStr = await response.json();
          $.LoadingOverlay("hide");
          msgAlerta(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success(
            `Cadastro efetuado com sucesso!
                         Banco: ${BancoClasse.BANCO}`,
            "Confirmação",
            {
              toastClass: "alert",
              iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden() {
                window.location.href = `${BASE_URI}/cadbanco`;
              },
            }
          )
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgAlerta(`Não foi possível gravar os dados:`);
      }
    }
  });
});