$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#conteudo',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro.',
        position: 'top'
      }
    },
    {
      element: '#dtEntregaNova',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome, ele serve para definir uma previsão de entrega.',
        position: 'top'
      }
    },
    {
      element: '#txtMoeda',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome, ele serve para alterar a moeda de pagamento do pedido.',
        position: 'top'
      }
    },
    {
      element: '#txtCondPagto',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome, ele serve para alterar a condição de pagamento do pedido.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "top",
      },
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar a Alteração do Pedido B2B.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE chave", "DESCRICAO descricao"], "where": null}`);
  $('#btnMoeda').pesquisa('#txtMoeda', 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":["CODMOE", "DESCRICAO"]}`, 'Pesquisa Moeda', 'MOEDA');
  $('#btnLimpaMoeda').on('click', function () {
    $('#txtMoeda').val('');
  });

  $('#txtCondPagto').autocompleta(1, `JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND chave", "DESCRICAO descricao"], "where": null}`);
  $('#btnCondPagto').pesquisa('#txtCondPagto', 'CODCOND', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONDICAO", "camposSelect":["CODCOND", "DESCRICAO"]}`, 'Pesquisa Condição de Pagamento', 'CONDICAO');
  $('#btnLimpaCondPagto').on('click', function () {
    $('#txtCondPagto').val('');
  });

  $('#txtTransportadora').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO chave", "NOME descricao"], "where": null}`);
  $('#btnTransportadora').pesquisa('#txtTransportadora', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRAN", "camposSelect":["CODIGO", "NOME"]}`, 'Pesquisa Transportadora', 'TABTRAN');
  $('#btnLimpaTransportadora').on('click', function () {
    $('#txtTransportadora').val('');
  });


  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let altpedidob2b = parametros[parametros.length - 1];

  if (altpedidob2b != "") {
    if (await liberarRegistro('ALTPEDIDOSB2B', altpedidob2b) == false) {
      window.location.href = '../altpedidob2b';
    } else {
      try {
        try {
          $.LoadingOverlay("show");
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={
            "tabela": "PEDIDO",
            "camposSelect": [
              "PEDIDO.NUMERO",
              "PEDIDO.MOEDA",
              "MOEDA.DESCRICAO DESCMOEDA",
              "PEDIDO.COND_PAGTO",
              "CONDICAO.DESCRICAO DESCCOND",
              "PEDIDO.TAB_TRANS",
              "TABTRAN.NOME",
              "PEDIDO.OBS",
              "PEDIDO.ENTREGA"
            ],
            "leftjoin": [
              {
                "tabela": "TABTRAN",
                "condicao": "TABTRAN.CODIGO = PEDIDO.TAB_TRANS"
              },
              {
                "tabela": "CONDICAO",
                "condicao": "CONDICAO.CODCOND = PEDIDO.COND_PAGTO"
              },
              {
                "tabela": "MOEDA",
                "condicao": "MOEDA.CODMOE = PEDIDO.MOEDA"
              }
            ],
            "where": [
              "PEDIDO.NUMERO = '${altpedidob2b}'"
            ]
          }`,
            null
          );

          if (!response) {
            return;
          }

          let jsonStr = await response.json();
          if (response.status != 200) {
            msgAlerta(jsonStr.RESULT[0].mensagem);
            return;
          }

          $("#dtEntregaNova").val(jsonStr.RESULT[0][0].ENTREGA);
          insereValor("#txtMoeda", jsonStr.RESULT[0][0].MOEDA, jsonStr.RESULT[0][0].DESCMOEDA);
          insereValor("#txtCondPagto", jsonStr.RESULT[0][0].COND_PAGTO, jsonStr.RESULT[0][0].DESCCOND);
          insereValor("#txtTransportadora", jsonStr.RESULT[0][0].TAB_TRANS, jsonStr.RESULT[0][0].NOME);
          $("#txtObservacao").val(jsonStr.RESULT[0][0].OBS);

        } catch (error) {
          console.error(error);
          msgAlerta(`Não foi possível buscar os dados:`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  }

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('ALTPEDIDOSB2B', getCookie('usuario'), altpedidob2b);
    window.location.href = `${BASE_URI}/altpedidob2b`;
  });

  $('#btnGravar').on('click', async function () {
    await gravarPedido()
  })

  async function retornaRegrasStatusAlteracaoPedido(tipo) {
    const pesquisa = {
      camposSelect: ["STATUS, FINANCEIRO"],
      tabela: "CONFIGSTATUS",
      where: [`OPERACAO = '${'opAlteraPedidoB2B'}' AND ID_TIPO = ${tipo}`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));

    if ((jsonStr) && (jsonStr.length > 0)) {
      return {
        status: jsonStr[0].STATUS,
        financeiro: jsonStr[0].FINANCEIRO
      }
    }

  }

  async function validaAlteradoMoedaOuCondPagto(pedido) {
    const pesquisa = {
      camposSelect: ["MOEDA, COND_PAGTO, ID_TIPO, STATUS, FINANCEIRO"],
      tabela: "PEDIDO",
      where: [`NUMERO = '${altpedidob2b}'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));

    if ((!jsonStr) && (jsonStr.length == 0)) {
      return;
    }

    const regras = await retornaRegrasStatusAlteracaoPedido(jsonStr[0].ID_TIPO);
    const moedaGravada = jsonStr[0].MOEDA
    const condPagtoGravada = jsonStr[0].COND_PAGTO
    const statusGravada = jsonStr[0].STATUS
    const financeiroGravada = jsonStr[0].FINANCEIRO
    if (regras) {

      if ((moedaGravada != pedido.MOEDA) || (pedido.CONDPAGTO != condPagtoGravada)) {
        pedido.financeiro = regras.financeiro == 'BLOQUEADO' ? '0' : '1'
        pedido.status = regras.status
      } else {
        pedido.financeiro = financeiroGravada
        pedido.status = statusGravada
      }
    }
  }

  async function gravarPedido() {
    $.LoadingOverlay('show')
    try {
      if ($('#dtEntregaNova').val() == '') {
        msgAlerta('Preencha Data de Entrega.');
        return;
      } else if ($('#txtMoeda').val() == '') {
        msgAlerta('Preencha Moeda.');
        return;
      } else if ($('#txtCondPagto').val() == '') {
        msgAlerta('Preencha Condição de Pagamento.');
        return;
      }

      let pedido = {}

      pedido.NUMERO = altpedidob2b;
      pedido.DATAENTREGA = $('#dtEntregaNova').val();
      pedido.MOEDA = pegaChave('#txtMoeda');
      pedido.CONDPAGTO = pegaChave('#txtCondPagto');
      pedido.TRANSP = pegaChave('#txtTransportadora');
      pedido.OBS = $("#txtObservacao").val().toUpperCase();

      await validaAlteradoMoedaOuCondPagto(pedido);

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/altpedidob2b?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(pedido)}`, 15000);
      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }
      toastr.success(
        `Cadastro efetuado com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/altpedidob2b`;
        }
      }).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnItens').on('click', async function (event) {
    event.preventDefault();
    $('#modal-itens').modal('show');
    await tabelaItenspedido();
  });

  async function tabelaItenspedido() {
    let dataSetCols = [];
    try {
      $.LoadingOverlay("show");
      response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"PED_ITEN","camposSelect":["CODIGO", "COR", "QTDE"],"where": ["NUMERO = '${altpedidob2b}'"]}`, null, 20000);
      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        $('#tabelaItensPedido').html(`<p class='d-flex justify-content-center border-Field' style="padding-top: 6px !important;">Nenhum registro encontrado</p>`);
        return;
      }
      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });

      if ($.fn.dataTable.isDataTable('#tabelaItensPedido')) {
        $('#tabelaItensPedido').DataTable().clear().destroy();
      }

      criaDataTablePadrao('#tabelaItensPedido', true, true, false, true, false, false, '200px', dataSet, dataSetCols);

      if ($('#tabelaItensPedido').DataTable().rows().count() < 4) {
        $('#tabelaItensPedido').css('min-height', '75px');
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os itens deste pedido.");
    } finally {
      $.LoadingOverlay("hide");
    }
    $("#tabelaItensPedido").DataTable().columns.adjust().draw(false);
  }


});
