$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os campos disponíveis de filtro.',
                position: 'right'
            }
        },
        {
            element: '#btnConciliar',
            popover: {
                title: 'Botão Conciliar',
                description: 'Clique aqui para ir para a tela de Conciliação',
                position: 'right'
            }
        },
        {
            element: '#btnImprimir',
            popover: {
                title: 'Botão Imprimir',
                description: 'Clique aqui para imprimir o relatório',
                position: 'right'
            }
        }
        ]);
        //inicio tour

        driver.start();

        // inicior tuor
        //final
    });
});
$(document).ready(async function () {
    let layout = '';


    const retornaBotaoOpcoes = () => {
        return '<div class="divBtnOpcoes p-0" style="max-width: 120px"> ' +
            '     <button class="botaoOpcoes btn-sm" type="button" title="Alterar" id="btn-editar"><span class="fas fa-folder" style="color:green"></span></button>     ' +
            '     <input type="file" value="" accept=".fr3" class="upload" style="display: none;" name="arquivo" id="arquivo" /> ' +
            '     <button class="botaoOpcoes btn-sm" type="button" title="Download" id="btn-download"><span class="fas fa-download" style="color:#6f42c1"></span></button>     ' +
            '    <a href="" id="anchorDownload" download><button class="botaoOpcoes pr-2 d-none" id="btnDownloadTrigger" type="button"><span class="fas fa-download" style="color:green"></span></button></a>' +
            '     <button class="botaoOpcoes btn-sm" type="button" title="Renomear" id="btn-renomear"><span class="fas fa-edit" style="color:green"></span></button>     ' +
            '     <button class="botaoOpcoes btn-sm" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
            '   </div>';
    };

    const buscaRegistrolayout = async () => {
        const url = "/sisplan/alterarrelatorio/v1/consultarelatorios?";
        try {
            $.LoadingOverlay("Show");
            try {
                const response = await requisicao("GET", url, `EMPRESA=${getCookie("empresa")}`, "", 360000);

                if (!response) {
                    return;
                }

                var jsonStr = await response.json()
                if (response.status != 200) {
                    msgErro(jsonStr['RESULT'][0].mensagem);
                    return;
                }

                return jsonStr;
            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os dados.');
            }
        } finally {
            $.LoadingOverlay("Hide");
        }
    }

    const criaDataTableLayout = async () => {
        if ($.fn.DataTable.isDataTable('#tabelaLayout')) {
            $('#tabelaLayout').DataTable().destroy();
            $('#tabelaLayout').empty();
        }
        try {
            $.LoadingOverlay('show')
            const jsonStr = await buscaRegistrolayout();

            if (jsonStr.length <= 0) {
                msgAlerta('Nenhum registro encontrado!')
                return;
            }

            const dataCols = []

            const keys = Object.keys(jsonStr[0]);

            keys.forEach((k) => {
                dataCols.push({
                    title: k,
                    data: k,
                });
            });

            $("#tabelaLayout").DataTable({
                destroy: true,
                sort: true,
                colReorder: {
                    fixedColumnsLeft: 2
                },
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    language: {
                        decimal: ",",
                        thousands: ".",
                    },
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                autoWidth: true,
                data: jsonStr,
                columns: dataCols,
                columnDefs: [
                    {
                        targets: [2], render: function (data, type, row) {
                            return retornaBotaoOpcoes();
                        }
                    },
                    {
                        type: "date-br",
                        render(data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        },
                        targets: [1]
                    }
                ]
            });
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnIncluir').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            $('#incluirArquivo').trigger('click')
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#incluirArquivo').change(async function (e) {
        $.LoadingOverlay('show')
        try {
            try {
                const arquivo = e.target.files[0];

                if (!validaExtencao(arquivo.name)){
                    msgAlerta('Arquivo selecionado não possui a extensão ".fr3" impossível continuar!');
                    return;
                }

                const leitor = new FileReader();

                leitor.onload = async function (ev) {
                    let base64 = ev.target.result;
                    await enviarParaBackEnd(base64, arquivo.name.split('.')[0]);
                };

                leitor.readAsDataURL(arquivo);
            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#tabelaLayout').on('click', '#btn-editar', function () {
        $.LoadingOverlay('show')
        try {
            layout = $('#tabelaLayout').DataTable().row($(this).parents('tr')).data();
            $('#arquivo').trigger('click')

        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#tabelaLayout').on('change', '#arquivo', async function (e) {
        $.LoadingOverlay('show')
        try {
            try {
                if (layout == '') {
                    return;
                }
                const arquivo = e.target.files[0];
                if (layout.NOME != arquivo.name) {
                    msgAlerta('Arquivo escolhido é diferente do selecionado, impossível continuar!');
                    return;
                }

                if (!validaExtencao(arquivo.name)){
                    msgAlerta('Arquivo selecionado não possui a extensão ".fr3" impossível continuar!');
                    return;
                }

                await msgAguardaConfirmacao('Deseja alterar o relatório ' + arquivo.name + '?', async () => {
                    const leitor = new FileReader();


                    leitor.onload = async function (ev) {
                        let base64 = ev.target.result;
                        await enviarParaBackEnd(base64, arquivo.name.split('.')[0], 'A');
                    };

                    leitor.readAsDataURL(arquivo);
                })
            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    const enviarParaBackEnd = async (base64, nomeArquivo, tipo = '') => {
        try {
            let response = await requisicao(
                'POST',
                '/sisplan/alterarrelatorio/v1/alterarrelatorio?',
                `NOMEARQUIVO=${nomeArquivo}&TIPO=${tipo}`,
                `SBASE64=${encodeURIComponent(base64)}`
            );
            if (!response) {
                return;
            }
            if (response.status != 200) {
                let jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }

            toastr.success(`Relatório ${tipo == 'A' ? 'alterado' : 'incluido'} com sucesso!`, "Confirmação", {
                toastClass: "success",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    location.reload()
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });

        } catch (error) {
            console.error(error)
        }
    }

    $('#tabelaLayout').on('click', '#btn-excluir', async function () {
        $.LoadingOverlay('show')
        try {
            try {
                const data = $('#tabelaLayout').DataTable().row($(this).parents('tr')).data();

                msgAguardaConfirmacao('Deseja realmente excluir o relatório: ' + data.NOME + '?', async () => {
                    await excluiRelatorio(data.NOME)
                })

            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    
    $('#tabelaLayout').on('click', '#btn-download', async function () {
        $.LoadingOverlay('show')
        try {
            try {
                const data = $('#tabelaLayout').DataTable().row($(this).parents('tr')).data();
                $('#anchorDownload').attr('href', `${BASE_URI}/Layout/${data.NOME}`);
                $('#btnDownloadTrigger').trigger('click');
            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    const excluiRelatorio = async (nomeArquivo) => {
        try {
            let response = await requisicao(
                'DELETE',
                '/sisplan/alterarrelatorio/v1/excluirelatorio?',
                `NOMEARQUIVO=${nomeArquivo}`,
                ``
            );
            if (!response) {
                return;
            }
            if (response.status != 200) {
                let jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }

            toastr.success(`Relatório excluido com sucesso!`, "Confirmação", {
                toastClass: "success",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    location.reload()
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });

        } catch (error) {
            console.error(error)
        }
    }

    $('#tabelaLayout').on('click', '#btn-renomear', async function () {
        $.LoadingOverlay('show')
        try {
            const data = $('#tabelaLayout').DataTable().row($(this).parents('tr')).data();
            $('#modal-renomear').modal('show')
            $('#txtNomeLayout').val(data.NOME.split('.')[0])
            $('#txtNomeLayoutOld').val(data.NOME)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnDesistir').on('click', function () {
        $('#modal-renomear').modal('hide')
    })

    $('#btnGravar').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            try {
                let nomeLayoutOld = $('#txtNomeLayoutOld').val()
                let nomeLayout;
                if (($('#txtNomeLayout').val().toUpperCase()).indexOf('.FR3') == -1) {
                    nomeLayout = $('#txtNomeLayout').val() + '.fr3'
                } else {
                    nomeLayout = $('#txtNomeLayout').val()
                }

                if (nomeLayout.toUpperCase() == nomeLayoutOld.toUpperCase()){
                    msgAlerta('Novo nome do arquivo é igual ao anterior!')
                    return;
                }

                let response = await requisicao(
                    'POST',
                    '/sisplan/alterarrelatorio/v1/renomearlayout?',
                    `NOMEARQUIVONOVO=${nomeLayout}&NOMEARQUIVO=${nomeLayoutOld}`,
                    ``
                );
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success(`Relatório renomeado com sucesso!`, "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        $('#modal-renomear').modal('hide')
                        location.reload()
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });
            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    const validaExtencao = (nome) => {
        if ((nome.split('.').pop()).toUpperCase() == 'FR3'){
            return true
        } else {
            return false
        }
    }

    $('#btnConsultar').on('click', async function () {
        $.LoadingOverlay("Show");
        try {
            try {
                await criaDataTableLayout();
            } catch (error) {
                console.error(error);
                msgErro("Erro ao buscar os dados");
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#btnConsultar').trigger('click')
});