$(document).ready(async function () {

    $('#modal-ocorrencias').on('shown.bs.modal', async function () {
        $('#txtObsOcorrencias').prop('disabled', true);
        bloqueiaCampos();
        await buscaOcorrencias($('input[name="tipoFiltro"]:checked').val());
        const nomeEntidade = `[${$('#txtCodCli').val()}] - ${$('#txtNome').val()}`
        $('#txtClienteContato').val(`${nomeEntidade}`);
        $('#lblEmailContato').html('E-mail:');
    });

    async function buscaOcorrencias(ativo = '') {
        try {
            const cliente = $('#txtClienteOcorrencias').val();
            $.LoadingOverlay('show');
            try {
                if ($.fn.DataTable.isDataTable('#tabelaOcorrencias')) {
                    $('#tabelaOcorrencias').DataTable().destroy();
                    $('#tabelaOcorrencias').empty();
                };

                let listaWhere = [`1=1 AND CODCLI = '${cliente}'`];

                if (ativo != '') {
                    listaWhere.push(
                        `ATIVO = '${ativo}'`
                    )
                }

                const pesquisa = {
                    tabela: "CLI_HISTORICO",
                    camposSelect: ["CLI_HISTORICO.*", "'HISTORICO' AS CADASTRO"
                    ],
                    where: listaWhere,
                    orderBy: [
                        "NUMERO",
                    ]

                };

                const ocorrencias = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

                const dataSetCols = [
                    {
                        data: 'NUMERO',
                        title: 'Número'
                    },
                    {
                        data: 'ATIVO',
                        title: 'Ativo'
                    },
                    {
                        data: 'DATA',
                        title: 'Data'
                    },
                    {
                        data: 'DT_PREV_RETORNO',
                        title: 'Previsão de Retorno'
                    },
                    {
                        data: 'USUARIO',
                        title: 'Usuário'
                    },
                    {
                        data: 'OBS',
                        title: 'Observação'
                    },
                ];

                $('#tabelaOcorrencias').DataTable({
                    bPaginate: false,
                    destroy: true,
                    search: false,
                    filter: false,
                    lengthChange: false,
                    pageLength: 5,
                    info: true,
                    order: false,
                    language: {
                        sEmptyTable: "Nenhum registro encontrado",
                        sInfo: "_TOTAL_ registros",
                        sInfoEmpty: " 0 registros",
                        sInfoFiltered: "(Filtrados de _MAX_ registros)",
                        sInfoPostFix: "",
                        sInfoThousands: ".",
                        sLengthMenu: "_MENU_ resultados",
                        sLoadingRecords: "Carregando...",
                        sProcessing: "Processando...",
                        sZeroRecords: "Nenhum registro encontrado",
                        sSearch: "Pesquisar",
                        oPaginate: {
                            sNext: "Próximo",
                            sPrevious: "Anterior",
                            sFirst: "Primeiro",
                            sLast: "Último",
                        },
                        oAria: {
                            sSortAscending: ": Ordenar colunas de forma ascendente",
                            sSortDescending: ": Ordenar colunas de forma descendente",
                        },
                    },
                    autoWidth: true,
                    columns: dataSetCols,
                    data: ocorrencias,
                    columnDefs: [{
                        type: 'date-br',
                        targets: [2, 3],
                        render(data) {
                            if (data === '1899-12-30') {
                                return '';
                            } else if (data) {
                                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                            } else {
                                return '';
                            }
                        }
                    }, {
                        targets: [0],
                        render: function (data, display, row) {
                            let texto;
                            if (row['ATIVO'] == 'S') {
                                texto = 'Inativar';
                            } else {
                                texto = 'Ativar';
                            }
                            return retornaOpcoes(data, texto);
                        }
                    }]
                });
            } catch (e) {
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#btnIncluirOcorrencias').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            habilitaInclusao();

            $('#tabelaOcorrencias').DataTable().row.add({
                NUMERO: await RetornaProximo("CLI_HISTORICO", "CLI_HISTORICO", "NUMERO", 1),
                ATIVO: 'S',
                DATA: formataData(new Date()),
                DT_PREV_RETORNO: '',
                USUARIO: (await buscaValor('ACESSO_USUARIOS', 'NOME', 'CODIGO', getCookie('cod_usuario'))).NOME,
                OBS: '',
            }).draw(false);
        } finally {
            $.LoadingOverlay('hide');
        }

    });

    $('#btnCancelarOcorrencias').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            desabilitaInclusao();

            await buscaOcorrencias($('input[name="tipoFiltro"]:checked').val());
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    $('#btnGravarOcorrencias').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let ocorrencia = {};

                const data = $('#tabelaOcorrencias').DataTable().data().toArray();

                dadosObject = data[data.length - 1];

                ocorrencia.NUMERO = dadosObject.NUMERO;
                ocorrencia.ASSUNTO = $('#txtObsOcorrencias').val().substring(0, 98);
                ocorrencia.ATIVO = dadosObject.ATIVO;
                ocorrencia.DATA = dadosObject.DATA;
                ocorrencia.DT_PREV_RETORNO = '1899-12-30';
                ocorrencia.AVISA_CAD = 'N';
                ocorrencia.AVISA_EXP = 'N';
                ocorrencia.AVISA_NOTA = 'N';
                ocorrencia.AVISA_PED = 'N';
                ocorrencia.BLOQUEAR_FAT = 'N';
                ocorrencia.CODCLI = $('#txtClienteOcorrencias').val();
                ocorrencia.USUARIO = dadosObject.USUARIO;
                // ocorrencia.ID_USUARIO_ORIG = (await buscaValor('ACESSO_USUARIOS', 'ID', 'CODIGO', getCookie('cod_usuario'))).ID;
                ocorrencia.DT_ENTREGA = '1899-12-30';
                ocorrencia.OBS = $('#txtObsOcorrencias').val();

                const url = `/sisplan/cliente/v1/incluiocorrencia?`;
                const response = await requisicao("POST", url, `JSON=${JSON.stringify(ocorrencia)}`, '', 60000);

                if (response.status != 200) {
                    const jsonMsg = await response.json();
                    msgAlerta(jsonMsg.mensagem);
                    return;
                };

                criaMensagemSucesso('Ocorrência inclusa com sucesso!', desabilitaInclusao);

                await buscaOcorrencias($('input[name="tipoFiltro"]:checked').val());

            } catch (e) {
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    function habilitaInclusao() {
        $('#btnIncluirOcorrencias').addClass('d-none');
        $('#btnGravarOcorrencias').removeClass('d-none');
        $('#btnImprimirOcorrencias').addClass('d-none');
        $('#btnCancelarOcorrencias').removeClass('d-none');
        $('#txtObsOcorrencias').prop('disabled', false);
        $('#radioFiltroOcorrencias').prop('disabled', true);
        $('.botoesTabela').prop('disabled', true);
    }

    function desabilitaInclusao() {
        $('#btnIncluirOcorrencias').removeClass('d-none');
        $('#btnGravarOcorrencias').addClass('d-none');
        $('#btnImprimirOcorrencias').removeClass('d-none');
        $('#btnCancelarOcorrencias').addClass('d-none');
        $('#txtObsOcorrencias').prop('disabled', true);
        $('#radioFiltroOcorrencias').prop('disabled', false);
        $('#txtObsOcorrencias').val('');
        $('.botoesTabela').prop('disabled', false);
    }

    function retornaOpcoes(sChave, texto) {

        return `<div> 
                <button class="btn btn-info btn-sm dropdown-toggle btnOpcoesOcorrencias" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">${sChave}
                </button> 
                <div class="dropdown-menu">
                <button class="dropdown-item botoesTabela" id="btn-alterar-ocorrencia">${texto}</button>
                <button class="dropdown-item botoesTabela" id="btn-excluir-ocorrencia">Excluir</button>
                </div>`;
    };

    $('.controleRadio').on('change', async function () {
        await buscaOcorrencias($('input[name="tipoFiltro"]:checked').val());
    });

    $('#tabelaOcorrencias').on('click', '#btn-alterar-ocorrencia', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                if (!await uMasterOuSupervisor()) {
                    msgErro('Somente um usuário master ou supervisor pode ativar ou inativar uma ocorrência.');
                    return;
                }

                const numero = ($("#tabelaOcorrencias").DataTable().row($(this).parents('tr')).data()).NUMERO;
                const status = ($("#tabelaOcorrencias").DataTable().row($(this).parents('tr')).data()).ATIVO == 'S' ? 'N' : 'S';

                const url = `/sisplan/cliente/v1/alteraocorrencia?`;
                const response = await requisicao("PUT", url, `NUMERO=${numero}&STATUS=${status}`, '', 60000);

                if (response.status != 200) {
                    const jsonMsg = await response.json();
                    msgAlerta(jsonMsg.mensagem);
                    return;
                };

                await buscaOcorrencias($('input[name="tipoFiltro"]:checked').val());

            } catch (e) {
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    $('#tabelaOcorrencias').on('click', '#btn-excluir-ocorrencia', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                if (!await uMasterOuSupervisor()) {
                    msgErro('Somente um usuário master ou supervisor pode excluir uma ocorrência.')
                    return;
                }

                msgAlerta('Deseja realmente excluir esta ocorrência?', async () => { }, null, async () => {

                    const numero = ($("#tabelaOcorrencias").DataTable().row($(this).parents('tr')).data()).NUMERO;

                    const url = `/sisplan/cliente/v1/excluiocorrencia?`;
                    const response = await requisicao("DELETE", url, `NUMERO=${numero}&CODCLI=${$('#txtClienteOcorrencias').val()}`, '', 60000);

                    if (response.status != 200) {
                        const jsonMsg = await response.json();
                        msgAlerta(jsonMsg.mensagem);
                        return;
                    };

                    criaMensagemSucesso('Ocorrência excluída com sucesso!', desabilitaInclusao);

                    await buscaOcorrencias($('input[name="tipoFiltro"]:checked').val())
                })

            } catch (e) {
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnImprimirOcorrencias').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let url = `/sisplan/impressao/v1/historicocliente?CODCLI=${$('#txtClienteOcorrencias').val()}&STATUS=${$('input[name="tipoFiltro"]:checked').val()}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('HistoricoCliente');
                const arquivo = await GeraRelatorio(url, "POST", 100000, false);
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                    }
                    await limparRelatorios();
                }

            } catch (e) {
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    })
});