$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Filtro',
        description: 'Aqui podemos aplicar o filtro por tipo de turno.',
        position: 'bottom'
      }
    },
    {
      element: '#btnNovoTemplate',
      popover: {
        title: 'Inclusão',
        description: 'Neste botão, podemos incluir um novo registro de turno.',
        position: 'bottom'
      }
    },
    {
      element: '#tabelaTurno',
      popover: {
        title: 'Informações da Tabela',
        description: 'Aqui é apresentado os registro da tabela.',
        position: 'top'
      }
    },
    {
      element: '#tutorialTabela',
      popover: {
        title: 'Opções de Alterar e Excluir',
        description: 'Neste botão, podemos escolher entre alterar ou excluir o registro.',
        position: 'top'
      }
    },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#btn-ConsultaTurnos').pesquisa('#txtStatusConsulta', 'TURNO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TURNO", "camposSelect":[ "TURNO", "DESCRICAO" ], "where": null}', 'Pesquisar Turno', 'Turno');
  $('#txtStatusConsulta').autocompleta(1, `JSON={ "tabela":"TURNO", "camposSelect":["TURNO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btn-limpa-ConsultaTurnos, #btnLimparFiltros').on('click', function () {
    $('#txtStatusConsulta').val('');
  });
  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });



  $('#btnConsultar').on('click', async function consultaTabela() {

    let colunas = [];
    let dataSetCols = [];
    $.LoadingOverlay("show");

    try {
      if ($.fn.DataTable.isDataTable('#tabelaTurno')) {
        $("#tabelaTurno").DataTable().destroy();
        $("#tabelaTurno").empty();
      }

      if ($("#txtStatusConsulta").val() == '') {
      camposSelect = `["TURNO", "DESCRICAO", "NOTURNO", "HORA_INI", "HORA_FIM"]`;
      colunas = ["TURNO", "DESCRICAO", "NOTURNO", "HORA_INI", "HORA_FIM"];
      ajaxData = {
        "EMPRESA": getCookie('empresa'),
        "JSON": `{"tabela":"TURNO", "camposSelect":["TURNO", "DESCRICAO", "NOTURNO", "HORA_INI", "HORA_FIM"],"where": ["1=1"]}`
      };
    }else{
      camposSelect = `["TURNO", "DESCRICAO", "NOTURNO", "HORA_INI", "HORA_FIM"]`;
      colunas = ["TURNO", "DESCRICAO", "NOTURNO", "HORA_INI", "HORA_FIM"];
      ajaxData = {
        "EMPRESA": getCookie('empresa'),
        "JSON": `{"tabela":"TURNO", "camposSelect":["TURNO", "DESCRICAO", "NOTURNO", "HORA_INI", "HORA_FIM"],"where": ["1=1 AND TURNO='${pegaChave("#txtStatusConsulta")}'"]}`
      };
    }

      for (let i = 0; i < colunas.length; i++) {
        dataSetCols.push({
          'title': colunas[i],
          'data': i
        });
      }

      $('#tabelaTurno').DataTable({
        paging: true,
        lengthChange: false,
        filter: true,
        info: true,
        order: true,
        autoWidth: true,
        destroy: true,
        serverSide: true,
        processing: false,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable?`,
          type: "POST",
          headers: {
            'Authorization': BASIC_AUTH
          },
          data: ajaxData,
        },
        "language": {
          "sEmptyTable": "Nenhuma consulta realizada",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhuma consulta realizada",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"

          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          },
        },
        columns: dataSetCols,
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
          {
            targets: [0, 1, 2, 3, 4], 
          },
          {
            "targets": [3, 4],
            'render': function (data, type, full, meta) {
              if (type === 'display') {
                data = data.substring(11, 16);
              }

              return data;
              
            }
          }
        ]

      });

    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados dos itens.');
    } finally {
      setTimeout(function() {
        $.LoadingOverlay('hide');
      }, 2500); 
      $('#modal-filtros').modal('hide');
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" href="#txtTurno" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  $("#tabelaTurno").on("click", "#btn-editar", async function carregaDados() {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaTurno").DataTable().row($(this).parents("tr")).data();
      let registroLiberado = await verificarRegistro("TURNO", String(data[0]));
      if (registroLiberado) {
        window.location.href = `turno/${(data[0])}`;
      }

    }
    else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }

  });

  $('#btnConsultar').trigger('click');

  $('#tabelaTurno').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaTurno").DataTable().row($(this).parents("tr")).data();
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  const permissaoUsuarioLogado = await permissaoAcessos("TURNO");

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {

        let response = await requisicao('DELETE', '/sisplan/cadastros/V1/turno?', `DELETATURNO=${encodeURIComponent(data[0])}`, null);

        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/turno`;
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }

  };

  $('#tabelaTurno').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaTurno').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("TURNO", String(data[0]));
      if (registroLiberado) {
        window.location.href = `turno/${(data[0])}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });
});