$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoStatus',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de um status.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaStatus',
                popover: {
                    title: 'Tabela Status',
                    description: 'Aqui estão os dados dos status cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    componenteFiltro('tipo', true, true)
    componenteFiltro('status', true, true)

    const permissaoUsuarioLogado = await permissaoAcessos("STATUSPED");

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });


    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    consultaStatus();

    $('#btnConsultar').on('click', async function () {
        await consultaStatus(true);
        $('#modal-filtros').modal('hide');
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtTipo').val('');
        $('#rdTodos').prop('checked', true);
    });

    async function consultaStatus(bBotao = false) {
        try {
            $.LoadingOverlay("show");
            let response;
            const idTipo = $('#txtTipo').val() != '' ? ` AND CONFIGSTATUS.ID_TIPO IN (${await formataListas($('#txtTipo').val().toString())})` : '';
            const status = $('#txtStatus').val() != '' ? ` AND CONFIGSTATUS.STATUS IN (${await formataListas($('#txtStatus').val().toString())})` : '';
            const operacao = $('#rgOperacao').val() != '' ? ` AND CONFIGSTATUS.OPERACAO = '${$('#rgOperacao').val()}'` : '';
            
            if (bBotao) {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"CONFIGSTATUS", 
                                                                                            "camposSelect":["CONFIGSTATUS.ID", "CONFIGSTATUS.ID_TIPO TIPO", "TIPO.DESCRICAO DESC_TIPO",
                                                                                                            "CONFIGSTATUS.OPERACAO", "CONFIGSTATUS.STATUS", "SITPROD.DESCRICAO DESC_STATUS",
                                                                                                            "CONFIGSTATUS.FINANCEIRO", "CONFIGSTATUS.DIAS", "CONFIGSTATUS.UTIL"], 
                                                                                            "leftjoin":[{"tabela":"TIPO", "condicao":"TIPO.ID_TIPO = CONFIGSTATUS.ID_TIPO"},
                                                                                                        {"tabela":"SITPROD", "condicao":"SITPROD.CODIGO = CONFIGSTATUS.STATUS"}],
                                                                                            "where": ["1=1 ${idTipo} ${status} ${operacao}"]}`, null);
            } else {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"CONFIGSTATUS", 
                                                                                            "camposSelect":["CONFIGSTATUS.ID", "CONFIGSTATUS.ID_TIPO TIPO", "TIPO.DESCRICAO DESC_TIPO",
                                                                                                            "CONFIGSTATUS.OPERACAO", "CONFIGSTATUS.STATUS", "SITPROD.DESCRICAO DESC_STATUS",
                                                                                                            "CONFIGSTATUS.FINANCEIRO", "CONFIGSTATUS.DIAS", "CONFIGSTATUS.UTIL"], 
                                                                                            "leftjoin":[{"tabela":"TIPO", "condicao":"TIPO.ID_TIPO = CONFIGSTATUS.ID_TIPO"},
                                                                                                        {"tabela":"SITPROD", "condicao":"SITPROD.CODIGO = CONFIGSTATUS.STATUS"}],
                                                                                            "where": null}`, null);
            }

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }
            
            if (jsonStr.RESULT[0].length <= 0 ){
                $.LoadingOverlay("hide");
                msgAlerta('Nenhum Registro Encontrado!')
                return
            }

            const dataSetCols = []
            const keys = Object.keys(jsonStr.RESULT[0][0]);

            keys.forEach((k) => {
                dataSetCols.push({
                    title: k,
                    data: k,
                });
            });


            $('#tabelaStatus').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": dataSetCols,
                "columnDefs": [
                    {
                        targets: [0],
                        render: function (data, type, row) {
                            return retornaBotaoOpcoes(data);
                        },
                    },
                    {
                        targets: [7, 8],
                        visible: false,
                    },
                ]
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }

    }

    $('#btnNovoStatus').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "statusped/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#tabelaStatus').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaStatus').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('STATUSEPD', data.ID);
            if (registroLiberado) {
                window.location.href = `statusped/${data.ID}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaStatus').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaStatus').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('STATUSEPD', data.ID);
            if (registroLiberado) {
                window.location.href = `statusped/${data.ID}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaStatus').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaStatus").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/statusped?", `ID=${encodeURIComponent(valorLinha.ID)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }
});