$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relatorioMovimentacaoMat == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relatorioMovimentacaoMat: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relatorioMovimentacaoMat: novasColunas }))

      $('#tabelaRelMovimentacao').DataTable().columns().visible(true);
      // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

      $('#tabelaRelMovimentacao').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })


  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      }
      ]);
      driver.start();
    });
  });

  await preencheOrdenacaoTela('RelMovimentacaoDeEstoqueMat');

  await criaCampoDocto();

  $('#txtOrdem').val('3');

  limparFiltros(true);

  // const filtroDeposito = await retornaDepositoUsuario(getCookie('cod_usuario'));

  const filtroDeposito = await buscaDepositoEmpresaUsuario();

  componenteFiltro('material', true);
  componenteFiltro('cor', true);
  componenteFiltro('depositoUsuario', true);
  componenteFiltro('grupoMA', true);
  componenteFiltro('subGrupo', true);
  componenteFiltro('colecao', true);
  componenteFiltro('qualidade', true);

  $('#txtLote').pesquisa_variosServerside(1, `{ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO"], "where": ["LOTE <> '' OR LOTE IS NOT NULL"], "groupBy": ["LOTE", "CODIGO"]}`, 'LOTE', 'CODIGO');
  $('#btnLote').pesquisa_serversideSel('#txtLote', `{ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO", "COR" ], "where": ["LOTE <> '' OR LOTE IS NOT NULL"], "groupBy": ["LOTE", "CODIGO", "COR"]}`, 'Pesquisa de Lote');

  $('#txtLote').addClass('camposFiltros');
  $('#btnLimpaLote').on('click', function () {
    $('#txtLote').empty().trigger('change')
    $('#txtLote').val('');
    $('#txtLote').attr('data-chave', '');
    $('#txtLote').attr('data-desc', '');
  });


  $('#txtLoteInterno').pesquisa_variosServerside(1, `{ "tabela":"MAT_ITEN", "camposSelect":["LOTE_INTERNO", "CODIGO"], "where": ["LOTE_INTERNO <> '' OR LOTE_INTERNO IS NOT NULL"], "groupBy": ["LOTE_INTERNO", "CODIGO"]}`, 'LOTE_INTERNO', 'CODIGO');
  $('#btnLoteInterno').pesquisa_serversideSel('#txtLoteInterno', `{ "tabela":"MAT_ITEN", "camposSelect":["LOTE_INTERNO", "CODIGO", "COR"], "where": ["LOTE_INTERNO <> '' OR LOTE_INTERNO IS NOT NULL"], "groupBy": ["LOTE_INTERNO", "CODIGO", "COR"]}`, 'Pesquisa Lote');

  $('#txtLoteInterno').addClass('camposFiltros');
  $('#btnLimpaLoteInterno').on('click', function () {
    $('#txtLoteInterno').empty().trigger('change')
    $('#txtLoteInterno').val('');
    $('#txtLoteInterno').attr('data-chave', '');
    $('#txtLoteInterno').attr('data-desc', '');
  });

  $('#txtTonalidade').pesquisa_variosServerside(1, `{ "tabela":"MAT_ITEN", "camposSelect":[ "TONALIDADE", "ATIVO" ], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "ATIVO"]}`, 'TONALIDADE', 'ATIVO');
  $('#btnTonalidade').pesquisa_serversideSel('#txtTonalidade', `{ "tabela":"MAT_ITEN", "camposSelect":[ "TONALIDADE", "ATIVO" ], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "ATIVO"]}`, 'Pesquisa de Tonalidade');

  $('#txtTonalidade').addClass('camposFiltros');
  $('#btnLimpaTonalidade').on('click', function () {
    $('#txtTonalidade').empty().trigger('change')
    $('#txtTonalidade').val('');
    $('#txtTonalidade').attr('data-chave', '');
    $('#txtTonalidade').attr('data-desc', '');
  });

  $('#txtDoctoMatMov').pesquisa_variosServerside(1, `{ "tabela":"MAT_MOV", "camposSelect":[ "NUM_DOCTO", "DEPOSITO" ], "groupBy": ["NUM_DOCTO", "DEPOSITO"]}`, 'NUM_DOCTO', 'DEPOSITO');
  $('#btnDoctoMatMov').pesquisa_serversideSel('#txtDoctoMatMov', '{"tabela":"MAT_MOV", "camposSelect":[ "NUM_DOCTO", "DEPOSITO"], "groupBy": ["NUM_DOCTO", "DEPOSITO"]}', 'Pesquisa Documento');

  $('#btnLimpaDoctoMatMov').on('click', function () {
    $('#txtDoctoMatMov').empty().trigger('change');
  });

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  async function retornaFiltros() {

    const tipoMov = $('#radioEntrada').is(':checked') ? 'E' : $('#radioSaida').is(':checked') ? 'S' : '';
    const codigo = await formataListas($('#txtMaterial').val().toString());
    let deposito = await formataListas($('#txtDepositoUsuario').val().toString());
    if (deposito == '') {
      deposito = filtroDeposito;
    }
    // deposito = deposito != ''
    //   ? deposito : filtroDeposito.replaceAll('["CODIGO IN (', '').replaceAll(')"]', '') != 'null'
    //     ? filtroDeposito.replaceAll('["CODIGO IN (', '').replaceAll(')"]', '')
    //     : '';
    const qualidade = await formataListas($('#txtQualidade').val().toString());
    const grupo = await formataListas($('#txtGrupoMA').val().toString());
    const subgrupo = await formataListas($('#txtSubGrupo').val().toString());
    const lote = await formataListas($('#txtLote').val().toString());
    const cor = await formataListas($('#txtCor').val().toString());
    const obs = $('#txtObs').val();
    const doctos = await formataListas($('#txtDoctoMatMov').val().toString());
    const dataDe = $('#txtDataDe').val();
    const dataAte = $('#txtDataAte').val();
    const loteInterno = await formataListas($('#txtLoteInterno').val().toString())
    const tonalidade = await formataListas($('#txtTonalidade').val().toString())

    const retorno = `TIPOMOV=${tipoMov}` +
      `&CODIGO=${codigo}` +
      `&DEPOSITO=${deposito}` +
      `&QUALIDADE=${qualidade}` +
      `&GRUPO=${grupo}` +
      `&SUBGRUPO=${subgrupo}` +
      `&LOTE=${lote}` +
      `&COR=${cor}` +
      `&OBS=${obs}` +
      `&DOCTO=${doctos}` +
      `&DATADE=${dataDe}` +
      `&DATAATE=${dataAte}` +
      `&LOTE_INTERNO=${loteInterno}` +
      `&TONALIDADE=${tonalidade}`;
    return retorno;
  };

  retornaHintRelatorio('btnImprimir', 'relmovestoquemat')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        if ($('#tabelaRelMovimentacao').DataTable().rows().count() != 0) {
          const url = `/sisplan/impressao/v1/movestoquemat?`;
          const filtros = await retornaFiltros();
          const ordem = `&TELA_ORDENACAO=RelMovimentacaoDeEstoqueMat&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
          const bImprimeAutomatico = await verificaImprimirAutomatico('RelMovimentacaoDeEstoqueMat');
          const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 100000, false, 'RelMovimentacaoDeEstoqueMat');
          if (arquivo != undefined) {
            if (!bImprimeAutomatico) {
              window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            }
            await limparRelatorios();
          }
        } else {
          msgAlerta('Não há itens para imprimir!');
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      if ($("#txtOrdem option").toArray().lenght > 0) {
        retornaHintRelatorio('btnImprimir', $('#txtOrdem option').toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
      }
      try {
        let dataSetCols = [];
        const url = '/sisplan/impressao/v1/consultamovestoquemat?';
        const filtros = await retornaFiltros();
        const response = await requisicao('GET', url, filtros, 30000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta('Nenhum registro encontrado!');
          if ($.fn.DataTable.isDataTable('#tabelaRelMovimentacao')) {
            $('#tabelaRelMovimentacao').DataTable().clear().draw(false);
          }
          return;
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k
          });
        });

        $('#tabelaRelMovimentacao').DataTable({
          destroy: true,
          language: {
            sEmptyTable: 'Nenhum registro encontrado',
            sInfo: '_TOTAL_ registros',
            sInfoEmpty: ' 0 registros',
            sInfoFiltered: '(Filtrados de _MAX_ registros)',
            sInfoPostFix: '',
            sInfoThousands: '.',
            sLengthMenu: '_MENU_ resultados',
            sLoadingRecords: 'Carregando...',
            sProcessing: 'Processando...',
            sZeroRecords: 'Nenhum registro encontrado',
            sSearch: 'Pesquisar',
            oPaginate: {
              sNext: 'Próximo',
              sPrevious: 'Anterior',
              sFirst: 'Primeiro',
              sLast: 'Último',
            },
            oAria: {
              sSortAscending: ': Ordenar colunas de forma ascendente',
              sSortDescending: ': Ordenar colunas de forma descendente',
            },
          },
          autoWidth: true,
          "colReorder": true,
          "data": jsonStr,
          "columns": dataSetCols,
          "columnDefs": [
            {
              targets: colunas.relatorioMovimentacaoMat ?? [],
              visible: false,
            },
            {
              "targets": [10],
              "className": 'pr-4 text-right'
            }
          ]
        });

        $('#tabelaRelMovimentacao_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelMovimentacao_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/sisplan/impressao/v1/consultamovestoquemat?';
          const filtros = await retornaFiltros();
          await exportaCSV(url, filtros, false, null, 'Relatório de Movimentação de Estoque de Materiais', '#tabelaRelMovimentacao');
        })

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaRelMovimentacao').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relatorioMovimentacaoMat).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });


  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelMovimentacao').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relatorioMovimentacaoMat ?? [])
  })

  async function criaCampoDocto() {

    $('#txtDoctoMatMov').select2({
      placeholder: 'Selecione o(s) registro(s)',
      tags: true,
      allowClear: false,
      language: {
        noResults: function () {
          return ''
        }
      },

    });

    $('.txtDoctoMatMov').trigger('click');

    const id = $('#txtDoctoMatMov')[0].id;
    $($($($('#txtDoctoMatMov').parent().children()[1]).children()[0]).children().children()[0]).addClass(id);

    $('#txtDoctoMatMov').on('select2:open', function () {
      $('.select2-search__field').keyup(function (e) {
        if (e.keyCode == 115) {
          const idBotaoPesquisa = this.parentElement.parentElement.parentElement.parentElement.parentElement.parentElement.children[2].children[0].id
          $(`#${idBotaoPesquisa}`).trigger('click')
          e.preventDefault();
          e.stopPropagation();
        };
      });

      const maxWidth = parseFloat($(`.${id}`).css('width')) - 3;
      $('.select2.select2-container.select2-container--default').css('flex', '1');
      $('.select2-search__field').attr('style', function (i, s) { return s + 'height: 100% !important;' });
      //$('.select2-selection__rendered').attr('style', function(i, s) { return s + 'overflow: hidden !important;' });

      if ($(`.select2-selection__rendered.${id}`).length > 0) {
        $(`.select2-selection__rendered.${id}`)[0].style.position = "absolute";
        $(`.select2-selection__rendered.${id}`)[0].style.zIndex = 99999999;

        $(`.select2-selection__rendered.${id}`).on("keydown", function (e) {
          setTimeout(() => { $(".select2-results").removeClass("d-none"); }, 200);
        })

      } else {
        $(`.select2-selection__rendered`)[0].style.position = "absolute";
        $(`.select2-selection__rendered`)[0].style.zIndex = 99999999;

        $(`.select2-selection__rendered`).on("keydown", function (e) {
          setTimeout(() => { $(".select2-results").removeClass("d-none"); }, 200);
        })

      }

      // $(`.${id}`).css('max-width', `${maxWidth}px`);

      $('#txtDoctoMatMov').on('select2:open', function () {
        $('.select2-search__field').keyup(function (e) {
          if (e.keyCode == 115) {
            const idBotaoPesquisa = $('#txtDoctoMatMov').parentElement.parentElement.parentElement.parentElement.parentElement.parentElement.children[2].children[0].id
            $(`#${idBotaoPesquisa}`).trigger('click')
            e.preventDefault();
            e.stopPropagation();
          };
        });

        $('.select2-selection__rendered').css('z-index', ''); // remove z-index de todos os select
        $('#txtDoctoMatMov').siblings('.select2-container').find('.select2-selection__rendered').css('z-index', '99999999'); // adiciona z-index no select aberto
        if ($(`.${id}`).length > 0) {
          $(`.${id}`).css('height', '');
        } else {
          $(".select2-selection__rendered").css('height', '');
        }

        if ($('#txtDoctoMatMov').val().length > 0 && $(".select2-search__field").val() != "") {
          $(".select2-results").removeClass("d-none");
        } else if ($('#txtDoctoMatMov').val().length > 0) {
          $(".select2-results").addClass("d-none");
        } else {
          $(".select2-results").removeClass("d-none");
        }

      });


      $('#txtDoctoMatMov').on('select2:close', function () {
        if ($(`.${id}`).length > 0) {
          $(`.${id}`).css('height', '35px');
        } else {
          $(".select2-selection__rendered").css('height', '35px');
        }
      });

    });
  }
});