$(document).ready(async function () {
  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para Imprimir um relatório.',
          position: 'right'
        }
      }
      ]);
      driver.start();
    });
  });
  /////////////////////////
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relEspelhoPedido == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEspelhoPedido: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  $('#btnConfirmarColunas').on('click', async function () {
    $.LoadingOverlay('show');
    try {

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEspelhoPedido: novasColunas }))

      $('#tabelaPedidos').DataTable().columns().visible(true);

      $('#tabelaPedidos').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaPedidos').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relEspelhoPedido ?? [])
  })

  await adicionaPesquisas()

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  async function retornaFiltros() {
    const rgItens = $('#rdItensProduto').is(':checked') ? 1 : $('#rdItensMaterial').is(':checked') ? 2 : 0;
    const rgTipoPed = $('#rdTipoPedidoPai').is(':checked') ? 1 : $('#rdTipoPedidoFilho').is(':checked') ? 2 : 0;
    const rgQtde = $('#rdQtdeCancelado').is(':checked') ? 1 : $('#rdQtdeFatPed').is(':checked') ? 2 : $('#rdQtdeFatFat').is(':checked') ? 3 : $('#rdQtdeReservado').is(':checked') ? 4 : $('#rdQtdeTotal').is(':checked') ? 5 : 0;
    const rgFiltro = $('#rgFiltroLiberadoFin').is(':checked') ? 1 : $('#rgFiltroLiberadoCom').is(':checked') ? 2 : $('#rgFiltroBloqueadoFin').is(':checked') ? 3 : $('#rgFiltroBloqueadoCom').is(':checked') ? 4 : 0;
    const empresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')]

    const filtros = `EMISSAODE=${$('#dtEmissaoDe').val()}` +
      `&EMISSAOATE=${$('#dtEmissaoAte').val()}` +
      `&ENTREGADE=${$('#dtEntregaDe').val()}` +
      `&ENTREGAATE=${$('#dtEntregaAte').val()}` +
      `&DIGITACAODE=${$('#dtDigitacaoDe').val()}` +
      `&DIGITACAOATE=${$('#dtDigitacaoAte').val()}` +
      `&PREVISAOFATURAMENTODE=${$('#dtPrevisaoFaturamentoDe').val()}` +
      `&PREVISAOFATURAMENTOATE=${$('#dtPrevisaoFaturamentoAte').val()}` +
      `&SAIDADE=${$('#dtSaidaDe').val()}` +
      `&SAIDAATE=${$('#dtSaidaAte').val()}` +
      `&PEDIDO=${await formataListas($('#txtPedido').val().toString())}` +
      `&REPRESENTANTE=${await formataListas($('#txtRepresentante').val().toString())}` +
      `&PRODUTO=${await formataListas($('#txtProduto').val().toString())}` +
      `&GRUPOCLI=${await formataListas($('#txtGrupoCli').val().toString())}` +
      `&CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
      `&COLECAO=${await formataListas($('#txtColecao').val().toString())}` +
      `&NOTA=${await formataListas($('#txtNota').val().toString())}` +
      `&RGITENS=${rgItens}` +
      `&RGTIPOPED=${rgTipoPed}` +
      `&RGQTDE=${rgQtde}` +
      `&EMPRESAS=${await formataListas(empresas.toString())}` +
      `&RGFILTRO=${rgFiltro}`

    return filtros
  }

  retornaHintRelatorio('btnImprimir', 'RelEspelhoPedido')
  preencheOrdenacaoTela('RelEspelhoPedido');

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = "/sisplan/impressao/v1/relespelhopedido?";

        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelEspelhoPedido&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelEspelhoPedido');
        let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'POST', 480000, false, 'RelEspelhoPedido');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      $('#itensTitle').addClass('d-none')
      await buscaDados()
      $('#modal-filtros').modal('hide')
      $('#itensTitle').removeClass('d-none')
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function buscaDados() {
    const url = "/sisplan/impressao/v1/relespelhopedido?";
    const filtros = await retornaFiltros()
    const response = await requisicao("GET", url, filtros, "", 480000);

    if (!response) {
      return;
    }

    const jsonStr = await response.json()
    if (response.status != 200) {
      throw new Error(jsonStr['RESULT'][0].mensagem);
    }

    if (jsonStr[0].length <= 0) {
      throw new Error('Nenhum registro encontrado!')
    }

    const tbPedidos = jsonStr[0]
    const tbItens = jsonStr[1]

    await montaDataTablePedidos(tbPedidos)
    await montaDataTableItens(tbItens)
  }

  async function montaDataTablePedidos(jsonStr) {
    const dataSetCols = []
    const keys = Object.keys(jsonStr[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    $('#tabelaPedidos').DataTable({
      bPaginate: true,
      search: false,
      destroy: true,
      colReorder: true,
      info: true,
      language: {
        sEmptyTable: "Nenhum registro encontrado na tabela de pedidos",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado na tabela de pedidos",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      columnDefs: [
        {
          "type": 'date-br',
          "targets": [10, 14, 15, 17,],
          "render": function (data) {
            if (data != undefined) {
              x = data.slice(0, 10).split('-');
              return `${x[2]}/${x[1]}/${x[0]}`;
            } else {
              return ''
            }
          }
        }]
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaPedidos_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
    $('#tabelaPedidos_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVis').prop('title', 'Configurar colunas visíveis');
    $('#buttonExcel').prop('title', 'Exportar');

    $('#buttonColVis').on('click', async function () {
      $.LoadingOverlay('show');
      try {
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide');
      }
    });

    $('#buttonExcel').on('click', async function () {
      const dados = $("#tabelaPedidos").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Relatório de espelho de pedido', '#tabelaPedidos', '', 999, false, false, dados);
    })

    $('#tabelaPedidos').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.relEspelhoPedido).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  async function montaDataTableItens(jsonStr) {
    const dataSetCols = []
    const keys = Object.keys(jsonStr[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    $('#tabelaItens').DataTable({
      bPaginate: true,
      search: false,
      destroy: true,
      colReorder: true,
      info: true,
      language: {
        sEmptyTable: "Nenhum registro encontrado na tabela de pedidos",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado na tabela de pedidos",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr
    });
  }

  $('#btnLimparFiltros').on('click', async function () {
    $('#dtEmissaoDe').val('1200-01-01')
    $('#dtEmissaoAte').val('2500-12-31')
    $('#dtEntregaDe').val('1200-01-01')
    $('#dtEntregaAte').val('2500-12-31')
    $('#dtDigitacaoDe').val('1200-01-01')
    $('#dtDigitacaoAte').val('2500-12-31')
    $('#dtPrevisaoFaturamentoDe').val('1200-01-01')
    $('#dtPrevisaoFaturamentoAte').val('2500-12-31')
    $('#dtSaidaDe').val('1200-01-01')
    $('#dtSaidaAte').val('2500-12-31')

    $('#txtPedido').empty().trigger('change')
    $('#txtRepresentante').empty().trigger('change')
    $('#txtProduto').empty().trigger('change')
    $('#txtGrupoCli').empty().trigger('change')
    $('#txtCliente').empty().trigger('change')
    $('#txtColecao').empty().trigger('change')
    $('#txtNota').empty().trigger('change')

    $('#rdItensProduto').prop('checked', true)
    $('#rdTipoPedidoPai').prop('checked', true)
    $('#rdQtdePendente').prop('checked', true)
    $('#rgFiltroTodos').prop('checked', true)
  })

  async function adicionaPesquisas() {
    // componenteFiltro('pedido', true, true)
    componenteFiltro('representante', true, true)
    componenteFiltro('produto', true, true)
    componenteFiltro('grupoCli', true, true)
    componenteFiltro('cliente', true, true)
    componenteFiltro('colecao', true, true)

    $('#txtNota').pesquisa_variosServerside(1, '{ "tabela":"NOTA", "camposSelect":[ "FATURA", "SERIE" ], "where": null}', 'FATURA', 'SERIE');
    $('#btnNota').pesquisa_serversideSel('#txtNota', `{ "tabela":"NOTA", "camposSelect":[ "FATURA", "SERIE" ], "where": null}`, 'Pesquisa de Nota');
    $('#btnLimpaNota').on('click', function () { $('#txtNota').empty().trigger('change') })

    $('#txtPedido').pesquisa_variosServerside(1, '{ "tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI"], "where": null}', 'NUMERO', 'CODCLI');
    $('#btnPedido').pesquisa_serversideSel('#txtPedido', `{ "tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI", "PED_CLI" ], "where": null}`, 'Pesquisa de Pedido');
    $('#btnPedido').on('click', function () { $('#txtPedido').empty().trigger('change') })
  }

});