/* eslint-disable camelcase */
async function avancarPag() {

    if ($("#txtCodigo").val() == '') {
        $("#txtCodigo").val(' ');
    }
    if ($("#txtRegiao").val() == '') {
        $("#txtRegiao").val(' ');
    }
    if ($("#txtTipoTabela").val() == '') {
        $("#txtTipoTabela").val(0);
    }

    current_fs = $(this).parent();
    next_fs = $(this).parent().next();

    $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");

    next_fs.show();
    current_fs.animate({
        opacity: 0
    }, {
        step(now) {
            opacity = 1 - now;

            current_fs.css({
                'display': 'none',
                'position': 'relative'
            });
            next_fs.css({
                'opacity': opacity
            });
        },
        duration: 600
    });
}

$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    avancarPag();
                    $('#avancar1').trigger('click');
                };
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'checkTour') {
                    $('#voltar').trigger('click');
                };
            }
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#codigotuto',
            popover: {
                title: 'Código',
                description: 'O campo de código é preenchido automaticamente após gravar o registro.',
                position: 'top'
            }
        },
        {
            element: '#desctuto',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para a tabela de preço.',
                position: 'top'
            }
        },
        {
            element: '#tipotabelatuto',
            popover: {
                title: 'Tipo da Tabela',
                description: 'Aqui selecionamos o tipo de tabela que será, compra ou venda.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description: "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#checkTour',
            popover: {
                title: 'Opções',
                description: 'Aqui estão algumas configurações da região.',
                position: 'right'
            }
        },
        {
            element: '.my-div',
            popover: {
                title: 'Moedas',
                description: 'Aqui podemos adicionar os tipo de moedas aceitas para essa tabela.',
                position: 'right'
            }
        },
        {
            element: '#tabela-empAcesso',
            popover: {
                title: 'Empresas',
                description: 'Nessa tabela, podemos selecionar as empresas que usarão essa tabela de preço.',
                position: 'right'
            }
        },
        {
            element: '#labelTour',
            popover: {
                title: 'Tipo da Região',
                description: 'Aqui você selecionará o tipo da região.',
                position: 'left'
            }
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique nesse botão para gravar região.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {


    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let regiao = parametros[parametros.length - 1];
    let listaMoeda = [];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('REGIAO', getCookie('usuario'), regiao);
        window.location.href = `${BASE_URI}/tabeladepreco`;
    });

    let current_fs;
    let next_fs;
    let previous_fs; // fieldsets
    let opacity;

    $('#txtCom1').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtCom2').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtIndice').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtPerc').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtIndice').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtPrecoKG').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#tabelaMoedas').DataTable({
        paging: false,
        autoWidth: true,
        filter: false,
        info: false,
        ordering: false,
        destroy: true,
        scrollY: "220px",
        autowidth: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }

        }
    });

    $('#tabela-empAcesso').DataTable({
        paging: false,
        autoWidth: true,
        filter: false,
        info: false,
        ordering: false,
        destroy: true,
        scrollY: "220px",
        autowidth: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });

    let dataSet = await RetornaEmpresas();

    function botaoSelecionarGrid() {
        return '<div class="form-check icheck-primary">' +
            '<input type="checkbox" class="align-self-center checkEmpresa" value""><label></label>' +
            '</div>';
    };

    $('#tabela-empAcesso').DataTable().rows().remove().draw(false);
    for (let i = 0; i < dataSet.length; i++) {
        const empresa = dataSet[i];
        $('#tabela-empAcesso').DataTable().row.add([botaoSelecionarGrid(), `${empresa.EMP_PAT} - ${empresa.EMP_NOME}`]).draw(false);
    }

    $('#tabela-empAcesso').on('click', 'td', function () {
        selecionarLinhaTabela('#tabela-empAcesso', 'checkEmpresa', this);
    });

    async function RetornaEmpresas() {
        const url = `/sisplan/funcoes/v1/pesquisa?`;
        const params = `JSON={"tabela":"empresa", "camposSelect":[ "Replace(emp_pat,'_','') emp_pat", "emp_nome"], "where": null}`;

        try {
            let response = await requisicao('GET', url, params, null);

            if (!response) {
                return '';
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return '';
            }

            const arrDados = jsonStr.RESULT[0];
            return arrDados;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar as empresas.');
            return '';
        }
    }

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtCodigo: {
                required: true,
            },
            txtRegiao: {
                required: true,
            },
            txtTipoTabela: {
                required: true,
            }
        },
        messages: {
            txtCodigo: {
                required: "Informe um código válido.",
            },
            txtRegiao: {
                required: "Informe uma descrição válida."
            },
            txtTipoTabela: {
                required: "Selecione um tipo de tabela."
            }

        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    $(".next").click(function () {

        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
            current_fs = $(this).parent();
            next_fs = $(this).parent().next();

            $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");

            next_fs.show();
            current_fs.animate({
                opacity: 0
            }, {
                step(now) {
                    opacity = 1 - now;

                    current_fs.css({
                        'display': 'none',
                        'position': 'relative'
                    });
                    next_fs.css({
                        'opacity': opacity
                    });
                },
                duration: 600
            });
            $("#tabelaMoedas").DataTable().columns.adjust().draw(false);
        }
    });



    $(".previous").click(function () {

        current_fs = $(this).parent();
        previous_fs = $(this).parent().prev();

        $("#progressbar li").eq($("fieldset").index(current_fs)).removeClass("active");
        previous_fs.show();
        current_fs.animate({
            opacity: 0
        }, {
            step(now) {
                opacity = 1 - now;
                current_fs.css({
                    'display': 'none',
                    'position': 'relative'
                });
                previous_fs.css({
                    'opacity': opacity
                });
            },
            duration: 600
        });
    });

    $("#btnIncluir").click(function () {
        limpaCampos();
    });

    async function limpaCampos() {
        if ($('#txtMoedaTabela').val() != '') {
            try {
                $.LoadingOverlay("show");
                addMoeda();
                $('#txtMoedaTabela').val('');
            } finally {
                $.LoadingOverlay('hide');
            }
        } else {
            msgAlerta('Informe uma moeda para incluir.');

        }
    };

    async function addMoeda() {
        let moeda = pegaChave('#txtMoedaTabela');
        let descMoeda = pegaDescricao('#txtMoedaTabela');
        if (!listaMoeda.includes(moeda)) {
            $('#tabelaMoedas').DataTable().row.add([moeda, descMoeda,
                '<div style="text-align:center;"> ' +
                '   <button class="btn btn-info btn-sm btnExluirMoeda" type="button"> ' +
                '      Excluir' +
                '   </button> ' +
                '</div>'
            ]).draw(false);
            listaMoeda.push(moeda);
        } else {
            msgAlerta('Moeda já está na tabela.');
        }
    };

    async function buscaEmpValor(valor, tabela) {
        const url = "/Sisplan/Funcoes/v1/pesquisa?";
        const response = await requisicao(
            "GET",
            url,
            `JSON={ "tabela":"EMP_VALOR", "camposSelect":["EMP_ID"], "where": ["TABELA = '${tabela}'", "VALOR = '${valor}'"]}`
        );

        if (!response) {
            return [];
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return [];
        }
        return jsonStr.RESULT[0];
    }

    $('#tabelaMoedas').on('click', '.btnExluirMoeda', async function () {
        $('#tabelaMoedas').DataTable()
            .row($(this).parents('tr'))
            .remove()
            .draw(false);
    });

    $('#txtCodigo').prop('disabled', true);

    $('#txtMoedaTabela').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "CODMOE chave", "DESCRICAO descricao"], "where": null}`);

    $('#btnMoeda').pesquisa('#txtMoedaTabela', 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"moeda", "camposSelect":[ "CODMOE", "DESCRICAO"]}`, 'Pesquisa Moeda', 'moeda');
    $('#btnAMoeda').on('click', function () {
        $('#txtMoedaTabela').val('');
    });

    try {
        let response1 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"regiao", 
                    "camposSelect":["count(REGIAO) as CONTAGEM"], 
                    "where": ["1 = 1"]}`, null);
        let jsonStr1 = await response1.json();
        $('#txtOrdem').val(jsonStr1.RESULT[0][0].CONTAGEM + 1);
    } catch (error) {
        console.error(error);
    }

    async function executaSelectEmpresa(codRegiao, tabela) {
        try {
            const empValor = await buscaEmpValor(codRegiao, tabela);
            const url = '/Sisplan/Funcoes/v1/pesquisa?';

            if (empValor.length > 0) {
                return empValor;
            }
            const response = await requisicao('GET', url, `JSON={ "tabela":"REGIAO", "camposSelect":["EMPRESA", "REGIAO"], "where": ["REGIAO = '${codRegiao}'"]}`);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return;
            }

            const dadosFormatados = [];
            if (jsonStr.RESULT[0].length > 0) {
                const dados = {};
                dados.EMP_ID = jsonStr.RESULT[0][0].EMPRESA;
                dados.VALOR = jsonStr.RESULT[0][0].REGIAO;
                dadosFormatados.push(dados);
                return dadosFormatados;
            }

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar as empresas.`);
        }

    }

    if (regiao != '' && regiao != 'create') {

        if (await liberarRegistro('REGIAO', regiao) == false) {
            window.location.href = '../tabeladepreco';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"REGIAO", "camposSelect":["COM2", "COM1", "TIPO", "PADRAO_VAREJO", 
                                                               "PADRAO_ATACADO", "PADRAO_PROD", "PADRAO", 
                                                               "LIBERADO", "REGIAO", "DESCRICAO", "EMPRESA", 
                                                               "TIPO_TABELA", "ORDEM", "INDICE", "PERC", "OBS", "PRECO_KG",
                                                               "MOEDA_VINC"], 
                            "where": ["regiao = '${regiao}'"]}`, null);
                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    const codigo = jsonStr.RESULT[0][0].REGIAO;
                    const tabela = 'REGIAO';

                    let dadosEmpresaUsuario = await executaSelectEmpresa(codigo, tabela);

                    if (dadosEmpresaUsuario != '') {
                        for (let i = 0; i < dadosEmpresaUsuario.length; i++) {
                            for (let x = 0; x < $('#tabela-empAcesso').DataTable().rows().data().length; x++) {
                                let dados = $('#tabela-empAcesso').DataTable().rows().data()[x];
                                let empresa = dados[1].substr(0, 3);
                                let empID = (await buscaValor('EMPRESA', 'EMP_ID', 'EMP_PAT', `_${empresa}`)).EMP_ID;
                                if (empID == dadosEmpresaUsuario[i].EMP_ID) {
                                    $($('.checkEmpresa')[x]).prop('checked', true);
                                    $($("table#tabela-empAcesso tr")[x + 1]).addClass("selected");
                                }
                            }
                        }
                    }

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].REGIAO);
                    $('#txtRegiao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#txtOrdem').val(jsonStr.RESULT[0][0].ORDEM);
                    $('#txtCom1').val(jsonStr.RESULT[0][0].COM1);
                    $('#txtCom2').val(jsonStr.RESULT[0][0].COM2);
                    $('#txtIndice').val(jsonStr.RESULT[0][0].INDICE);
                    $('#txtPrecoKG').val(jsonStr.RESULT[0][0].PRECO_KG);
                    $('#txtPerc').val(jsonStr.RESULT[0][0].PERC);
                    $('#txtObs').val(jsonStr.RESULT[0][0].OBS);

                    if (jsonStr.RESULT[0][0].MOEDA_VINC != null && jsonStr.RESULT[0][0].MOEDA_VINC != undefined && jsonStr.RESULT[0][0].MOEDA_VINC != '') {
                        listaMoeda = jsonStr.RESULT[0][0].MOEDA_VINC.split(',');
                        let responseMoeda = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela":"moeda", "camposSelect":["codmoe", "descricao"], 
                                    "where": ["codmoe IN (${listaMoeda})"]}`, null);
                        let jsonStrMoeda = await responseMoeda.json();
                        for (let i = 0; i < listaMoeda.length; i++) {
                            $('#tabelaMoedas').DataTable().row.add([jsonStrMoeda.RESULT[0][i].CODMOE, jsonStrMoeda.RESULT[0][i].DESCRICAO,
                            '<div style="text-align:center;"> ' +
                            '   <button class="btn btn-info btn-sm btnExluirMoeda" type="button"> ' +
                            '      Excluir' +
                            '   </button> ' +
                            '</div>'
                            ]).draw(false);
                        }
                    }

                    if (jsonStr.RESULT[0][0].TIPO_TABELA == "C") {
                        $('#txtTipoTabela').val(0);
                    }

                    if (jsonStr.RESULT[0][0].TIPO_TABELA == "V") {
                        $('#txtTipoTabela').val(1);
                    }

                    if (jsonStr.RESULT[0][0].LIBERADO == "S") {
                        $('#checkLiberado').prop('checked', true);
                    } else {
                        $('#checkLiberado').prop('checked', false);
                    }

                    if (jsonStr.RESULT[0][0].PADRAO == "S") {
                        $('#checkPadrao').prop('checked', true);
                    }

                    if (jsonStr.RESULT[0][0].PADRAO_PROD == "S") {
                        $('#checkPadProd').prop('checked', true);
                    }

                    if (jsonStr.RESULT[0][0].PADRAO_ATACADO == "S") {
                        $('#checkPadAta').prop('checked', true);
                    }

                    if (jsonStr.RESULT[0][0].PADRAO_VAREJO == "S") {
                        $('#checkPadVar').prop('checked', true);
                    }

                    if (jsonStr.RESULT[0][0].TIPO == "T") {
                        $('#inputTerceiro').prop('checked', true);
                    }

                    if (jsonStr.RESULT[0][0].TIPO == "L") {
                        $('#inputLoja').prop('checked', true);
                    }

                    if (jsonStr.RESULT[0][0].TIPO == "V") {
                        $('#inputVarejo').prop('checked', true);
                    }

                    if (jsonStr.RESULT[0][0].TIPO == "C") {
                        $('#inputComercial').prop('checked', true);
                    }

                    if (jsonStr.RESULT[0][0].TIPO == "A") {
                        $('#inputAtacado').prop('checked', true);
                    }

                    if (jsonStr.RESULT[0][0].TIPO == "M") {
                        $('#inputMostruario').prop('checked', true);
                    }

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da região: ${error}`);
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $('.radio-group .radio').click(function () {
        $(this).parent().find('.radio').removeClass('selected');
        $(this).addClass('selected');
    });

    $(".submit").click(function () {
        return false;
    });

    $("#btnGravar").click(async function () {

        let validaPadrao = true;

        if ($('#checkPadrao').prop('checked')) {
            try {
                let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"regiao", 
                "camposSelect":["padrao"], 
                "where": ["regiao != '${$('#txtCodigo').val()}'"]}`, null);

                if (!responseOperadora) {
                    return;
                }
                let jsonStrOperadora = await responseOperadora.json();
                if (responseOperadora.status != 200) {
                    msgErro(jsonStrOperadora.RESULT[0].mensagem);
                    return;
                }

                let existePadrao = false;
                for (let index = 0; index < jsonStrOperadora.RESULT[0].length; index++) {
                    if (jsonStrOperadora.RESULT[0][index].PADRAO == 'S') {
                        existePadrao = true;
                        break;
                    }
                }

                if (existePadrao == true) {
                    msgAlerta('Já existe uma região padrão.');
                    $('#checkPadrao').prop('checked', false);
                    validaPadrao = false;
                }
            } catch (error) {
                console.error(error);
            }
        }

        if (validaPadrao) {

            try {
                $.LoadingOverlay("show");

                regiao = {};

                regiao.DESCRICAO = $('#txtRegiao').val();
                regiao.REGIAO = $('#txtCodigo').val() == '' ? await RetornaProximo('REGIAO', 'REGIAO', 'REGIAO', 5) : $('#txtCodigo').val();

                regiao.MOEDA_VINC = '';
                let qtdeMoeda = $('#tabelaMoedas').DataTable().rows().count();
                for (let index = 0; index < qtdeMoeda; index++) {
                    let data = $('#tabelaMoedas').DataTable().row(index).data();
                    if (index == 0) {
                        regiao.MOEDA_VINC += data[0];
                    } else {
                        regiao.MOEDA_VINC += `,${data[0]}`;
                    }
                }

                if ($('#checkPadrao').prop('checked')) {
                    regiao.PADRAO = 'S';
                } else {
                    regiao.PADRAO = 'N';
                };

                if ($('#checkLiberado').prop('checked')) {
                    regiao.LIBERADO = 'S';
                } else {
                    regiao.LIBERADO = 'N';
                };

                regiao.OBS = $('#txtObs').val();

                if ($('#inputTerceiro').prop('checked')) {
                    regiao.TIPO = 'T';
                }
                if ($('#inputLoja').prop('checked')) {
                    regiao.TIPO = 'L';
                }
                if ($('#inputVarejo').prop('checked')) {
                    regiao.TIPO = 'V';
                }
                if ($('#inputComercial').prop('checked')) {
                    regiao.TIPO = 'C';
                }
                if ($('#inputAtacado').prop('checked')) {
                    regiao.TIPO = 'A';
                }
                if ($('#inputMostruario').prop('checked')) {
                    regiao.TIPO = 'M';
                }

                if ($('#checkPadProd').prop('checked')) {
                    regiao.PADRAO_PROD = 'S';
                } else {
                    regiao.PADRAO_PROD = 'N';
                };

                regiao.COM1 = parseFloat($('#txtCom1').val().replace(',', '.'));
                regiao.COM2 = parseFloat($('#txtCom2').val().replace(',', '.'));
                regiao.INDICE = $('#txtIndice').val();
                regiao.PERC = parseFloat($('#txtPerc').val().replace(',', '.'));
                regiao.PRECO_KG = parseFloat($('#txtPrecoKG').val().replace(',', '.'));

                regiao.ORDEM = $('#txtOrdem').val();


                if ($('#checkPadVar').prop('checked')) {
                    regiao.PADRAO_VAREJO = 'S';
                } else {
                    regiao.PADRAO_VAREJO = 'N';
                }

                if ($('#checkPadAta').prop('checked')) {
                    regiao.PADRAO_ATACADO = 'S';
                } else {
                    regiao.PADRAO_ATACADO = 'N';
                }

                if ($('#txtTipoTabela').val() == '0') {
                    regiao.TIPO_TABELA = 'C';
                }
                if ($('#txtTipoTabela').val() == '1') {
                    regiao.TIPO_TABELA = 'V';
                }

                let arrayEmpresas = [];
                for (let i = 0; i < $('#tabela-empAcesso').DataTable().rows('.selected').data().length; i++) {
                    let empresa = {};
                    const dados = $('#tabela-empAcesso').DataTable().rows('.selected').data()[i];
                    empresa.TABELA = 'REGIAO';
                    empresa.CAMPO = 'REGIAO';
                    empresa.EMP_ID = (await buscaValor('EMPRESA', 'EMP_ID', 'EMP_PAT', `_${dados[1].substr(0, 3)}`)).EMP_ID;
                    empresa.VALOR = regiao.REGIAO;

                    arrayEmpresas.push(empresa);
                }
                regiao.EMPRESA = arrayEmpresas;

                let response = await requisicao('POST', '/Sisplan/Cadastros/v1/regiao?', `JSON=${encodeURIComponent(JSON.stringify(regiao))}`, null);

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                };

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr.success(
                    `Cadastro efetuado com sucesso!
                    Região: ${regiao.REGIAO}`,
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/tabeladepreco`;
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgErro(`Não foi possível gravar os dados da região: ${error}`);
            }
        }
    });
});