<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Receber</title>

  <meta name="viewport" content="width=device-width, initial-scale=1">

  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2412.10.1">

  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2412.10.1">

  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.2412.10.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2412.10.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.2412.10.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2412.10.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2412.10.1" />
  <link rel="stylesheet" href="dist/css/select.bootstrap.min.css?versao=3.2412.10.1" />
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2412.10.1">
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2412.10.1">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2412.10.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2412.10.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2412.10.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.2412.10.1">
  <link rel="stylesheet" href="dist/css/cards-financeiro.css">

  <style>
    #msform {
      text-align: start;
      position: relative;
    }

    #myModalText {
      color: black;
      font-size: 17px;
    }

    td.ColunaVermelha {
      color: red;
    }

    .content-wrapper {
      margin-left: 0px !important;
    }

    .main-header,
    .main-sidebar,
    footer {
      display: none;
    }

    #tabelaReceber.table.dataTable tbody td {
      white-space: normal !important;
      text-overflow: inherit !important;
      overflow: inherit !important;
    }

    #tabelaHistorico.table.dataTable {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }


    .lista-botoes {
      display: none;
      position: absolute;
      top: calc(100% + 10px);
      left: 0;
      background-color: #121214;
      padding: 10px;
      width: max-content;
      z-index: 999;
    }

    #cbTodos {
      margin: 0px 0 0 20px;
      width: 21px;
      margin-bottom: 0px !important;
    }

    #scrollToBottomBtn {
      z-index: 10;
      padding: 10px 12px;
      background-color: #c2121a;
      color: white;
      border: none;
      border-radius: 18px;
      cursor: pointer;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
      position: fixed;
      bottom: 5rem;
      left: 50%;
      transform: translateX(-50%);
      animation: pulse 2s infinite ease-in-out;
    }

    @media (min-height: 300px) and (max-height: 349px) {
      #scrollToBottomBtn {
        bottom: 0rem;
      }
    }

    @media (min-height: 350px) and (max-height: 399px) {
      #scrollToBottomBtn {
        bottom: 0.5rem;
      }
    }

    @media (min-height: 400px) and (max-height: 449px) {
      #scrollToBottomBtn {
        bottom: 1rem;
      }
    }

    @media (min-height: 450px) and (max-height: 499px) {
      #scrollToBottomBtn {
        bottom: 1.5rem;
      }
    }

    @media (min-height: 500px) and (max-height: 549px) {
      #scrollToBottomBtn {
        bottom: 2rem;
      }
    }

    @media (min-height: 550px) and (max-height: 599px) {
      #scrollToBottomBtn {
        bottom: 2.5rem;
      }
    }

    @media (min-height: 600px) and (max-height: 649px) {
      #scrollToBottomBtn {
        bottom: 3rem;
      }
    }

    @media (min-height: 650px) and (max-height: 699px) {
      #scrollToBottomBtn {
        bottom: 3.5rem;
      }
    }

    @media (min-height: 700px) and (max-height: 749px) {
      #scrollToBottomBtn {
        bottom: 4rem;
      }
    }

    @media (min-height: 750px) and (max-height: 799px) {
      #scrollToBottomBtn {
        bottom: 4.5rem;
      }
    }

    @keyframes pulse {
      0% {
        transform: translateY(-7%)
      }

      50% {
        transform: translateY(0%)
      }

      100% {
        transform: translateY(-7%)
      }
    }

    .bordaRadio {
      border: 2px solid #e0e4e6;
      border-radius: 4px;
      /* height: 142px; */
      padding-right: 50px;
    }

    .spanDollar {
      width: 28% !important;
      height: 5vh !important;
    }
  </style>

</head>


<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <?php
    include_once('../../menu.php');
    ?>

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 id="tituloTela" class="m-0 text-dark">Contas a Receber</h1>
              <button title="Tutorial" type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">

            </div>
          </div>

          <div class="row" id="boxDashboard">
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12 d-flex p-0">
              <div class="col col-lg">
                <div id="valortotal" class="info-box d-flex align-items-center">
                  <span class="info-box-icon text-white spanDollar" style="background-color:var(--info-box-primary)"><i class="fas fa-dollar-sign"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text">Valor Total</span>
                    <span class="info-box-number" id="txt_val_total">0,00</span>
                  </div>
                </div>
              </div>

              <div class="col col-lg">
                <div id="valor" class="info-box d-flex align-items-center">
                  <span class="info-box-icon text-white spanDollar" style="background-color:var(--info-box-danger)"><i class="fas fa-dollar-sign"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text">Valor</span>
                    <span class="info-box-number" id="txt_val">0,00</span>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12 d-flex p-0">
              <div class="col col-lg">
                <div id="valorpago" class="info-box d-flex align-items-center">
                  <span class="info-box-icon text-white spanDollar" style="background-color:var(--info-box-danger)"><i class="fas fa-dollar-sign"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text">Valor Pago</span>
                    <span class="info-box-number" id="txt_val_pago">0,00</span>
                  </div>
                </div>
              </div>

              <div class="col col-lg">
                <div id="valorsaldo" class="info-box d-flex align-items-center">
                  <span class="info-box-icon text-white spanDollar" style="background-color:var(--info-box-success)"><i class="fas fa-dollar-sign"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text">Saldo Total</span>
                    <span class="info-box-number" id="txt_val_saldo">0,00</span>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12 d-flex p-0">
              <div class="col col-lg">
                <div id="valorsaldoselecionadas" class="info-box d-flex align-items-center">
                  <span class="info-box-icon text-white spanDollar" style="background-color:var(--info-box-success)"><i class="fas fa-dollar-sign"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text">Saldo Dupli. Selecionadas</span>
                    <span class="info-box-number" id="txt_val_selecionadas">0,00</span>
                  </div>
                </div>
              </div>

              <div class="col col-lg">
                <div id="valordesconto" class="info-box d-flex align-items-center">
                  <span class="info-box-icon text-white spanDollar" style="background-color:var(--info-box-primary)"><i class="fas fa-dollar-sign"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text">Desconto</span>
                    <span class="info-box-number" id="txt_desconto">0,00</span>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12 d-flex p-0">
              <div class="col col-lg">
                <div id="valorematraso" class="info-box d-flex align-items-center">
                  <span class="info-box-icon text-white spanDollar" style="background-color:var(--info-box-danger)"><i class="fas fa-dollar-sign"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text">Em Atraso</span>
                    <span class="info-box-number" id="txt_em_atraso">0,00</span>
                  </div>
                </div>
              </div>

              <div class="col col-lg">
                <div id="valorjurosmultacalc" class="info-box d-flex align-items-center">
                  <span class="info-box-icon text-white spanDollar" style="background-color:var(--info-box-danger)"><i class="fas fa-dollar-sign"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text">Juros + Multa Calc.</span>
                    <span class="info-box-number" id="txt_juros_multa_calc">0,00</span>
                  </div>
                </div>
              </div>
            </div>

          </div>

          <div class="row">
            <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
              <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content" id="modalBody">
                  <div class="modal-header">
                    <h4 class="modal-title">Filtros</h4>
                    <label style="margin-top: 12px; margin-left: 15px;" for="checkTodasEmpresas"><input type="checkbox" id="checkTodasEmpresas"> Todas Empresas</label>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body">
                    <div class="row">
                      <div class="col-lg-3 col-md-6 col-sm-6">
                        <label for="">Número:</label>
                        <div class="form-group input-group">
                          <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" id="txtNumero" name="numero" width="100%" placeholder="Número">
                        </div>
                      </div>
                      <div class="col-lg-3 col-md-6 col-sm-6">
                        <label for="">Fatura:</label>
                        <div class="form-group input-group">
                          <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" id="txtFatura" name="fatura" width="100%" placeholder="Fatura">
                        </div>
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6">
                      </div>

                      <div class="col-lg-4 col-md-12 col-sm-12">
                        <label data-error="wrong" data-success="right" for="txtDataEmiI">Emissão De/ Até:</label>
                        <div class="input-group">
                          <input type="date" max="2500-12-31" autocomplete="off" value="1200-01-01" class="input-default focus form-control" id="txtDataEmiI" class="form-control">
                          <input type="date" max="2500-12-31" autocomplete="off" value="2500-12-31" class="input-default focus form-control" id="txtDataEmiF" class="form-control">
                        </div>
                      </div>

                      <div class="col-lg-4 col-md-12 col-sm-12">
                        <label data-error="wrong" data-success="right" for="txtVenctoI">Vencimento De/ Até:</label>
                        <div class="input-group">
                          <input type="date" max="2500-12-31" autocomplete="off" value="1200-01-01" class="input-default focus form-control" id="txtVenctoI" class="form-control">
                          <input type="date" max="2500-12-31" autocomplete="off" value="2500-12-31" class="input-default focus form-control" id="txtVenctoF" class="form-control">
                        </div>
                      </div>

                      <div class="col-lg-4 col-md-6 col-sm-6">
                        <label data-error="wrong" data-success="right" for="txtVenctoI">Pagamento De/ Até:</label>
                        <div class="input-group">
                          <input type="date" max="2500-12-31" autocomplete="off" value="1200-01-01" class="input-default focus form-control" id="txtPagamentoI" class="form-control">
                          <input type="date" max="2500-12-31" autocomplete="off" value="2500-12-31" class="input-default focus form-control" id="txtPagamentoF" class="form-control">
                        </div>
                      </div>

                      <div class="col-lg-4 col-md-12 col-sm-12" id="ClienteInfoTour">
                        <label data-error="wrong" data-success="right" for="txtClienteConsulta">Cliente: </label>
                        <div class="relative">
                          <div class="input-group">
                            <select class="js-example-programmatic js-states form-control" id="txtClienteConsulta" name="txtClienteConsulta" multiple="multiple">
                            </select>
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btn-ClienteConsulta" name="btn-ClienteConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btn-limpa-ClienteConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-md-12 col-sm-12" id="RepresentanteInfoTour">
                        <label data-error="wrong" data-success="right" for="txtRepresentanteConsulta">Representante:</label>
                        <div class="form-group input-group">
                          <input type="text" class="input-default focus form-control" id="txtRepresentanteConsulta" name="txtRepresentanteConsulta" class="form-control" placeholder="Representante">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-RepresentanteConsulta" name="btn-RepresentanteConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-RepresentanteConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-md-12 col-sm-12" id="GuiaInfoTour">
                        <label data-error="wrong" data-success="right" for="txtGuia">Guia:</label>
                        <div class="form-group input-group">
                          <input type="text" class="input-default focus form-control" id="txtGuia" name="txtGuia" class="form-control" placeholder="Guia">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnGuia" name="btnGuia" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaGuia" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="group-default form-group">
                          <label for="Situacao">Situação:</label>
                          <div class="relative">
                            <select id="txtSituacao" class="input-default focus form-control validate">
                              <option value="Todos">Todos</option>
                              <option value="Em Aberto" selected>Em Aberto</option>
                              <option value="Perdidas">Perdidas</option>
                              <option value="Pagas">Pagas</option>
                              <option value="TodosPerdidas">Todos/Perdidas</option>
                              <option value="Parcialmente">Parcialmente pago</option>
                            </select>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="group-default form-group">
                          <label for="selectStatusNFe">Status NFe:</label>
                          <div class="relative">
                            <select id="selectStatusNFe" class="input-default focus form-control validate">
                              <option value="" selected>Todos</option>
                              <option value="S">Impressos</option>
                              <option value="N">Não impresso</option>
                              <!-- <option value="C">Canceladas</option>
                              <option value="D">Denegadas</option> -->
                            </select>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="group-default form-group">
                          <label for="selectSituacaoNFe">Situação NFe:</label>
                          <div class="relative">
                            <select id="selectSituacaoNFe" class="input-default focus form-control validate">
                              <option value="" selected>Todos</option>
                              <option value="1">Com protocolo</option>
                              <option value="2">Sem protocolo</option>
                            </select>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3 col-md-12 col-sm-12" id="MoedaInfoTour">
                        <label data-error="wrong" data-success="right" for="txtMoedaConsulta">Moeda:</label>
                        <div class="form-group input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtMoedaConsulta" name="txtMoedaConsulta" multiple="multiple">
                          </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnMoedaConsulta" name="btnMoedaConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaMoedaConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3 col-md-12 col-sm-12" id="ClasseGerInfoTour">
                        <label data-error="wrong" data-success="right" for="txtClasseGerConsulta">Classe Gerencial:</label>
                        <div class="form-group input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtClasseGerConsulta" name="txtClasseGerConsulta" multiple="multiple">
                          </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnClasseGerConsulta" name="btnClasseGerConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaClasseGerConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3 col-md-12 col-sm-12">
                        <label for="txtSituacaoConsulta">Situação:</label>
                        <div class="form-group input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtSituacaoConsulta" name="txtSituacaoConsulta" multiple="multiple">
                          </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnSituacaoConsulta" name="btnSituacaoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaSituacaoConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3 col-md-12 col-sm-12">
                        <label for="txtHistoricoConsulta">Histórico:</label>
                        <div class="form-group input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtHistoricoConsulta" name="txtHistoricoConsulta" multiple="multiple">
                          </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnHistoricoConsulta" name="btnHistoricoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaHistoricoConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3 col-md-12 col-sm-12">
                        <label for="txtBancoConsulta">Banco:</label>
                        <div class="form-group input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtBancoConsulta" name="txtBancoConsulta" multiple="multiple">
                          </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnBancoConsulta" name="btnBancoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaBancoConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3 col-md-12 col-sm-12">
                        <label for="txtContaConsulta">Conta:</label>
                        <div class="form-group input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtContaConsulta" name="txtContaConsulta" multiple="multiple">
                          </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnContaConsulta" name="btnContaConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaContaConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3 col-md-12 col-sm-12">
                        <label for="txtNumeroCaixa">Número Caixa:</label>
                        <div class="form-group input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtNumeroCaixa" name="txtNumeroCaixa" multiple="multiple">
                          </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnNumeroCaixa" name="btnNumeroCaixa" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaNumeroCaixa" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-3 col-md-12 col-sm-12">
                        <label for="txtNumeroChConsulta">Numero Cheque:</label>
                        <div class="form-group input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtNumeroChConsulta" name="txtNumeroChConsulta" multiple="multiple">
                          </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnNumeroChConsulta" name="btnNumeroChConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaNumeroChConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-9 col-md-9 col-sm-9 form-group">
                        <label for="Sstatus">Status:</label>
                        <div class="row w-100 bordaRadio p-1">
                          <div class="col-lg-3 col-md-3 col-sm-3">
                            <div class="form-check">
                              <input class="form-check-input" type="checkbox" id="cbDUPL">
                              <label for="cbDUPL">Duplicatas</label>
                            </div>
                            <div class="form-check">
                              <input class="form-check-input" type="checkbox" id="cbANTE">
                              <label for="cbANTE">Antecipações</label>
                            </div>
                            <div class="form-check">
                              <input class="form-check-input" type="checkbox" id="cbORCA">
                              <label for="cbORCA">Orçamentos</label>
                            </div>
                            <div class="form-check">
                              <input class="form-check-input" type="checkbox" id="cbCHEQ">
                              <label for="cbCHEQ">Cheques</label>
                            </div>
                          </div>
                          <div class="col-lg-5 col-md-5 col-sm-5">
                            <div class="form-check">
                              <input class="form-check-input" type="checkbox" id="cbCHDE">
                              <label for="cbCHDE">Cheques Devolvidos</label>
                            </div>
                            <div class="form-check">
                              <input class="form-check-input" type="checkbox" id="cbDESD">
                              <label for="cbDESD">Desdobradas</label>
                            </div>
                            <div class="form-check">
                              <input class="form-check-input" type="checkbox" id="cbAGRU">
                              <label for="cbAGRU">Agrupadas</label>
                            </div>
                            <div class="form-check">
                              <input class="form-check-input" type="checkbox" id="cbCANC">
                              <label for="cbCANC">Canceladas</label>
                            </div>
                          </div>
                          <div class="col-lg-4 col-md-4 col-sm-4">
                            <div class="form-check">
                              <input class="form-check-input" type="checkbox" id="cbDEVO">
                              <label for="cbDEVO">Devolução</label>
                            </div>
                            <div class="form-check">
                              <input class="form-check-input" type="checkbox" id="cbAVDD">
                              <label for="cbAVDD">Aviso Débito</label>
                            </div>
                            <div class="form-check">
                              <input class="form-check-input" type="checkbox" id="cbPRESENTE">
                              <label for="cbPRESENTE">Cartão Presente</label>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-3 form-group">
                        <div class="row">
                          <div class="col-lg-12 col-md-12 col-sm-12">
                            <label for="txtCartaoPresente">Cartão Presente:</label>
                            <div class="form-group input-group">
                              <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" id="txtCartaoPresente" name="CartaoPresente" width="100%" placeholder="Cartão Presente">
                            </div>
                          </div>

                          <div class="col-lg-12 col-md-12 col-sm-12">
                            <label for="txtBordero">Bordero</label>
                            <div class="form-group input-group">
                              <input type="number" class="input-default focus form-control" id="txtBordero" name="txtBordero" class="form-control" placeholder="Número Bordero">
                            </div>
                          </div>
                        </div>
                      </div>

                    </div>
                  </div>
                  <div class="modal-footer">
                    <div class="row col-lg-12 col-12">
                      <div class="col-lg-4 col-sm-6 col-md-6">
                        <label for="selectOrdemRel">Ordem Impressão:</label>
                        <div class="relative">
                          <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="txtOrdem" class="custom-select">
                          </select>
                        </div>
                      </div>
                      <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end pr-0">
                        <div class="d-flex">
                          <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                          <button id="btnConsultar" class='btn btn-primary float-right' type='button'><span class="fas fa-search"></span> Consultar </button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="container-fluid">
            <div class="row card pr-3">
              <div class="col-sm-12 mt-3">
                <button class="btn btn-primary" id="abreBotoes"><i class="seta-cima-baixo fas fa-angle-double-down"></i></button>
                <button class="btn btn-success btn-sisp" id="btnFiltros" type="button" data-toggle="collapse" data-target="#collapseFiltros" aria-expanded="false" aria-controls="collapseFiltros"><span class="fas fa-filter"></span> Filtros</button>
                <button class="btn btn-danger btn-sisp" id="btn-novoReceber"><span class="fas fa-plus"></span> Novo</button>
                <button class="btn btn-secondary btn-sisp" id="btnBaixar" data-toggle="modal" title="Selecione alguma duplicata para baixar" disabled><i class="far fa-arrow-alt-circle-down"></i> Baixar</button>
                <button class="btn btn-info btn-sisp" id="btnBaixarComAntecipacao" data-toggle="modal" title="Selecione alguma duplicata para baixar" disabled><i class="far fa-arrow-alt-circle-down"></i> Baixar com Antecipação</button>
                <button class="btn btn-success btn-sisp" id="btnImprimir" title="Selecione alguma duplicata para imprimir"><i class="fas fa-print"></i> Imprimir</button>
                <button class="btn btn-danger btn-sisp" id="btnImprimirBaixas" title="Selecione alguma duplicata para imprimir as baixas"><i class="fas fa-print"></i> Imprimir Baixas</button>
                <div class="lista-botoes">
                  <button class="btn btn-primary btn-sisp" id="btnDesdobrarAgrupar" title="Selecione alguma duplicata para desdobrar ou agrupar"><i class="fas fa-solid fa-wallet"></i> Desdobrar/Agrupar Duplicatas</button>
                  <button class="btn btn-success btn-sisp" id="btnAbreGeraBoleto"><i class="fas fa-scroll"></i> Abrir Geração de Boletos</button>
                </div>
              </div>

              <div class="col-sm-12 table-responsive card-body" id="tabelaTour">
                <table id="tabelaReceber" class="table table-sm table-select table-hover" width="100%">
                  <thead>
                    <th>Sel</th>
                    <th>Número</th>
                    <th>Fatura</th>
                    <th>Cod. Cli.</th>
                    <th>Cliente</th>
                    <th>Data Emissão</th>
                    <th>Data Vencimento</th>
                    <th>Valor Total</th>
                    <th>Valor</th>
                    <th>Valor Pago</th>
                    <th>Desconto</th>
                    <th>Juros</th>
                    <th>Saldo</th>
                    <th>Status</th>
                    <th>Dias Atraso</th>
                    <th>NSU</th>
                    <th>Bandeira</th>
                    <th>Taxa Bandeira</th>
                    <th>Empresa</th>
                    <th>Emp_Multa</th>
                    <th>Caixa</th>
                    <th>Moeda</th>
                    <th>Desc_moeda</th>
                    <th>Bordero</th>
                    <th>NRBanco</th>
                    <th>Histórico</th>
                    <th>Desc_Histórico</th>
                    <th>Situação</th>
                    <th>Desc_Situação</th>
                    <th>Classe</th>
                    <th>Desc_classe</th>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
          </div>

          <div class="modal fade bd-baixa-modal-xl" id="modalBaixar" tabindex="-1" role="dialog" aria-labelledby="ModalBaixa" aria-hidden="true">
            <div class="modal-dialog modal-xl">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="BaixaModal">Baixas Receber</h5>
                  <button type="button" class="close" id="CloseBaixa" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <button type="button" id="scrollToBottomBtn" class="fa fa-arrow-down" aria-hidden="true"></button>
                  <div class="container-fluid">
                    <div class="card">
                      <div class="card-body">
                        <form id="msform" name="msform">
                          <div class="form-row">
                            <div class="col-3 col-lg-3 form-group" id="divMoeda">
                              <label data-error="wrong" data-success="right" for="txtMoeda">Moeda *     
                                <!-- <input type="checkbox" id="cbNaoLancaCc" style="margin-right: 2px;">
                                <label for="cbNaoLancaCc" style="margin-bottom: 0rem!important;">
                                  Não lançar conta corrente
                                </label> -->
                              </label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtMoeda" name="txtMoeda" class="form-control" placeholder="Moeda">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnMoeda" name="btnMoeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-Moeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                                <input type="text" class="input-default focus d-none" id="txtTipoMoeda" name="txtTipoMoeda" class="form-control" placeholder="Tipo Moeda">
                              </div>
                            </div>
                            <div class="col-12 col-lg-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtConta">Conta </label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtConta" name="txtConta" class="form-control" placeholder="Conta">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnConta" name="btnConta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-Conta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                            <div class="col-6 col-lg-3 form-group d-none" id="lancaCaixa">
                              <label data-error="wrong" data-success="right" for="txtCaixa">Caixa</label>
                              <div class="input-group">
                                <input type="text" class="input-default form-control" id="txtCaixa" name="txtCaixa" class="form-control" placeholder="Caixa">
                                <div class="input-group-append">
                                  <button class="btn bg-danger d-none" id="btn-impostor" name="btn-impostor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnCaixa" name="btnCaixa" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-Caixa" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                            <div class="col-6 col-lg-3" id="checkLancaCaixa">
                              <div style="margin-top: 21px;">
                                <input type="checkbox" id="checkCaixa" style="width: 20px; height: 20px;">
                                <label for="checkCaixa" style="display: inline-block;vertical-align: middle;line-height: 0px;margin-bottom: 15px;">
                                  Lançar no caixa
                                </label>
                              </div>
                              <div>
                                <input type="checkbox" id="cbNaoLancaCc" style="width: 20px; height: 20px;">
                                <label for="cbNaoLancaCc" style="display: inline-block;vertical-align: middle;line-height: 0px;margin-bottom: 15px;">
                                  Não lançar conta corrente
                                </label>
                              </div>
                            </div>
                          </div>

                          <div class="form-row d-none" id="divCondicoesDePagamento" style="margin-bottom: 10px;">
                            <div class="col-md-9 col-12">
                              <label data-error="wrong" data-success="right" for="txtCondicaoDePagamento">Condição de Pagamento</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondicaoDePagamento" name="txtCondicaoDePagamento" class="form-control" placeholder="Condição de Pagamento">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-CondicaoDePagamento" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-condicao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                            <div class="col-md-3 col-12">
                              <div class="group-default">
                                <label for="txtNrParcelas">Nr. Parcelas</label>
                                <div class="relative">
                                  <input type="text" placeholder="Nr. Parcelas" class="input-default" id="txtNrParcelas" name="txtNrParcelas" readonly>
                                </div>
                              </div>
                            </div>
                          </div>

                          <div class="form-row d-none" id="divNSU" style="margin-bottom: 10px;">
                            <div class="col-md-6 col-6">
                              <label data-error="wrong" data-success="right" for="txtNsu">NSU</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtNsu" name="txtNsu" class="form-control" placeholder="NSU">
                              </div>
                            </div>
                            <div class="col-md-6 col-6">
                              <label data-error="wrong" data-success="right" for="select_bandeira">Bandeira</label>
                              <div class="input-group">
                                <select class="form-control select2 select2-danger focus" id="select_bandeira" name="select_bandeira" data-dropdown-css-class="select2-danger" style="width: 100%;">
                                  <option value="" selected="selected">Selecione uma bandeira</option>
                                </select>
                              </div>
                            </div>
                          </div>

                          <div class="row">
                            <div class="col-sm-3 col-12" id="ClasseInfoTour">
                              <label data-error="wrong" data-success="right" for="txtClasse">Classe *</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClasse" name="txtClasse" class="form-control" placeholder="Classe">

                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-Classe" name="btn-Classe" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-Classe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                            <div class="col-sm-3 col-12" id="HistoricoInfoTour">
                              <label data-error="wrong" data-success="right" for="txtHistorico">Histórico *</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtHistorico" name="txtHistorico" class="form-control" placeholder="Historico">

                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-Historico" name="btn-Historico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-Historico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                            <!-- <div class="col-sm-4 col-12" id="SituacaoInfoTour">
                              <label data-error="wrong" data-success="right" for="txtSituacaoBaixa">Situação </label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSituacaoBaixa" name="txtSituacaoBaixa" class="form-control" placeholder="Situação">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-SituacaoBaixa" name="btn-SituacaoBaixa" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-SituacaoBaixa" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>-->
                            <div class="form-group group-default col-sm-3 col-12">
                              <label for="">Data Pagamento</label>
                              <div class="relative">
                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="txtDTPagamento">
                              </div>
                            </div>
                            <div class="form-group group-default col-sm-3 col-12">
                              <label for="">Data Contabilização</label>
                              <div class="relative">
                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="txtDTContabilizacao">
                              </div>
                            </div>
                          </div>

                          <div class="col-sm-12 table-responsive">
                            <table id="tabelaBaixarContas" class="table table-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                  <th>Número</th>
                                  <th>Codcli</th>
                                  <th>Cliente</th>
                                  <th>Desc</th>
                                  <th>% Desc</th>
                                  <th>Juros</th>
                                  <th>Valor</th>
                                  <th>Valor Pago</th>
                                  <th>Saldo</th>
                                  <th>Dt. Vencto</th>
                                  <th>Obs</th>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                          <div class="col-sm-12 col-12 float-right form-row">
                            <div class="col-sm-2">
                              <label data-error="wrong" data-success="right" for="txtTotalDesconto">Total Desconto</label>
                              <input type="text" style="margin-top:-5px" autocomplete="off" class="input-default focus form-control" id="txtTotalDesconto" name="txtTotalDesconto" disabled>
                            </div>
                            <div class="col-sm-2">
                              <label data-error="wrong" data-success="right" for="txtTotalJuros">Total Juros</label>
                              <input type="text" style="margin-top:-5px" autocomplete="off" class="input-default focus form-control" id="txtTotalJuros" name="txtTotalJuros" disabled>
                            </div>
                            <div class="col-sm-2">
                              <label data-error="wrong" data-success="right" for="txtTotalValor">Valor total</label>
                              <input type="text" style="margin-top:-5px" autocomplete="off" class="input-default focus form-control" id="txtTotalValor" name="txtTotalValor" disabled>
                            </div>
                            <div class="col-sm-2">
                              <label data-error="wrong" data-success="right" for="txtTotalPago">Total pago</label>
                              <input type="text" style="margin-top:-5px" autocomplete="off" class="input-default focus form-control" id="txtTotalPago" name="txtTotalPago" disabled>
                            </div>
                            <div class="col-sm-2 d-none" id="divValorRecebido">
                              <label data-error="wrong" data-success="right" for="txtValorRecebido">Valor Recebido</label>
                              <input type="text" style="margin-top:-5px" autocomplete="off" class="input-default focus form-control maskDecimais" value="0.00" id="txtValorRecebido" name="txtValorRecebido">
                            </div>
                            <div class="col-sm-2 d-none" id="divTroco">
                              <label data-error="wrong" data-success="right" for="txtTroco">Troco</label>
                              <input type="text" style="margin-top:-5px" autocomplete="off" class="input-default focus form-control maskDecimais" value="0.00" id="txtTroco" name="txtTroco" disabled>
                            </div>
                          </div>
                          <input id="btn-baixar" type="button" style="font-size:16px; margin-top:22px;" class="btn btn-danger float-right" value="Gravar Baixa">
                        </form>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="modal fade bd-baixa-modal-xl" id="modalBaixarComAntecipacao" tabindex="-1" role="dialog" aria-labelledby="modalBaixarComAntecipacao" aria-hidden="true">
            <div class="modal-dialog modal-xl">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="BaixaModal">Baixar Receber com Antecipação</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <div class="container-fluid">
                    <div class="card">
                      <div class="card-body">
                        <div class="row">
                          <div class="col-sm-4 col-12">
                            <label data-error="wrong" data-success="right" for="txtClasseAnt">Classe</label>
                            <div class="input-group">
                              <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClasseAnt" name="txtClasseAnt" class="form-control" placeholder="Classe">
                              <div class="input-group-append">
                                <button class="btn bg-danger" id="btn-ClasseAnt" name="btn-ClasseAnt" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                <button class="btn bg-danger" id="btn-limpa-ClasseAnt" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-4 col-12">
                            <label data-error="wrong" data-success="right" for="txtHistoricoAnt">Histórico</label>
                            <div class="input-group">
                              <input type="text" autocomplete="off" class="input-default focus form-control" id="txtHistoricoAnt" name="txtHistoricoAnt" class="form-control" placeholder="Historico">
                              <div class="input-group-append">
                                <button class="btn bg-danger" id="btn-HistoricoAnt" name="btn-HistoricoAnt" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                <button class="btn bg-danger" id="btn-limpa-HistoricoAnt" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-4 col-12"></div>
                          <div class="form-group group-default col-sm-4 col-12">
                            <label for="">Data Pagamento</label>
                            <div class="relative">
                              <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="txtDTPagamentoAnt">
                            </div>
                          </div>
                          <div class="form-group group-default col-sm-4 col-12">
                            <label for="">Data Contabilização</label>
                            <div class="relative">
                              <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="txtDTContabilizacaoAnt">
                            </div>
                          </div>

                          <div class="form-group group-default col-sm-4 col-12">
                            <div class="float-right">
                              <h4>Saldo à pagar </h4>
                              <h5 id="txtSaldoAPagarAnt">R$ 00,00</h5>
                            </div>
                          </div>

                        </div>
                        <p>Antecipações</p>
                        <div class="col-sm-12 table-responsive">
                          <table id="tabelaAntecipacoesABaixar" class="table table-sm table-select table-hover" width="100%">
                            <thead>
                            </thead>
                            <tbody>
                            </tbody>
                          </table>
                        </div>
                        <input id="btn-baixarAnt" type="submit" style="font-size:16px; margin-top:22px;" class="btn btn-danger float-right" value="Gravar Baixa">
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>


          <div class="modal fade" id="modalParcelas" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl">
              <div class="modal-content">
                <div class="modal-header">
                  <h4 id="modalParcelas-titulo" class="modal-title">Crediário / Cheques</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <div class="row">
                    <div class="col-sm-4 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtChequeCliente">Cliente *</label>
                      <div class="input-group">
                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtChequeCliente" name="txtChequeCliente" class="form-control" placeholder="Cliente">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-ChequeCliente" name="btn-ChequeCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-ChequeCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>

                    <div class="col-sm-4 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtChequeRepresentante">Representante *</label>
                      <div class="input-group">
                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtChequeRepresentante" name="txtChequeRepresentante" class="form-control" placeholder="Representante">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-ChequeRepresentante" name="btn-ChequeRepresentante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-ChequeRepresentante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>

                    <div class="col-sm-4 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtChequeSituacao">Situação *</label>
                      <div class="input-group">
                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtChequeSituacao" name="txtChequeSituacao" class="form-control" placeholder="Situação">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-ChequeSituacao" name="btn-ChequeSituacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-ChequeSituacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>

                    <div class="col-sm-4 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtChequeClasse">Classe *</label>
                      <div class="input-group">
                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtChequeClasse" name="txtChequeClasse" class="form-control" placeholder="Classe">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-ChequeClasse" name="btn-ChequeClasse" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-ChequeClasse" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>

                    <div class="col-sm-4 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtChequeHistorico">Histórico *</label>
                      <div class="input-group">
                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtChequeHistorico" name="txtChequeHistorico" class="form-control" placeholder="Histórico">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnChequeHistorico" name="btnChequeHistorico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaChequeHistorico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>

                    <div class="col-sm-10 pb-2" style='display: flex; align-items: flex-end;'>
                      <button id="btn-adicionar-cheque" style="margin-bottom: 1rem" class="btn btn-danger">Adicionar Cheque</button>
                    </div>
                    <div class="col-sm-2 pb-2 form-group">
                      <div class="group-default">
                        <label for="txt_cred_valor_total">Valor Total: </label>
                        <div class="relative flex">
                          <input type="text" placeholder="Valor Total" class="input-default" id="txt_cred_valor_total" name="txt_cred_valor_total" readonly>
                          <button type="button" id="btn_dividir_valor" class="btn btn-primary" style="margin-left: 10px;"> Dividir</button>
                        </div>
                      </div>
                    </div>
                    <div class="col-sm-3 d-none">
                      <div class="group-default">
                        <label for="txt_cred_valor_pago">Valor pago: </label>
                        <div class="relative flex">
                          <input type="text" placeholder="Valor pago" class="input-default" id="txt_cred_valor_pago" name="txt_cred_valor_pago" readonly>
                        </div>
                      </div>
                    </div>
                    <div class="col-sm-12 table-responsive">
                      <table style="width:100%" width="100%" id="tabelaParcelas" class="table table-sm">
                        <thead>
                        </thead>
                      </table>
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <div class="row">
                    <div class="col-sm-12">
                      <button id="btn_confirmar_cred" type="button" class="btn btn-danger"> Confirmar </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="modal fade bd-visualizar-modal-lg" id="ModalVisualizarBaixa" tabindex="-1" role="dialog" aria-labelledby="ModalBaixa" aria-hidden="true">
            <div class="modal-dialog modal-xl">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="VisualizarModal">Visualizar Dados</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>

                <div class="card-body pt-1" style="overflow: auto;">
                  <div class="card" id="tourRelatorioMeta">

                    <div class="col-sm-12 table-responsive card-body  pt-2 pb-2">
                      <nav>
                        <div class="nav nav-tabs justify-content-start" id="nav-tab" role="tablist" style="text-decoration: none">
                          <a class="nav-link abaLink active" id="tabBaixas" data-toggle="tab" href="#divBaixas" role="tab" aria-controls="divBaixas" aria-selected="true">Baixas</a>
                          <a class="nav-link abaLink" id="tabHistorico" data-toggle="tab" href="#divHistorico" role="tab" aria-controls="divHistorico" aria-selected="false">Histórico</a>
                          <a class="nav-link abaLink" id="tabObservacoes" data-toggle="tab" href="#divObservacoes" role="tab" aria-controls="divObservacao" aria-selected="false">Observações</a>
                        </div>
                      </nav>
                    </div>

                    <div class="tab-content" id="nav-tabContent">
                      <div class="tab-pane fade active" id="divBaixas" role="tabpanel" aria-labelledby="tabBaixas">
                        <div class="">
                          <div class="card-body">
                            <form id="formVisualizarBaixas" name="formVisualizarBaixas">
                              <div class="form-row">
                                <div class="form-group group-default col-md-12 col-12" id="FornecedorInfoTour">
                                  <label data-error="wrong" data-success="right" for="txtClienteVisual">Fornecedor</label>
                                  <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClienteVisual" name="txtClienteVisual" class="form-control" placeholder="Fornecedor" disabled>
                                  </div>
                                </div>
                              </div>
                              <div class="form-row">
                                <div class="form-group group-default col-md-3 col-12" id="NotaFiscalInfoTour">
                                  <label>Nota Fiscal</label>
                                  <div class="relative">
                                    <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" required="required" pattern="[0-9]+$" id="txtNotaFiscalVisual" name="numbers" disabled>
                                  </div>
                                </div>
                                <div class="form-group group-default col-md-3 col-12">
                                  <label>Data de Emissão</label>
                                  <div class="relative" id="DataEmissao">
                                    <input type="date" max="2500-12-31" class="input-default focus form-control validatel" id="txtDTemissaoVisual" disabled>
                                  </div>
                                </div>
                                <div class="form-group group-default col-md-3 col-6" id="NotaFiscalInfoTour">
                                  <label>Valor</label>
                                  <div class="relative">
                                    <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" required="required" pattern="[0-9]+$" id="txtValorPagoVisual" name="numbers" disabled>
                                  </div>
                                </div>
                                <div class="form-group group-default col-md-3 col-6" id="NotaFiscalInfoTour">
                                  <label>Saldo</label>
                                  <div class="relative">
                                    <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" required="required" pattern="[0-9]+$" id="txtSaldoVisual" name="numbers" disabled>
                                  </div>
                                </div>
                              </div>
                              <div class="form-row">
                                <div class="form-group group-default col-md-3 col-6" id="nsuInfoTour">
                                  <label>NSU</label>
                                  <div class="relative">
                                    <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" required="required" pattern="[0-9]+$" id="txtNsuVisual" name="numbers" disabled>
                                  </div>
                                </div>
                                <div class="form-group group-default col-md-3 col-6" id="bandeiraInfoTour">
                                  <label>Bandeira</label>
                                  <div class="relative">
                                    <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" required="required" id="txtBandeiraVisual" name="numbers" disabled>
                                  </div>
                                </div>
                                <div class="form-group group-default col-md-3 col-6" id="taxabandeiraInfoTour">
                                  <label>Taxa Bandeira</label>
                                  <div class="relative">
                                    <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" required="required" pattern="[0-9]+$" id="txtTaxaBandeiraVisual" name="numbers" disabled>
                                  </div>
                                </div>
                                <div class="form-group group-default col-md-3 col-6" id="autorizacaoInfoTour">
                                  <label>Código Autorização</label>
                                  <div class="relative">
                                    <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" required="required" id="txtCodigoAutorizacaoVisual" name="numbers" disabled>
                                  </div>
                                </div>
                              </div>
                            </form>
                            <button class="btn btn-primary btn-sisp" id="btnImprimirBaixasVisual"><i class="fas fa-print"></i> Imprimir Baixas</button>
                            <div class="col-sm-12 table-responsive">
                              <table id="tabelaBaixar" class="table table-sm table-select table-hover" width="100%">
                                <thead>
                                  <tr>
                                    <th>Número</th>
                                    <th>Lançamento</th>
                                    <th>Data Pagamento</th>
                                    <th>Valor</th>
                                    <th>Valor Pago</th>
                                    <th>Moeda</th>
                                    <th>Desc_moeda</th>
                                    <th>Desconto</th>
                                    <th>Juros</th>
                                    <th>Valor Dev.</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="tab-pane fade active" id="divHistorico" role="tabpanel" aria-labelledby="tabHistorico">
                        <div class="">
                          <div class="card-body">
                            <form id="formVisualizarHistorico" name="formVisualizarHistorico">
                              <div class="col-sm-12 table-responsive">
                                <table id="tabelaHistorico" class="table table-sm table-select table-hover" width="100%">
                                  <thead>
                                    <tr>
                                      <th>Ordem</th>
                                      <th>Data</th>
                                      <th>Tipo</th>
                                      <th>Banco</th>
                                      <th>Conta</th>
                                      <th>Carteira</th>
                                      <th>Ocorrência (Codigo + Desc)</th>
                                      <th>Valor</th>
                                      <th>Data Retorno</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                </table>
                              </div>
                          </div>
                        </div>
                      </div>

                      <div class="tab-pane fade active" id="divObservacoes" role="tabpanel" aria-labelledby="tabObservacoes">
                        <div class="">
                          <div class="card-body">
                            <form id="formVisualizarObservacoes" name="formVisualizarObservacoes">
                              <div class="col-sm-12 table-responsive">
                                <table id="tabelaVisualizarObservacoes" class="table table-sm table-select table-hover" width="100%">
                                  <thead>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                </table>
                              </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="modal fade bd-itens-venda-modal-lg" id="modalItensVenda" tabindex="-1" role="dialog" aria-labelledby="ModalBaixa" aria-hidden="true">
            <div class="modal-dialog modal-xl">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="itensVendaModal">Visualizar Itens Venda</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <div class="container-fluid">
                    <div class="card">
                      <div class="card-body">
                        <form id="formVisualizar" name="formVisualizar">
                          <div class="form-row">
                            <div class="form-group group-default col-md-3 col-12">
                              <label>Número</label>
                              <div class="relative">
                                <input type="text" class="input-default focus form-control" id="txtNumeroItens" name="txtNumeroItens" disabled>
                              </div>
                            </div>
                            <div class="form-group group-default col-md-3 col-12">
                              <label>Venda</label>
                              <div class="relative">
                                <input type="text" class="input-default focus form-control" id="txtVenda" name="txtVenda" disabled>
                              </div>
                            </div>
                            <div class="form-group group-default col-md-3 col-12">
                              <label> </label>
                              <div class="relative">
                                <button class="btn btn-primary btn-sisp" id="btnImprimirItens"><i class="fas fa-print"></i> Imprimir Itens</button>
                              </div>
                            </div>
                          </div>
                        </form>
                      </div>
                      <div class="card-body">
                        <div class="col-sm-12 table-responsive">
                          <table id="tabelaItensVenda" class="table table-sm table-select table-hover" width="100%">
                            <thead>
                              <tr>
                              </tr>
                            </thead>
                            <tbody>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>











          <div class="modal fade bd-baixa-modal-xl" id="modalObservacao" tabindex="-1" role="dialog" aria-labelledby="ModalBaixa" aria-hidden="true">
            <div class="modal-dialog modal-xl">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="BaixaModal">Cadastro de Observações</h5>
                  <button type="button" class="close" id="CloseBaixa" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <div class="container-fluid">
                    <div class="card">
                      <div class="card-body">
                        <form id="msform" name="msform">
                          <div class="form-row">
                            <div class="col-md-3 col-12">
                              <label for="txtNrParcelas">ID</label>
                              <div class="relative">
                                <input type="text" placeholder="ID" class="input-default focus form-control" id="txtIdObservacao" name="txtIdObservacao" disabled readonly>
                              </div>
                            </div>
                          </div>
                          <div class="form-row">
                            <div class="col-md-3 col-12">
                              <label for="txtObservacaoNumero">Número</label>
                              <div class="relative">
                                <input type="text" placeholder="Número" class="input-default focus form-control" id="txtObservacaoNumero" name="txtObservacaoNumero" disabled readonly>
                              </div>
                            </div>
                            <div class="col-md-3 col-12">
                              <label for="txtObservacaoUsuario">Usuário</label>
                              <div class="relative">
                                <input type="text" placeholder="Usuário" class="input-default focus form-control" id="txtObservacaoUsuario" name="txtObservacaoUsuario" disabled readonly>
                              </div>
                            </div>
                            <div class="form-group group-default col-sm-3 col-12">
                              <label for="">Data de Cadastro</label>
                              <div class="relative">
                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="dtObservacaoCadastro">
                              </div>
                            </div>
                            <div class="col-12 col-lg-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtObservacaoMotivo">Motivo: *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtObservacaoMotivo" name="txtObservacaoMotivo" class="form-control" placeholder="Motivo">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnObservacaoMotivo" name="btnObservacaoMotivo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaObservacaoMotivo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class="form-group col-12">
                              <label data-error="wrong" data-success="right" for="txtAreaObservacao">Observação: *</label>
                              <div class="input-group">
                                <textarea style="resize: none" id="txtAreaObservacao" maxlength="1000" placeholder="Observação" class="input-default focus form-control" rows="6"></textarea>
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-12 table-responsive">
                            <table id="tabelaObservacoes" class="table table-sm table-select table-hover" width="100%">
                              <thead>
                                <th>ID</th>
                                <th>NUMERO</th>
                                <th>OBS</th>
                                <th>MOTIVO</th>
                                <th>USUARIO</th>
                                <th>DATA</th>
                                <th>EMP_ID</th>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>

                          <input id="btnGravarObservacao" type="button" style="font-size:16px; margin-top:22px;" class="btn btn-danger float-right" value="Gravar">
                        </form>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>








        </div>
      </div>
    </div>


    <aside class="control-sidebar control-sidebar-dark">

    </aside>
    <?php
    include_once('../../../modais.php');
    include_once('../../../modals/modal_pix.php');
    include_once('../../../modals/modal_lancRateio.html');
    include_once('../../../modals/modal_anexos.html');
    include_once('../../../modals/modal_desdobra_receber.html');
    ?>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.2412.10.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.2412.10.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2412.10.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2412.10.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2412.10.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2412.10.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.2412.10.1"></script>
  <script src="utils/cookies.js?versao=3.2412.10.1"></script>
  <script src="utils/funcoes.js?versao=3.2412.10.1"></script>
  <script src="dist/js/sisplan.js?versao=3.2412.10.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.2412.10.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.2412.10.1"></script>
  <script src="dist/js/driver.min.js?versao=3.2412.10.1"></script>
  <script src="dist/js/datetime.js?versao=3.2412.10.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.2412.10.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.2412.10.1"></script>
  <script src="plugins/moment/moment.min.js?versao=3.2412.10.1"></script>
  <script src="dist/js/jquery.inputmask.js?versao=3.2412.10.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.2412.10.1"></script>
  <script type="text/javascript" src="config.js?versao=3.2412.10.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.2412.10.1"></script>
  <script type="text/javascript" src="modals/modal_lancRateio.js?versao=3.2412.10.1"></script>
  <script type="text/javascript" src="modals/modal_desdobra_receber.js?versao=3.2412.10.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2412.10.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/qrious.min.js?versao=3.2412.10.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.2412.10.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');
      let queryString = window.location.href;
      let parametros = queryString.split('/');
      let nomeTela = parametros[parametros.length - 1].toUpperCase();

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;
      sArquivo = `${BASE_URI}/pages/receber/acesso_receber/acesso_receber.js?versao=3.2412.10.1`;

      const temAcesso = await temAcessoTela('RECEBER');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }
      await insereJavaScriptPagina(sArquivo);
      await insereJavaScriptPagina(`${BASE_URI}/pages/loja/js/rotinas.js?versao=3.2412.10.1`);

      await verificaPermissoes('RECEBER');

      $(function() {
        $('[data-toggle="tooltip"]').tooltip()
      })
    });
  </script>
</body>

</html>