$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoPreco',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de preço por cor e tamanho.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaPreco',
                popover: {
                    title: 'Tabela Preços',
                    description: 'Aqui estarão os preços cadastrados de acordo com o seu filtro.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    const permissaoUsuarioLogado = await permissaoAcessos("PRECOCORTAM");

    $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO chave", "descricao descricao"], "where": null}`);
    $('#txtProduto').autocompleta(3, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtMaterial').autocompleta(3, `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

    $('#btnTabPreco').pesquisa('#txtTabPreco', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"]}`, 'Pesquisa Tabela de Preço', 'regiao');
    $('#btnProduto').pesquisa('#txtProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Produto', 'produto');
    $('#btnMaterial').pesquisa('#txtMaterial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Material', 'material');

    $('#btnExcluiTabPreco').on('click', function () {
        $('#txtTabPreco').val('');
    });
    $('#btnExcluiProduto').on('click', function () {
        $('#txtProduto').val('');
    });
    $('#btnExcluiMaterial').on('click', function () {
        $('#txtMaterial').val('');
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
          '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
          '      ' + data + ' ' +
          '    </button> ' +
          '    <div class="dropdown-menu"> ' +
          '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
          '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
          '</div>';
        return retorno;
      };

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaPreco(true);
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtTabPreco').val('');
        $('#txtProduto').val('');
        $('#txtMaterial').val('');
        $("#txtTipo").val("");
    });

   

    async function consultaPreco() {
        try {
            $.LoadingOverlay("show");
            let tipo = $("#txtTipo").val() != '' ? `AND PRECO_COR_TAM.TIPO = '${$('#txtTipo').val()}'` : '';
            let codigoProduto = pegaChave('#txtProduto') != '' ? `AND PRECO_COR_TAM.CODIGO = '${pegaChave('#txtProduto')}'` : '';
            let codigoMaterial = pegaChave('#txtMaterial') != '' ? `AND PRECO_COR_TAM.CODIGO = '${pegaChave('#txtMaterial')}'` : '';
            let tabelapreco = pegaChave('#txtTabPreco') != '' ? `AND PRECO_COR_TAM.REGIAO = '${pegaChave('#txtTabPreco')}'` : '';
            const response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"PRECO_COR_TAM", "camposSelect":[ "PRECO_COR_TAM.CODIGO", "PRECO_COR_TAM.TIPO", "CASE WHEN PRECO_COR_TAM.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO", "PRECO_COR_TAM.REGIAO", "REGIAO.DESCRICAO DESC_REGIAO"], 
                "leftjoin": [{"tabela" : "PRODUTO", "condicao" : "PRODUTO.CODIGO = PRECO_COR_TAM.CODIGO AND PRECO_COR_TAM.TIPO = 'P'"}, {"tabela" : "MATERIAL", "condicao" : "MATERIAL.CODIGO = PRECO_COR_TAM.CODIGO AND PRECO_COR_TAM.TIPO = 'M'"}, {"tabela" : "REGIAO", "condicao" : "REGIAO.REGIAO = PRECO_COR_TAM.REGIAO"}],
                "groupby": ["PRECO_COR_TAM.CODIGO", "PRECO_COR_TAM.REGIAO", "CASE WHEN PRECO_COR_TAM.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END", "REGIAO.DESCRICAO", "PRECO_COR_TAM.TIPO"],
                "where": ["1=1 ${codigoProduto} ${codigoMaterial} ${tabelapreco} ${tipo}"]}`, null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelaPreco').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    "data": "CODIGO"
                },
                {
                    "data": "DESCRICAO"
                },
                {
                    "data": "REGIAO"
                },
                {
                    "data": "DESC_REGIAO"
                },
                {
                    "data": "TIPO"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                      }
                }]
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }
    }

    $('#tabelaPreco').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S'){
        let data = $('#tabelaPreco').DataTable().row($(this).parents('tr')).data();
        let registroLiberado = await verificarRegistro('PRECOCORTAM', String(data.REGIAO) + String(data.CODIGO + String(data.TIPO)));
        if (registroLiberado) {
            window.location.href = `precocortam/${btoa(`${data.REGIAO}/${data.CODIGO}/${data.TIPO}`)}`;
        }
    } else {
        msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
    });

    $('#tabelaPreco').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S'){
        let data = $('#tabelaPreco').DataTable().row($(this)).data();
        let registroLiberado = await verificarRegistro('PRECOCORTAM', String(data.REGIAO) + String(data.CODIGO) + String(data.TIPO));
        if (registroLiberado) {
            window.location.href = `precocortam/${btoa(`${data.REGIAO}/${data.CODIGO}/${data.TIPO}`)}`;
        }
    } else {
        msgAlertaSemConfirmacao("Sem permissão para alterar!");
    } 
    });

    $('#tabelaPreco').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S'){
        msgAlerta('Você realmente deseja excluir esse registro?', async () => {
            const data = $("#tabelaPreco").DataTable().row($(this).parents("tr"));
            await excluiRegistro(data);
        });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    $("#btnNovoPreco").on("click", function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
          window.location.href = "precocortam/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
      });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/cadastros/v1/precocortam?", `CODIGO=${(valorLinha.CODIGO)}&REGIAO=${(valorLinha.REGIAO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#btnConsultar').trigger('click');
});