$(document).ready(async function () {
  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      },
      {
        element: '#buttonColVis',
        popover: {
          title: 'Configurar colunas visíveis ',
          description: 'Clique aqui para selecionar as colunas que deseja retirar da tabela.',
          position: 'right'
        }
      },
      {
        element: '#buttonExcel',
        popover: {
          title: 'Botão Exportar',
          description: 'Clique aqui para exportar a tabela em CSV.',
          position: 'right'
        }
      },
      ]);
      driver.start();
    });
  });
  let consultando = true
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.pcpDemandaProdutos == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, pcpDemandaProdutos: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  if (colunas == null || colunas.pcpDemandaPedidos == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, pcpDemandaPedidos: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  if (colunas == null || colunas.pcpDemandaConsumos == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, pcpDemandaConsumos: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  function validaNovasColunas(novasColunas) {
    if (novasColunas.includes('SEL')) {
      throw new Error('Impossível deixar a coluna SEL invisível, favor desmarcar a mesma!');
    }
  }

  $('#btnConfirmarColunas').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      const novasColunas = retornaNovasColunasInvisiveis();

      if (localStorage.getItem('tabelaConsumos') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, pcpDemandaConsumos: novasColunas }))
        $('#tabelaConsumos').DataTable().columns().visible(true);
        $('#tabelaConsumos').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('tabelaPedidos') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, pcpDemandaPedidos: novasColunas }))
        $('#tabelaPedidos').DataTable().columns().visible(true);
        $('#tabelaPedidos').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, pcpDemandaProdutos: novasColunas }))
        $('#tabelaProdutos').DataTable().columns().visible(true);
        $('#tabelaProdutos').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (localStorage.getItem('tabelaPedidos') == 'true') {
      $('#tabelaPedidos').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.pcpDemandaPedidos ?? [])
    } else if (localStorage.getItem('tabelaConsumos') == 'true') {
      $('#tabelaConsumos').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.pcpDemandaConsumos ?? [])
    } else {
      $('#tabelaProdutos').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.pcpDemandaProdutos ?? [], ['Sel', 'Código', 'Produzir'])
    }
  })

  $('#modal-ColunasVisiveis').on('hide.bs.modal', function () {
    localStorage.removeItem('tabelaPedidos')
    localStorage.removeItem('tabelaConsumos')
  })

  await adicionaComponenteFiltro();
  limparFiltros(true);
  let formula;
  let formulaItens;
  let formulaWhere;
  let campos;
  await retornaFormula();
  camposFormula();
  tabelaCalculo();

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnIncluirCalculo').on('click', function () {
    habilitaBotoes();
    limpaCampos();
    habilitaCampos();
    tabelaFiltrosCalculo(-1);
    tabelaCamposCalculo(-1);
    const linhasSelecionadas = $("#tabelaCalculos").DataTable().rows(".selected").nodes();
    $(linhasSelecionadas).removeClass('selected');
    const linhasSelecionadasCampos = $("#tabelaCamposCalculos").DataTable().rows(".selected").nodes();
    $(linhasSelecionadasCampos).removeClass('selected');
    const linhasSelecionadasFiltros = $("#tabelaFiltrosCalculos").DataTable().rows(".selected").nodes();
    $(linhasSelecionadasFiltros).removeClass('selected');
  });

  $('#btnExcluirCalculo').on('click', async function () {
    await excluirCalculo();
  });

  $('#btnAlterarCalculo').on('click', function () {
    try {
      validaAlteracaoExclusao();
      habilitaBotoes();
      habilitaCampos();
    } catch (error) {
      msgErro(error.message);
    }
  });

  $('#btnCancelarCalculo').on('click', function () {
    habilitaBotoes(false);
    habilitaCampos(false);
    limpaCampos();
  });

  $('#btnGravarCalculo').on('click', async function () {
    await gravaFormula();
  });

  $('#btnGerarOF').on('click', async function () {
    const programacao = await RetornaProximo('OF1', 'OF1', 'PROGRAMACAO', 8);
    insereValor('#txtProgramacao', programacao);
    $('#modal-gerarOF').modal('show');
  });

  $('#btnGerarProjecao').on('click', async function () {
    const projecao = await retornaProximaProjecao();
    insereValor('#txtProjecaoProj', projecao.PROJECAO);
    insereValor('#txtDescricaoProj', projecao.DESCRICAO);

    if (projecao.PERIODO != '') {
      insereValor('#txtPeriodoProj', projecao.PERIODO, projecao.PERIODO);
    }

    if (projecao.COLECAO != '') {
      insereValor('#txtColecaoProj', projecao.COLECAO, projecao.COLECAO);
    }

    $('#modal-gerarProjecao').modal('show');
  });

  $('#btnFecharProj').on('click', function () {
    $('#modal-gerarProjecao').modal('hide');
  });

  $('#btnConfirmarProj').on('click', async function () {
    $(this).prop('disabled', true);
    try {
      await gravaProjecao();
    } finally {
      $(this).prop('disabled', false);
    }
  });

  $('#btnConfirmarGerarOF').on('click', async function () {
    $(this).prop('disabled', true);
    try {
      await gerarOF();
    } finally {
      $(this).prop('disabled', false);
    }
  });

  $('#btnAddCamposCalculo').on('click', function () {
    adicionaCampoCalculo();
  });

  $('#btnDelCamposCalculo').on('click', function () {
    deletaCampoCalculo();
  });

  $('#btnAddFiltrosCalculo').on('click', function () {
    adicionaFiltroCalculo();
  });

  $('#btnDelFiltrosCalculo').on('click', function () {
    deletaFiltroCalculo();
  });

  async function retornaFiltros() {
    const empresasFiltradas = $(".empresa_selecionada:checked").toArray().length > 0 ? $(".empresa_selecionada:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : [getCookie("emp_id")];
    const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());
    const empresa = empresasFiltradasFormatada != '' ? empresasFiltradasFormatada.replace(/'/g, '').split(',').map(Number).join(', ') : getCookie('emp_id');
    const retorno =
      `EMPRESA=${getCookie('empresa')}` +
      `&USUARIO=${getCookie('usuario')}` +
      `&DTFATPEDIDOINI=${$('#dtFatPedidoDe').val()}` +
      `&DTFATPEDIDOFIM=${$('#dtFatPedidoAte').val()}` +
      `&DTEMISSAOPEDINI=${$('#dtEmissaoPedidoDe').val()}` +
      `&DTEMISSAOPEDFIM=${$('#dtEmissaoPedidoAte').val()}` +
      // `&DTENTREGAPEDINI=${$('#dtEntregaPedidoDe').val()}` +
      // `&DTENTREGAPEDFIM=${$('#dtEntregaPedidoAte').val()}` +
      // `&DTFINALIZACAOOFINI=${$('#dtFinalizacaoOFDe').val()}` +
      // `&DTFINALIZACAOOFFIM=${$('#dtFinalizacaoOFAte').val()}` +
      // `&DTEMISSAOOFINI=${$('#dtEmissaoOFDe').val()}` +
      // `&DTEMISSAOOFFIM=${$('#dtEmissaoOFAte').val()}` +
      `&DTVENDALOJAINI=${$('#dtVendasLojaDe').val()}` +
      `&DTVENDALOJAFIM=${$('#dtVendasLojaAte').val()}` +
      `&PRODUTO=${await formataListas($('#txtProduto').val().toString())}` +
      `&SETOR=${await formataListas($('#txtSetor').val().toString())}` +
      `&COLECAO=${await formataListas($('#txtColecao').val().toString())}` +
      // `&SUBGRUPOCONSFT=${await formataListas($('#txtSubGrupoConsFT').val().toString())}` +
      `&DEPOSITO=${await formataListas($('#txtDeposito').val().toString())}` +
      // `&MATERIALCONSFT=${await formataListas($('#txtMaterialConsFT').val().toString())}` +
      `&STATUSPED=${await formataListas($('#txtStatusPed').val().toString())}` +
      // `&PRAZOPRODPEDIDO=${await formataListas($('#txtPrazoProdPedido').val().toString())}` +
      // `&GRUPOCONSFT=${await formataListas($('#txtGrupoConsFT').val().toString())}` +
      `&TIPOVENDA=${await formataListas($('#txtTipoVenda').val().toString())}` +
      // `&CORCONSFT=${await formataListas($('#txtCorConsFT').val().toString())}` +
      // `&PRODCONSFT=${await formataListas($('#txtProdConsFT').val().toString())}` +
      `&MARCA=${await formataListas($('#txtMarca').val().toString())}` +
      // `&ETIQUETA=${await formataListas($('#txtEtiqueta').val().toString())}` +
      // `&QUALIDADE=${await formataListas($('#txtQualidade').val().toString())}` +
      // `&GRUPOPRODFT=${await formataListas($('#txtGrupoProdFT').val().toString())}` +
      `&STATUSPROD=${await formataListas($('#txtStatusProd').val().toString())}` +
      `&GRUPOPROD=${await formataListas($('#txtGrupoProd').val().toString())}` +
      `&LINHAPROD=${await formataListas($('#txtLinhaProd').val().toString())}` +
      // `&FAIXADESC=${await formataListas($('#txtFaixaDesc').val().toString())}` +
      // `&TIPOOF=${await formataListas($('#txtTipoOF').val().toString())}` +
      // `&SUBCOLECAO=${await formataListas($('#txtSubColecao').val().toString())}` +
      `&CORPROD=${await formataListas($('#txtCorProd').val().toString())}` +
      `&CLIENTEPROD=${await formataListas($('#txtClienteProd').val().toString())}` +
      `&CATEGORIA=${await formataListas($('#txtCategoria').val().toString())}` +
      // `&PEDIDO=${await formataListas($('#txtPedido').val().toString())}` +
      `&TIPO=${await formataListas($('#txtTipo').val().toString())}` +
      `&PRAZOOF=${await formataListas($('#txtPrazoOF').val().toString())}` +
      // `&PROGRAMACAO=${await formataListas($('#txtProgramacao').val().toString())}` +
      // `&RAMOATIVIDADE=${await formataListas($('#txtRamoAtividade').val().toString())}` +
      // `&SEGMENTO=${await formataListas($('#txtSegmento').val().toString())}` +
      `&PRAZOPROD=${await formataListas($('#txtPrazoProd').val().toString())}` +
      `&TAMANHO=${await formataListas($('#txtTamanho').val().toString())}` +
      // `&GRUPOCLIENTE=${await formataListas($('#txtGrupoCliente').val().toString())}` +
      `&GRUPOPEDIDO=${await formataListas($('#txtGrupoPedido').val().toString())}` +
      // `&FAMILIA=${await formataListas($('#txtFamilia').val().toString())}` +
      // `&FIO=${await formataListas($('#txtFio').val().toString())}` +
      // `&TPVENDAFAT=${await formataListas($('#txtTpVendaFat').val().toString())}` +
      // `&TIPOCLASSIFICACAO=${await formataListas($('#txtProdClasTipo').val().toString())}` +
      `&PROJECAO=${pegaChave('#txtProjecao')}` +
      `&LISTAPEDIDO=${await formataListas($('#txtListaPedido').val().toString())}` +
      `&EMPRESALOJA=${empresa}` +
      `&COMERCIAL=${$('input[name="rdFiltroComercial"]:checked').val()}` +
      `&FINANCEIRO=${$('input[name="rdFiltroFinanceiro"]:checked').val()}` +
      `&TIPOPEDIDO=${$('input[name="rdFiltroTipoPedido"]:checked').val()}` +
      `&RGTIPOVENDA=${$('input[name="rdFiltroTipoVenda"]:checked').val()}` +
      // `&SCPATIVO=${isChecked('#cbAtivo') ? 'S' : 'N'}` +
      // `&SCPPRODRESTRICAO=${isChecked('#cbProdComRestricao') ? 'S' : 'N'}` +
      // `&SCPCORBASICA=${isChecked('#cbCorBasica') ? 'S' : 'N'}` +
      // `&SCPCORAMOSTRA=${isChecked('#cbCorAmostra') ? 'S' : 'N'}` +
      `&OPCBUSCAPRODUTOFT=${isChecked('#cbBuscaProdutoFT') ? 'S' : 'N'}` +
      `&OPCPRODUTOPEDIDO=${isChecked('#cbProdutosPedido') ? 'S' : 'N'}` +
      `&OPCPRODUTOPROJECAO=${isChecked('#cbProdutosProjecao') ? 'S' : 'N'}` +
      // `&OPCFILTRARPRODUCAOPROJECAO=${isChecked('#cbProducaoProjecao') ? 'S' : 'N'}` +
      // `&OPCDESCONTAMPROJECAO=${isChecked('#cbDescTamProjecao') ? 'S' : 'N'}` +
      // `&OPCDETALHESPROCESSO=${isChecked('#cbDetalhesProcesso') ? 'S' : 'N'}` +
      // `&OPCFILTDEPPRODPEDIDO=${isChecked('#cbFiltraDepositoProducaoPedido') ? 'S' : 'N'}` +
      `&PERIODOGERAOF=${pegaChave('#txtPeriodoGerarOF')}` +
      `&DEPOSITOGERAOF=${pegaChave('#txtDepositoGerarOF')}` +
      // `&DEPOSITOSAIDAGERAOF=${pegaChave('#txtDepositoSaidaGerarOF')}` +
      // `&COLECAOGERAOF=${pegaChave('#txtColecaoGerarOF')}` +
      `&LANCAFACCAOGERAOF=${isChecked('#cbLancarFaccao') ? 'S' : 'N'}` +
      `&GERAOFPOR=${$('input[name="rdFiltroGerarOFPor"]:checked').val()}` +
      `&OBSGERAOF=${pegaValor('#txtObsGerarOF')}` +
      `&TIPOGERAOF=${pegaChave('#txtTipoGerarOF')}` +
      `&PROGRAMACAOGERAOF=${pegaValor('#txtProgramacao')}` +
      `&OPCBUSCAVENDALOJA=${isChecked('#cbBuscaVendaLoja') ? 'S' : 'N'}` +
      `&PROJECAOPROJ=${pegaValor('#txtProjecaoProj')}` +
      `&COLECAOPROJ=${pegaChave('#txtColecaoProj')}` +
      `&DESCRICAOPROJ=${pegaValor('#txtDescricaoProj')}` +
      `&PERIODOPROJ=${pegaChave('#txtPeriodoProj')}`;
    // `&OPCMETACOLECAO=${isChecked('#cbMetaColecao') ? 'S' : 'N'}` +
    // `&OPCDATACARTEIRA=${isChecked('#cbDataCarteira') ? 'S' : 'N'}` +
    // `&OPCSOMENTECOMESTOQUE=${isChecked('#cbSomenteComEstoque') ? 'S' : 'N'}` +
    // `&OPCDATAPEDFATURADO=${isChecked('#cbPedFaturado') ? 'S' : 'N'}`;

    return retorno;
  }

  $("#cbBuscaVendaLoja").on("click", function () {
    if (isChecked(this)) {
      carregaEmpresasDisponiveis();
    }
  });

  $('#check_todos').on('change', function () {
    selecionarTodos();
  });

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirpcpdemanda?`;
        const dados = retornaParametros();
        const ordem = `&TELA_ORDENACAO=pcpdemanda`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('PCPDemanda');
        const arquivo = await GeraRelatorio(`${url}${ordem}&`, 'POST', 100000, false, 'PCPDemanda', dados);
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    await consulta();
  });

  $('#btnFecharGerarOF').on('click', function () {
    $('#modal-gerarOF').modal('hide');
  });

  async function adicionaComponenteFiltro() {
    await componenteFiltro('produto', true, true);
    await componenteFiltro('setor', true);
    await componenteFiltro('colecao', true);
    // await componenteFiltro('subGrupo', true, false, 'SubGrupoConsFT');
    await componenteFiltro('deposito', true);
    // await componenteFiltro('material', true, true, 'MaterialConsFT');
    await componenteFiltro('status', true, false, 'StatusPed');
    // await componenteFiltro('tabPrazo', true, false, 'PrazoProdPedido');
    // await componenteFiltro('grupoMA', true, false, 'GrupoConsFT');
    await componenteFiltro('tipo', true, false, 'TipoVenda', ["AREA = 'COM'"]);
    // await componenteFiltro('cor', true, true, 'CorConsFT');
    // await componenteFiltro('produto', true, true, 'ProdConsFT');
    await componenteFiltro('marca', true);
    // await componenteFiltro('etiqueta', true);
    // await componenteFiltro('qualidade', true);
    // await componenteFiltro('grupoPA', true, false, 'GrupoProdFT');
    await componenteFiltro('status', true, false, 'StatusProd');
    await componenteFiltro('grupoPA', true, false, 'GrupoProd');
    await componenteFiltro('linha', true, false, 'LinhaProd');
    // await componenteFiltro('faixaDesconto', true, false, 'FaixaDesc');
    // await componenteFiltro('tipo', true, false, 'TipoOF');
    // await componenteFiltro('subColecao', true);
    await componenteFiltro('cor', true, true, 'CorProd');
    await componenteFiltro('cliente', true, true, 'ClienteProd');
    await componenteFiltro('auxiliar', true, false, 'Categoria');
    // await componenteFiltro('pedido', true);
    await componenteFiltro('tipoProduto', true, false, 'Tipo');
    await componenteFiltro('tabPrazo', true, true, 'PrazoOF');
    // await componenteFiltro('programacao', true);
    // await componenteFiltro('ramoAtividade', true);
    // await componenteFiltro('modelo', true, false, 'Segmento');
    await componenteFiltro('tabPrazo', true, true, 'PrazoProd');
    await componenteFiltro('tamanho', true);
    // await componenteFiltro('grupoCli', true, false, 'GrupoCliente');
    await componenteFiltro('grupo_ped', true, false, 'GrupoPedido');
    // await componenteFiltro('etiqueta', true, true, 'Familia');
    // await componenteFiltro('cadFio', true, true, 'Fio');
    // await componenteFiltro('tipo', true, false, 'TpVendaFat');
    // await componenteFiltro('projecao', false, true);
    await componenteFiltro('pedido', true, true, 'ListaPedido');
    // await componenteTipoClassificacao();
    // await adicionaEmpresas();
    $('#txtColecaoProj').autocompleta(1, `JSON={
      "tabela": "COLECAO",
      "camposSelect": ["COLECAO.CODIGO CHAVE", "COLECAO.DESCRICAO"],
      "where": ["1 = 1"]
    }`);

    $('#btnColecaoProj').pesquisa_serverside(['#txtColecaoProj'], ['COLECAO.CODIGO'], ['COLECAO.DESCRICAO'], `{
      "tabela":"COLECAO",
      "camposSelect": ["COLECAO.CODIGO", "COLECAO.DESCRICAO"],
      "where": ["1 = 1"]
    }`, 'Pesquisa Coleção');

    $('#btnLimpaColecaoProj').on('click', function () {
      $('#txtColecaoProj').val('');
    });

    $('#txtPeriodoProj').autocompleta(1, `JSON={
      "tabela": "TABPRZ",
      "camposSelect": ["TABPRZ.PRAZO CHAVE", "TABPRZ.DESCRICAO"],
      "where": ["TABPRZ.ATIVO_PRODUCAO = 'S'"]
    }`);

    $('#btnPeriodoProj').pesquisa_serverside(['#txtPeriodoProj'], ['TABPRZ.PRAZO'], ['TABPRZ.DESCRICAO'], `{
      "tabela":"TABPRZ",
      "camposSelect": ["TABPRZ.PRAZO", "TABPRZ.DESCRICAO"],
      "where": ["TABPRZ.ATIVO_PRODUCAO = 'S'"]
    }`, 'Pesquisa Prazo');

    $('#btnLimpaPeriodoProj').on('click', function () {
      $('#txtPeriodoProj').val('');
    });

    $('#txtProjecao').autocompleta(3, `JSON={
      "tabela": "PROG_COMPRA",
      "camposSelect": ["PROG_COMPRA.NUMERO CHAVE", "PROG_COMPRA.CODIGO DESCRICAO"],
      "where": ["1 = 1"]
    }`);

    $('#btnProjecao').pesquisa_serverside(['#txtProjecao'], ['NUMERO'], ['CODIGO'], `{
      "tabela":"PROG_COMPRA",
      "camposSelect": ["NUMERO", "CODIGO"],
      "where": ["1 = 1"]
    }`, 'Pesquisa Prazo');

    $('#btnLimpaProjecao').on('click', function () {
      $('#txtProjecao').val('');
    });

    $('#txtPeriodoGerarOF').autocompleta(1, `JSON={
      "tabela": "TABPRZ",
      "camposSelect": ["TABPRZ.PRAZO CHAVE", "TABPRZ.DESCRICAO"],
      "where": ["TABPRZ.ATIVO_PRODUCAO = 'S'"]
    }`);

    $('#btnPeriodoGerarOF').pesquisa_serverside(['#txtPeriodoGerarOF'], ['TABPRZ.PRAZO'], ['TABPRZ.DESCRICAO'], `{
      "tabela":"TABPRZ",
      "camposSelect": ["TABPRZ.PRAZO", "TABPRZ.DESCRICAO"],
      "where": ["TABPRZ.ATIVO_PRODUCAO = 'S'"]
    }`, 'Pesquisa Prazo');

    $('#btnLimpaPeriodoGerarOF').on('click', function () {
      $('#txtPeriodoGerarOF').val('');
    });

    $('#txtDepositoGerarOF').autocompleta(1, `JSON={
      "tabela": "DEPOSITO",
      "camposSelect": ["DEPOSITO.CODIGO CHAVE", "DEPOSITO.DESCRICAO"],
      "where": ["1 = 1"]
    }`);

    $('#btnDepositoGerarOF').pesquisa_serverside(['#txtDepositoGerarOF'], ['DEPOSITO.CODIGO'], ['DEPOSITO.DESCRICAO'], `{
      "tabela":"DEPOSITO",
      "camposSelect": ["DEPOSITO.CODIGO", "DEPOSITO.DESCRICAO"],
      "where": ["1 = 1"]
    }`, 'Pesquisa Depósito');

    $('#btnLimpaDepositoGerarOF').on('click', function () {
      $('#txtDepositoGerarOF').val('');
    });

    // $('#txtDepositoSaidaGerarOF').autocompleta(1, `JSON={
    //   "tabela": "DEPOSITO",
    //   "camposSelect": ["DEPOSITO.CODIGO CHAVE", "DEPOSITO.DESCRICAO"],
    //   "where": ["1 = 1"]
    // }`);

    // $('#btnDepositoSaidaGerarOF').pesquisa_serverside(['#txtDepositoSaidaGerarOF'], ['DEPOSITO.CODIGO'], ['DEPOSITO.DESCRICAO'], `{
    //   "tabela":"DEPOSITO",
    //   "camposSelect": ["DEPOSITO.CODIGO", "DEPOSITO.DESCRICAO"],
    //   "where": ["1 = 1"]
    // }`, 'Pesquisa Depósito');

    // $('#btnLimpaDepositoSaidaGerarOF').on('click', function () {
    //   $('#txtDepositoSaidaGerarOF').val('');
    // });

    // $('#txtFluxoGerarOF').autocompleta(1, `JSON={
    //   "tabela": "ROTEIRO",
    //   "camposSelect": ["ROTEIRO.CODIGO CHAVE", "ROTEIRO.DESCRICAO"],
    //   "where": ["1 = 1"]
    // }`);

    // $('#btnFluxoGerarOF').pesquisa_serverside(['#txtFluxoGerarOF'], ['ROTEIRO.CODIGO'], ['ROTEIRO.DESCRICAO'], `{
    //   "tabela":"ROTEIRO",
    //   "camposSelect": ["ROTEIRO.CODIGO", "ROTEIRO.DESCRICAO"],
    //   "where": ["1 = 1"]
    // }`, 'Pesquisa Depósito');

    // $('#btnLimpaFluxoGerarOF').on('click', function () {
    //   $('#txtFluxoGerarOF').val('');
    // });

    $('#txtTipoGerarOF').autocompleta(1, `JSON={
      "tabela": "TIPO",
      "camposSelect": ["TIPO.ID_TIPO CHAVE", "TIPO.DESCRICAO"],
      "where": ["1 = 1"]
    }`);

    $('#btnTipoGerarOF').pesquisa_serverside(['#txtTipoGerarOF'], ['TIPO.ID_TIPO'], ['TIPO.DESCRICAO'], `{
      "tabela":"TIPO",
      "camposSelect": ["TIPO.ID_TIPO", "TIPO.DESCRICAO"],
      "where": ["1 = 1"]
    }`, 'Pesquisa Depósito');

    $('#btnLimpaTipoGerarOF').on('click', function () {
      $('#txtTipoGerarOF').val('');
    });

    // $('#txtColecaoGerarOF').autocompleta(1, `JSON={
    //   "tabela": "COLECAO",
    //   "camposSelect": ["COLECAO.CODIGO CHAVE", "COLECAO.DESCRICAO"],
    //   "where": ["1 = 1"]
    // }`);

    // $('#btnColecaoGerarOF').pesquisa_serverside(['#txtColecaoGerarOF'], ['COLECAO.CODIGO'], ['COLECAO.DESCRICAO'], `{
    //   "tabela":"COLECAO",
    //   "camposSelect": ["COLECAO.CODIGO", "COLECAO.DESCRICAO"],
    //   "where": ["1 = 1"]
    // }`, 'Pesquisa Depósito');

    // $('#btnLimpaColecaoGerarOF').on('click', function () {
    //   $('#txtColecaoGerarOF').val('');
    // });
  }

  // async function adicionaEmpresas() {
  //   const pesquisaParam = {
  //     tabela: 'EMPRESA',
  //     camposSelect: ['EMP_PAT', 'EMP_NOME'],
  //     where: ['1 = 1'],
  //   }

  //   const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
  //   $("#selectEmpresa").append(new Option(`Empresa`, '', null, ''));
  //   jsonStr.map(emp => {
  //     $("#selectEmpresa").append(new Option(`${emp.EMP_PAT.replace('_', '')} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null));
  //   });
  // };

  async function consulta() {
    $.LoadingOverlay('show');
    try {
      $('#divButtonsProdutos').addClass('d-none')
      $('#divButtonsPedidos').addClass('d-none')
      $('#divButtonsConsumos').addClass('d-none')
      consultando = true

      const url = '/sisplan/pcpdemanda/v1/pcpdemanda?';
      const filtros = await retornaFiltros();
      const response = await requisicao('GET', url, filtros, null, 500000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.mensagem)
        return;
      }

      const tbConsulta = jsonStr[0];
      // const tbPedidos = jsonStr[1];
      // const tbProcesso = jsonStr[3];
      // const tbTotProdColecao = jsonStr[4];
      // const tbCorEnt = jsonStr[5];
      const qryPedidos = jsonStr[6];
      tabelaProduto(tbConsulta);
      tabelaPedido(qryPedidos);
      if ($('#cbBuscaProdutoFT').is(':checked')) {
        const tbResumoProd = jsonStr[2];
        tabelaConsumos(tbResumoProd)
        $('#tabTabelaConsumos').removeClass('d-none')
        $('#divButtonsConsumos').removeClass('d-none')
      } else {
        $('#tabTabelaConsumos').addClass('d-none')
      }

      $('#divButtonsProdutos').removeClass('d-none')
      $('#divButtonsPedidos').removeClass('d-none')

      $('#modal-filtros').modal('hide');
      consultando = false
    } catch (error) {
      console.log(error);
      msgErro('Erro na rotina consulta: ' + error.message);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function tabelaProduto(tabela) {
    if ($.fn.DataTable.isDataTable('#tabelaProdutos')) {
      $('#tabelaProdutos').DataTable().destroy();
      $('#tabelaProdutos').empty();
    }
    tabela.forEach((item, index) => {
      item.SEL = botaoSelecionarGrid();
      item.CODIGO = retornaBotaoOpcoes(item.CODIGO);
      item.PRODUZIR = `<input type="number" class="input-default focus classProduzir" id="produzir${index}" value="${item.PRODUZIR}" style="min-width: 90px;"></input>`;
    });

    let colunasItens = [
      { title: 'Sel', data: 'SEL' },
      { title: 'Código', data: 'CODIGO' },
      { title: 'Descrição', data: 'DESCRICAO' },
      { title: 'Tam', data: 'TAM' },
      { title: 'Cor', data: 'COR' },
      { title: 'Desc. Cor', data: 'DESC_COR' },
      { title: 'Código2_Cor', data: 'CODIGO2_COR' },
      { title: 'Ped. Pend -', data: 'PED_PEND' },
      { title: 'Ped. Res', data: 'PED_RES' },
      { title: 'Ped. Exp', data: 'PED_EXP' },
      { title: 'Ped. Proc +', data: 'PED_PROC' },
      { title: 'Ped. Fat', data: 'PED_FAT' },
      { title: 'Ped. Prog', data: 'PED_PROG' },
      { title: 'Carteira -', data: 'TOTAL_PEND' },
      { title: 'Reserva', data: 'RESERVA' },
      { title: 'Expedição', data: 'EXPEDICAO' },
      { title: 'Programação', data: 'PROGRAMACAO' },
      { title: 'Processo +', data: 'PROCESSO' },
      { title: 'Produzido', data: 'PROD_TOTAL' },
      { title: 'Compra +', data: 'COMPRA' },
      { title: 'Cons. Prod.', data: 'CONS_PROD' },
      { title: 'Estoque +', data: 'ESTOQUE' },
      { title: 'Saldo', data: 'SALDO' },
      { title: 'Ativo', data: 'ATIVO' },
      { title: 'Produzir', data: 'PRODUZIR' },
      { title: 'Simular', data: 'SIMULAR' },
      { title: 'Zebrado', data: 'ZEBRADO' },
      { title: 'Projeção', data: 'PROJECAO' },
      { title: 'Qtde. Min.', data: 'QTDE_MIN' },
      { title: 'Posição', data: 'POSICAO' },
      { title: 'Grade', data: 'GRADE' },
      { title: 'Total Grade', data: 'TOTAL_GRADE' },
      { title: 'Packs', data: 'PACKS' },
      { title: 'Codigo2', data: 'CODIGO2' },
      { title: 'Etiqueta', data: 'ETIQUETA' },
      { title: 'Data Proj', data: 'DATA_PROJ' },
      { title: 'Desc. Etiqueta', data: 'DESC_ETIQUETA' },
      { title: 'Faixa Desconto', data: 'FAIXA_DESCONTO' },
      { title: 'Desc. Faixa Desconto', data: 'DESC_FAIXA_DESC' },
      { title: 'Grupo', data: 'GRUPO' },
      { title: 'Desc. Grupo', data: 'DESC_GRUPO' },
      { title: 'Linha', data: 'LINHA' },
      { title: 'Desc. Linha', data: 'DESC_LINHA' },
      { title: 'Vendas Loja', data: 'VENDAS_LOJA' },
      { title: 'Vendas Loja Prod', data: 'VENDAS_LOJA_PROD' },
      { title: 'Qtde. Est. Min', data: 'QTDE_EST_MIN' },
      { title: 'Coleção', data: 'COLECAO' },
      { title: 'Desc. Coleção', data: 'DESC_COLECAO' },
      { title: 'Meta. Col', data: 'META_COL' },
      { title: 'Venda Col', data: 'VENDA_COL' },
      { title: 'Prod. Col', data: 'PROD_COL' },
      { title: 'Exp. Man', data: 'EXP_MAN' },
      { title: 'Composição', data: 'COMPOSICAO' },
      { title: 'Venda Col. Tot', data: 'VENDA_COL_TOT' },
      { title: 'Prod Col. Tot', data: 'PROD_COL_TOT' },
      { title: 'SubProd', data: 'SUBPROD' },
      { title: 'Perc. Prod', data: 'PERC_PROD' },
      { title: 'Prod. Base', data: 'PROD_BASE' },
      { title: 'Desc. Prod. Base', data: 'DESC_PROD_BASE' },
      { title: 'QtdeProd_B', data: 'QTDEPROD_B' },
      { title: 'Proc. OF', data: 'PROC_OF' },
      { title: 'Ordem Tam', data: 'ORDEM_TAM' },
      { title: 'Projeção_B', data: 'PROJECAO_B' },
      { title: 'Qtde. Ped. Lista', data: 'QTDE_PED_LISTA' },
      { title: 'Tipo_Prod', data: 'TIPO_PROD' },
      { title: 'Desc_Tipo_Prod', data: 'DESC_TIPO_PROD' },
      { title: 'qtde_mult', data: 'QTDE_MULT' },
      { title: 'Saldo Proj.', data: 'SALDO_PROJ' },
      { title: 'Ven_Consig', data: 'VEN_CONSIG' },
      { title: 'DiasUtil_Emissao', data: 'DIASUTIL_EMISSAO' },
      { title: 'PedPend_Prod', data: 'PEDPEND_PROD' },
      { title: 'PedFat_Prod', data: 'PEDFAT_PROD' },
      { title: 'DiasVendas', data: 'DIASVENDAS' },
      { title: 'Marca', data: 'MARCA' },
      { title: 'Desc. Marca', data: 'DESC_MARCA' },
      { title: 'Ordem', data: 'ORDEM' },
      { title: 'Status', data: 'STATUS' },
      { title: 'Desc_Status', data: 'DESC_STATUS' },
      { title: 'Qtde_Mostruario', data: 'QTDE_MOSTRUARIO' },
      { title: 'PedPend_ProdCor', data: 'PEDPEND_PRODCOR' },
      { title: 'PedFat_ProdCor', data: 'PEDFAT_PRODCOR' },
      { title: 'Proj_Cor', data: 'PROJ_COR' },
      { title: 'Saldo_ProdCor', data: 'SALDO_PRODCOR' },
      { title: 'Fator_Comp', data: 'FATOR_COMP' },
      { title: 'Fator_Larg', data: 'FATOR_LARG' },
      { title: 'Qtde_Partes', data: 'QTDE_PARTES' },
      { title: 'Cont_Pedido', data: 'CONT_PEDIDO' },
      { title: 'PedPend_Total', data: 'PEDPEND_TOTAL' },
      { title: 'PedFat_Total', data: 'PEDFAT_TOTAL' },
      { title: 'OF Pedido', data: 'OF_PEDIDO' },
      { title: 'Referencia', data: 'REFERENCIA' },
    ]

    const colunasVisiveis = ['SEL', 'CODIGO', 'DESCRICAO', 'TAM', 'COR', 'DESC_COR', 'CODIGO2_COR', 'PED_PEND', 'PED_RES', 'PED_EXP', 'PED_PROC', 'PED_FAT', 'PED_PROG', 'TOTAL_PEND',
      'RESERVA', 'EXPEDICAO', 'PROGRAMACAO', 'PROCESSO', 'PROD_TOTAL', 'COMPRA', 'CONS_PROD', 'ESTOQUE', 'SALDO', 'ATIVO', 'PRODUZIR'
    ];
    const colunasOcultas = [];
    const colunasDireita = [];

    const colunasValor = ['PED_PEND', 'PED_RES', 'PED_EXP', 'PED_PROC', 'PED_FAT', 'PED_PROG', 'TOTAL_PEND', 'RESERVA', 'EXPEDICAO', 'PROGRAMACAO', 'PROCESSO', 'PROD_TOTAL', 'COMPRA',
      'CONS_PROD', 'ESTOQUE', 'SALDO'
    ];

    colunasItens.forEach((item, index) => {
      if (!colunasVisiveis.includes(item.data)) {
        colunasOcultas.push(index)
      }

      if (colunasValor.includes(item.data)) {
        colunasDireita.push(index);
      }
    })

    let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
    ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)
    let keys
    if (ordemColunasRelatorio != null && ordemColunasRelatorio.pcpDemandaProdutos != undefined) {
      const ordenacao = 'GERAL'
      const colunas = ordemColunasRelatorio.pcpDemandaProdutos.filter(f => f.ordenacao == ordenacao)
      keys = colunas.length > 0 ? colunas[0].colunas : [];
    } else {
      keys = [];
    }

    if (keys.length > 0) {
      colunasItens = keys.map(function (data) {
        return colunasItens.find(function (obj) {
          return obj.data == data
        })
      })
    }

    $('#tabelaProdutos').DataTable({
      search: false,
      filter: false,
      order: [],
      sort: true,
      destroy: true,
      scrollX: true,
      scrollY: '400px',
      paging: false,
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },

      "autoWidth": true,
      "data": tabela,
      "columns": colunasItens,
      autoWidth: true,
      "colReorder": true,
      "columnDefs": [{
        targets: colunasDireita,
        "className": 'pr-4 text-right'
      },
      {
        targets: colunasOcultas,
        visible: false
      }]
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaProdutos').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.pcpDemandaProdutos).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })

    $('.classProduzir').on('focusout', function () {
      const inputValue = $(this).val();
      // let total = 0;
      if (!Number.isInteger(parseFloat(inputValue))) {
        msgAlerta('Permitido apenas números inteiros!');
        $(this).val(0);
      }

      // $('.classProduzir').each(function () {
      //   total += isNaN(parseFloat($(this).val())) ? 0 : parseFloat($(this).val());
      // });

      // $('#txtTotalProduzir').val(total);
    });

    $('.btnSubVerificaOpcoes').hover(function () {
      $(this).siblings('.dropdown-menu').addClass('show');
    }, function (e) {
      const dropdownMenu = $(this).siblings('.dropdown-menu');
      const target = $(e.relatedTarget);
      if (!target.hasClass('dropdownSub')) {
        dropdownMenu.removeClass('show');
      }
    });

    $('.btnFormulas').click(function (e) {
      e.preventDefault();
      calculoProduzir(this);
    });

    $('.btnCadastraFormulas').click(function (e) {
      e.preventDefault();
      $('#modal-calculo').modal('show');
    });

    $('#tabelaProdutos').on('column-reorder.dt', function (e, settings, details) {
      if (consultando) {
        return
      }
      const newColumnOrder = []

      for (let i = 0; i < settings.aoColumns.length; i++) {
        const column = settings.aoColumns[i].mData

        newColumnOrder.push(column)
      }

      let ordemColunas = localStorage.getItem('ordemColunasDataTable')
      ordemColunas = JSON.parse(ordemColunas)
      const ordenacao = 'GERAL'

      if (ordemColunas == null || ordemColunas.pcpDemandaProdutos == undefined) {
        localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, pcpDemandaProdutos: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

      } else if (!ordemColunas.pcpDemandaProdutos.some(s => s.ordenacao == ordenacao)) {

        const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
        const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
        ordensSalvas.pcpDemandaProdutos.push(newObj)
        localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

      } else if (ordemColunas.pcpDemandaProdutos.some(s => s.ordenacao == ordenacao)) {

        const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
        ordensSalvas.pcpDemandaProdutos.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
        localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
      }
    });
  }

  $('#modal-calculo').on('shown.bs.modal', async function () {
    if ($.fn.DataTable.isDataTable('#tabelaCalculos')) {
      await sleep(200);
      $("#tabelaCalculos").DataTable().columns.adjust().draw(false);
    }
    if ($.fn.DataTable.isDataTable('#tabelaCamposCalculos')) {
      $("#tabelaCamposCalculos").DataTable().columns.adjust().draw(false);
    }
    if ($.fn.DataTable.isDataTable('#tabelaFiltrosCalculos')) {
      $("#tabelaFiltrosCalculos").DataTable().columns.adjust().draw(false);
    }
  });

  function tabelaPedido(tabela) {
    if ($.fn.DataTable.isDataTable('#tabelaPedidos')) {
      $('#tabelaPedidos').DataTable().destroy();
      $('#tabelaPedidos').empty();
    }

    let colunasItens = [
      { title: 'Número', data: 'NUMERO' },
      { title: 'Status', data: 'STATUS' },
      { title: 'Tipo', data: 'TIPO' },
      { title: 'Código', data: 'CODIGO' },
      { title: 'Descrição', data: 'DESCRICAO' },
      { title: 'Cor', data: 'COR' },
      { title: 'Desc. Cor', data: 'DESC_COR' },
      { title: 'Posição', data: 'POSICAO' },
      { title: 'Tam', data: 'TAM' },
      { title: 'Ped. Pend.', data: 'PED_PEND' },
      { title: 'Uni. Ped.', data: 'UNI_PED' },
      { title: 'Ped. Fat.', data: 'PED_FAT' },
      { title: 'Ped. Res.', data: 'PED_RES' },
      { title: 'Ped. Exp.', data: 'PED_EXP' },
      { title: 'Ped. Proc', data: 'PED_PROC' },
      { title: 'Dt. Fatura', data: 'DT_FATURA' },
      { title: 'Prazo Entrega', data: 'PRAZO_ENTREGA' },
      { title: 'Desc. Prazo Entrega', data: 'DESC_PRAZO_ENTREGA' },
      { title: 'Prazo Prod.', data: 'PRAZO_PROD' },
      { title: 'Desc. Prazo Prod.', data: 'DESC_PRAZO_PROD' },
      { title: 'CodCli', data: 'CODCLI' },
      { title: 'Nome', data: 'NOME' },
      { title: 'Dt. Emissão', data: 'DT_EMISSAO' },
      { title: 'Programação', data: 'PROGRAMACAO' },
      { title: 'Código 2', data: 'CODIGO2' },
      { title: 'Ped. Pend. Total', data: 'PEDPEND_TOTAL' },
      { title: 'Ped. Pend. Prod.', data: 'PEDPEND_PROD' },
      { title: 'Ped. Fat. Prod.', data: 'PEDFAT_PROD' },
      { title: 'Ped. Pend. Prod. Cor', data: 'PEDPEND_PRODCOR' },
      { title: 'Ped. Fat. Prod. Cor', data: 'PEDFAT_PRODCOR' },
      { title: 'Ped. Prog', data: 'PED_PROG' },
      { title: 'Qtde. Packs', data: 'QTDE_PACKS' },
      { title: 'Ordem Tam.', data: 'ORDEM_TAM' },
    ];

    const colunasVisiveis = ['NUMERO', 'STATUS', 'TIPO', 'CODIGO', 'DESCRICAO', 'COR', 'DESC_COR', 'POSICAO', 'TAM', 'PED_PEND', 'UNI_PED', 'PED_FAT', 'PED_RES', 'PED_EXP', 'PED_PROC',
      'DT_FATURA', 'PRAZO_ENTREGA', 'DESC_PRAZO_ENTREGA', 'PRAZO_PROD', 'DESC_PRAZO_PROD', 'CODCLI', 'NOME', 'DT_EMISSAO'
    ];
    const colunasValor = ['POSICAO', 'PED_PEND', 'UNI_PED', 'PED_FAT', 'PED_RES', 'PED_EXP', 'PED_PROC'];
    const colunasDatas = ['DT_FATURA', 'DT_EMISSAO'];

    const colunasOcultas = [];
    const colunasDireita = [];
    const colunasData = [];
    colunasItens.forEach((item, index) => {
      if (!colunasVisiveis.includes(item.data)) {
        colunasOcultas.push(index);
      }

      if (colunasValor.includes(item.data)) {
        colunasDireita.push(index);
      }

      if (colunasDatas.includes(item.data)) {
        colunasData.push(index);
      }
    })

    let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
    ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)
    let keys
    if (ordemColunasRelatorio != null && ordemColunasRelatorio.pcpDemandaPedidos != undefined) {
      const ordenacao = 'GERAL'
      const colunas = ordemColunasRelatorio.pcpDemandaPedidos.filter(f => f.ordenacao == ordenacao)
      keys = colunas.length > 0 ? colunas[0].colunas : [];
    } else {
      keys = [];
    }

    if (keys.length > 0) {
      colunasItens = keys.map(function (data) {
        return colunasItens.find(function (obj) {
          return obj.data == data
        })
      })
    }

    $('#tabelaPedidos').DataTable({
      search: false,
      filter: false,
      order: [],
      sort: true,
      destroy: true,
      scrollX: true,
      scrollY: '400px',
      paging: false,
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },

      "autoWidth": true,
      "data": tabela,
      "columns": colunasItens,
      autoWidth: true,
      "colReorder": true,
      "columnDefs": [{
        targets: colunasDireita,
        "className": 'pr-4 text-right'
      },
      {
        targets: colunasOcultas,
        visible: false
      },
      {
        "type": 'date-br',
        "targets": colunasData,
        "render": function (data) {
          if (data != undefined) {
            x = data.slice(0, 10).split('-');
            return `${x[2]}/${x[1]}/${x[0]}`;
          } else {
            return ''
          }
        }
      }]
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaPedidos').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.pcpDemandaPedidos).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })

    $('#tabelaPedidos').on('column-reorder.dt', function (e, settings, details) {
      if (consultando) {
        return
      }
      const newColumnOrder = []

      for (let i = 0; i < settings.aoColumns.length; i++) {
        const column = settings.aoColumns[i].mData

        newColumnOrder.push(column)
      }

      let ordemColunas = localStorage.getItem('ordemColunasDataTable')
      ordemColunas = JSON.parse(ordemColunas)
      const ordenacao = 'GERAL'

      if (ordemColunas == null || ordemColunas.pcpDemandaPedidos == undefined) {
        localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, pcpDemandaPedidos: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

      } else if (!ordemColunas.pcpDemandaPedidos.some(s => s.ordenacao == ordenacao)) {

        const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
        const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
        ordensSalvas.pcpDemandaPedidos.push(newObj)
        localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

      } else if (ordemColunas.pcpDemandaPedidos.some(s => s.ordenacao == ordenacao)) {

        const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
        ordensSalvas.pcpDemandaPedidos.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
        localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
      }
    });
  }

  function tabelaConsumos(tabela) {
    if ($.fn.DataTable.isDataTable('#tabelaConsumos')) {
      $('#tabelaConsumos').DataTable().destroy();
      $('#tabelaConsumos').empty();
    }

    let colunasItens = [
      { title: 'Insumo', data: 'INSUMO' },
      { title: 'Descricao', data: 'DESCRICAO' },
      { title: 'Cor_I', data: 'COR_I' },
      { title: 'Desc. Cor_I', data: 'DESC_COR_I' },
      { title: 'Tam', data: 'TAM' },
      { title: 'Codigo2_Tam', data: 'CODIGO2_TAM' },
      { title: 'Saldo Prod.', data: 'SALDO_PROD' },
      { title: 'Ped. Pend.', data: 'PED_PEND' },
    ];

    let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
    ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)
    let keys
    if (ordemColunasRelatorio != null && ordemColunasRelatorio.pcpDemandaConsumos != undefined) {
      const ordenacao = 'GERAL'
      const colunas = ordemColunasRelatorio.pcpDemandaConsumos.filter(f => f.ordenacao == ordenacao)
      keys = colunas.length > 0 ? colunas[0].colunas : [];
    } else {
      keys = [];
    }

    if (keys.length > 0) {
      colunasItens = keys.map(function (data) {
        return colunasItens.find(function (obj) {
          return obj.data == data
        })
      })
    }

    $('#tabelaConsumos').DataTable({
      search: false,
      filter: false,
      order: [],
      sort: true,
      destroy: true,
      scrollX: true,
      scrollY: '400px',
      paging: false,
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },

      "autoWidth": true,
      "data": tabela,
      "columns": colunasItens,
      autoWidth: true,
      "colReorder": true,
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaConsumos').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.pcpDemandaConsumos).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })

      $('#tabelaConsumos').on('column-reorder.dt', function (e, settings, details) {
        if (consultando) {
          return
        }
        const newColumnOrder = []
  
        for (let i = 0; i < settings.aoColumns.length; i++) {
          const column = settings.aoColumns[i].mData
  
          newColumnOrder.push(column)
        }
  
        let ordemColunas = localStorage.getItem('ordemColunasDataTable')
        ordemColunas = JSON.parse(ordemColunas)
        const ordenacao = 'GERAL'
  
        if (ordemColunas == null || ordemColunas.pcpDemandaConsumos == undefined) {
          localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, pcpDemandaConsumos: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));
  
        } else if (!ordemColunas.pcpDemandaConsumos.some(s => s.ordenacao == ordenacao)) {
  
          const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
          const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
          ordensSalvas.pcpDemandaConsumos.push(newObj)
          localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
  
        } else if (ordemColunas.pcpDemandaConsumos.some(s => s.ordenacao == ordenacao)) {
  
          const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
          ordensSalvas.pcpDemandaConsumos.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
          localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
        }
      });
  }



  function botaoSelecionarGrid() {
    return (
      '<div class="form-check">' +
      '<input type="checkbox" class="align-self-center checkDocumento" value"">' +
      '</div>'
    );
  }

  function addSelected(add = true) {
    for (let i = 0; i < $('#tabelaProdutos').DataTable().rows().data().length; i++) {
      if (add) {
        $($("table#tabelaProdutos tr")[i + 1]).addClass("selected");
      } else {
        $($("table#tabelaProdutos tr")[i + 1]).removeClass("selected");
      }
    }
  }

  $("#tabelaProdutos").on("click", "td", function () {
    selecionarLinhaTabela("#tabelaProdutos", "checkDocumento", this);
  });

  function retornaBotaoOpcoes(codigo) {
    let retorno = '<div style="text-align:center;"> ' +
      '   <div class="dropdown"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + codigo + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu dropDownDemanda" style="z-index: 999999;"> ' +
      '    <a class="dropdown-item btnCadastraFormulas" href="">Fórmulas</a>' +
      '   <div class="dropdownSub"> ' +
      '<button type="button" class="btn btn-secondary dropdown-toggle  btnSubVerificaOpcoes" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" onclick="event.stopPropagation()" style="border-color: none; background-color: none;">Produzir</button>' +
      '<div class="dropdown-menu custom-scroll" x-placement="right-start" style="position: absolute; transform: translate3d(111px, 0px, 0px); top: 0px; left: 0px; will-change: transform; z-index: 999999;">';
    formula.forEach((item) => {
      retorno += `<a id="btn${item.NUMERO}" class="dropdown-item btnFormulas" href="" data-info="NUMERO=${item.NUMERO}&CALCULO=${item.CALCULO}&MULTIPLICAR=${item.MULTIPLICAR}&VALIDAR_NEGATIVO=${item.VALIDAR_NEGATIVO}&ZERAR_NEGATIVO=${item.ZERAR_NEGATIVO}">${item.NOME}</a>`
    });
    retorno += '</div>' +
      '</div>' +
      '</div>' +
      '  </div>' +
      '</div>';

    return retorno;
  }

  async function retornaFormula() {
    $.LoadingOverlay('show');
    try {
      const url = '/sisplan/pcpdemanda/v1/formula?';
      const response = await requisicao('GET', url);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.mensagem)
        return;
      }

      formula = jsonStr[0];
      formulaWhere = jsonStr[1];
      campos = jsonStr[2];
      formulaItens = jsonStr[3];
    } catch (error) {
      console.log(error);
      msgErro('Erro na rotina retornaFormula: ' + error.message);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function calculoProduzir(componente) {
    $.LoadingOverlay('show');
    try {
      const dados = $("#tabelaProdutos").DataTable().rows(".selected").data().toArray();
      const numero = 0;
      const regra = $(componente).data('info').split('&');
      let bRetornouRegistro = false;

      const opcao = formula.filter((item) => {
        return item.NUMERO == regra[numero].split('=')[1];
      });

      if (dados.length == 0) {
        if (opcao[0].MENSAGEM == '') {
          msgAlerta('Nenhum registro selecionado. Impossível continuar.');
        } else {
          msgAlerta(opcao[0].MENSAGEM);
        }
        return;
      }

      const opcaoWhere = formulaWhere.filter((item) => {
        return item.NUMERO == regra[numero].split('=')[1];
      });

      $("#tabelaProdutos").DataTable().data().toArray().forEach((item, index) => {
        if ($('.checkDocumento').eq(index).prop('checked')) {
          let bValidacao = avaliarExpressao(calcularFormulaWhere(item, campos, opcaoWhere));
          let retorno = 0;
          if (bValidacao) {
            retorno = avaliarExpressao(calcularFormula(item, campos, opcao));
            bRetornouRegistro = true;
          }
          if ((opcao[0].ZERAR_NEGATIVO == 'S') && (retorno < 0)) {
            retorno = 0;
          } else if (((retorno < 0) && (opcao[0].VALIDAR_NEGATIVO == 'S')) || (opcao[0].MULTIPLICAR == 'S')) {
            retorno = parseInt(retorno * -1);
          }
          $(`#produzir${index}`).val(retorno);
        }
      });

      if (!bRetornouRegistro) {
        if (opcao[0].MENSAGEM == '') {
          msgAlerta('Nenhum registro selecionado. Impossível continuar.');
        } else {
          msgAlerta(opcao[0].MENSAGEM);
        }
      }
    } catch (error) {
      console.log(error);
      msgErro('Erro na rotina calculoProduzir ' + error.message);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function calcularFormula(item, campos, opcao) {
    let expressao = opcao[0].CALCULO;
    campos.sort((a, b) => { return b.CAMPO.length - a.CAMPO.length });
    campos.forEach(campo => {
      expressao = expressao.replace(new RegExp(campo.CAMPO, 'g'), item[campo.CAMPO]);
    });
    return expressao;
  }

  function calcularFormulaWhere(item, campos, opcaoWhere) {
    let expressao = '';

    if (opcaoWhere.length === 0) {
      return true;
    } else {
      opcaoWhere.forEach((opcao, index) => {
        if (index > 0) {
          expressao += ' && '
        }
        expressao += `(${opcao.CAMPO} ${opcao.OPERACAO} ${opcao.VALOR})`;
      })
    }

    campos.sort((a, b) => { return b.CAMPO.length - a.CAMPO.length });
    campos.forEach(campo => {
      expressao = expressao.replace(new RegExp(campo.CAMPO, 'g'), item[campo.CAMPO]);
    });
    return expressao;
  }

  function avaliarExpressao(expressao) {
    return eval(expressao);
  }

  async function gerarOF() {
    $.LoadingOverlay('show');
    try {
      let ofsGeradas = ''
      const url = '/sisplan/pcpdemanda/v1/gerarof?';
      const filtros = await retornaFiltros();
      const parametros = retornaParametros();
      const response = await requisicao('POST', url, filtros, parametros, 500000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgAlerta(jsonStr.mensagem);
        return;
      }

      $('#modal-gerarOF').modal('hide');

      for (let i = 0; i < jsonStr.length; i++) {
        ofsGeradas += jsonStr[i].NUMERO + ', ';
      }

      msgSucesso(`OF gerada com sucesso!` +
        `\nOFs Geradas: ${ofsGeradas.slice(0, -2)}`
      )

    } catch (error) {
      console.log(error);
      msgErro('Erro na rotina gerarOF: ' + error.message);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function retornaParametros() {
    const obj = $("#tabelaProdutos").DataTable().rows().data().toArray();
    const objPedido = $("#tabelaPedidos").DataTable().rows().data().toArray();

    obj.forEach((item, index) => {
      item.CODIGO = $('.btnVerificaOpcoes').eq(index).text().trim();
      item.PRODUZIR = isNaN(parseInt($(`#produzir${index}`).val())) ? 0 : parseInt($(`#produzir${index}`).val());
      item.SEL = $('.checkDocumento').eq(index).is(':checked') ? 'S' : 'N';
    });

    return `JSON=${JSON.stringify(obj)}&JSONPEDIDO=${JSON.stringify(objPedido)}`;
  }

  async function retornaProximaProjecao() {
    $.LoadingOverlay('show');
    try {
      const url = '/sisplan/pcpdemanda/v1/proximoprojecao?';
      const response = await requisicao('GET', url, '');

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgAlerta(jsonStr.mensagem);
        return;
      }

      return jsonStr[0];
    } catch (error) {
      console.log(error);
      msgErro('Erro na rotina retornaProximaProjecao: ' + error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function gravaProjecao() {
    $.LoadingOverlay('show');
    try {
      const url = '/sisplan/pcpdemanda/v1/gerarprojecao?';
      const filtros = await retornaFiltros();
      const parametros = retornaParametros();
      const response = await requisicao('POST', url, filtros, parametros, 500000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgAlerta(jsonStr.mensagem);
        return;
      }

      criaMensagemSucesso(`Projeção gerada com sucesso!`);
      $('#modal-gerarProjecao').modal('hide');
    } catch (error) {
      console.log(error);
      msgErro('Erro na rotina gravaProjecao: ' + error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function camposFormula() {
    const operacao = ['+', '-', '*', '/'];
    const condicao = ['>', '<', '>=', '<=', '<>'];
    const parenteses = ['(', ')'];

    $("#cbCampoCampos").append(new Option("", ""));
    $("#cbCampoCampos").append(new Option("CAMPO_MANUAL"));
    $("#cbValorFiltros").append(new Option("", ""));
    $("#cbValorFiltros").append(new Option("CAMPO_MANUAL"));
    campos?.forEach((item) => {
      $("#cbCampoCampos").append(new Option(item.CAMPO));
      $("#cbValorFiltros").append(new Option(item.CAMPO));
    });

    $("#cbCampoFiltros").append(new Option("", ""));
    campos?.forEach((item) => {
      $("#cbCampoFiltros").append(new Option(item.CAMPO));
    });

    $("#cbOperacaoCampos").append(new Option("", ""));
    operacao?.forEach((item) => {
      $("#cbOperacaoCampos").append(new Option(item));
    });

    $("#cbOperacaoFiltros").append(new Option("", ""));
    condicao?.forEach((item) => {
      $("#cbOperacaoFiltros").append(new Option(item));
    });

    $("#cbParentesesCampos").append(new Option("", ""));
    parenteses?.forEach((item) => {
      $("#cbParentesesCampos").append(new Option(item));
    });

    $('#cbCampoCampos').on('change', function () {
      if ($(this).val() == 'CAMPO_MANUAL') {
        $('#campoManual').removeClass('d-none');
        $('#cbCampoManual').removeClass('col-4');
        $('#cbCampoManual').addClass('col-2');
      } else {
        $('#cbCampoManual').removeClass('col-2');
        $('#cbCampoManual').addClass('col-4');
        $('#campoManual').addClass('d-none');
      }
    });

    $('#cbValorFiltros').on('change', function () {
      if ($(this).val() == 'CAMPO_MANUAL') {
        $('#ValorManual').removeClass('d-none');
        $('#cbValorManual').removeClass('col-4');
        $('#cbValorManual').addClass('col-2');
      } else {
        $('#cbValorManual').removeClass('col-2');
        $('#cbValorManual').addClass('col-4');
        $('#ValorManual').addClass('d-none');
      }
    });
  }

  function tabelaCalculo() {
    try {
      if ($.fn.DataTable.isDataTable('#tabelaCalculos')) {
        $('#tabelaCalculos').DataTable().destroy();
        $('#tabelaCalculos').empty();
      }

      const colunasItens = [
        { title: 'Ordem', data: 'ORDEM' },
        { title: 'Cálculo', data: 'CALCULO' },
        { title: 'Nome', data: 'NOME' },
        { title: 'Multiplicar', data: 'MULTIPLICAR' },
        { title: 'Validar Negativo', data: 'VALIDAR_NEGATIVO' },
        { title: 'Mensagem', data: 'MENSAGEM' },
        { title: 'Número', data: 'NUMERO' },
        { title: 'Tela', data: 'TELA' },
        { title: 'Zerar Negativo', data: 'ZERAR_NEGATIVO' },
      ]

      const colunasVisiveis = ['ORDEM', 'CALCULO', 'NOME', 'MULTIPLICAR', 'VALIDAR_NEGATIVO'];
      const colunasOcultas = [];

      colunasItens.forEach((item, index) => {
        if (!colunasVisiveis.includes(item.data)) {
          colunasOcultas.push(index)
        }
      })

      $('#tabelaCalculos').DataTable({
        search: false,
        filter: false,
        order: [],
        sort: true,
        destroy: true,
        scrollX: true,
        scrollY: '200px',
        paging: false,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },

        "autoWidth": true,
        "data": formula,
        "columns": colunasItens,
        autoWidth: true,
        "colReorder": true,
        "columnDefs": [{
          targets: colunasOcultas,
          visible: false
        }]
      });

      $('#tabelaCalculos').DataTable().order([0, 'asc']).draw();
      eventoClickTabela();
      $('#tabelaCalculos tbody tr:first').click();
    } catch (error) {
      console.log(error);
      msgErro('Erro na rotina tabelaCalculo: ' + error.message);
    }
  }

  function eventoClickTabela() {
    $('#tabelaCalculos tbody').unbind('click');
    $('#tabelaCalculos tbody').on('click', 'tr', async function () {
      if ($(this).hasClass('selected')) {
        $(this).removeClass('selected');
      } else {
        $('#tabelaCalculos').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        if ($('#tabelaCalculos').DataTable().rows().count() == 0) {
          limpaCampos();
        } else {
          const data = $('#tabelaCalculos').DataTable().row($(this)).data();
          $('#txtNomeCalculo').val(data.NOME);
          $('#txtMensagemCalculo').val(data.MENSAGEM);
          $('#txtCalculo').val(data.CALCULO);
          $('#cbMultiplicar').prop('checked', data.MULTIPLICAR == 'S');
          $('#cbValidarNegativo').prop('checked', data.VALIDAR_NEGATIVO == 'S');
          $('#cbZerarNegativos').prop('checked', data.ZERAR_NEGATIVO == 'S');
          tabelaCamposCalculo(data.NUMERO);
          tabelaFiltrosCalculo(data.NUMERO);
        }
      }
    });
  }

  function habilitaCampos(bHabilita = true) {
    $('.campoCalculo').prop('disabled', !bHabilita);
    $('.camposFiltros').prop('disabled', !bHabilita);
    $('#txtCalculo').prop('disabled', true);
    if (bHabilita) {
      $('#tabelaCalculos tbody').off('click');
    } else {
      eventoClickTabela();
    }
  }

  function tabelaCamposCalculo(numero) {
    try {
      if ($.fn.DataTable.isDataTable('#tabelaCamposCalculos')) {
        $('#tabelaCamposCalculos').DataTable().destroy();
        $('#tabelaCamposCalculos').empty();
      }

      const dados = formulaItens.filter((item) => { return item.NUMERO === numero });

      const colunasItens = [
        { title: 'Ordem', data: 'ORDEM' },
        { title: 'Campo', data: 'CAMPO' },
        { title: 'Operação', data: 'OPERACAO' },
        { title: 'Parênteses', data: 'PARENTESES' },
        { title: 'Número', data: 'NUMERO' },
        { title: 'Tela', data: 'TELA' },
      ]

      const colunasVisiveis = ['ORDEM', 'CAMPO', 'OPERACAO', 'PARENTESES'];
      const colunasOcultas = [];

      colunasItens.forEach((item, index) => {
        if (!colunasVisiveis.includes(item.data)) {
          colunasOcultas.push(index)
        }
      })

      $('#tabelaCamposCalculos').DataTable({
        search: false,
        filter: false,
        order: false,
        sort: true,
        destroy: true,
        scrollX: true,
        scrollY: '200px',
        paging: false,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },

        "autoWidth": true,
        "data": dados,
        "columns": colunasItens,
        autoWidth: true,
        "colReorder": true,
        "columnDefs": [{
          targets: colunasOcultas,
          visible: false
        }]
      });

      $('#tabelaCamposCalculos').DataTable().order([0, 'asc']).draw();

      $('#tabelaCamposCalculos tbody').unbind('click');
      $('#tabelaCamposCalculos tbody').on('click', 'tr', async function () {
        if ($(this).hasClass('selected')) {
          $(this).removeClass('selected');
          $('#cbParentesesCampos').val('');
          $('#cbOperacaoCampos').val('');
          $('#cbCampoCampos').val('');
        } else {
          $('#tabelaCamposCalculos').DataTable().$('tr.selected').removeClass('selected');
          $(this).addClass('selected');
          if ($('#tabelaCamposCalculos').DataTable().rows().count() == 0) {
            $('.campoCalculo').val('');
          } else {
            const data = $('#tabelaCamposCalculos').DataTable().row($(this)).data();
            $('#cbParentesesCampos').val(data.PARENTESES);
            $('#cbOperacaoCampos').val(data.OPERACAO);
            $('#cbCampoCampos').val(data.CAMPO);
          }
        }
      });

      $('#tabelaCamposCalculos tbody tr:first').click();
    } catch (error) {
      console.log(error);
      msgErro('Erro na rotina tabelaCamposCalculo: ' + error.message);
    }
  }

  function tabelaFiltrosCalculo(numero) {
    try {
      if ($.fn.DataTable.isDataTable('#tabelaFiltrosCalculos')) {
        $('#tabelaFiltrosCalculos').DataTable().destroy();
        $('#tabelaFiltrosCalculos').empty();
      }

      const dados = formulaWhere.filter((item) => { return item.NUMERO === numero });

      const colunasItens = [
        { title: 'Campo', data: 'CAMPO' },
        { title: 'Operação', data: 'OPERACAO' },
        { title: 'Valor', data: 'VALOR' },
        { title: 'Número', data: 'NUMERO' },
        { title: 'Tela', data: 'TELA' },
      ]

      const colunasVisiveis = ['CAMPO', 'OPERACAO', 'VALOR'];
      const colunasOcultas = [];

      colunasItens.forEach((item, index) => {
        if (!colunasVisiveis.includes(item.data)) {
          colunasOcultas.push(index)
        }
      })

      $('#tabelaFiltrosCalculos').DataTable({
        search: false,
        filter: false,
        order: [],
        sort: true,
        destroy: true,
        scrollX: true,
        scrollY: '200px',
        paging: false,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },

        "autoWidth": true,
        "data": dados,
        "columns": colunasItens,
        autoWidth: true,
        "colReorder": true,
        "columnDefs": [{
          targets: colunasOcultas,
          visible: false
        }]
      });

      $('#tabelaFiltrosCalculos').DataTable().order([0, 'asc']).draw();

      $('#tabelaFiltrosCalculos tbody').unbind('click');
      $('#tabelaFiltrosCalculos tbody').on('click', 'tr', async function () {
        if ($(this).hasClass('selected')) {
          $(this).removeClass('selected');
          $('#cbValorFiltros').val('');
          $('#cbOperacaoFiltros').val('');
          $('#cbCampoFiltros').val('');
        } else {
          $('#tabelaFiltrosCalculos').DataTable().$('tr.selected').removeClass('selected');
          $(this).addClass('selected');
          if ($('#tabelaFiltrosCalculos').DataTable().rows().count() == 0) {
            $('.camposFiltros').val('');
          } else {
            const data = $('#tabelaFiltrosCalculos').DataTable().row($(this)).data();
            $('#cbValorFiltros').val(data.VALOR);
            $('#cbOperacaoFiltros').val(data.OPERACAO);
            $('#cbCampoFiltros').val(data.CAMPO);
          }
        }
      });

      $('#tabelaFiltrosCalculos tbody tr:first').click();
    } catch (error) {
      console.log(error);
      msgErro('Erro na rotina tabelaFiltrosCalculo: ' + error.message);
    }
  }

  function habilitaBotoes(bAlteracao = true) {
    if (bAlteracao) {
      $('#btnIncluirCalculo').addClass('d-none');
      $('#btnExcluirCalculo').addClass('d-none');
      $('#btnAlterarCalculo').addClass('d-none');
      $('#btnGravarCalculo').removeClass('d-none');
      $('#btnCancelarCalculo').removeClass('d-none');
    } else {
      $('#btnIncluirCalculo').removeClass('d-none');
      $('#btnExcluirCalculo').removeClass('d-none');
      $('#btnAlterarCalculo').removeClass('d-none');
      $('#btnGravarCalculo').addClass('d-none');
      $('#btnCancelarCalculo').addClass('d-none');
    }
    habilitaCampos(bAlteracao);
  }

  function limpaCampos() {
    $('.campoCalculo').val('');
    $('.camposFiltros').val('');
    $('.configCheckOpcCalculo').prop('checked', false);
  }

  async function gravaFormula() {
    $.LoadingOverlay('show');
    try {
      const url = '/sisplan/pcpdemanda/v1/formula?';
      const body = retornaDadosFormula();
      const response = await requisicao('POST', url, '', body);

      if (!response) {
        return;
      }

      const jsonStr = await response.text();

      if (response.status != 200) {
        msgErro(jsonStr.mensagem)
        return;
      }

      habilitaBotoes(false);
      habilitaCampos(false);
      await retornaFormula();
      tabelaCalculo();
      criaMensagemSucesso(`Fórmula gravada com sucesso!`);
    } catch (error) {
      console.log(error);
      msgErro('Erro na rotina gravaFormula: ' + error.message);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function retornaDadosFormula() {
    const calculo = $("#tabelaCalculos").DataTable().rows(".selected").data().toArray();
    if (calculo.length == 0) {
      calculo.push({
        CALCULO: $('#txtCalculo').val(),
        MENSAGEM: $('#txtMensagemCalculo').val(),
        MULTIPLICAR: isChecked('#cbMultiplicar') ? 'S' : 'N',
        NOME: $('#txtNomeCalculo').val(),
        VALIDAR_NEGATIVO: isChecked('#cbValidarNegativo') ? 'S' : 'N',
        ZERAR_NEGATIVO: isChecked('#cbZerarNegativos') ? 'S' : 'N',
        TELA: 'TfmPCPDemanda'
      });
    } else {
      calculo[0].CALCULO = $('#txtCalculo').val();
      calculo[0].MENSAGEM = $('#txtMensagemCalculo').val();
      calculo[0].MULTIPLICAR = isChecked('#cbMultiplicar') ? 'S' : 'N';
      calculo[0].NOME = $('#txtNomeCalculo').val();
      calculo[0].VALIDAR_NEGATIVO = isChecked('#cbValidarNegativo') ? 'S' : 'N';
      calculo[0].ZERAR_NEGATIVO = isChecked('#cbZerarNegativos') ? 'S' : 'N';
      calculo[0].TELA = 'TfmPCPDemanda';
    }
    const campos = $("#tabelaCamposCalculos").DataTable().rows().data().toArray();
    const filtros = $("#tabelaFiltrosCalculos").DataTable().rows().data().toArray();
    return `JSONCALCULO=${JSON.stringify(calculo)}&JSONCAMPOS=${JSON.stringify(campos)}&JSONFILTROS=${JSON.stringify(filtros)}`;
  }

  function adicionaCampoCalculo() {
    try {
      const index = $('#tabelaCamposCalculos tr.selected').index();
      const qtdeRegistro = $("#tabelaCamposCalculos").DataTable().rows().count()

      if ((index != -1) && (qtdeRegistro > 0)) {
        let data_old = $('#tabelaCamposCalculos').DataTable().row(index).data();
        data_old.CAMPO = $('#cbCampoCampos').val() == 'CAMPO_MANUAL' ? pegaValor('#txtCampoManual') : $('#cbCampoCampos').val();
        data_old.OPERACAO = $('#cbOperacaoCampos').val();
        data_old.PARENTESES = $('#cbParentesesCampos').val();
        $('#tabelaCamposCalculos').DataTable().row(index).data(data_old).draw(false);

      } else {
        const qtdeRegistro = $('#tabelaCamposCalculos').DataTable().rows().count();
        const dados = $("#tabelaCalculos").DataTable().rows(".selected").data().toArray()[0];
        $('#tabelaCamposCalculos').DataTable().row.add({
          ORDEM: qtdeRegistro + 1,
          CAMPO: $('#cbCampoCampos').val() == 'CAMPO_MANUAL' ? pegaValor('#txtCampoManual') : $('#cbCampoCampos').val(),
          OPERACAO: $('#cbOperacaoCampos').val(),
          PARENTESES: $('#cbParentesesCampos').val(),
          NUMERO: dados?.NUMERO ? dados?.NUMERO : 0,
          TELA: 'TfmPCPDemanda'
        }).draw(false);
      }

      preencheCalculo();
      $('#cbCampoCampos').val('');
      $('#cbOperacaoCampos').val('');
      $('#cbParentesesCampos').val('');
      $('#cbCampoCampos').trigger('change');
    } catch (error) {
      console.log(error);
    }
  }

  function preencheCalculo() {
    const data = $('#tabelaCamposCalculos').DataTable().data().toArray();
    let descricao = '';
    data.forEach((item) => {
      descricao += item.PARENTESES == '(' ? '(' : '';
      descricao += item.CAMPO;
      descricao += item.PARENTESES == ')' ? ') ' : ' ';
      descricao += item.OPERACAO + ' ';
    })
    $('#txtCalculo').val(descricao);
  }

  function deletaCampoCalculo() {
    try {
      const index = $('#tabelaCamposCalculos tr.selected').index();

      if (index != -1) {
        $('#tabelaCamposCalculos').DataTable().row(':eq(' + index + ')').remove().draw(false);
        preencheCalculo();
      } else {
        msgAlerta('Nenhum registro selecionado, impossível continuar!');
      }
    } catch (error) {
      console.log(error);
    }
  }

  function adicionaFiltroCalculo() {
    try {
      const index = $('#tabelaFiltrosCalculos tr.selected').index();
      const qtdeRegistro = $("#tabelaFiltrosCalculos").DataTable().rows().count();

      if ((index != -1) && (qtdeRegistro > 0)) {
        let data_old = $('#tabelaFiltrosCalculos').DataTable().row(index).data();
        data_old.CAMPO = $('#cbCampoFiltros').val();
        data_old.OPERACAO = $('#cbOperacaoFiltros').val();
        data_old.VALOR = $('#cbValorFiltros').val() == 'CAMPO_MANUAL' ? pegaValor('#txtValorManual') : $('#cbValorFiltros').val();
        $('#tabelaFiltrosCalculos').DataTable().row(index).data(data_old).draw(false);
      } else {
        const dados = $("#tabelaFiltrosCalculos").DataTable().rows(".selected").data().toArray()[0];
        $('#tabelaFiltrosCalculos').DataTable().row.add({
          CAMPO: $('#cbCampoFiltros').val(),
          OPERACAO: $('#cbOperacaoFiltros').val(),
          VALOR: $('#cbValorFiltros').val() == 'CAMPO_MANUAL' ? pegaValor('#txtValorManual') : $('#cbValorFiltros').val(),
          NUMERO: dados?.NUMERO ? dados?.NUMERO : 0,
          TELA: 'TfmPCPDemanda'
        }).draw(false);
      }

      $('#cbCampoFiltros').val('');
      $('#cbOperacaoFiltros').val('');
      $('#cbValorFiltros').val('');
      $('#cbValorFiltros').trigger('change');
    } catch (error) {
      console.log(error);
    }
  }

  function deletaFiltroCalculo() {
    try {
      const index = $('#tabelaFiltrosCalculos tr.selected').index();

      if (index != -1) {
        $('#tabelaFiltrosCalculos').DataTable().row(':eq(' + index + ')').remove().draw(false);
      } else {
        msgAlerta('Nenhum registro selecionado, impossível continuar!');
      }
    } catch (error) {
      console.log(error);
    }
  }

  function validaAlteracaoExclusao() {
    const dados = $("#tabelaCalculos").DataTable().rows(".selected").data().toArray();
    if (dados.length == 0) {
      throw new Error('Nenhum registro selecionado, impossível continuar!');
    }
  }

  async function excluirCalculo() {
    $.LoadingOverlay('show');
    try {
      validaAlteracaoExclusao();
      const dados = $("#tabelaCalculos").DataTable().rows(".selected").data().toArray();
      const url = '/sisplan/pcpdemanda/v1/formula?';
      const response = await requisicao('DELETE', url, `NUMERO=${dados[0].NUMERO}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.text();

      if (response.status != 200) {
        msgErro(jsonStr.mensagem)
        return;
      }

      await retornaFormula();
      tabelaCalculo();
    } catch (error) {
      console.log('Erro na rotina excluirCalculo: ' + error);
      msgErro(error.message);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function selecionarTodos() {
    $.LoadingOverlay('show');
    try {
      await sleep(200);
      $('.checkDocumento').prop('checked', $('#check_todos').prop('checked'));
      if ($('#checkDocumento').prop('checked')) {
        $('.checkDocumento').addClass('selecionado');
      } else {
        $('.checkDocumento').removeClass('selecionado');
      }
      addSelected($('#check_todos').prop('checked'));
    } catch (error) {
      console.log(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#nav-tab').on('shown.bs.tab', function (e) {
    const tabela = $(e.target)[0].id.replace('tabT', 't')
    if ($(e.target).hasClass('active')) {
      $(`#${tabela}`).DataTable().columns.adjust().draw()
    }
  })

  $('#buttonColVis').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      $('#modal-ColunasVisiveis').modal('show');
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#buttonExcel').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const url = '/sisplan/pcpdemanda/v1/pcpdemanda?';
      const filtros = await retornaFiltros();
      const response = await requisicao('GET', url, filtros, null, 500000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.mensagem)
        return;
      }

      const tbConsulta = jsonStr[0];

      await exportaCSV("", "", undefined, null, 'Relatório de demanda pcp', '#tabelaProdutos', '', 999, false, false, tbConsulta);
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#buttonColVisPedidos').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      localStorage.setItem('tabelaPedidos', 'true')
      $('#modal-ColunasVisiveis').modal('show');
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#buttonExcelPedidos').on('click', async function () {
    const dados = $("#tabelaPedidos").DataTable().data().toArray();
    await exportaCSV("", "", undefined, null, 'Relatório de demanda pcp', '#tabelaPedidos', '', 999, false, false, dados);
  })

  $('#buttonColVisConsumos').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      localStorage.setItem('tabelaConsumos', 'true')
      $('#modal-ColunasVisiveis').modal('show');
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#buttonExcelConsumos').on('click', async function () {
    const dados = $("#tabelaConsumos").DataTable().data().toArray();
    await exportaCSV("", "", undefined, null, 'Relatório de demanda pcp', '#tabelaConsumos', '', 999, false, false, dados);
  })
});