$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnNovoCadastro',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro.',
          position: 'right'
        }
      },
      {
        element: '#tabelaMedidas',
        popover: {
          title: 'Tabela de Funções',
          description: 'Aqui estão os dados das Medidas cadastradas.',
          position: 'bottom'
        }
      }
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  
  componenteFiltro('medidas', true)

  const permissaoUsuarioLogado = await permissaoAcessos("MEDIDAS");

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });


  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  consultaMedidas();

  $('#btnConsultar').on('click', async function () {
    await consultaMedidas(true);
    $('#modal-filtros').modal('hide');
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtMedidas').empty().trigger('change')
  });

  async function consultaMedidas(bBotao = false) {
    try {
      $.LoadingOverlay("show");
      let response;
      const medidas = $('#txtMedidas').val().length <= 0 ? '' : ` AND CODIGO IN (${await formataListas($('#txtMedidas').val().toString())})`;
      if (bBotao) {
        response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"MEDIDAS", "camposSelect":["CODIGO", "DESCRICAO", "DESC_INGLES", "ORIENTACAO", "TOLERANCIA", "TIPO_ENCOLHA"],"where": ["1=1 ${medidas}"]}`, null);
      } else {
        response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"MEDIDAS", "camposSelect":["CODIGO", "DESCRICAO", "DESC_INGLES", "ORIENTACAO", "TOLERANCIA", "TIPO_ENCOLHA"], "where": null}', null);
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $('#tabelaMedidas').DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },

        "autoWidth": true,
        "data": jsonStr.RESULT[0],
        "columns": [{
          "data": "CODIGO",
          "title": "Código"
        },
        {
          "data": "DESCRICAO",
          "title": 'Descrição'
        },
        {
          "data": "DESC_INGLES",
          "title": 'Descrição Compl.'
        },
        {
          "data": "ORIENTACAO",
          "title": 'Orientação'
        },
        {
          "data": "TOLERANCIA",
          "title": 'Tolerância'
        },
        {
          "data": "TIPO_ENCOLHA",
          "title": 'Tipo Encolhimento'
        }
        ],
        "columnDefs": [{
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          }
        }]
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }

  }

  $('#btnNovoCadastro').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "medidas/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaMedidas').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaMedidas').DataTable().row($(this).parents('tr')).data();
      let registroLiberado = await verificarRegistro('MEDIDAS', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `medidas/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaMedidas').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaMedidas').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro('MEDIDAS', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `medidas/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaMedidas').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaMedidas").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/cadmedidas?", `CODIGO=${encodeURIComponent(valorLinha.CODIGO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});
