$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([
            {
                element: "#btnVoltar",
                popover: {
                    title: "Botão Voltar",
                    description:
                        "Ao clicar nesse botão você retorna para a tela de consulta.",
                    position: "left",
                },
            },
            {
                element: '#btnGravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar os dados.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $('.apenasFloat').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 4,
        allowNegative: true
    });

    $('.apenasFloat2').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    const lancto = parametros[parametros.length - 1];

    $('[name="rdTipo"]').on('change', function () {
        if ($(`[name="rdTipo"]:checked`).val() == 'P') {
            $('#btnCodigo').off('pesquisa_serverside');
            $('#btnCodigo').pesquisa_serverside(['#txtCodigo', '#txtDescricao', '#txtUnidade'],
                ['CODIGO', 'DESCRICAO', 'UNIDADE'],
                ['CODIGO', 'DESCRICAO', 'UNIDADE'],
                '{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO", "UNIDADE"], "camposWhereServerSide":["CODIGO", "DESCRICAO"], "where": null}',
                'Pesquisa Código',
                undefined,
                [true, true, true]);
        } else {
            $('#btnCodigo').off('pesquisa_serverside');
            $('#btnCodigo').pesquisa_serverside(['#txtCodigo', '#txtDescricao', '#txtUnidade'],
                ['CODIGO', 'DESCRICAO', 'UNIDADE'],
                ['CODIGO', 'DESCRICAO', 'UNIDADE'],
                '{"tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO", "UNIDADE"], "camposWhereServerSide":["CODIGO", "DESCRICAO"], "where": null}',
                'Pesquisa Código',
                undefined,
                [true, true, true]);
        }
    })

    $('#btnLimpaCodigo').on('click', function () {
        $('#txtCodigo').val('');
        $('#txtDescricao').val('');
    });

    if (lancto == 'create') {
        $('#txtCodigo').prop('disabled', false);
        $('#btnCodigo').prop('disabled', false);
        $('#btnLimpaCodigo').prop('disabled', false);
        $('#divTipoCodigo').removeClass('d-none');
        $('[name="rdTipo"]').trigger('change');
    } else {
        await buscaDados(lancto);
    }

    componenteFiltro('cliente', false, false, 'Entidade');
    componenteFiltro('setor', false, false);
    componenteFiltro('motivo', false, false);
    componenteFiltro('ordemProducao', true, true, 'NumeroDesc');
    componenteFiltro('setor', false, false, 'SetorDesc');
    componenteFiltro('cliente', false, false, 'FaccaoDesc');

    async function buscaDados(lancto) {
        $.LoadingOverlay('show');
        try {
            let response = await requisicao('GET', '/Sisplan/faclanca/V1/faclanca?', `&LANCTO=${lancto}`, null);

            if (!response) {
                return;
            }

            let data = await response.json();
            if (response.status != 200) {
                msgErro(data.mensagem);
            }

            data = data[0];

            $('#txtNumero').val(data.NUMERO);
            insereValor('#txtCodigo', data.CODIGO);
            insereValor('#txtDescricao', data.DESCRICAO);
            insereValor('#txtEntidade', data.CODCLI, data.NOME);
            $('#txtEmissao').val(data.DT_EMI);
            $('#txtVencimento').val(data.DT_LAN);
            $('#txtObs').val(data.OBS);
            $('#txtPreco').val(data.PRECO);
            $('#txtValor').val(data.VALOR);
            $('#txtQuantidade').val(data.QUANT);
            insereValor('#txtSetor', data.SETOR, data.DESC_SETOR);
            $('#txtLancamento').val(data.LANCAMENTO);
            $('#txtUnidade').val(data.UNIDADE);
            insereValor('#txtMotivo', data.MENSAGEM, data.DESC_MENSAGEM);
            $('#cbLanctoEspecial').prop('checked', data.TIPO_ESPECIAL == 'S');

        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#txtSetor').on('blur', async function () {
        if ($(this).val() != '') {
            try {
                if ($('#cbQtdePreco').prop('checked')) {
                    $.LoadingOverlay('show');
                    let preco = await buscaValor('CADFLUXO', 'CUSTO', 'CODIGO', pegaChave(this));
                    if (preco) {
                        preco = preco.CUSTO;
                    } else {
                        preco = 0;
                    }
                    $('#txtPreco').val(preco);
                }
            } catch (e) {
                console.log(e);
                msgErro(`Setor inválido: ${e}`);
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    })

    $('#txtNumero').on('blur', async function () {
        if ($(this).val() != '') {
            try {
                if ($('#cbQtdePreco').prop('checked')) {
                    $.LoadingOverlay('show');
                    let qtde = await buscaValor('OF_ITEN', 'SUM(QTDE) QTDE', 'NUMERO', $(this).val());
                    if (qtde) {
                        qtde = qtde.QTDE;
                    } else {
                        qtde = 0;
                    }
                    $('#txtQuantidade').val(qtde);
                }
            } catch (e) {
                console.log(e);
                msgErro(`OF inválida: ${e}`);
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    })

    $('#btnGravar').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            const obj = {
                LANCTO: 0,
                NUMERO: $('#txtNumero').val(),
                CODIGO: $('#txtCodigo').val(),
                DESCRICAO: $('#txtDescricao').val(),
                TERCEIRO: pegaChave('#txtEntidade'),
                SETOR: pegaChave('#txtSetor'),
                MOTIVO: pegaChave('#txtMotivo'),
                OBS: $('#txtObs').val(),
                UNIDADE: $('#txtUnidade').val(),
                EMISSAO: $('#txtEmissao').val() == '' ? formataData(new Date()) : $('#txtEmissao').val(),
                VENCTO: $('#txtVencimento').val() == '' ? formataData(new Date()) : $('#txtVencimento').val(),
                QTDE: $('#txtQuantidade').val(),
                PRECO: $('#txtPreco').val(),
                VALOR: $('#txtValor').val(),
                OPERACAO: $('#txtOperacao').val(),
                LANCTO_ESPECIAL: $('cbLanctoEspecial').prop('checked')
            }

            if (!obj.CODIGO || obj.CODIGO == '') {
                msgErro('Código inválido, impossível continuar.', () => { $('#txtCodigo').focus(); }, () => { $('#txtCodigo').focus(); });
                return;
            }

            if (!obj.DESCRICAO || obj.DESCRICAO == '') {
                msgErro('Descrição inválida, impossível continuar.', () => { $('#txtDescricao').focus(); }, () => { $('#txtDescricao').focus(); });
                return;
            }

            if (!obj.UNIDADE || obj.UNIDADE == '') {
                msgErro('Unidade inválida, impossível continuar.', () => { $('#txtUnidade').focus(); }, () => { $('#txtUnidade').focus(); });
                return;
            }

            if (!obj.TERCEIRO || obj.TERCEIRO == '') {
                msgErro('Terceiro inválido, impossível continuar.', () => { $('#txtEntidade').focus(); }, () => { $('#txtEntidade').focus(); });
                return;
            }

            if (!obj.SETOR || obj.SETOR == '') {
                msgErro('Setor inválido, impossível continuar.', () => { $('#txtSetor').focus(); }, () => { $('#txtSetor').focus(); });
                return;
            }

            if (!obj.VALOR || obj.VALOR == 0) {
                msgErro('Valor zerado, impossível continuar.', () => { $('#txtValor').focus(); }, () => { $('#txtValor').focus(); });
                return;
            }

            if (obj.OPERACAO == 'D' && obj.VALOR > '0') {
                obj.VALOR = parseFloat(obj.VALOR) * -1;
            }

            $('#btnGravar').trigger('blur')

            await gravaDados(obj);
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível gravar os dados: ${e}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    async function gravaDados(obj) {
        try {

            let response = await requisicao("POST", `/Sisplan/faclanca/V1/faclanca?&CODUSUARIO=${getCookie('cod_usuario')}`, ``,
                `&OBJ=${encodeURIComponent(JSON.stringify(obj))}`);

            if (!response) {
                return;
            }

            if (response.status != 200) {
                let json = await response.json();
                msgErro(json.mensagem);
                return;
            }

            toastr.success("Dados gravados com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() { window.location.href = `${BASE_URI}/faclanca` },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível gravar os dados: ${e}`);
        }
    }

    $('#btnDuplicar').on('click', async function () {
        msgAlerta('Deseja duplicar esse registro?', () => { }, () => { }, async () => { await duplicarRegistro() });
    })

    async function duplicarRegistro() {
        $.LoadingOverlay('show');
        try {
            $('#txtCodigo').prop('disabled', false);
            $('#txtLancamento').val('');
            $('#btnCodigo').prop('disabled', false);
            $('#btnLimpaCodigo').prop('disabled', false);
            $('#divTipoCodigo').removeClass('d-none');
            $('[name="rdTipo"]').trigger('change');
            $('#txtEntidade').val('');
            $('#btnDuplicar').addClass('d-none');
            $('#txtEntidade').focus();
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível duplicar o registro: ${e}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#btnConsultarDesc').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            const filtros = {
                LANCTO_INI: $('#dtLancamentoDeDesc').val(),
                LANCTO_FIM: $('#dtLancamentoAteDesc').val(),
                NUMERO: await formataListas($('#txtNumeroDesc').val().toString()),
                SETOR: pegaChave('#txtSetorDesc'),
                CODCLI: pegaChave('#txtFaccaoDesc'),
                MOVTO: $('#txtMovimentoDesc').val()
            }

            if (!filtros.SETOR || filtros.SETOR == '') {
                msgErro('Setor não informado, impossível continuar.', () => { $('#txtSetorDesc').focus; }, () => { $('#txtSetorDesc').focus; });
                return;
            }

            if (!filtros.CODCLI || filtros.CODCLI == '') {
                msgErro('Facção não informada, impossível continuar.', () => { $('#txtFaccaoDesc').focus; }, () => { $('#txtFaccaoDesc').focus; });
                return;
            }

            let response = await requisicao('GET', '/Sisplan/faclanca/V1/consultadesconto?', `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`, null);

            if (!response) {
                return;
            }

            let data = await response.json();
            if (response.status != 200) {
                msgErro(data.mensagem);
            }

            criaTabelaDesconto(data);
            apuraDesconto();
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    function criaTabelaDesconto(data) {
        if ($.fn.DataTable.isDataTable('#tabelaDesconto')) {
            $('#tabelaDesconto').DataTable().destroy();
            $('#tabelaDesconto').empty();
        }

        let cols = [{
            data: 'NUMERO',
            title: 'Número'
        },
        {
            data: 'CODIGO',
            title: 'Código'
        },
        {
            data: 'DESC_PRODUTO',
            title: 'Descrição'
        },
        {
            data: 'CODCLI',
            title: 'Codcli'
        },
        {
            data: 'NOME',
            title: 'Nome'
        },
        {
            data: 'SETOR',
            title: 'Setor'
        },
        {
            data: 'MOV',
            title: 'Mov'
        },
        {
            data: 'QTDE',
            title: 'Qtde'
        },
        {
            data: 'QTDE_2',
            title: 'Qtde 2ª'
        },
        {
            data: 'QTDE_I',
            title: 'Qtde Inc.'
        },
        {
            data: 'QTDE_P',
            title: 'Qtde P.'
        },
        {
            data: 'CUSTO_INDUSTRIAL',
            title: 'Custo'
        },
        {
            data: 'MAO_OBRA',
            title: 'Mão de Obra'
        },
        {
            data: 'TOTAL_CUSTO',
            title: 'Custo Total'
        },
        {
            data: 'TOTAL_DESCONTO',
            title: 'Desconto Total'
        }];

        $("#tabelaDesconto").DataTable({
            order: false,
            sort: true,
            paging: false,
            destroy: true,
            lengthChange: false,
            searching: false,
            info: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            data: data,
            columns: cols,
            columnDefs: [{
                targets: [11, 12, 13, 14],
                render: function (data) {
                    return parseFloat(data).toLocaleString("pt-br", {
                        maximumFractionDigits: 2,
                        minimumFractionDigits: 2,
                    });
                },
            }]
        });
    }

    $('#btnAtualizarDesc').on('click', function () {
        $.LoadingOverlay('show');
        try {
            apuraDesconto();
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível atualizar os valores: ${e}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    function apuraDesconto() {
        let total = 0;
        let totQtde = 0;
        let qtde;
        let desconto;

        if (!$.fn.DataTable.isDataTable('#tabelaDesconto')) {
            return
        }

        const data = $('#tabelaDesconto').DataTable().data().toArray();
        data.map((e) => {
            qtde = 0;
            if ($('#cbPerdida').prop('checked')) {
                qtde += parseInt(e.QTDE_P);
            }

            if ($('#cbSegunda').prop('checked')) {
                qtde += parseInt(e.QTDE_2);
            }

            if ($('#cbIncompleta').prop('checked')) {
                qtde += parseInt(e.QTDE_I);
            }

            desconto = qtde * e.TOTAL_CUSTO;
            desconto += parseFloat(parseFloat(desconto * ($('#txtDescontoDesc').val() / 100)).toFixed(2));
            e.TOTAL_DESCONTO = desconto;
            totQtde += parseInt(qtde);
            total += parseFloat(parseFloat(desconto).toFixed(2));
        });

        criaTabelaDesconto(data);
        $('#txtTotalDescontoDesc').val(parseFloat(total).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
        }));
        $('#txtTotalPecasDesc').val(totQtde);
    }

    $('#btnGravarDesc').on('click', async function () {
        if (!$.fn.DataTable.isDataTable('#tabelaDesconto')) {
            return
        }
        $.LoadingOverlay('show');
        try {
            msgAlerta('Deseja gravar os dados?', () => { }, () => { }, async () => { await gravaDesconto() })
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível gravar os dados: ${e}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    async function gravaDesconto() {

        if (!$.fn.DataTable.isDataTable('#tabelaDesconto')) {
            return
        }

        const aux = new Set();

        const data = $('#tabelaDesconto').DataTable().data().toArray();

        if (data.length == 0) {
            msgErro('Nenhuma informação consultada, impossível continuar.');
            return;
        }

        data.forEach(e => {
            if (e.hasOwnProperty('NUMERO')) {
                aux.add(e.NUMERO);
            }
        })

        const ofs = Array.from(aux);

        const obj = {
            NUMERO: ofs.length == 1 ? data[0].NUMERO : '',
            CODIGO: ofs.length == 1 ? data[0].CODIGO : '',
            CODCLI: pegaChave('#txtFaccaoDesc'),
            OBS: $('#txtObsDesc').val(),
            DT_LANCTO: $('#txtLancamentoDesc').val() == '' ? formataData(new Date()) : $('#txtLancamentoDesc').val(),
            TOT_PECAS: parseInt($('#txtTotalPecasDesc').val()),
            TOT_DESCONTO: parseFloat(parseFloat($('#txtTotalDescontoDesc').val().replaceAll('.', '').replaceAll(',', '.')).toFixed(2)),
            SETOR: pegaChave('#txtSetorDesc'),
            OPERACAO: $('#txtOperacaoDesc').val()
        };

        let response = await requisicao("POST", `/Sisplan/faclanca/V1/descontoproc?&CODUSUARIO=${getCookie('cod_usuario')}`, ``,
            `&OBJ=${encodeURIComponent(JSON.stringify(obj))}`);

        if (!response) {
            return;
        }

        if (response.status != 200) {
            let json = await response.json();
            msgErro(json.mensagem);
            return;
        }

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() { window.location.href = `${BASE_URI}/faclanca` },
        }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
        });
    }

    $('#txtQuantidade, #txtPreco').on('blur', function () {
        const qtde = parseFloat($('#txtQuantidade').val());
        const preco = parseFloat($('#txtPreco').val());
        $('#txtValor').val(parseFloat(qtde * preco).toFixed(4));
    })

    $('#btnVoltar, #btnVoltarDesc').on('click', async function () {
        window.history.back();
    });
});