$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnTransferir',
                popover: {
                    title: 'Botão Transferir',
                    description: 'Clique aqui para iniciar a transferência de depósitos.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaDemanda',
                popover: {
                    title: 'Tabela Dados',
                    description: 'Aqui está a lista de produtos solicitados para a sua loja.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    // const permissaoUsuarioLogado = await permissaoAcessos("DEMANDA_ECOMMERCE");
    let barrasLog = [];
    // autocompleta
    $("#txtTipoMov").autocompleta(1, `JSON={"tabela": "TABBAI", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`);
    $("#txtFuncionario").autocompleta(1, `JSON={"tabela": "PESSOAL", "camposSelect": ["CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
    $("#txtOperacaoNFE").autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": [] }`);
    $('#txtNaturezaNFE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '1'"] }`);
    $('#txtClienteNFE').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": [] }`);
    $('#txtTabelaDePrecoNFE').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":["regiao CHAVE, DESCRICAO"], "where": [] }`);

    // pesquisa
    $("#btnTipoMov").pesquisa_array(["#txtTipoMov"], ["CHAVE"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABBAI", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`, "Pesquisa Tipo Movimento", "tabbai");
    $("#btnFuncionario").pesquisa_array(["#txtFuncionario"], ["CHAVE"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "PESSOAL", "camposSelect": ["CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`, "Pesquisa Funcionário", "pessoal");
    $("#btnOperacaoNFE").pesquisa("#txtOperacaoNFE", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Operação", "oper_fiscal");
    $('#btn-NaturezaNFE').pesquisa('#txtNaturezaNFE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '1'"]}`, 'Pesquisa Natureza', 'natureza');
    $('#btn-ClienteNFE').pesquisa_serverside(['#txtClienteNFE'], ['CODCLI'], ['NOME'], JSON.stringify({ tabela: "ENTIDADE", camposSelect: ["CODCLI", "NOME", "FANTASIA", "CNPJ"], where: [] }), 'Pesquisa de Cliente');
    $('#btnTabelaDePrecoNFE').pesquisa_serverside(['#txtTabelaDePrecoNFE'], ['REGIAO'], ['DESCRICAO'], JSON.stringify({ tabela: "REGIAO", camposSelect: ["REGIAO", "DESCRICAO"], where: [] }), 'Pesquisa de Tabela de Preço');

    // limpacampo
    $("#btnLimpaTabelaDePrecoNFE").on("click", function () {
        $("#txtTabelaDePrecoNFE").val("");
    });

    $("#btnLimparTipoMov").on("click", function () {
        $("#txtTipoMov").val("");
    });

    $('#btn-limpa-ClienteNFE').on('click', function () {
        $('#txtClienteNFE').val('');
    });

    $("#btnAOperacaoNFE").on("click", function () {
        $("#txtOperacaoNFE").val("");
    });

    $('#btn-limpa-NaturezaNFE').on('click', function () {
        $('#txtNaturezaNFE').val('');
    });

    $("#btnLimparFuncionario").on("click", function () {
        $("#txtFuncionario").val("");
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#modal-filtros').modal('hide');


    async function addBarraLogLida(barraLog) {
        if (!barraLog) {
            return true;
        }

        if (!barrasLog.includes(barraLog)) {
            if (!await validaBarraLogLiberada(barraLog.replace('#', '[HASHTAG]'))) {
                return false;
            }
            barrasLog.push(barraLog);
            return true;
        }
        return false;

    };

    // function retornaBotaoOpcoes(data) {
    //     var retorno = '<div style="text-align:start;"> ' +
    //       '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
    //       '      ' + data + ' ' +
    //       '    </button> ' +
    //       '    <div class="dropdown-menu"> ' +
    //       '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
    //       '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  '+
    //       '</div>';
    //     return retorno;
    //   };

    consultaDemandas();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaDemandas();
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtUnidadeConsulta').val('');
    });

    async function verificaDepositoEmpresa() {
        const pesquisa = {
            tabela: "EMPRESA",
            camposSelect: ["EMP_DEPOSITO"],
            where: [`EMP_PAT = '${getCookie('empresa')}'`]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        return jsonStr[0];
    };

    function criptografaCodigo(codigo) {
        return btoa(codigo).replaceAll('=', '');
    }

    async function consultaDemandas() {
        try {
            $.LoadingOverlay("show");
            const depositosVinculados = await verificaDepositoEmpresa();
            const depositosEmp = depositosVinculados.EMP_DEPOSITO.length > 0 ? depositosVinculados.EMP_DEPOSITO : '';

            const pesquisa = {
                camposSelect: ['DEMANDA_ENVIAR.ID_DEMANDA',
                    'DEMANDA_RECEBER.CODIGO',
                    'PRODUTO.DESCRICAO',
                    'DEMANDA_RECEBER.COR',
                    'CADCOR.DESCRICAO DESC_COR',
                    'DEMANDA_RECEBER.TAMANHO',
                    'DEMANDA_RECEBER.QUALIDADE',
                    'DEMANDA_ENVIAR.QTDE_SOLICITADA',
                    'DEMANDA_ENVIAR.STATUS',
                    'DEMANDA_ENVIAR.DEPOSITO',
                    "'' FOTO"],
                tabela: 'DEMANDA_ENVIAR',
                leftJoin: [{ tabela: 'DEMANDA_RECEBER', condicao: 'DEMANDA_RECEBER.ID = DEMANDA_ENVIAR.ID_DEMANDA' },
                { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = DEMANDA_RECEBER.CODIGO' },
                { tabela: 'CADCOR', condicao: 'CADCOR.COR = DEMANDA_RECEBER.COR' }
                ],
                where: [`DEMANDA_ENVIAR.STATUS = 'PENDENTE' AND DEMANDA_ENVIAR.QTDE_SOLICITADA > DEMANDA_ENVIAR.QTDE_ENVIADA`],
            };

            if (depositosEmp.length > 0) {
                pesquisa.where[0] += ` AND DEMANDA_ENVIAR.DEPOSITO IN (${depositosEmp})`;
            }

            const response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON=${JSON.stringify(pesquisa)}`, null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelaDemanda').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: false,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [
                    { "data": "ID_DEMANDA" },
                    { "data": "CODIGO" },
                    { "data": "DESCRICAO" },
                    { "data": "FOTO" },
                    { "data": "COR" },
                    { "data": "DESC_COR" },
                    { "data": "TAMANHO" },
                    { "data": "QUALIDADE" },
                    { "data": "QTDE_SOLICITADA" },
                    { "data": "STATUS" },
                    { "data": "DEPOSITO" },
                ],
                "columnDefs": [
                    {
                        targets: [3],
                        render(data, type, row) {
                            const codigo = row.CODIGO;
                            const codigoCriptografado = criptografaCodigo(`img_prod_${codigo}`);
                            if (!$(codigoCriptografado).hasClass('carregado')) {
                                buscaFotoProduto(codigo);
                                return `<img class="${codigoCriptografado}" src="${BASE_URI}/dist/img/prod-1.png" loading="lazy" alt="${data}" height="50" width="50"/>`;
                            }
                        }
                    }
                ]
            });

            $('#tabelaDemanda').on('click', 'tr td', async function () {
                if ($(this).index() == 3) {
                    $('.imagepreview').attr('src', $(this).find('img').attr('src'));
                    $('#imagemodal').modal('show');
                    $('#imagemodal').css('z-index', '999999');
                }
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }

    }

    async function carregaValoresPadroes() {
        const pesquisa = {
            camposSelect: ['CAMPO', 'VALOR'],
            tabela: 'TABPADRAO',
            where: [`TABPADRAO.TABELA = 'DEMANDA_ECOMMERCE'`]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (jsonStr.filter(item => item.CAMPO == 'DEPOSITO' && item.VALOR != '').length == 0) {
            msgAlerta('Necessário informar um valor padrão para Depósito transitório dentro da tela de Cadastro Padrão. Verifique.');
            setTimeout(() => {
                $('#modal-transferencia').modal('hide');
            }, 1000);
            return;
        }

        jsonStr.map(async item => {
            switch (item.CAMPO) {
                case 'TIPO_BAIXA': {
                    insereValor('#txtTipoMov', item.VALOR, { tabela: 'TABBAI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'DEPOSITO': {
                    insereValor('#txtDeposito', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                default: break;
            }
        });

    };

    async function buscaFuncionario() {
        const codUsuario = getCookie('cod_usuario');
        try {
            const pesquisaParam = {
                tabela: 'ACESSO_USUARIOS',
                camposSelect: ['ACESSO_USUARIOS.CODFUN', 'PESSOAL.NOME', 'ACESSO_USUARIOS.VISUALIZA_BARRA_EXP'],
                leftJoin: [{ tabela: 'PESSOAL', condicao: 'PESSOAL.CODIGO = ACESSO_USUARIOS.CODFUN' }],
                where: [`ACESSO_USUARIOS.CODIGO = '${codUsuario}'`]
            };
            const jsonStr = (await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam)))[0];

            visualizaBarra = jsonStr.VISUALIZA_BARRA_EXP == 'S';

            if (jsonStr.CODFUN == '') {
                return;
            }

            insereValor('#txtFuncionario', jsonStr.CODFUN, jsonStr.NOME);

        } catch (error) {
            console.error(error);
        }
    };


    async function buscaFotoProduto(codigo, modal = false) {
        const concatenaModal = modal ? 'true' : '';
        const codigoFormatado = criptografaCodigo(`img_prod_${codigo}${concatenaModal}`);
        if ($(`.${codigoFormatado}`).hasClass('carregado')) {
            return;
        }
        try {
            const urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
            const response = await requisicao('GET', urlRequisicao, `CODIGO=${codigo}`, null);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            if (response.status !== 200) {
                $(`.${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                $(`.${codigoFormatado}`).addClass('carregado');
                return;
            }

            const sBase64 = jsonStr;
            $(`.${codigoFormatado}`).attr('src', `data:image/png;base64,${sBase64.mensagem}`);
            $(`.${codigoFormatado}`).addClass('carregado');
        } catch (error) {
            console.error(error);
            $(`.${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        }
    }

    async function retornaBarraLogLida(sBarra) {
        try {
            const url = `/sisplan/barralog/v1/validarbarra?`;
            const params = `barra=${encodeURIComponent(sBarra)}`;
            const response = await requisicao('GET', url, params, 15000);

            if (!response) {
                return;
            }

            jsonStr = await response.json();
            if (response.status != 200) {
                return jsonStr.mensagem;
            }

            return jsonStr.mensagem;
        } catch (error) {
            console.error(error);
        }
    }

    $('#tabelaTransferencia tbody').on('click', 'tr', async function () {
        $("#tabelaTransferencia tbody tr td")[0].click();
        $('#tabelaTransferencia tbody tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });

    $("#txtBarraConferencia").on('blur', async function () {
        if ($(this).val() == '') { return; }
        try {
            const bBarraLog = await retornaBarraLogLida($('#txtBarraConferencia').val()) == "barra_log";
            if (bBarraLog) {
                barralog = await extraiBarra28($("#txtBarraConferencia").val());
            } else {
                msgAlerta('Necessário bipar uma barra_log', undefined, undefined, () => { $('#txtBarraConferencia').val(''); $('#txtBarraConferencia').focus(); });
                return;
            }

            if (!await addBarraLogLida($('#txtBarraConferencia').val())) {
                msgAlerta('Barra Log já lida, impossível ler novamente.');
                return;
            }

            const dados = $('#tabelaTransferencia').DataTable().rows().data().toArray();
            const indiceEncontrado = dados.findIndex(item => item.BARRA28 == barralog);
            if (indiceEncontrado == -1) {
                msgAlerta('Barra não encontrada, verifique.');
                $('#txtBarraConferencia').focus();
            } else {
                const dadosItem = $('#tabelaTransferencia').DataTable().row(indiceEncontrado).data();

                if (dadosItem.ESTOQUE <= 0) {
                    msgAlerta('Não há estoque disponível para esse item.');
                    return;
                }

                if (dadosItem.QTDE_CONFERIDA == dadosItem.ESTOQUE) {
                    msgAlerta('Quantidade total já conferida');
                    return;
                }

                if (dadosItem.QTDE_CONFERIDA == dadosItem.QTDE_SOLICITADA) {
                    msgAlerta('Quantidade solicitada já atendida');
                    return;
                }

                dadosItem.QTDE_CONFERIDA += 1;
                if (dadosItem.QTDE_CONFERIDA == dadosItem.QTDE_SOLICITADA) {
                    dadosItem.CONCLUIDO = dadosItem.CONCLUIDO.replace('times-circle', 'check-circle').replace('#EEAD2D', 'green');
                }
                const codigoCriptografado = criptografaCodigo(`img_prod_${dadosItem.CODIGO}true`);
                $(`.${codigoCriptografado}`).removeClass('carregado');
                $('#tabelaTransferencia').DataTable().row(indiceEncontrado).data(dadosItem).draw(false);
                $($('#tabelaTransferencia tbody tr')[indiceEncontrado]).click();
                // $('#tabelaTransferencia').DataTable().context[0].nScrollBody.scrollTo(0, ($('.selected')[0].offsetTop));
                $("#tabelaTransferencia .dataTables_scrollBody").scrollTo(
                    $("#tabelaTransferencia tbody tr").eq(indiceEncontrado),
                    200
                );

            }
        } finally {
            $('#txtBarraConferencia').val('');
            $('#txtBarraConferencia').focus();
        }
    });

    function retornaListaItens() {
        const dados = $('#tabelaTransferencia').DataTable().data().toArray().filter(dado => dado.QTDE_CONFERIDA > 0);
        const lista = dados.map(dado => ({
            id_demanda: dado.ID_DEMANDA,
            codigo: dado.CODIGO,
            cor: dado.COR,
            tamanho: dado.TAMANHO,
            qualidade: dado.QUALIDADE,
            qtde_conf: dado.QTDE_CONFERIDA,
            deposito: dado.DEPOSITO,
            depositoDestino: dado.DEP_EMP
        }));
        return lista;
    }

    function retornaObjetoTransferencia() {
        const obj = {
            numero: $('#txtNumero').val(),
            itens: retornaListaItens(),
            funcionario: pegaChave('#txtFuncionario'),
            desc_funcionario: pegaDescricao('#txtFuncionario'),
            tipo_movimento: pegaChave('#txtTipoMov'),
            lancamento: $('#txtLancamento').val()
        };
        return obj;
    }

    function retornaListaBarras() {
        const barras = barrasLog;
        const lista = barras.map(barra => ({ barra }));
        return lista;
    }


    async function gravaAtendimento() {
        try {
            try {
                $.LoadingOverlay('show');
                let validacao = true;
                if ($('#txtTabelaDePrecoNFE').val() == '') {
                    msgAlerta('Favor preencher a tabela de preço para continuar.');
                    return;
                } 
                
                if ($('#txtOperacaoNFE').val() != '') {
                    validacao = $('#txtClienteNFE').val() != '';
                } else {
                    validacao = $('#txtNaturezaNFE').val() != '' && $('#txtClienteNFE').val() != '';
                }

                if (!validacao) {
                    msgAlerta('Favor preencher os campos para continuar.');
                    return;
                }

                const url = `/sisplan/demandaecommerce/v1/atendesolicitacao?`;
                const obj = await retornaObjetoTransferencia();
                const barras = await retornaListaBarras();
                const objBarras = {
                    barras
                };
                const deposito = pegaChave('#txtDeposito');
                rotinaGeraLog('DEMANDA_ECOMMERCE', $('#txtNumero').val(), `TRANSFERÊNCIA DE DEPÓSITO POR SOLICITAÇÃO DE E-COMMERCE, BARRAS: ${barrasLog.toString()}`, 'Inclusão');
                const response = await requisicao('POST', url, '', `JSON=${JSON.stringify(obj)}&BARRAS=${JSON.stringify(objBarras)}&DEPOSITO_DEST=${deposito}`, 90000);
                if (response.status == '200') {
                    await toastr
                        .success('Transferência efetuada com sucesso.', "Confirmação", {
                            toastClass: "alert",
                            iconClasses: {
                                error: "alert-error",
                                info: "alert-info",
                                success: "alert-success",
                                warning: "alert-warning",
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                            async onHidden() {
                                // se deu certo a gravação da movimentação
                                const nota = {
                                    NATUREZA: $('#txtNaturezaNFE').val(),
                                    CLIENTE: $('#txtClienteNFE').val(),
                                    NUMERO: $('#txtNumero').val(),
                                    OPERACAO: $('#txtOperacaoNFE').val(),
                                    TRANSFERENCIA: 'S',
                                    TABELA: $('#txtTabelaDePrecoNFE').val()
                                };
                                const jsonNota = JSON.stringify(nota);
                                parent.abrirEmNovaAbaIFrame('Faturamento Geral', `${BASE_URI}/faturamento/`, btoa(jsonNota));
                                $('#modalNFE').modal('hide');
                                $('#modal-transferencia').modal('hide');
                                setTimeout(() => {
                                    window.location.reload();
                                }, 1500);
                            },
                        })
                        .css({
                            "margin-top": "20%",
                            width: "500px",
                            "max-width": "500px",
                        });
                } else {
                    msgAlerta('Não foi possível gravar, verifique.');
                }
            } catch (error) {
                msgAlerta('Erro ao gravar Atendimento');
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    }

    async function confirmarAtendimento() {
        try {
            $.LoadingOverlay('show');
            const dados = $('#tabelaTransferencia').DataTable().data().toArray();
            const itensAtendidos = dados.filter(item => item.QTDE_CONFERIDA > 0);
            if (itensAtendidos.length == 0) {
                msgAlerta('Nenhum item atendido, impossível continuar');
                return;
            }

            if ($('#txtNumero').val() == '') {
                msgAlerta('Necessário gerar um número de transferência.');
                return;
            }

            if ($('#txtFuncionario').val() == '') {
                msgAlerta('Necessário informar um funcionário.');
                return;
            }

            if ($('#txtTipoMov').val() == '') {
                msgAlerta('Necessário informar um tipo de movimento.');
                return;
            }

            if ($('#txtDeposito').val() == '') {
                msgAlerta('Necessário informar um Depósito na tela de Cadastro Padrão.');
                return;
            }
            $('#modal-transferencia').modal('hide');
            $("#modalNFE").modal({
                backdrop: "static",
                keyboard: true,
                show: true,
            });
            $('#modalNFE').modal('show');
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#btnCancelar').on('click', async function () {
        msgAlerta('Tem certeza que deseja cancelar?', () => { 
            $('#modal-transferencia').modal('hide'); 
            barrasLog = [];
        });
    });

    $('#btnConfirmar').on('click', async function () {
        const dados = $('#tabelaTransferencia').DataTable().data().toArray();
        const temQuantidadeNaoAtendida = dados.filter(item => item.QTDE_SOLICITADA != item.QTDE_CONFERIDA).length > 0;
        if (temQuantidadeNaoAtendida) {
            msgAlerta('Há itens que não foram conferidos, tem certeza que deseja confirmar?', () => {
                confirmarAtendimento();
            });
        } else {
            confirmarAtendimento();
        }
    });

    $('#btn_confirmar_nfe').on('click', async function () {
        await gravaAtendimento();
    });

    $("#txtBarraConferencia").on("keydown", async function (event) {
        if (event.key == "Enter") {
            $("#txtBarraConferencia").trigger("blur");
            $("#txtBarraConferencia").focus();
        }
    });

    $('#modal-transferencia').on('shown.bs.modal', async function () {
        // $("#txtNumero").focus();
        // setTimeout(() => {
        //     $('#modal-transferencia').DataTable().columns.adjust().draw(false); 
        // }, 1500);
        //    $("#txtNumero").attr('disabled', true);
    });

    $('#modal-transferencia').on('hidden.bs.modal', async function () {
        await consultaDemandas();
    });

    $("#txtNumero").on("blur", async function () {
        try {
            $.LoadingOverlay("show");
            const lancamento = await RetornaDoctoELancto('LANCTO', 'PA_MOV', 'NUM_DOCTO', '6');
            insereValor('#txtLancamento', lancamento);
            const docto = await RetornaProximo("DOCTO", "PA_MOV", "NUM_DOCTO", "6");
            insereValor("#txtNumero", docto);
            $(this).attr("disabled", $(this).val() != "");
        } finally {
            $.LoadingOverlay("hide");
            $('#txtBarraConferencia').focus();
        }
    });


    $('#modalNFE .close').off();
    $('#modalNFE .close').on('click', async function () {
        msgAlerta('Tem certeza que deseja cancelar ? você irá perder os itens bipados.', ()=> { 
            $('#modalNFE').modal('hide'); 
            barrasLog = [];
        }, ()=>{});
    });

    $('#modal-transferencia .close').off();
    $('#modal-transferencia .close').on('click', async function () {
        $('#btnCancelar').trigger('click');
    });

    $('#btnTransferir').on('click', async function () {
        if ($('#tabelaDemanda').DataTable().data().toArray().length == 0) {
            msgAlerta('Nenhuma solicitação de estoque encontrada para a sua loja.');
            return;
        }

        $('#txtNumero').attr('disabled', false);
        $('#txtNumero').val('');
        $('#txtNumero').trigger('blur');
        $('#txtLancamento').val('');
        $('#txtTipoMov').val('');
        await buscaFuncionario();
        await carregaValoresPadroes();

        $("#modal-transferencia").modal({
            backdrop: "static",
            keyboard: true,
            show: true,
        });

        const depositosVinculados = await verificaDepositoEmpresa();
        const depositosEmp = depositosVinculados.EMP_DEPOSITO.length > 0 ? depositosVinculados.EMP_DEPOSITO : '';

        const pesquisa = {
            camposSelect: ['DEMANDA_ENVIAR.ID_DEMANDA',
                'DEMANDA_RECEBER.DEPOSITO DEP_EMP',
                'DEMANDA_RECEBER.CODIGO',
                'PRODUTO.DESCRICAO',
                'DEMANDA_RECEBER.COR',
                'CADCOR.DESCRICAO DESC_COR',
                'DEMANDA_RECEBER.TAMANHO',
                'DEMANDA_RECEBER.QUALIDADE',
                'DEMANDA_ENVIAR.QTDE_SOLICITADA',
                'DEMANDA_ENVIAR.QTDE_ENVIADA QTDE_CONFERIDA',
                'DEMANDA_ENVIAR.DEPOSITO',
                'PA_ITEN.BARRA28',
                'PA_ITEN.QUANTIDADE ESTOQUE',
                "'' FOTO"
            ],
            tabela: 'DEMANDA_ENVIAR',
            leftJoin: [{ tabela: 'DEMANDA_RECEBER', condicao: 'DEMANDA_RECEBER.ID = DEMANDA_ENVIAR.ID_DEMANDA' },
            { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = DEMANDA_RECEBER.CODIGO' },
            { tabela: 'CADCOR', condicao: 'CADCOR.COR = DEMANDA_RECEBER.COR' },
            { tabela: 'PA_ITEN', condicao: 'PA_ITEN.CODIGO = DEMANDA_RECEBER.CODIGO AND PA_ITEN.COR = DEMANDA_RECEBER.COR AND PA_ITEN.TAM = DEMANDA_RECEBER.TAMANHO AND PA_ITEN.TIPO = DEMANDA_RECEBER.QUALIDADE AND PA_ITEN.DEPOSITO = DEMANDA_ENVIAR.DEPOSITO' }
            ],
            where: [`DEMANDA_ENVIAR.STATUS = 'PENDENTE' AND DEMANDA_ENVIAR.QTDE_SOLICITADA > DEMANDA_ENVIAR.QTDE_ENVIADA`],
            orderBy: [`DEMANDA_RECEBER.CODIGO`, `DEMANDA_RECEBER.COR`, `DEMANDA_RECEBER.TAMANHO`]
        };

        if (depositosEmp.length > 0) {
            pesquisa.where[0] += ` AND DEMANDA_ENVIAR.DEPOSITO IN (${depositosEmp})`;
        }

        const response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON=${JSON.stringify(pesquisa)}`, null);

        if (!response) {
            $.LoadingOverlay("hide");
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }

        const dados = jsonStr.RESULT[0].map(item => ({ CONCLUIDO: `<div class="icheck-primary d-inline"><span class="fas fa-times-circle" style="color:#EEAD2D"></span></div>`, ...item }));
        $('#tabelaTransferencia').DataTable({
            destroy: true,
            searching: false,
            order: false,
            sort: false,
            paginate: false,
            lengthChange: false,
            serverside: false,
            autoWidth: true,
            // scrollX: '750px',
            // scrollY: '380px',
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
            "data": dados,
            "columns": [
                { "data": "CONCLUIDO" },
                { "data": "ID_DEMANDA" },
                { "data": "DEP_EMP" },
                { "data": "CODIGO" },
                { "data": "DESCRICAO" },
                { "data": "FOTO" },
                { "data": "COR" },
                { "data": "DESC_COR" },
                { "data": "TAMANHO" },
                { "data": "QUALIDADE" },
                { "data": "QTDE_SOLICITADA" },
                { "data": "ESTOQUE" },
                { "data": "QTDE_CONFERIDA" },
                { "data": "DEPOSITO" },
                { "data": "BARRA28" },
            ],
            "columnDefs": [
                {
                    targets: [5],
                    render(data, type, row) {
                        const codigo = row.CODIGO;
                        const codigoCriptografado = criptografaCodigo(`img_prod_${codigo}true`);
                        if (!$(codigoCriptografado).hasClass('carregado')) {
                            buscaFotoProduto(codigo, true);
                            return `<img class="${codigoCriptografado}" src="${BASE_URI}/dist/img/prod-1.png" loading="lazy" alt="${data}" height="50" width="50"/>`;
                        }
                    }
                },
                {
                    targets: [1, 2, 14],
                    visible: false,
                    // targets: [0], render: function (data, type, row) {
                    //     return retornaBotaoOpcoes(data);
                    //   }
                }
            ]
        });

        $('#tabelaTransferencia').on('click', 'tr td', async function () {
            if ($(this).index() == 3) {
                $('.imagepreview').attr('src', $(this).find('img').attr('src'));
                $('#imagemodal').modal('show');
                $('#imagemodal').css('z-index', '999999');
            }
        });

        $("#modal-transferencia").modal("show");



    });

    // $('#tabelaUnidade').on('click', '#btn-editar', async function () {
    //     if (permissaoUsuarioLogado.ALTERA == 'S') {

    //         let data = $('#tabelaUnidade').DataTable().row($(this).parents('tr')).data();
    //         let registroLiberado = await verificarRegistro('UNIDADE', data.UNIDADE);
    //         if (registroLiberado) {
    //             window.location.href = `unidade/${data.UNIDADE}`;
    //         }
    //     } else {
    //         msgAlertaSemConfirmacao("Sem permissão para alterar!");
    //     }
    // });

    // $('#tabelaUnidade').on('dblclick', 'tr', async function () {
    //     if (permissaoUsuarioLogado.ALTERA == 'S') {
    //         let data = $('#tabelaUnidade').DataTable().row($(this)).data();
    //         let registroLiberado = await verificarRegistro('UNIDADE', data.UNIDADE);
    //         if (registroLiberado) {
    //             window.location.href = `unidade/${data.UNIDADE}`;
    //         }
    //     } else {
    //         msgAlertaSemConfirmacao("Sem permissão para alterar!");
    //     }
    // });

    // $('#tabelaUnidade').on('click', '#btn-excluir', async function () {
    //     if (permissaoUsuarioLogado.EXCLUI == 'S') {
    //         msgAlerta('Você realmente deseja excluir esse registro?', async () => {
    //             const data = $("#tabelaUnidade").DataTable().row($(this).parents("tr"));
    //             await excluiRegistro(data);
    //         });
    //     } else {
    //         msgAlertaSemConfirmacao("Sem permissão para excluir!");
    //     }
    // });


});