$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#abaGeral',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar as barras.',
          position: 'bottom'
        }
      },
      {
        element: '#divBarra',
        popover: {
          title: 'Campos Barra',
          description: 'Aqui você pode filtrar as barras nos tipos: BARRA28, EAN13 e BARRA_LOG.',
          position: 'bottom'
        }
      },
      {
        element: '#btnConsultar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta das barras.',
          position: 'left'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para realizar a impressão dos registros filtrados.',
          position: 'left'
        }
      },
      {
        element: '#divTabela',
        popover: {
          title: 'Tabela Barras',
          description: 'Aqui estão os dados das barras filtrados.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  addPesquisaAutocompleta();

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.consultaBarraLog == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, consultaBarraLog: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, consultaBarraLog: novasColunas }))
      $('#tabelaBarras').DataTable().columns().visible(true);
      $('#tabelaBarras').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })
      $('#modal-ColunasVisiveis').modal('hide');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#btnConsultar').on('click', async () => { await buscaBarrasLog() });

  async function retornaFiltros() {
    const barraLogLida = $('#rdLidas').is(':checked') ? 'S' : $('#rdNaoLidas').is(':checked') ? 'N' : '';
    const isBarraLog = $('#txtBarra').val() != '' ? await retornaTipoBarra($('#txtBarra').val()) == "barra_log" : false;
    const filtros =
      `PRODUTO=${await formataListas($('#txtProduto').val().toString())}` +
      `&COR=${await formataListas($('#txtCor').val().toString())}` +
      `&TAMANHO=${await formataListas($('#txtTamanho').val().toString())}` +
      `&DEPOSITO=${await formataListas($('#txtDeposito').val().toString())}` +
      `&EPC=${encodeURIComponent($('#txtEPC').val())}` +
      `&BARRA=${encodeURIComponent($('#txtBarra').val())}` +
      `&BARRALOG=${isBarraLog ? 'S' : 'N'}` +
      `&BARRALOGLIDA=${barraLogLida}`;
    return filtros;
  }

  async function buscaBarrasLog() {
    if ($.fn.DataTable.isDataTable('#tabelaBarras')) {
      $("#tabelaBarras").DataTable().destroy();
      $("#tabelaBarras").empty();
    };
    $.LoadingOverlay('show')
    try {
      const url = "/sisplan/impressao/v1/relbarralog?";
      const filtros = await retornaFiltros()
      const response = await requisicao("GET", url, filtros, "", 360000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json()
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      if (jsonStr.length <= 0) {
        throw new Error('Nenhum registro encontrado!')
      }

      await montaDataTableBarras(jsonStr)
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function montaDataTableBarras(jsonStr) {
    const dataSetCols = []
    const keys = Object.keys(jsonStr[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    $('#tabelaBarras').DataTable({
      bPaginate: true,
      destroy: true,
      colReorder: true,
      filter: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado na tabela de pedidos",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado na tabela de pedidos",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
    });

    $('#tabelaBarras_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
    $('#tabelaBarras_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcel').prop('title', 'Exportar')

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#buttonColVis').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#buttonExcel').on('click', async function () {
      let dados = $("#tabelaBarras").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Relatório de Barras Log', '#tabelaBarras', '', 999, false, false, dados);
    })

    $('#tabelaBarras').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.consultaBarraLog).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaBarras').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.consultaBarraLog ?? [])
  })

  function validacaoRegistroEncontrado() {
    if (!$.fn.DataTable.isDataTable('#tabelaBarras')) {
      throw new Error('Nenhum registro encontrado!')
    }

    if ($('#tabelaBarras').DataTable().data().toArray().length <= 0) {
      throw new Error('Nenhum registro encontrado!')
    }
  }

  retornaHintRelatorio('btnImprimir', 'RelBarraLog')

  $('#btnImprimir').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      validacaoRegistroEncontrado()

      const url = `/sisplan/impressao/v1/relbarralog?`;
      const filtros = await retornaFiltros();
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelBarraLog');
      const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'POST', 360000, false, 'RelBarraLog');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function retornaTipoBarra(sBarra) {
    try {
      const url = `/sisplan/barralog/v1/validarbarra?`;
      const params = `barra=${encodeURIComponent(sBarra)}`;
      const response = await requisicao('GET', url, params, 15000);

      if (!response) {
        return;
      }

      jsonStr = await response.json();
      if (response.status != 200) {
        return jsonStr.mensagem;
      }

      return jsonStr.mensagem;
    } catch (error) {
      console.error(error);
    }
  }

  function addPesquisaAutocompleta() {
    componenteFiltro('produto', true, true)
    componenteFiltro('cor', true, true)
    componenteFiltro('tamanho', true, true)
    componenteFiltro('deposito', true, true)
  }
});