$("#tutorial").on("click", function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
        });
        driver.defineSteps([]);
        driver.start();
    });
});

$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CHEQUEEMI");
    let dataCancelamento = {}

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (colunas == null || colunas.chequeemi == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, chequeemi: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, chequeemi: novasColunas }))
            $('#tabelaCheque').DataTable().columns().visible(true);
            $('#tabelaCheque').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

            $('#modal-ColunasVisiveis').modal('hide');
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaCheque').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });
        adicionaColunas(cols, colunasInvisiveis.chequeemi ?? [], ['NUMERO'])

    })

    await adicionaPesquisaFiltros()
    $("#btnFiltros").on("click", async function () {
        $("#modal-filtros").modal("show");
    });

    $("#btnMovimentacao").on("click", async function () {
        if (permissaoUsuarioLogado.INCLUI == "S") {
            window.location.href = "chequeemi/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#btnConsultar').on('click', async function () {
        await buscaAcesso()
        $("#modal-filtros").modal("hide");
    })

    $('#btnSelecionarEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    async function retornaFiltros() {
        const situacao = $('#rgPendentes').is(':checked') ? 'P' : $('#rgCancelados').is(':checked') ? 'C' : $('#rgBaixados').is(':checked') ? 'B' : 'T';
        const empresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')]

        const filtros = `DTVENCIMENTODE=${$('#txtDtVencimentoI').val()}` +
            `&DTVENCIMENTOATE=${$('#txtDtVencimentoF').val()}` +
            `&DTEMISSAODE=${$('#txtDtEmissaoI').val()}` +
            `&DTEMISSAOATE=${$('#txtDtEmissaoF').val()}` +
            `&SITUACAO=${situacao}` +
            `&CHEQUE=${await formataListas($('#txtCheque').val().toString())}` +
            `&BANCO=${pegaChave('#txtBanco')}` +
            `&CONTA=${pegaChave('#txtConta')}` +
            `&EMPRESAS=${await formataListas(empresas.toString())}` +
            `&FORNECEDOR=${pegaChave('#txtFornecedor')}`;

        return filtros
    }

    async function buscaAcesso() {
        $.LoadingOverlay('show')
        try {
            const url = "/sisplan/chequeemi/v1/buscaacesso?"
            const filtros = await retornaFiltros()
            const response = await requisicao('GET', url, filtros, null, 180000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            if (response.status != 200) {
                throw msgAlerta(jsonStr.mensagem);
            }

            if (jsonStr.length <= 0) {
                throw msgAlerta('Nenhum registro encontrado!');
            }

            await montaDataTableAcesso(jsonStr)

        } catch (error) {
            $('#modal-filtros').modal('hide')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    function retornaBotaoOpcoes(data) {
        var retorno = '<div> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" title="Cancelar" id="btnCancelar">Cancelar</button>     ' +
            '    <button class="dropdown-item" title="Excluir" id="btnExcluir">Excluir</button>     ' +
            '</div>';
        return retorno;
    };

    async function montaDataTableAcesso(jsonStr) {
        if ($.fn.DataTable.isDataTable('#tabelaCheque')) {
            $('#tabelaCheque').DataTable().destroy();
            $('#tabelaCheque').empty();
        }

        const keys = Object.keys(jsonStr[0]);
        let dataSetCols = [];

        for (var k in keys) {
            dataSetCols.push({
                'title': keys[k].toUpperCase(),
                'data': keys[k]
            });
        };

        $('#tabelaCheque').DataTable({
            bPaginate: true,
            search: false,
            destroy: true,
            colReorder: true,
            order: [],
            info: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado na tabela de pedidos",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado na tabela de pedidos",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    type: "date-br",
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        } else {
                            return ''
                        }
                    },
                    targets: [1, 2]
                },
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            minimumFractionDigits: 2,
                        });
                    },
                    targets: [3],
                    "className": 'pr-4 text-right'
                },
                {
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    },
                }
            ]
        });

        $('#tabelaCheque_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaCheque_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#buttonColVis').on('click', async function () {
            $.LoadingOverlay('show')
            try {
                $('#modal-ColunasVisiveis').modal('show');
            } finally {
                $.LoadingOverlay('hide')
            }
        });

        $('#tabelaCheque').DataTable().columns().every(
            function () {
                if ((colunasInvisiveis.chequeemi).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            })

        $('#buttonExcel').off()
        $('#buttonExcel').on('click', async function () {
            const dados = $("#tabelaCheque").DataTable().data().toArray();
            await exportaCSV('', null, false, null, 'Relatório de Orçamento', '#tabelaCheque', '', 999, false, false, dados)
        })
    }

    $("#tabelaCheque").on("click", "#btnCancelar", async function () {
        $.LoadingOverlay("show");
        try {
            if (permissaoUsuarioLogado.ALTERA == "S") {
                dataCancelamento = $("#tabelaCheque").DataTable().row($(this).parents("tr"));
                $('#modalCancelar').modal('show')
            } else {
                msgAlertaSemConfirmacao("Sem permissão para cancelar!");
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $("#tabelaCheque").on("click", "#btnExcluir", async function () {
        $.LoadingOverlay("show");
        try {
            if (permissaoUsuarioLogado.EXCLUI == "S") {
                msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                    const data = $("#tabelaCheque").DataTable().row($(this).parents("tr"));
                    await deletaCheque(data);
                });
            } else {
                msgAlertaSemConfirmacao("Sem permissão para excluir!");
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $('#btnConfirmar').on('click', async function () {
        msgAlerta('Você realmente deseja cancelar este cheque?', async () => {
            await deletaCheque(dataCancelamento, $('#txtMotivo').val());
            $('#modalCancelar').modal('hide')
            $('#txtMotivo').val('')
        });
    })

    $('#btnFecharCancelar').on('click', async function () {
        $('#modalCancelar').modal('hide')
    })
    
    $('#modalCancelar').on('hidden.bs.modal', function () {
        $('#txtMotivo').val('')    
    })

    async function deletaCheque(data, mensagem = '') {
        $.LoadingOverlay('show')
        try {
            const linha = data.data()

            if (mensagem != '' && linha.STATUS != 'CHEQ') {
                msgAlerta('Impossível cancelar este cheque.');
                return
            } else if ((!mensagem != '') && linha.STATUS != 'CHCA') {
                msgAlerta('Para excluir um cheque é necessário primeiro fazer o cancelamento.');
                return
            }

            const cheque = {
                LANCAMENTO: linha.LANCAMENTO,
                EMISSAO: linha.EMISSAO,
                VENCIMENTO: linha.VENCIMENTO,
                VALOR: linha.VALOR,
                BANCO: linha.BANCO,
                AGENCIA: linha.LANCAMENTO,
                CONTA: linha.CONTA,
                NUM_AP: linha.NUM_AP,
                NUMERO: linha.NUMERO,
                EMPRESA: linha.EMPRESA,
                CODCRE: linha.CODCRE,
                NOME: linha.NOME,
                SITUACAO: linha.SITUACAO,
                CLASSE: linha.CLASSE,
                HISTORICO: linha.HISTORICO,
                MENSAGEM: mensagem,
            }

            let response = await requisicao(mensagem != '' ? "POST" : "DELETE", "/sisplan/chequeemi/v1/deletacheque?", `JSON=${encodeURIComponent(JSON.stringify(cheque))}`, null, 50000);

            if (!response) {
                return;
            }
            if (response.status != 200) {
                let jsonStr = await response.json();
                msgAlerta(jsonStr.mensagem);
                return;
            }

            toastr.success(`Cheque ${mensagem != '' ? 'cancelado' : 'excluido'} com sucesso!`, "Confirmação", {
                toastClass: "success",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    if (mensagem != '') {
                        $('#btnConsultar').trigger('click')
                    } else {
                        data.remove().draw(false);
                    }
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
            dataCancelamento = {}
        }
    }

    $('#btnLimparFiltros').on('click', async function () {
        limparFiltros()
    })

    function limparFiltros() {
        $('#txtDtCadastroI').val('1200-01-01')
        $('#txtDtCadastroF').val('2500-12-01')
        $('#txtDtSaidaI').val('1200-01-01')
        $('#txtDtSaidaF').val('2500-12-01')
        $('#txtDtEntregaI').val('1200-01-01')
        $('#txtDtEntregaF').val('2500-12-01')
        $('#txtDtDigitacaoI').val('1200-01-01')
        $('#txtDtDigitacaoF').val('2500-12-01')
        $('#rgTodos').prop('checked', true)
        $('#rgItensTodos').prop('checked', true)
        $('#txtNumero').empty().trigger('change')
        $('#txtCliente').empty().trigger('change')
        $('#txtProduto').empty().trigger('change')
        $('#txtGrupoPA').empty().trigger('change')
        $('#txtEtiqueta').empty().trigger('change')
        $('#txtLinha').empty().trigger('change')
    }

    retornaHintRelatorio('btnImprimir', 'RelAcessoChequeEmi')

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/chequeemi/v1/imprimiracesso?`;
                const filtros = await retornaFiltros();
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoChequeEmi');
                const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 100000, false, 'RelAcessoChequeEmi');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function adicionaPesquisaFiltros() {
        componenteFiltro("banco", false, false);
        componenteFiltro("conta", false, false);
        componenteFiltro("entidade", false, false, 'Fornecedor');

        $('#txtCheque').pesquisa_variosServerside(3, `{ 
            "tabela":"PAGTO", 
            "camposSelect": ["PAGTO.DUPLI", "PAGTO.CODCRE"],
            "where": ["PAGTO.STATUS = 'CHEQ' OR PAGTO.STATUS = 'CHCA'"]}`,
            'DUPLI', 'CODCRE');

        $('#btnCheque').pesquisa_serversideSel('#txtCheque', `{ 
            "tabela":"PAGTO", 
            "camposSelect": ["PAGTO.DUPLI", "PAGTO.CODCRE", "ENTIDADE.NOME", "PAGTO.VALOR"], 
            "leftjoin":[{"tabela":"ENTIDADE", "condicao": "ENTIDADE.CODCLI = PAGTO.CODCRE"}],
            "where": ["PAGTO.STATUS = 'CHEQ' OR PAGTO.STATUS = 'CHCA'"]}`, 'Pesquisa Cheques');

        $('#btnLimpaCheque').on('click', function () {
            $('#txtCheque').empty().trigger('change');
        });
    }
});
