$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de uma carteira de pagamento.",
          position: "right",
        },
      },
      {
        element: "#tabelaCarteiraPagamento",
        popover: {
          title: "Tabela Carteira Pagamento",
          description: "Aqui estão os dados das carteiras de pagamento cadastradas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CARTEIRA_COBRANCA");

  $("#txtConta").autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "Conta CHAVE", "DESCRICAO"], "where": null}`);
  $("#btnConta").pesquisa("#txtConta", "CONTA", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO"]}`, "Pesquisa Conta", "CADCONTA");
  $("#btnLimpaConta").on("click", function () {
    $("#txtConta").val("");
  });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnIncluir").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "carteira_cobranca/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };


  await consultaCarteirasCobranca();

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await consultaCarteirasCobranca();
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtConta").val("");
  });

  async function consultaCarteirasCobranca() {
    try {
      $.LoadingOverlay("show");
      let codigo = pegaChave("#txtConta") != "" ? ` AND CONTA = '${pegaChave("#txtConta")}'` : "";
      const response = await requisicao("GET", "/Sisplan/Funcoes/V1/pesquisa?", `JSON={ "tabela":"CARTEIRA", "camposSelect":[ "CARTEIRA", "CONTA", "DESCRICAO"], "where": ["CARTEIRA <> 'P' ${codigo}"]}`, null);
      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      if (jsonStr.RESULT[0].length == 0) {
        $.LoadingOverlay("hide");
        return;
      }

      $("#tabelaCarteiraCobranca").DataTable({
        destroy: true,
        lengthChange: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "CARTEIRA",
          },
          {
            data: "CONTA",
          },
          {
            data: "DESCRICAO",
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $("#tabelaCarteiraCobranca").on("dblclick", "tr", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
          let data = $("#tabelaCarteiraCobranca").DataTable().row($(this)).data();
          const dados = btoa(JSON.stringify({ CONTA: data.CONTA, CARTEIRA: data.CARTEIRA }));
          window.location.href = `carteira_cobranca/${dados}`;
        } else {
          msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }

      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaCarteiraCobranca").unbind("click");

  $("#tabelaCarteiraCobranca").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaCarteiraCobranca").DataTable().row($(this).parents("tr")).data();
      const dados = btoa(JSON.stringify({ CONTA: data.CONTA, CARTEIRA: data.CARTEIRA }));
      window.location.href = `carteira_cobranca/${dados}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaCarteiraCobranca').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaCarteiraCobranca").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/sisplan/cadastros/v1/carteira?", `CONTA=${encodeURIComponent(valorLinha.CONTA)}&CARTEIRA=${encodeURIComponent(valorLinha.CARTEIRA)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgAlerta(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});
