$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
    });

    driver.defineSteps([
      {
        element: '#campostour',
        popover: {
          title: 'Tipo',
          description: "Aqui, escolhemos o tipo de item que será usado para a amarração.",
          position: 'top'
        }
      },
      {
        element: '#inputMaterial',
        popover: {
          title: 'Código do Item',
          description: 'Código do item a ser amarrado.',
          position: 'top'
        }
      },
      {
        element: '#txtFornecedor',
        popover: {
          title: 'Fornecedor',
          description: 'Fornecedor a ser amarrado.',
          position: 'top'
        }
      },
      {
        element: '#txtCodFornec',
        popover: {
          title: 'Código Fornecedor',
          description: 'Código para este Fornecedor.',
          position: 'top'
        }
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: '#gravar',
        popover: {
          title: 'Botão Gravar',
          description: 'Clique aqui para gravar o cadastro da Amarração.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  async function aplicaMascara() {
    $('.campoValor').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2
    });

    $('.campoInteger').on('input', function (e) {
      let valorAtual = $(this).val();

      let novoValor = valorAtual.replace(/\D/g, '');

      if (novoValor != valorAtual) {
        $(this).val(novoValor);
      }
    });
  }

  await aplicaMascara()

  $('#txtProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnProduto').pesquisa('#txtProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Produto', 'PRODUTO');
  $('#btnLimpaProduto').on('click', function () {
    $('#txtProduto').val('');
  });

  $('#txtMaterial').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnMaterial').pesquisa('#txtMaterial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Material', 'MATERIAL');
  $('#btnLimpaMaterial').on('click', function () {
    $('#txtMaterial').val('');
  });

  $('#txtServico').autocompleta(1, `JSON={ "tabela":"SERVICO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnServico').pesquisa('#txtServico', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SERVICO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Servico', 'SERVICO');
  $('#btnLimpaServico').on('click', function () {
    $('#txtServico').val('');
  });

  $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":[ "COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnCor').pesquisa('#txtCor', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"]}`, 'Pesquisa de Cor', 'CADCOR');
  $('#btnLimpaCor').on('click', function () {
    $('#txtCor').val('');
  });

  $('#txtTamanho').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":[ "TAM CHAVE", "FAIXA DESCRICAO"], "where": null}`);
  $('#btnTamanho').pesquisa('#txtTamanho', 'TAM', 'FAIXA', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA", "CODIGO2"]}`, 'Pesquisa de Tamanho', 'TABTAM');
  $('#btnLimpaTamanho').on('click', function () {
    $('#txtTamanho').val('');
  });

  $('#txtFornecedor').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#btnFornecedor').pesquisa('#txtFornecedor', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, 'Pesquisa de Fornecedor', 'ENTIDADE');
  $('#btnLimpaFornecedor').on('click', function () {
    $('#txtFornecedor').val('');
  });

  $('#txtUnidade').autocompleta(1, `JSON={ "tabela":"UNIDADE", "camposSelect":[ "UNIDADE CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#btnUnidade').pesquisa('#txtUnidade', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"UNIDADE", "camposSelect":[ "UNIDADE", "DESCRICAO"]}`, 'Pesquisa de Unidade', 'UNIDADE');
  $('#btnLimpaUnidade').on('click', function () {
    $('#txtUnidade').val('');
  });


  $('#rdTipoProduto, #rdTipoMaterial, #rdTipoServico').on('change', function () {
    $('#txtProduto').val('')
    $('#txtMaterial').val('')
    $('#txtServico').val('')

    if($('#rdTipoServico').is(':checked')) {
      $('#inputMaterial').addClass('d-none')
      $('#inputProduto').addClass('d-none')
      $('#inputServico').removeClass('d-none')
    }else if($('#rdTipoProduto').is(':checked')){
      $('#inputMaterial').addClass('d-none')
      $('#inputServico').addClass('d-none')
      $('#inputProduto').removeClass('d-none')
    }else {
      $('#inputMaterial').removeClass('d-none')
      $('#inputProduto').addClass('d-none')
      $('#inputServico').addClass('d-none')
    }
  });

  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let amarracao_fornecedor = parametros[parametros.length - 1];

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('AMARRACAO_FORNECEDOR', getCookie('usuario'), amarracao_fornecedor);
    window.location.href = `${BASE_URI}/amarracao_fornecedor`;
  });

  if (amarracao_fornecedor != '' && amarracao_fornecedor != 'create') {

    if (await liberarRegistro('AMARRACAO_FORNECEDOR', amarracao_fornecedor) == false) {
      window.location.href = '../amarracao_fornecedor';
    } else {
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"CONV_MATERIAL", 
                    "camposSelect":["*"], 
                    "where": ["ID = '${amarracao_fornecedor}'"]}`, null);

          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          await preencherTipoComDados(jsonStr.RESULT[0][0].CODIGO_MAT, jsonStr.RESULT[0][0].TIPO);

          const pesquisasMap = {
            COR: pesquisaCor,
            UNI_COM: pesquisaUnidade,
            CODFOR: pesquisaFornecedor,
            TAM: pesquisaTamanho
          };
          
          for (const [campo, funcaoPesquisa] of Object.entries(pesquisasMap)) {
              const valor = jsonStr.RESULT[0][0][campo];
              if (valor) {
                  await funcaoPesquisa(valor);
              }
          }
          
          $('#txtCodFornec').val(jsonStr.RESULT[0][0].CODIGO_FOR);
          $('#txtDescFornec').val(jsonStr.RESULT[0][0].DESCRICAO_FOR);
          $('#txtFatorConv').val(jsonStr.RESULT[0][0].DIVISOR);
          $('#txtPreco').val(jsonStr.RESULT[0][0].PRECO);
          $('#txtDiasEntrega').val(jsonStr.RESULT[0][0].DIAS_ENTREGA);
          $('#txtDia').val(jsonStr.RESULT[0][0].DIAS);
          $('#txtPeso').val(jsonStr.RESULT[0][0].PESO);
          $('#txtGramatura').val(jsonStr.RESULT[0][0].GRAMATURA);
          $('#txtLargura').val(jsonStr.RESULT[0][0].LARGURA);

          $(`#rdTipoMaterial, #rdTipoProduto, #rdTipoServico, 
            #txtServico, #btnServico, #btnLimpaServico, 
            #txtMaterial, #btnMaterial, #btnLimpaMaterial, 
            #txtProduto, #btnProduto, #btnLimpaProduto,
            #txtFornecedor, #btnFornecedor, #btnLimpaFornecedor,
            #txtCodFornec`).prop('disabled', true)

          $('.campoValor').each(function () {
            let valorAtual = $(this).val();
            $(this).val(valorAtual).trigger('mask');
          });

        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados da Função: ${error}`);
        }
      } finally {
        $('#txtCodigo').attr('readonly', true);
        $.LoadingOverlay('hide');
      }
    }
  }

  $("#gravar").click(
    async function () {
      try {
        $.LoadingOverlay("show");

        const tiposMap = {
          '#rdTipoServico': { campo: '#txtServico', mensagem: 'Serviço', tipo: 'S' },
          '#rdTipoProduto': { campo: '#txtProduto', mensagem: 'Produto', tipo: 'P' },
          '#rdTipoMaterial': { campo: '#txtMaterial', mensagem: 'Material', tipo: 'M' }
        };
        
        let codigo = '';
        let tipoSelecionado = '';
        
        for (const [tipo, dados] of Object.entries(tiposMap)) {
          if ($(tipo).is(':checked')) {
              if ($(dados.campo).val() === '') {
                  msgAlertaSemConfirmacao(`Campo '${dados.mensagem}' vazio, verifique!`);
                  return;
              }
              codigo = pegaChave(dados.campo);
              tipoSelecionado = dados.tipo;
              break;
          }
        }

        const id =  await RetornaProximo('Amarração Fornecedor', 'CONV_MATERIAL', 'ID', 0);

        let objAmarracaoFornecedor = {};
        if (amarracao_fornecedor != '' && amarracao_fornecedor != 'create'){
          objAmarracaoFornecedor.id = amarracao_fornecedor
        }else{
          objAmarracaoFornecedor.id = id
        }
        
        objAmarracaoFornecedor.codigoMat = codigo
        objAmarracaoFornecedor.tipo = tipoSelecionado
        objAmarracaoFornecedor.cor = pegaChave('#txtCor')
        objAmarracaoFornecedor.tam = pegaChave('#txtTamanho')
        objAmarracaoFornecedor.codfor = pegaChave('#txtFornecedor')
        objAmarracaoFornecedor.dtAtualiza = $('#dtAttDe').val()
        objAmarracaoFornecedor.uniCom = pegaChave('#txtUnidade')
        objAmarracaoFornecedor.codigofor = $('#txtCodFornec').val()
        objAmarracaoFornecedor.descricaoFor = $('#txtDescFornec').val()
        objAmarracaoFornecedor.divisor = $('#txtFatorConv').val()
        objAmarracaoFornecedor.preco = $('#txtPreco').val()
        objAmarracaoFornecedor.diasEntrega = $('#txtDiasEntrega').val()
        objAmarracaoFornecedor.dias = $('#txtDia').val()
        objAmarracaoFornecedor.peso = $('#txtPeso').val()
        objAmarracaoFornecedor.gramatura = $('#txtGramatura').val()
        objAmarracaoFornecedor.largura = $('#txtLargura').val()

        let response = await requisicao('POST', '/Sisplan/Cadastros/v1/amarracaofornecedor?', `JSON=${encodeURIComponent(JSON.stringify(objAmarracaoFornecedor))}`, null);

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        };

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr.success(
          `Cadastro efetuado com sucesso!`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/amarracao_fornecedor`;
          }
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });

      } catch (error) {
        console.error(error);
        msgAlerta(error.message)
        $.LoadingOverlay("hide");
      }
    });

    async function preencherTipoComDados(codigo_mat, tipo) {
      const map = {
          'M': {
              pesquisa: pesquisaMaterial,
              campo: '#txtMaterial',
              radio: '#rdTipoMaterial'
          },
          'P': {
              pesquisa: pesquisaProduto,
              campo: '#txtProduto',
              radio: '#rdTipoProduto'
          },
          'S': {
              pesquisa: pesquisaServico,
              campo: '#txtServico',
              radio: '#rdTipoServico'
          }
      };
  
      const opcoes = map[tipo];
      if (opcoes) {
          const resultado = await opcoes.pesquisa(codigo_mat);
          if (resultado && Object.keys(resultado).length > 0) {
              $(opcoes.radio).trigger('click', true);
              insereValor(opcoes.campo, resultado.CODIGO, resultado.DESCRICAO);
              return;
          }
      }
  
      msgAlertaSemConfirmacao("Nenhum serviço, produto ou material encontrado.");
  }
  
  async function pesquisaGenerica(tabela, codigo_mat) {
    const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"${tabela}", 
                "camposSelect":["CODIGO", "DESCRICAO"], 
                "where": ["CODIGO = '${codigo_mat}'"]}`, null);

    if (!response) {
        return;
    }

    const jsonStr = await response.json();
    if (response.status !== 200) {
        console.error(jsonStr.RESULT[0]?.mensagem || "Erro desconhecido.");
        return;
    }

    return jsonStr.RESULT[0]?.[0] || null;
  }

  async function pesquisaMaterial(codigo_mat) {
      return pesquisaGenerica('MATERIAL', codigo_mat);
  }

  async function pesquisaProduto(codigo_mat) {
      return pesquisaGenerica('PRODUTO', codigo_mat);
  }

  async function pesquisaServico(codigo_mat) {
      return pesquisaGenerica('SERVICO', codigo_mat);
  }

  async function pesquisaCor(cor){
    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
      `JSON={ "tabela":"CADCOR", 
              "camposSelect":["COR", "DESCRICAO"], 
              "where": ["COR = '${cor}'"]}`, null);

    if (!response) {
        return;
    }

    let jsonStr = await response.json();
    if (response.status !== 200) {
        console.error(jsonStr.RESULT[0]?.mensagem || "Erro desconhecido.");
        return;
    }

    if (jsonStr && Object.keys(jsonStr).length > 0) {
      insereValor('#txtCor', jsonStr.RESULT[0][0].COR, jsonStr.RESULT[0][0].DESCRICAO);
      return;
    }
  }

  async function pesquisaTamanho(tamanho){
    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
      `JSON={ "tabela":"TABTAM", 
              "camposSelect":["TAM", "FAIXA"], 
              "where": ["TAM = '${tamanho}'"]}`, null);

    if (!response) {
        return;
    }

    let jsonStr = await response.json();
    if (response.status !== 200) {
        console.error(jsonStr.RESULT[0]?.mensagem || "Erro desconhecido.");
        return;
    }

    if (jsonStr && Object.keys(jsonStr).length > 0) {
      insereValor('#txtTamanho', jsonStr.RESULT[0][0].TAM, jsonStr.RESULT[0][0].FAIXA);
      return;
    }
  }

  async function pesquisaFornecedor(fornecedor){
    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
      `JSON={ "tabela":"ENTIDADE", 
              "camposSelect":["CODCLI", "NOME"], 
              "where": ["CODCLI = '${fornecedor}'"]}`, null);

    if (!response) {
        return;
    }

    let jsonStr = await response.json();
    if (response.status !== 200) {
        console.error(jsonStr.RESULT[0]?.mensagem || "Erro desconhecido.");
        return;
    }

    if (jsonStr && Object.keys(jsonStr).length > 0) {
      insereValor('#txtFornecedor', jsonStr.RESULT[0][0].CODCLI, jsonStr.RESULT[0][0].NOME);
      return;
    }
  }

  async function pesquisaUnidade(Unidade){
    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
      `JSON={ "tabela":"UNIDADE", 
              "camposSelect":["UNIDADE", "DESCRICAO"], 
              "where": ["UNIDADE = '${Unidade}'"]}`, null);

    if (!response) {
        return;
    }

    let jsonStr = await response.json();
    if (response.status !== 200) {
        console.error(jsonStr.RESULT[0]?.mensagem || "Erro desconhecido.");
        return;
    }

    if (jsonStr && Object.keys(jsonStr).length > 0) {
      insereValor('#txtUnidade', jsonStr.RESULT[0][0].UNIDADE, jsonStr.RESULT[0][0].DESCRICAO);
      return;
    }
  }

  

});
