<?php include_once('config.php') ?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Loja</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="plugins/overlayScrollbars/css/OverlayScrollbars.min.css">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="plugins/daterangepicker/daterangepicker.css">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="dist/css/animate.min.css">
  <link rel="stylesheet" href="dist/css/custom.css">
  <link rel="stylesheet" href="dist/css/sisplan.css">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css" />
  <link rel="shortcut icon" href="favicon.ico">
  <style>
    .info-box-text {
      font-size: 20px;
      font-weight: bold;
    }

    :root {
      --animate-duration: 1800ms;
      --animate-delay: 1s;
    }

    #info_produtos_semana {
      color: white !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('menu.php');
    ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h1 class="m-0 text-dark">Página Inicial</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item active">Início</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
      <section class="content">
        <div class="container-fluid">
          <div class="row" id="card-carregando">
            <div class="col-sm-12 pnlDashboard" style="text-align:center">
              <h5>Carregando dashboard</h5>
              <div class="progress progress-striped active">
                <div class="progress-bar progress-bar-striped bg-danger progress-bar-animated" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%">
                </div>
              </div>
            </div>
          </div>
          <div class="row m-0 mt-2">
            <div class="col-12">
              <h5>Seja bem vindo !</h5>
            </div>
          </div>
          <div class="row mt-2 pnlDashboard">
            <div class="col-lg-4 col-12 animate__animated animate__fadeIn d-none venda_semana">
              <div class="small-box bg-info">
                <div class="inner">
                  <h3 id="qtde_vendas_semana"></h3>
                  <p>Quantidade de Vendas (Semana)</p>
                </div>
                <div class="icon">
                  <i class="ion ion-bag"></i>
                </div>
                <a href="" id="info_vendas_semana" class="small-box-footer">Mais Informações <i class="fas fa-arrow-circle-right"></i></a>
              </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-4 col-12 animate__animated animate__fadeIn d-none venda_semana">
              <!-- small box -->
              <div class="small-box bg-success">
                <div class="inner animated">
                  <h3 id="valor_vendas_semana"></h3>
                  <p>Valor de Vendas (Semana)</p>
                </div>
                <div class="icon">
                  <i class="ion ion-stats-bars"></i>
                </div>
                <a href="" id="info_vendas_semana_2" class="small-box-footer">Mais Informações <i class="fas fa-arrow-circle-right"></i></a>
              </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-4 col-12 animate__animated animate__fadeIn d-none produto_semana">
              <!-- small box -->
              <div class="small-box bg-warning animated">
                <div class="inner">
                  <h3 id="qtde_produtos_semana"></h3>
                  <p>Quantidade Produtos Vendidos (Semana)</p>
                </div>
                <div class="icon">
                  <i class="ion ion-person-add"></i>
                </div>
                <a href="" id="info_produtos_semana" class="small-box-footer">Mais Informações <i class="fas fa-arrow-circle-right"></i></a>
              </div>
            </div>
            <div class="col-lg-6 col-12 animate__animated animate__fadeIn d-none graf_qtde_semana">
              <div class="card">
                <div class="card-header bg-info">
                  <h3 class="card-title">Análise de Quantidade Vendida (Semanal)</h3>
                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i>
                    </button>
                  </div>
                </div>
                <div class="card-body">
                  <div class="chart">
                    <canvas id="chart_venda_semanal_qtde" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                  </div>
                </div>
                <!-- /.card-body -->
              </div>
            </div>
            <div class="col-lg-6 col-12 animate__animated animate__fadeIn d-none graf_qtde_semana">
              <div class="card">
                <div class="card-header bg-info">
                  <h3 class="card-title">Análise de Valor Vendido (Semanal)</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i>
                    </button>
                  </div>
                </div>
                <div class="card-body">
                  <div class="chart">
                    <canvas id="chart_venda_semanal_valor" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                  </div>
                </div>
                <!-- /.card-body -->
              </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-4 col-12 animate__animated animate__fadeIn d-none venda_mes">
              <!-- small box -->
              <div class="small-box" style="background-color: var(--brown-color)">
                <div class="inner text-white">
                  <h3 id="qtde_vendas_mes"></h3>
                  <p>Quantidade de Vendas (Mês)</p>
                </div>
                <div class="icon">
                  <i class="ion ion-pie-graph"></i>
                </div>
                <a href="" id="info_vendas_mes" class="small-box-footer">Mais Informações <i class="fas fa-arrow-circle-right"></i></a>
              </div>
            </div>
            <div class="col-lg-4 col-12 animate__animated animate__fadeIn d-none venda_mes">
              <!-- small box -->
              <div class="small-box bg-primary">
                <div class="inner">
                  <h3 id="valor_vendas_mes"></h3>
                  <p>Valor de Vendas (Mês)</p>
                </div>
                <div class="icon">
                  <i class="ion ion-pie-graph"></i>
                </div>
                <a href="" id="info_vendas_mes_2" class="small-box-footer">Mais Informações <i class="fas fa-arrow-circle-right"></i></a>
              </div>
            </div>
            <div class="col-lg-4 col-12 animate__animated animate__fadeIn d-none produto_mes">
              <!-- small box -->
              <div class="small-box bg-secondary">
                <div class="inner">
                  <h3 id="qtde_produtos_mes"></h3>
                  <p>Quantidade Produtos Vendidos (Mês)</p>
                </div>
                <div class="icon">
                  <i class="ion ion-pie-graph"></i>
                </div>
                <a href="" id="info_produtos_mes" class="small-box-footer">Mais Informações <i class="fas fa-arrow-circle-right"></i></a>
              </div>
            </div>
            <div class="col-lg-6 col-12 animate__animated animate__fadeIn d-none graf_qtde_mes">
              <div class="card">
                <div class="card-header bg-info">
                  <h3 class="card-title">Análise de Quantidade Vendida (Mensal)</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i>
                    </button>
                  </div>
                </div>
                <div class="card-body">
                  <div class="chart">
                    <canvas id="chart_venda_mensal_qtde" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                  </div>
                </div>
                <!-- /.card-body -->
              </div>
            </div>
            <div class="col-lg-6 col-12 animate__animated animate__fadeIn d-none graf_qtde_mes">
              <div class="card">
                <div class="card-header bg-info">
                  <h3 class="card-title">Análise de Valor Vendido (Mensal)</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i>
                    </button>
                  </div>
                </div>
                <div class="card-body">
                  <div class="chart">
                    <canvas id="chart_venda_mensal_valor" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                  </div>
                </div>
                <!-- /.card-body -->
              </div>
            </div>
            <!-- ./col -->
          </div>
          <div class="row">
            <div class="modal fade" id="modal-vendas-semanal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
              <div class="modal-dialog modal-xl">
                <div class="modal-content">
                  <div class="modal-header">
                    <h4 id="modal-vendas-semanal-titulo" class="modal-title">Vendas Semanais</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body">
                    <div class="row">
                      <div class="col-sm-12" id="card_vendas_semanais">
                        <div class="table-responsive">
                          <table id="tabelaVendasSemanal" class="display table table-sm table-select table-hover" width="100%">
                            <thead>
                            </thead>
                            <tbody>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal fade" id="modal-vendas-mensal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
              <div class="modal-dialog modal-xl">
                <div class="modal-content">
                  <div class="modal-header">
                    <h4 id="modal-vendas-mensal-titulo" class="modal-title">Vendas Mensais</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body">
                    <div class="row">
                      <div class="col-sm-12" id="card_vendas_mensais">
                        <div class="table-responsive">
                          <table id="tabelaVendasMensal" class="table table-sm table-select table-hover" width="100%">
                            <thead>
                            </thead>
                            <tbody>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <!-- /.row -->
            <div class="modal fade" id="modal-produtos-semanal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
              <div class="modal-dialog modal-xl">
                <div class="modal-content">
                  <div class="modal-header">
                    <h4 id="modal-produtos-semanal-titulo" class="modal-title"> Produtos Vendidos (Semana)</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body">
                    <div class="row">
                      <div class="col-sm-12" id="card_produtos_semanais">
                        <div class="table-responsive">
                          <table id="tabelaProdutosSemana" class="table table-sm table-select table-hover" width="100%">
                            <thead>
                            </thead>
                            <tbody>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal fade" id="modal-produtos-mensal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
              <div class="modal-dialog modal-xl">
                <div class="modal-content">
                  <div class="modal-header">
                    <h4 id="modal-produtos-mensal-titulo" class="modal-title"> Produtos Vendidos (Mês)</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body">
                    <div class="row">
                      <div class="col-sm-12" id="card_produtos_mensais">
                        <div class="table-responsive">
                          <table id="tabelaProdutosMes" class="table table-sm table-select table-hover" width="100%">
                            <thead>
                            </thead>
                            <tbody>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
      </section>

      <!-- /.content -->
    </div>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside>
    <!-- /.control-sidebar -->
  </div>
  <!-- /.content-wrapper -->
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>

  <?php
  include_once('modais.php');
  ?>
  </div>
  <!-- ./wrapper -->

  <!-- jQuery -->
  <script src="plugins/jquery/jquery.min.js"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="plugins/jquery-ui/jquery-ui.min.js"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button)
  </script>

  <!-- Bootstrap 4 -->
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <!-- ChartJS -->
  <script src="plugins/chart.js/Chart.min.js"></script>
  <!-- Sparkline -->
  <script src="plugins/sparklines/sparkline.js"></script>
  <script src="dist/js/sisplan.js"></script>
  <script type="text/javascript" src="utils/funcoes.js"></script>
  <script src="dist/js/adminlte.min.js"></script>
  <script src="dist/js/jquery.dataTables.min.js"></script>
  <script type="text/javascript" src="dist/js/loadingoverlay.min.js"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js"></script>
  <script type="text/javascript" src="dist/js/sum().js"></script>
  <script src="dist/js/jquery.maskMoney.min.js"></script>
  <script src="dist/js/dataTables.keyTable.js"></script>
  <script src="utils/cookies.js"></script>
  <script src="dist/js/requisicoes.js"></script>
  <script type="text/javascript" src="plugins/jszip/jszip.min.js"></script>
  <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js"></script>
  <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js"></script>
  <script>
    $(document).ready(async function() {

      if (getCookie('usuario') == "") {
        window.location.href = "login";
      }
      await verificaPermissoes('INICIO');

      var iEmpID = getCookie('emp_id');
      var buttonCommon = {
        exportOptions: {
          format: {
            body: function(data, row, column, node) {
              // Strip $ from salary column to make it numeric
              return column === 5 ?
                data.replace(/[$,]/g, '') :
                data;
            }
          }
        }
      };

      async function CriaGraficoQtdeSemanal(arraySemanaAtual, arraySemanaPassada) {
        var areaChartData = {
          labels: ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
          datasets: [{
              label: 'Semana Atual',
              backgroundColor: '#343a40',
              borderColor: '#343a40',
              pointRadius: false,
              pointColor: '#3b8bba',
              pointStrokeColor: '#343a40',
              pointHighlightFill: '#fff',
              pointHighlightStroke: '#343a40',
              data: arraySemanaAtual
            },
            {
              label: 'Semana Passada',
              backgroundColor: 'rgba(255, 58, 45, 1)',
              borderColor: 'rgba(255, 58, 45, 1)',
              pointRadius: false,
              pointColor: 'rgba(255, 58, 45, 1)',
              pointStrokeColor: '#c1c7d1',
              pointHighlightFill: '#fff',
              pointHighlightStroke: 'rgba(220,220,220,1)',
              data: arraySemanaPassada,
            }
          ]
        }
        //-------------
        //- BAR CHART -
        //-------------
        var barChartCanvas = $('#chart_venda_semanal_qtde').get(0).getContext('2d')
        var barChartData = jQuery.extend(true, {}, areaChartData);
        var temp0 = areaChartData.datasets[0]
        var temp1 = areaChartData.datasets[1]
        barChartData.datasets[0] = temp1
        barChartData.datasets[1] = temp0

        var barChartOptions = {
          responsive: true,
          maintainAspectRatio: false,
          datasetFill: false
        }

        var barChart = new Chart(barChartCanvas, {
          type: 'bar',
          data: barChartData,
          options: barChartOptions
        });


        $('.graf_qtde_semana').removeClass('d-none');
      }

      async function CriaGraficoQtdeMensal(arrayMesAtual, arrayMesPassado) {
        var areaChartData = {
          labels: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17',
            '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31'
          ],
          datasets: [{
              label: 'Mês Atual',
              backgroundColor: '#343a40',
              borderColor: '#343a40',
              pointRadius: false,
              pointColor: '#3b8bba',
              pointStrokeColor: '#343a40',
              pointHighlightFill: '#fff',
              pointHighlightStroke: '#343a40',
              data: arrayMesAtual
            },
            {
              label: 'Mês passado',
              backgroundColor: 'rgba(255, 58, 45, 1)',
              borderColor: 'rgba(255, 58, 45, 1)',
              pointRadius: false,
              pointColor: 'rgba(255, 58, 45, 1)',
              pointStrokeColor: '#c1c7d1',
              pointHighlightFill: '#fff',
              pointHighlightStroke: 'rgba(220,220,220,1)',
              data: arrayMesPassado
            },
          ]
        }
        //-------------
        //- BAR CHART -
        //-------------
        var barChartCanvas = $('#chart_venda_mensal_qtde').get(0).getContext('2d')
        var barChartData = jQuery.extend(true, {}, areaChartData)
        var temp0 = areaChartData.datasets[0]
        var temp1 = areaChartData.datasets[1]
        barChartData.datasets[0] = temp1
        barChartData.datasets[1] = temp0

        var barChartOptions = {
          responsive: true,
          maintainAspectRatio: false,
          datasetFill: false
        }

        var barChart = new Chart(barChartCanvas, {
          type: 'bar',
          data: barChartData,
          options: barChartOptions
        });
        $('.graf_qtde_mes').removeClass('d-none');
      }

      async function CriaGraficoValorMensal(arrayMesAtual, arrayMesPassado) {
        var areaChartData = {
          labels: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17',
            '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31'
          ],
          datasets: [{
              label: 'Mês Atual',
              backgroundColor: '#343a40',
              borderColor: '#343a40',
              pointRadius: false,
              pointColor: '#3b8bba',
              pointStrokeColor: '#343a40',
              pointHighlightFill: '#fff',
              pointHighlightStroke: '#343a40',
              data: arrayMesAtual
            },
            {
              label: 'Mês passado',
              backgroundColor: 'rgba(255, 58, 45, 1)',
              borderColor: 'rgba(255, 58, 45, 1)',
              pointRadius: false,
              pointColor: 'rgba(255, 58, 45, 1)',
              pointStrokeColor: '#c1c7d1',
              pointHighlightFill: '#fff',
              pointHighlightStroke: 'rgba(220,220,220,1)',
              data: arrayMesPassado
            },
          ]
        }
        //-------------
        //- BAR CHART -
        //-------------
        var barChartCanvas = $('#chart_venda_mensal_valor').get(0).getContext('2d')
        var barChartData = jQuery.extend(true, {}, areaChartData)
        var temp0 = areaChartData.datasets[0]
        var temp1 = areaChartData.datasets[1]
        barChartData.datasets[0] = temp1
        barChartData.datasets[1] = temp0

        var barChartOptions = {
          responsive: true,
          maintainAspectRatio: false,
          datasetFill: false
        }

        var barChart = new Chart(barChartCanvas, {
          type: 'bar',
          data: barChartData,
          options: barChartOptions
        });
        $('.graf_valor_mes').removeClass('d-none');
      }

      async function CriaGraficoValorSemanal(arraySemanaAtual, arraySemanaPassada) {
        var areaChartData = {
          labels: ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
          datasets: [{
              label: 'Semana Atual',
              backgroundColor: '#343a40',
              borderColor: '#343a40',
              pointRadius: false,
              pointColor: '#3b8bba',
              pointStrokeColor: '#343a40',
              pointHighlightFill: '#fff',
              pointHighlightStroke: '#343a40',
              data: arraySemanaAtual
            },
            {
              label: 'Semana Passada',
              backgroundColor: 'rgba(255, 58, 45, 1)',
              borderColor: 'rgba(255, 58, 45, 1)',
              pointRadius: false,
              pointColor: 'rgba(255, 58, 45, 1)',
              pointStrokeColor: '#c1c7d1',
              pointHighlightFill: '#fff',
              pointHighlightStroke: 'rgba(220,220,220,1)',
              data: arraySemanaPassada
            },
          ]
        }
        //-------------
        //- BAR CHART -
        //-------------
        var barChartCanvas = $('#chart_venda_semanal_valor').get(0).getContext('2d')
        var barChartData = jQuery.extend(true, {}, areaChartData)
        var temp0 = areaChartData.datasets[0]
        var temp1 = areaChartData.datasets[1]
        barChartData.datasets[0] = temp1
        barChartData.datasets[1] = temp0

        var barChartOptions = {
          responsive: true,
          maintainAspectRatio: false,
          datasetFill: false
        }

        var barChart = new Chart(barChartCanvas, {
          type: 'bar',
          data: barChartData,
          options: barChartOptions
        });

        $('.graf_valor_semana').removeClass('d-none');
      }

      jQuery.fn.dataTable.Api.register('sum()', function() {
        return this.flatten().reduce(function(a, b) {
          return (a * 1) + (b * 1); // cast values in-case they are strings
        });
      });

      $('#info_produtos_mes').on('click', function() {
        event.preventDefault();
        $('#modal-produtos-mensal').modal('show');
      });

      $('#info_produtos_semana').on('click', function() {
        event.preventDefault();
        $('#modal-produtos-semanal').modal('show');
      });

      $('#info_vendas_semana').on('click', function() {
        event.preventDefault();
        $('#modal-vendas-semanal').modal('show');
      });

      $('#info_vendas_semana_2').on('click', function() {
        event.preventDefault();
        $('#modal-vendas-semanal').modal('show');
      });

      $('#info_vendas_mes').on('click', function() {
        event.preventDefault();
        $('#modal-vendas-mensal').modal('show');
      });

      $('#info_vendas_mes_2').on('click', function() {
        event.preventDefault();
        $('#modal-vendas-mensal').modal('show');
      });

      await buscarVendasSemana();
      await buscarVendasMensal();
      await buscarProdutosSemana();
      await buscarProdutosMes();
      await buscarAnaliseSemanal();
      await buscarAnaliseMensal();
      $('#card-carregando').addClass('d-none');
      async function buscarAnaliseMensal() {
        try {
          sEmpresa = getCookie('empresa');
          // mes passado
          let inicial = new Date();
          let milissegundos_por_dia = 1000 * 60 * 60 * 24;
          let data = new Date(inicial.getTime() - (inicial.getDate() * milissegundos_por_dia));
          let datainicialpassada = new Date(data.getFullYear() + '-' + (data.getMonth() + 1) + '-' + '1');
          let final = new Date();
          data = new Date(final.getTime() - (final.getDate() * milissegundos_por_dia));
          let datafinalpassada = new Date(data.getFullYear() + '-' + (data.getMonth() + 1) + '-' + data
            .getDate());
          var x = datainicialpassada.toLocaleDateString().slice(0, 10).split('/');
          let sDataIniPassada = "'" + x[2] + "-" + x[1] + "-" + x[0] + "'";
          var y = datafinalpassada.toLocaleDateString().slice(0, 10).split('/');
          let sDataFimPassada = "'" + y[2] + "-" + y[1] + "-" + y[0] + "'";
          // mes passado
          // mes atual
          let inicialFinal = new Date();
          let datainicial = new Date(inicialFinal.getFullYear() + '-' + (inicialFinal.getMonth() + 1) + '-' +
            '1');
          let dataProxMes = new Date(final.getTime() + (30 * milissegundos_por_dia));
          let datafim = new Date(dataProxMes.getFullYear() + '-' + (dataProxMes.getMonth() + 1) + '-' + '1');
          let datafinal = new Date(datafim.getTime() - (1 * milissegundos_por_dia));
          var x = datainicial.toLocaleDateString().slice(0, 10).split('/');
          let sDataIni = "'" + x[2] + "-" + x[1] + "-" + x[0] + "'";
          var y = datafinal.toLocaleDateString().slice(0, 10).split('/');
          let sDataFim = "'" + y[2] + "-" + y[1] + "-" + y[0] + "'";
          // mes atual

          let array_mes_anterior_qtde = [];
          let array_mes_atual_qtde = [];
          let array_mes_anterior_valor = [];
          let array_mes_atual_valor = [];
          let separador = "' - '";
          let _url =
            `/sisplan/funcoes/v1/pesquisa?empresa=${sEmpresa}&JSON={ "tabela":"venda", "camposSelect":[ "case when venda.data between ${sDataIniPassada} and ${sDataFimPassada} then 'mes passado' else 'mes atual' end controle ", "venda.data", "sum(itvenda.total_liq) valor", "sum(itvenda.quantidade) qtde" ], "leftjoin": [{"tabela" : "itvenda", "condicao" : "itvenda.codven= venda.codven and venda.emp_id = itvenda.emp_id"}], "groupby": ["venda.data", "venda.emp_id"], "orderby": ["venda.data"],"where": ["(data >= ${sDataIniPassada} and data <= ${sDataFim}) and (venda.emp_id = ${iEmpID})"]}`;
          let response = await requisicao('GET', '', _url, null, 20000);

          if (!response) {
            return;
          }

          var result = await response.json()
          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem)
            return;
          }

          if (result['RESULT'][0]) {
            if (!result['RESULT'][0]) {
              dataSet.push(result['RESULT'][0]);
            } else {
              dataSet = result['RESULT'][0];
            }

            if (!$.isEmptyObject(dataSet[0])) {
              for (let index = 0; index < dataSet.length; index++) {
                const data = dataSet[index];
                var data_semana = new Date(dataSet[index].DATA);
                data_semana.setDate(data_semana.getDate() + 1);
                if (data.CONTROLE == 'MES PASSADO') {
                  array_mes_anterior_qtde[data_semana.getDate()] = data.QTDE;
                  array_mes_anterior_valor[data_semana.getDate()] = data.VALOR;
                } else {
                  array_mes_atual_qtde[data_semana.getDate()] = data.QTDE;
                  array_mes_atual_valor[data_semana.getDate()] = data.VALOR;
                }
              }

              //ajustando as posições do array de resultado ...
              var array_mes_ant_qtde = [];
              var array_mes_atu_qtde = [];
              for (let i = 1; i < 32; i++) {
                var novo = array_mes_anterior_qtde[i];
                var novo_atu = array_mes_atual_qtde[i];
                if (novo == undefined) {
                  array_mes_ant_qtde.push(0);
                } else {
                  array_mes_ant_qtde.push(novo);
                }
                if (novo_atu == undefined) {
                  array_mes_atu_qtde.push(0);
                } else {
                  array_mes_atu_qtde.push(novo_atu);
                }
              }

              var array_mes_ant_valor = [];
              var array_mes_atu_valor = [];
              for (let i = 1; i < 32; i++) {
                var novo = array_mes_anterior_valor[i];
                var novo_atu = array_mes_atual_valor[i];
                if (novo == undefined) {
                  array_mes_ant_valor.push(0);
                } else {
                  array_mes_ant_valor.push(novo);
                }
                if (novo_atu == undefined) {
                  array_mes_atu_valor.push(0);
                } else {
                  array_mes_atu_valor.push(novo_atu);
                }
              }
              CriaGraficoQtdeMensal(array_mes_atu_qtde, array_mes_ant_qtde);
              CriaGraficoValorMensal(array_mes_atu_valor, array_mes_ant_valor);

            }
          }
        } catch (error) {}
      };
      async function buscarAnaliseSemanal() {
        try {
          sEmpresa = getCookie('empresa');
          // semana passada
          var datainicialpassada = new Date();
          datainicialpassada.setDate((datainicialpassada.getDate() - datainicialpassada.getDay()) + 1 -
            7); // menos uma semana completa.
          var dataFinalpassada = new Date();
          // dataFinalpassada.setDate(datainicialpassada.getDate() + (dataFinalpassada.getDay() + 5));
          dataFinalpassada.setTime(datainicialpassada.getTime() + (1000 * 60 * 60 * 24 * 6));
          var x = datainicialpassada.toLocaleDateString().slice(0, 10).split('/');
          var sDataIniPassada = "'" + x[2] + "-" + x[1] + "-" + x[0] + "'";
          var y = dataFinalpassada.toLocaleDateString().slice(0, 10).split('/');
          var sDataFimPassada = "'" + y[2] + "-" + y[1] + "-" + y[0] + "'";
          // semana passada

          // semana atual
          var datainicial = new Date();
          datainicial.setDate(datainicial.getDate() - datainicial.getDay() + 1);
          var dataFinal = new Date();
          dataFinal.setDate(datainicial.getDate() + 5);
          var x = datainicial.toLocaleDateString().slice(0, 10).split('/');
          var sDataIni = "'" + x[2] + "-" + x[1] + "-" + x[0] + "'";
          var y = dataFinal.toLocaleDateString().slice(0, 10).split('/');
          var sDataFim = "'" + y[2] + "-" + y[1] + "-" + y[0] + "'";
          // semana atual

          var array_semana_anterior_qtde = [];
          var array_semana_atual_qtde = [];
          var array_semana_anterior_valor = [];
          var array_semana_atual_valor = [];
          var separador = "' - '";
          var _url =
            `/sisplan/funcoes/v1/pesquisa?empresa=${sEmpresa}&JSON={ "tabela":"venda", "camposSelect":[ "case when venda.data between ${sDataIniPassada} and ${sDataFimPassada} then 'semana passada' else 'semana atual' end controle ", "venda.data", "sum(itvenda.total_liq) valor", "sum(itvenda.quantidade) qtde" ], "leftjoin": [{"tabela" : "itvenda", "condicao" : "itvenda.codven= venda.codven and itvenda.emp_id = venda.emp_id"}], "groupby": ["venda.data", "venda.emp_id"], "orderby": ["venda.data"],"where": ["(data >= ${sDataIniPassada} and data <= ${sDataFim}) and (venda.emp_id = ${iEmpID})"]}`;
          var response = await requisicao('GET', '', _url, null, 20000);

          if (!response) {
            return;
          }

          var result = await response.json()
          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem)
            return;
          }

          if (result['RESULT'][0]) {
            if (!result['RESULT'][0]) {
              dataSet.push(result['RESULT'][0]);
            } else {
              dataSet = result['RESULT'][0];
            }

            if (!$.isEmptyObject(dataSet[0])) {
              for (let index = 0; index < dataSet.length; index++) {
                const data = dataSet[index];
                var data_semana = new Date(dataSet[index].DATA);
                data_semana.setDate(data_semana.getDate() + 1);
                var dia_semana = new Date(dataSet[index].DATA).getDay();
                if (data.CONTROLE == 'SEMANA PASSADA') {
                  array_semana_anterior_qtde[dia_semana] = data.QTDE;
                  array_semana_anterior_valor[dia_semana] = data.VALOR;
                } else {
                  array_semana_atual_qtde[dia_semana] = data.QTDE;
                  array_semana_atual_valor[dia_semana] = data.VALOR;
                }
              }

              //ajustando as posições do array de resultado ...
              var array_semana_ant_qtde = [];
              var array_semana_atu_qtde = [];
              for (let i = 0; i < 6; i++) {
                var novo = array_semana_anterior_qtde[i];
                var novo_atu = array_semana_atual_qtde[i];
                if (novo == undefined) {
                  array_semana_ant_qtde.push(0);
                } else {
                  array_semana_ant_qtde.push(novo);
                }
                if (novo_atu == undefined) {
                  array_semana_atu_qtde.push(0);
                } else {
                  array_semana_atu_qtde.push(novo_atu);
                }
              }

              var array_semana_ant_valor = [];
              var array_semana_atu_valor = [];
              for (let i = 0; i < 6; i++) {
                var novo = array_semana_anterior_valor[i];
                var novo_atu = array_semana_atual_valor[i];
                if (novo == undefined) {
                  array_semana_ant_valor.push(0);
                } else {
                  array_semana_ant_valor.push(novo);
                }
                if (novo_atu == undefined) {
                  array_semana_atu_valor.push(0);
                } else {
                  array_semana_atu_valor.push(novo_atu);
                }
              }
              CriaGraficoQtdeSemanal(array_semana_atu_qtde, array_semana_ant_qtde);
              CriaGraficoValorSemanal(array_semana_atu_valor, array_semana_ant_valor);

            }
          }
        } catch (error) {}
      };
      async function buscarVendasSemana() {
        try {
          var dataSetCols = [];
          sEmpresa = getCookie('empresa');
          var datainicial = new Date();
          datainicial.setDate(datainicial.getDate() - datainicial.getDay() + 1);
          var dataFinal = new Date();
          dataFinal.setDate(datainicial.getDate() + 5);
          var x = datainicial.toLocaleDateString().slice(0, 10).split('/');
          var sDataIni = "'" + x[2] + "-" + x[1] + "-" + x[0] + "'";
          var y = dataFinal.toLocaleDateString().slice(0, 10).split('/');
          var sDataFim = "'" + y[2] + "-" + y[1] + "-" + y[0] + "'";
          var separador = "' - '";
          var _url =
            `/sisplan/funcoes/v1/pesquisa?empresa=${sEmpresa}&JSON={ "tabela":"venda", "camposSelect":[ "venda.codven venda",  "venda.codcli|| ${separador}||entidade.nome cliente", "venda.data", "venda.valor", "sum(itvenda.quantidade) qtde_itens" ], "leftjoin": [{"tabela" : "entidade", "condicao" : "entidade.codcli = venda.codcli"}, {"tabela" : "itvenda", "condicao" : "itvenda.codven= venda.codven and itvenda.emp_id = venda.emp_id"}], "groupby": ["venda.codven","venda.codcli","entidade.nome","venda.data", "venda.valor", "venda.emp_id"], "orderby": ["venda.data"],"where": ["(data >= ${sDataIni} and data <= ${sDataFim}) and (venda.emp_id = ${iEmpID})"]}`;
          var response = await requisicao('GET', '', _url, null, 20000);

          if (!response) {
            return;
          }

          var result = await response.json()
          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem)
            return;
          }

          if (result['RESULT'][0]) {
            if (!result['RESULT'][0]) {
              dataSet.push(result['RESULT'][0]);
            } else {
              dataSet = result['RESULT'][0];
            }
            //se chegar aqui deu tudo certo

            if (!$.isEmptyObject(dataSet[0])) {
              // preciso dinamicamente ter a relação com o nome das colunas para tabela
              var keys = Object.keys(dataSet[0]);
              for (var k in keys) {
                dataSetCols.push({
                  'title': keys[k],
                  'data': keys[k]
                });
              }

              dataSetCols[2].type = 'date-br';
              dataSetCols[2].render = function(data, type, row) {
                //alert(navigator['userAgent'])
                var isIE = function() {
                  if (/MSIE/i ['test'](navigator['userAgent']) == true || /Edge/i ['test'](navigator[
                      'userAgent']) == true) {
                    return true;
                  } else {
                    return false;
                  }
                }
                if (isIE()) {
                  x = data.slice(0, 10).split('-');
                  return x[2] + "/" + x[1] + "/" + x[0];
                } else {
                  x = data.slice(0, 10).split('-');
                  return x[2] + "/" + x[1] + "/" + x[0];
                  return $.datepicker.formatDate("dd/mm/Y", new Date(data));
                }
              }

              tabelaVendasSemanal = await $('#tabelaVendasSemanal').DataTable({
                paging: true,
                filter: false,
                info: true,
                order: true,
                destroy: true,
                autowidth: true,
                dom: 'Bfrtip',
                buttons: [{
                    "extend": 'excel',
                    "text": 'Exportar Excel',
                    "className": 'btn btn-primary btn-sm btn-sisp',
                    "title": 'Dashboard - Vendas semana'
                  },
                  {
                    alignment: "center",
                    "extend": 'pdf',
                    "text": 'Exportar PDF',
                    "className": 'btn btn-secondary btn-sm btn-sisp',
                    customize: function(doc) {
                      doc.styles.tableBodyEven.alignment = 'center';
                      doc.styles.tableBodyOdd.alignment = 'center';
                      doc.content[1].table.widths =
                        Array(doc.content[1].table.body[0].length + 1).join('*').split('');
                    },
                    "title": 'Dashboard - Vendas semana'
                  }
                ],
                "language": {
                  "sEmptyTable": "Nenhum registro encontrado",
                  "sInfo": "_TOTAL_ registros",
                  "sInfoEmpty": " 0 registros",
                  "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                  "sInfoPostFix": "",
                  "sInfoThousands": ".",
                  "sLengthMenu": "_MENU_ resultados",
                  "sLoadingRecords": "Carregando...",
                  "sProcessing": "Processando...",
                  "sZeroRecords": "Nenhum registro encontrado",
                  "sSearch": "Pesquisar (geral): ",
                  "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                  },
                  "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                  }
                },
                "data": dataSet,
                "columns": dataSetCols
              });
            }
          }
          var total_valor = $('#tabelaVendasSemanal').DataTable().column(3, {}).data().sum();
          var qtde_vendas = $('#tabelaVendasSemanal').DataTable().rows().count();
          $('#qtde_vendas_semana').html(qtde_vendas);
          $("#valor_vendas_semana").html(parseFloat(total_valor).toLocaleString('pt-BR', {
            style: 'currency',
            currency: 'BRL'
          }));
          $('.venda_semana').removeClass('d-none');
        } catch (error) {}
      };

      async function buscarProdutosSemana() {
        try {
          var dataSetCols = [];
          sEmpresa = getCookie('empresa');
          var datainicial = new Date();
          datainicial.setDate(datainicial.getDate() - datainicial.getDay() + 1);
          var dataFinal = new Date();
          dataFinal.setDate(datainicial.getDate() + 5);
          var x = datainicial.toLocaleDateString().slice(0, 10).split('/');
          var sDataIni = "'" + x[2] + "-" + x[1] + "-" + x[0] + "'";
          var y = dataFinal.toLocaleDateString().slice(0, 10).split('/');
          var sDataFim = "'" + y[2] + "-" + y[1] + "-" + y[0] + "'";
          var separador = "' - '";
          var _url =
            `/sisplan/funcoes/v1/pesquisa?empresa=${sEmpresa}&JSON={"tabela":"itvenda", "camposSelect":[ "itvenda.codigo",  "produto.descricao", "sum(itvenda.quantidade) qtde" ],"leftjoin": [{"tabela" : "produto", "condicao" : "produto.codigo = itvenda.codigo"},{"tabela" : "venda", "condicao" : "itvenda.codven= venda.codven and itvenda.emp_id = venda.emp_id"}],"groupby": ["itvenda.codigo",  "produto.descricao", "venda.codven", "venda.emp_id"],"where": ["(venda.data >= ${sDataIni} and venda.data <= ${sDataFim}) and (venda.emp_id = ${iEmpID})"]}`;
          var response = await requisicao('GET', '', _url, null, 20000);

          if (!response) {
            return;
          }

          var result = await response.json()
          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem)
            return;
          }

          if (result['RESULT'][0]) {
            if (!result['RESULT'][0]) {
              dataSet.push(result['RESULT'][0]);
            } else {
              dataSet = result['RESULT'][0];
            }
            //se chegar aqui deu tudo certo

            if (!$.isEmptyObject(dataSet[0])) {
              // preciso dinamicamente ter a relação com o nome das colunas para tabela
              var keys = Object.keys(dataSet[0]);
              for (var k in keys) {
                dataSetCols.push({
                  'title': keys[k],
                  'data': keys[k]
                });
              }

              tabelaProdutosSemana = await $('#tabelaProdutosSemana').DataTable({
                paging: true,
                filter: false,
                info: true,
                order: true,
                destroy: true,
                autowidth: true,
                dom: 'Bfrtip',
                buttons: [{
                    "extend": 'excel',
                    "text": 'Exportar Excel',
                    "className": 'btn btn-primary btn-sm btn-sisp',
                    "title": 'Dashboard - Produtos Vendidos na Semana'
                  },
                  {
                    "extend": 'pdf',
                    "text": 'Exportar PDF',
                    "className": 'btn btn-secondary btn-sm btn-sisp',
                    customize: function(doc) {
                      doc.styles.tableBodyEven.alignment = 'center';
                      doc.styles.tableBodyOdd.alignment = 'center';
                      doc.content[1].table.widths =
                        Array(doc.content[1].table.body[0].length + 1).join('*').split('');
                    },
                    "title": 'Dashboard - Produtos Vendidos na Semana'
                  }
                ],
                "language": {
                  "sEmptyTable": "Nenhum registro encontrado",
                  "sInfo": "_TOTAL_ registros",
                  "sInfoEmpty": " 0 registros",
                  "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                  "sInfoPostFix": "",
                  "sInfoThousands": ".",
                  "sLengthMenu": "_MENU_ resultados",
                  "sLoadingRecords": "Carregando...",
                  "sProcessing": "Processando...",
                  "sZeroRecords": "Nenhum registro encontrado",
                  "sSearch": "Pesquisar (geral): ",
                  "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                  },
                  "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                  }
                },
                "data": dataSet,
                "columns": dataSetCols
              });

              tabelaProdutosSemana
                .columns(2)
                .order('desc')
                .draw();
            }
          }
          var qtde_produtos_semana = $('#tabelaProdutosSemana').DataTable().rows().sum();
          $('#qtde_produtos_semana').html(qtde_produtos_semana);
          $('.produto_semana').removeClass('d-none');
        } catch (error) {}
      };

      async function buscarProdutosMes() {
        try {
          var dataSetCols = [];
          var sEmpresa = getCookie('empresa');
          var date = new Date();
          var primeiroDia = new Date(date.getFullYear(), date.getMonth(), 1);
          var ultimoDia = new Date(date.getFullYear(), date.getMonth() + 1, 0);
          var x = primeiroDia.toLocaleDateString().slice(0, 10).split('/');
          var sDataIni = "'" + x[2] + "-" + x[1] + "-" + x[0] + "'";
          var y = ultimoDia.toLocaleDateString().slice(0, 10).split('/');
          var sDataFim = "'" + y[2] + "-" + y[1] + "-" + y[0] + "'";
          var separador = "' - '";
          var _url =
            `/sisplan/funcoes/v1/pesquisa?empresa=${sEmpresa}&JSON={"tabela":"itvenda", "camposSelect":[ "itvenda.codigo",  "produto.descricao", "sum(itvenda.quantidade) qtde" ],"leftjoin": [{"tabela" : "produto", "condicao" : "produto.codigo = itvenda.codigo"},{"tabela" : "venda", "condicao" : "itvenda.codven= venda.codven and itvenda.emp_id = venda.emp_id"}],"groupby": ["itvenda.codigo",  "produto.descricao", "venda.emp_id"],"where": ["(venda.data >= ${sDataIni} and venda.data <= ${sDataFim}) and (venda.emp_id = ${iEmpID})"]}`;
          var response = await requisicao('GET', '', _url, null, 20000);

          if (!response) {
            return;
          }

          var result = await response.json()
          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem)
            return;
          }

          if (result['RESULT'][0]) {
            if (!result['RESULT'][0]) {
              dataSet.push(result['RESULT'][0]);
            } else {
              dataSet = result['RESULT'][0];
            }
            //se chegar aqui deu tudo certo

            if (!$.isEmptyObject(dataSet[0])) {
              // preciso dinamicamente ter a relação com o nome das colunas para tabela
              var keys = Object.keys(dataSet[0]);
              for (var k in keys) {
                dataSetCols.push({
                  'title': keys[k],
                  'data': keys[k]
                });
              }

              tabelaProdutosMes = await $('#tabelaProdutosMes').DataTable({
                paging: true,
                filter: false,
                info: true,
                order: true,
                destroy: true,
                autowidth: true,
                dom: 'Bfrtip',
                buttons: [{
                    "extend": 'excel',
                    "text": 'Exportar Excel',
                    "className": 'btn btn-primary btn-sm btn-sisp',
                    "title": 'Dashboard - Produtos Vendidos no mês'
                  },
                  {
                    "extend": 'pdf',
                    "text": 'Exportar PDF',
                    "className": 'btn btn-secondary btn-sm btn-sisp',
                    customize: function(doc) {
                      doc.styles.tableBodyEven.alignment = 'center';
                      doc.styles.tableBodyOdd.alignment = 'center';
                      doc.content[1].table.widths =
                        Array(doc.content[1].table.body[0].length + 1).join('*').split('');
                    },
                    "title": 'Dashboard - Produtos Vendidos no mês'
                  }
                ],
                "scrollCollapse": true,
                "language": {
                  "sEmptyTable": "Nenhum registro encontrado",
                  "sInfo": "_TOTAL_ registros",
                  "sInfoEmpty": " 0 registros",
                  "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                  "sInfoPostFix": "",
                  "sInfoThousands": ".",
                  "sLengthMenu": "_MENU_ resultados",
                  "sLoadingRecords": "Carregando...",
                  "sProcessing": "Processando...",
                  "sZeroRecords": "Nenhum registro encontrado",
                  "sSearch": "Pesquisar (geral): ",
                  "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                  },
                  "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                  }
                },
                "data": dataSet,
                "columns": dataSetCols
              });

              tabelaProdutosMes
                .columns(2)
                .order('desc')
                .draw();
            }
          }
          var qtde_produtos_mes = $('#tabelaProdutosMes').DataTable().rows().sum();
          $('#qtde_produtos_mes').html(qtde_produtos_mes);
          $('.produto_mes').removeClass('d-none');

        } catch (error) {}
      };

      async function buscarVendasMensal() {
        try {
          var dataSetCols = [];
          var sEmpresa = getCookie('empresa');
          var date = new Date();
          var primeiroDia = new Date(date.getFullYear(), date.getMonth(), 1);
          var ultimoDia = new Date(date.getFullYear(), date.getMonth() + 1, 0);
          var x = primeiroDia.toLocaleDateString().slice(0, 10).split('/');
          var sDataIni = "'" + x[2] + "-" + x[1] + "-" + x[0] + "'";
          var y = ultimoDia.toLocaleDateString().slice(0, 10).split('/');
          var sDataFim = "'" + y[2] + "-" + y[1] + "-" + y[0] + "'";
          var separador = "' - '";
          var _url =
            `/sisplan/funcoes/v1/pesquisa?empresa=${sEmpresa}&JSON={ "tabela":"venda", "camposSelect":[ "venda.codven venda",  "venda.codcli|| ${separador}||entidade.nome cliente", "venda.data", "venda.valor", "sum(itvenda.quantidade) qtde_itens" ], "leftjoin": [{"tabela" : "entidade", "condicao" : "entidade.codcli = venda.codcli"}, {"tabela" : "itvenda", "condicao" : "itvenda.codven= venda.codven and itvenda.emp_id = venda.emp_id"}], "groupby": ["venda.codven","venda.codcli","entidade.nome","venda.valor", "venda.data", "venda.emp_id"], "orderby": ["venda.data"],"where": ["(data >= ${sDataIni} and data <= ${sDataFim}) and (venda.emp_id = ${iEmpID})"]}`;
          var response = await requisicao('GET', '', _url, null, 20000);

          if (!response) {
            return;
          }

          var result = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem);
            return;
          }

          if (result['RESULT'][0]) {
            if (!result['RESULT'][0]) {
              dataSet.push(result['RESULT'][0]);
            } else {
              dataSet = result['RESULT'][0];
            }
            //se chegar aqui deu tudo certo

            if (!$.isEmptyObject(dataSet[0])) {
              // preciso dinamicamente ter a relação com o nome das colunas para tabela
              var keys = Object.keys(dataSet[0]);
              for (var k in keys) {
                dataSetCols.push({
                  'title': keys[k],
                  'data': keys[k]
                });
              }
              dataSetCols[2].type = 'date-br';
              dataSetCols[2].render = function(data, type, row) {
                //alert(navigator['userAgent'])
                var isIE = function() {
                  if (/MSIE/i ['test'](navigator['userAgent']) == true || /Edge/i ['test'](navigator[
                      'userAgent']) == true) {
                    return true;
                  } else {
                    return false;
                  }
                }
                if (isIE()) {
                  x = data.slice(0, 10).split('-');
                  return x[2] + "/" + x[1] + "/" + x[0];
                } else {
                  x = data.slice(0, 10).split('-');
                  return x[2] + "/" + x[1] + "/" + x[0];
                  return $.datepicker.formatDate("dd/mm/Y", new Date(data));
                }
              }

              tabelaVendasSemanal = await $('#tabelaVendasMensal').DataTable({
                paging: true,
                filter: false,
                info: true,
                order: true,
                destroy: true,
                autowidth: true,
                dom: 'Bfrtip',
                buttons: [{
                    "extend": 'excel',
                    "text": 'Exportar Excel',
                    "className": 'btn btn-primary btn-sm btn-sisp',
                    "title": 'Dashboard - Vendas mês'
                  },
                  {
                    "extend": 'pdf',
                    "text": 'Exportar PDF',
                    "className": 'btn btn-secondary btn-sm btn-sisp',
                    customize: function(doc) {
                      doc.styles.tableBodyEven.alignment = 'center';
                      doc.styles.tableBodyOdd.alignment = 'center';
                      doc.content[1].table.widths =
                        Array(doc.content[1].table.body[0].length + 1).join('*').split('');
                    },
                    "title": 'Dashboard - Vendas mês'
                  }
                ],
                "language": {
                  "sEmptyTable": "Nenhum registro encontrado",
                  "sInfo": "_TOTAL_ registros",
                  "sInfoEmpty": " 0 registros",
                  "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                  "sInfoPostFix": "",
                  "sInfoThousands": ".",
                  "sLengthMenu": "_MENU_ resultados",
                  "sLoadingRecords": "Carregando...",
                  "sProcessing": "Processando...",
                  "sZeroRecords": "Nenhum registro encontrado",
                  "sSearch": "Pesquisar (geral): ",
                  "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                  },
                  "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                  }
                },
                "data": dataSet,
                "columns": dataSetCols
              });
            }
            var total_valor = $('#tabelaVendasMensal').DataTable().column(3, {}).data().sum();
            var qtde_vendas = $('#tabelaVendasMensal').DataTable().rows().count();
            $("#qtde_vendas_mes").html(qtde_vendas);
            $("#valor_vendas_mes").html(parseFloat(total_valor).toLocaleString('pt-BR', {
              style: 'currency',
              currency: 'BRL'
            }));
            $('.venda_mes').removeClass('d-none');
          }
        } catch (error) {}
      };
    });
  </script>
</body>

</html>